/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

public enum Status {
    PASSED(1, "00CC00"),
    PENDING(2, "800080"),
    FAILED(4, "FF0000"),
    ERROR(8, "FF0000"),
    ABORTED(16, "D69D29"),
    SKIPPED(32, "585858"),
    PASSEDWITHERRORS(64, "00CC00"),
    IGNORED(128, "000000");

    private final int bitMask;
    private final String displayColor;

    private Status(int bitMask, String displayColor) {
        this.bitMask = bitMask;
        this.displayColor = displayColor;
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public String getHtmlDisplayColor() {
        return this.displayColor;
    }

    public static boolean isFailureOrError(Status status) {
        return FAILED == status || ERROR == status;
    }

    public static boolean isSkipped(Status status) {
        return SKIPPED == status;
    }

    public static boolean isAborted(Status status) {
        return ABORTED == status;
    }

    public boolean isMaskApplied(int mask) {
        return (mask & this.getBitMask()) != 0;
    }
}

