/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.io.File;
import java.util.List;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.remote.AddRemotePanel;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepository;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepositoryPanel;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AddRemoteConfig {
    public void addRemote(File repository) {
        RemoteRepository remoteRepository = new RemoteRepository(null);
        AddRemotePanel arp = new AddRemotePanel(remoteRepository.getPanel());
        DialogDescriptor dd = new DialogDescriptor((Object)arp, NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"LBL_AddRemoteConfig.title"));
        Runnable validityUpdate = () -> dd.setValid(!arp.getRemoteName().isBlank() && remoteRepository.isValid());
        arp.txtRemoteName.addActionListener(actionEvent -> validityUpdate.run());
        remoteRepository.addChangeListener(changeEvent -> validityUpdate.run());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        final String remoteName = arp.getRemoteName();
        final String remoteUrl = remoteRepository.getURI().toPrivateString();
        if (remoteName.isEmpty() || remoteUrl.isEmpty()) {
            return;
        }
        remoteRepository.store();
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    GitRemoteConfig cfg = new GitRemoteConfig(remoteName, List.of(remoteUrl), List.of(), List.of(GitUtils.getGlobalRefSpec(remoteName)), List.of());
                    client.setRemote(cfg, this.getProgressMonitor());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(AddRemoteConfig.class, (String)"LBL_AddRemoteConfig.progressName"));
    }
}

