/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.modelcache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.ActiveConfigurationProvider;
import org.netbeans.modules.maven.modelcache.Bundle;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class MavenProjectCache {
    private static final Logger LOG = Logger.getLogger(MavenProjectCache.class.getName());
    private static final String CONTEXT_EXECUTION_RESULT = "NB_Execution_Result";
    private static final String CONTEXT_PLACEHOLDER_ARTIFACTS = "NB_PlaceholderArtifacts";
    private static final String CONTEXT_LOAD_TIMESTAMP = "org.netbeans.modules.maven.loadTimestamp";
    private static final String CONTEXT_PARTICIPANTS = "NB_AbstractParticipant_Present";
    private static final String CONTEXT_PARTIAL_PROJECT = "org.netbeans.modules.maven.partialProject";
    private static final String CONTEXT_FALLBACK_PROJECT = "org.netbeans.modules.maven.fallbackProject";
    private static final String LIFECYCLE_PARTICIPANT_PREFIX = "Projects/org-netbeans-modules-maven/LifecycleParticipants/";
    private static final String ATTR_IGNORE_ON_LOAD = "ignoreOnModelLoad";
    private static final Map<File, WeakReference<MavenProject>> file2Project = new WeakHashMap<File, WeakReference<MavenProject>>();
    private static final Map<File, Mutex> file2Mutex = new WeakHashMap<File, Mutex>();

    public static void clearMavenProject(final File pomFile) {
        Mutex mutex = MavenProjectCache.getMutex(pomFile);
        mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                file2Project.remove(pomFile);
                return null;
            }
        });
    }

    public static MavenProject getMavenProject(File pomFile, boolean reload) {
        return MavenProjectCache.getMavenProject(pomFile, false, reload);
    }

    public static MavenProject getMavenProject(final File pomFile, final boolean doNotLoadReturnNull, final boolean reload) {
        Mutex mutex = MavenProjectCache.getMutex(pomFile);
        MavenProject mp = (MavenProject)mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                if (!reload) {
                    MavenProject mp;
                    WeakReference<MavenProject> ref = file2Project.get(pomFile);
                    if (ref != null && (mp = (MavenProject)ref.get()) != null) {
                        LOG.log(Level.FINE, "Maven project {0} loaded from cache, packacing = {1}", new Object[]{pomFile, mp.getPackaging()});
                        return mp;
                    }
                    if (doNotLoadReturnNull) {
                        return null;
                    }
                }
                MavenProject mp = MavenProjectCache.loadOriginalMavenProject(pomFile);
                file2Project.put(pomFile, new WeakReference<MavenProject>(mp));
                return mp;
            }
        });
        return mp;
    }

    public static MavenProject loadMavenProject(File pomFile, ProjectActionContext context, RunConfig runConf) {
        if (context == null) {
            return MavenProjectCache.getMavenProject(pomFile, true);
        }
        return MavenProjectCache.loadOriginalMavenProject(pomFile, context, runConf);
    }

    public static MavenExecutionResult getExecutionResult(MavenProject project) {
        return (MavenExecutionResult)project.getContextValue(CONTEXT_EXECUTION_RESULT);
    }

    public static boolean unknownBuildParticipantObserved(MavenProject project) {
        return project.getContextValue(CONTEXT_PARTICIPANTS) != null;
    }

    public static long getLoadTimestamp(MavenProject p) {
        long l;
        if (p == null) {
            return -1L;
        }
        Object o = p.getContextValue(CONTEXT_LOAD_TIMESTAMP);
        if (o instanceof Long) {
            Long l2 = (Long)o;
            l = l2;
        } else {
            l = -2L;
        }
        return l;
    }

    public static Collection<Artifact> getPlaceholderArtifacts(MavenProject p) {
        Object o = p.getContextValue(CONTEXT_PLACEHOLDER_ARTIFACTS);
        return o instanceof Collection ? (Collection)o : Collections.emptySet();
    }

    public static Collection<String> getUnknownBuildParticipantsClassNames(MavenProject project) {
        return (Collection)project.getContextValue(CONTEXT_PARTICIPANTS);
    }

    @NonNull
    private static MavenProject loadOriginalMavenProject(File pomFile) {
        return MavenProjectCache.loadOriginalMavenProject(pomFile, null, null);
    }

    private static boolean isLifecycleParticipatnIgnored(AbstractMavenLifecycleParticipant instance) {
        String n = instance.getClass().getName();
        FileObject check = FileUtil.getConfigFile((String)(LIFECYCLE_PARTICIPANT_PREFIX + n));
        return check != null && check.getAttribute(ATTR_IGNORE_ON_LOAD) == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MavenProject loadOriginalMavenProjectInternal(MavenEmbedder projectEmbedder, MavenExecutionRequest req) {
        long startLoading;
        HashSet placeholders;
        MavenExecutionResult res;
        File pomFile;
        MavenProject newproject;
        block31: {
            newproject = null;
            pomFile = req.getPom();
            res = null;
            placeholders = new HashSet();
            startLoading = System.currentTimeMillis();
            try {
                res = NbArtifactFixer.collectPlaceholderArtifacts(() -> projectEmbedder.readProjectWithDependencies(req, true), c -> c.forEach(a -> placeholders.add(projectEmbedder.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getExtension(), a.getClassifier()))));
                newproject = res.getProject();
                if (newproject != null) {
                    LOG.log(Level.FINE, "Loaded project for {0}, packaging: {1}", new Object[]{pomFile, newproject.getPackaging()});
                    ClassRealm projectRealm = newproject.getClassRealm();
                    if (projectRealm != null) {
                        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                        try {
                            List lookup = projectEmbedder.getPlexus().lookupList(AbstractMavenLifecycleParticipant.class);
                            if (lookup.size() > 0) {
                                ArrayList<String> parts = new ArrayList<String>();
                                for (AbstractMavenLifecycleParticipant part : lookup) {
                                    if (MavenProjectCache.isLifecycleParticipatnIgnored(part)) continue;
                                    String name = part.getClass().getName();
                                    parts.add(name);
                                }
                                if (parts.size() > 0) {
                                    newproject.setContextValue(CONTEXT_PARTICIPANTS, parts);
                                }
                            }
                        }
                        catch (ComponentLookupException componentLookupException) {
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                        }
                    }
                }
                if (newproject != null) break block31;
            }
            catch (RuntimeException exc) {
                block32: {
                    try {
                        LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + pomFile, exc);
                        res = new DefaultMavenExecutionResult();
                        res.addException((Throwable)exc);
                        if (newproject != null) break block32;
                    }
                    catch (Throwable throwable) {
                        if (newproject == null) {
                            newproject = MavenProjectCache.getFallbackProject(res, pomFile);
                        }
                        newproject.setProjectBuildingRequest(null);
                        long endLoading = System.currentTimeMillis();
                        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
                        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                            LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                        }
                        if (LOG.isLoggable(Level.FINE) && !res.getExceptions().isEmpty()) {
                            LOG.log(Level.FINE, "Errors encountered during loading the project:");
                            for (Throwable t : res.getExceptions()) {
                                LOG.log(Level.FINE, "Maven reported:", t);
                            }
                        }
                        LOG.log(Level.FINE, "Loaded project flags - incomplete {0}, placeholder count {1}", new Object[]{MavenProjectCache.isIncompleteProject(newproject), placeholders.size()});
                        if (!placeholders.isEmpty()) {
                            LOG.log(Level.FINE, "Incomplete artifact encountered during loading the project: {0}", placeholders);
                            if (!MavenProjectCache.isIncompleteProject(newproject)) {
                                newproject.setContextValue(CONTEXT_PARTIAL_PROJECT, (Object)Boolean.TRUE);
                            }
                            newproject.setContextValue(CONTEXT_PLACEHOLDER_ARTIFACTS, placeholders);
                        }
                        throw throwable;
                    }
                    newproject = MavenProjectCache.getFallbackProject(res, pomFile);
                }
                newproject.setProjectBuildingRequest(null);
                long endLoading = System.currentTimeMillis();
                LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
                if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                    LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                }
                if (LOG.isLoggable(Level.FINE) && !res.getExceptions().isEmpty()) {
                    LOG.log(Level.FINE, "Errors encountered during loading the project:");
                    for (Throwable t : res.getExceptions()) {
                        LOG.log(Level.FINE, "Maven reported:", t);
                    }
                }
                LOG.log(Level.FINE, "Loaded project flags - incomplete {0}, placeholder count {1}", new Object[]{MavenProjectCache.isIncompleteProject(newproject), placeholders.size()});
                if (!placeholders.isEmpty()) {
                    LOG.log(Level.FINE, "Incomplete artifact encountered during loading the project: {0}", placeholders);
                    if (!MavenProjectCache.isIncompleteProject(newproject)) {
                        newproject.setContextValue(CONTEXT_PARTIAL_PROJECT, (Object)Boolean.TRUE);
                    }
                    newproject.setContextValue(CONTEXT_PLACEHOLDER_ARTIFACTS, placeholders);
                }
            }
            newproject = MavenProjectCache.getFallbackProject(res, pomFile);
        }
        newproject.setProjectBuildingRequest(null);
        long endLoading = System.currentTimeMillis();
        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
        }
        if (LOG.isLoggable(Level.FINE) && !res.getExceptions().isEmpty()) {
            LOG.log(Level.FINE, "Errors encountered during loading the project:");
            for (Throwable t : res.getExceptions()) {
                LOG.log(Level.FINE, "Maven reported:", t);
            }
        }
        LOG.log(Level.FINE, "Loaded project flags - incomplete {0}, placeholder count {1}", new Object[]{MavenProjectCache.isIncompleteProject(newproject), placeholders.size()});
        if (!placeholders.isEmpty()) {
            LOG.log(Level.FINE, "Incomplete artifact encountered during loading the project: {0}", placeholders);
            if (!MavenProjectCache.isIncompleteProject(newproject)) {
                newproject.setContextValue(CONTEXT_PARTIAL_PROJECT, (Object)Boolean.TRUE);
            }
            newproject.setContextValue(CONTEXT_PLACEHOLDER_ARTIFACTS, placeholders);
        }
        newproject.setContextValue(CONTEXT_LOAD_TIMESTAMP, (Object)startLoading);
        return newproject;
    }

    @NonNull
    private static MavenProject loadOriginalMavenProject(File pomFile, ProjectActionContext ctx, RunConfig runConf) {
        ProjectConfiguration cfg;
        MavenEmbedder projectEmbedder = EmbedderFactory.getProjectEmbedder();
        MavenProject newproject = null;
        FileObject projectDir = FileUtil.toFileObject((File)pomFile.getParentFile());
        if (projectDir == null || !projectDir.isValid()) {
            LOG.log(Level.INFO, "Project directory is not valid: {0} from pom {1}, parent {2}", new Object[]{projectDir, pomFile, pomFile.getParentFile()});
            return MavenProjectCache.getFallbackProject(pomFile);
        }
        M2AuxilaryConfigImpl aux = new M2AuxilaryConfigImpl(projectDir, false);
        ActiveConfigurationProvider config = new ActiveConfigurationProvider(projectDir, aux);
        M2Configuration active = config.getActiveConfiguration();
        if (ctx != null && ctx.getConfiguration() != null && (cfg = ctx.getConfiguration()) instanceof M2Configuration) {
            active = (M2Configuration)cfg;
        }
        try {
            List<Object> mavenConfigOpts = Collections.emptyList();
            for (FileObject root = projectDir; root != null; root = root.getParent()) {
                FileObject mavenConfig = root.getFileObject(".mvn/maven.config");
                if (mavenConfig == null || !mavenConfig.isData()) continue;
                mavenConfigOpts = Arrays.asList(mavenConfig.asText().split("\\s+"));
                LOG.log(Level.FINE, "Found maven config options: {0}", mavenConfigOpts);
                break;
            }
            MavenExecutionRequest req = projectEmbedder.createMavenExecutionRequest();
            req.addActiveProfiles(active.getActivatedProfiles());
            BiConsumer<String, String> addActiveProfiles = (opt, prefix) -> req.addActiveProfiles(Arrays.asList(opt.substring(prefix.length()).split(",")));
            Iterator<Object> optIt = mavenConfigOpts.iterator();
            while (optIt.hasNext()) {
                String opt2 = (String)optIt.next();
                if (opt2.equals("-P") || opt2.equals("--activate-profiles")) {
                    addActiveProfiles.accept((String)optIt.next(), "");
                    continue;
                }
                if (opt2.startsWith("-P")) {
                    addActiveProfiles.accept(opt2, "-P");
                    continue;
                }
                if (!opt2.startsWith("--activate-profiles=")) continue;
                addActiveProfiles.accept(opt2, "--activate-profiles=");
            }
            if (runConf != null) {
                req.addActiveProfiles(runConf.getActivatedProfiles());
            }
            if (ctx != null && ctx.getProfiles() != null) {
                req.addActiveProfiles(new ArrayList(ctx.getProfiles()));
            }
            req.setPom(pomFile);
            req.setNoSnapshotUpdates(true);
            req.setUpdateSnapshots(false);
            req.setInteractiveMode(false);
            req.setRecursive(false);
            req.setOffline(true);
            Properties uprops = req.getUserProperties();
            BiConsumer<String, String> setProperty = (opt, prefix) -> {
                String value = opt.substring(prefix.length());
                int equals = value.indexOf(61);
                if (equals != -1) {
                    uprops.setProperty(value.substring(0, equals), value.substring(equals + 1));
                } else {
                    uprops.setProperty(value, "true");
                }
            };
            optIt = mavenConfigOpts.iterator();
            while (optIt.hasNext()) {
                String opt3 = (String)optIt.next();
                if (opt3.equals("-D") || opt3.equals("--define")) {
                    setProperty.accept((String)optIt.next(), "");
                    continue;
                }
                if (opt3.startsWith("-D")) {
                    setProperty.accept(opt3, "-D");
                    continue;
                }
                if (!opt3.startsWith("--define=")) continue;
                setProperty.accept(opt3, "--define=");
            }
            uprops.putAll((Map<?, ?>)MavenProjectCache.createUserPropsForProjectLoading(active.getProperties()));
            if (ctx != null && ctx.getProperties() != null) {
                for (String k : ctx.getProperties().keySet()) {
                    uprops.setProperty(k, (String)ctx.getProperties().get(k));
                }
            }
            if (runConf != null && runConf.getProperties() != null) {
                Map<? extends String, ? extends String> props = runConf.getProperties();
                for (String string : props.keySet()) {
                    uprops.setProperty(string, props.get(string));
                }
            }
            req.setUserProperties(uprops);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "request property 'packaging': {0}", req.getSystemProperties().get("packaging"));
                LOG.log(Level.FINE, "embedder property 'packaging': {0}", projectEmbedder.getSystemProperties().get("packaging"));
            }
            newproject = MavenProjectCache.loadOriginalMavenProjectInternal(projectEmbedder, req);
        }
        catch (IOException exc) {
            DefaultMavenExecutionResult res = null;
            LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + pomFile, exc);
            res = new DefaultMavenExecutionResult();
            res.addException((Throwable)exc);
            newproject = MavenProjectCache.getFallbackProject((MavenExecutionResult)res, pomFile);
        }
        return newproject;
    }

    public static MavenProject getFallbackProject(MavenExecutionResult result, File projectFile) throws AssertionError {
        MavenProject toReturn = MavenProjectCache.getFallbackProject(projectFile);
        if (result == null) {
            return toReturn;
        }
        toReturn.setContextValue(CONTEXT_EXECUTION_RESULT, (Object)result);
        MavenProject partial = null;
        block0: for (Throwable t : result.getExceptions()) {
            ProjectBuildingException pbe;
            if (!(t instanceof ProjectBuildingException) || (pbe = (ProjectBuildingException)t).getResults() == null) continue;
            for (ProjectBuildingResult res : pbe.getResults()) {
                if (!projectFile.equals(res.getPomFile())) continue;
                partial = res.getProject();
                continue block0;
            }
        }
        if (partial != null) {
            toReturn.setContextValue(CONTEXT_PARTIAL_PROJECT, partial);
        }
        return toReturn;
    }

    public static MavenProject getFallbackProject(File projectFile) throws AssertionError {
        LOG.log(Level.FINE, "Creating fallback project for " + projectFile, new Throwable());
        MavenProject newproject = new MavenProject();
        newproject.setGroupId("error");
        newproject.setArtifactId("error");
        newproject.setVersion("0");
        newproject.setPackaging("pom");
        newproject.setName(Bundle.LBL_Incomplete_Project_Name());
        newproject.setDescription(Bundle.LBL_Incomplete_Project_Desc());
        newproject.setFile(projectFile);
        newproject.setContextValue(CONTEXT_FALLBACK_PROJECT, (Object)true);
        return newproject;
    }

    public static boolean isIncompleteProject(MavenProject prj) {
        return prj.getContextValue(CONTEXT_PARTIAL_PROJECT) != null;
    }

    public static boolean isFallbackproject(MavenProject prj) {
        if ("error".equals(prj.getGroupId()) && "error".equals(prj.getArtifactId()) && Bundle.LBL_Incomplete_Project_Name().equals(prj.getName())) {
            return true;
        }
        return prj.getContextValue(CONTEXT_FALLBACK_PROJECT) != null;
    }

    public static MavenProject getPartialProject(MavenProject prj) {
        Object o = prj.getContextValue(CONTEXT_PARTIAL_PROJECT);
        if (o instanceof MavenProject) {
            return (MavenProject)o;
        }
        return null;
    }

    public static Properties createUserPropsForProjectLoading(Map<String, String> activeConfiguration) {
        Properties props = new Properties();
        if (activeConfiguration != null) {
            props.putAll(activeConfiguration);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getMutex(File pomFile) {
        Map<File, Mutex> map = file2Mutex;
        synchronized (map) {
            Mutex mutex = file2Mutex.get(pomFile);
            if (mutex != null) {
                return mutex;
            }
            mutex = new Mutex();
            file2Mutex.put(pomFile, mutex);
            return mutex;
        }
    }
}

