/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class ContributorBlackList {
    private final Set<String> disabledContributors = new HashSet<String>();

    public boolean isDisabled(IConfigurationElement element) {
        return this.disabledContributors.contains(element.getContributor().getName());
    }

    public Set<String> getDisabledContributors() {
        return Collections.unmodifiableSet(new HashSet<String>(this.disabledContributors));
    }

    public void disableContributor(String pluginId) {
        this.disabledContributors.add(pluginId);
    }

    public void merge(ContributorBlackList blackList) {
        this.disabledContributors.addAll(blackList.getDisabledContributors());
    }
}

