/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.util.WildFlyProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class WildflyTabVisualPanel
extends JPanel {
    private final transient WildFlyProperties targetData;
    private final transient WildflyDeploymentManager dm;
    private final Set<ChangeListener> listeners = ConcurrentHashMap.newKeySet(2);
    private JTextField configFile;
    private JLabel description;
    private JButton openInstanceDirectorySelector;
    private JLabel parentDirectoryLabel;
    private JLabel spaceHack;

    public WildflyTabVisualPanel(DeploymentManager dm) {
        this.dm = (WildflyDeploymentManager)dm;
        this.targetData = new WildFlyProperties(this.dm);
        this.initComponents();
        this.configFile.setText(this.targetData.getServerProfile());
        this.configFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }
        });
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"StepName_EnterDomainDirectory");
    }

    String getParentDirectory() {
        return this.configFile.getText();
    }

    public final void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    void locationChanged() {
        this.fireChangeEvent();
    }

    private String browseDomainLocation() {
        String insLocation = null;
        JFileChooser chooser = new JFileChooser();
        this.decorateChooser(chooser, this.configFile.getText(), NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Choose_Domain"));
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Choose_Button"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    void decorateChooser(JFileChooser chooser, String fname, String title) {
        chooser.setDialogTitle(title);
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"Choose_Button_Mnemonic").charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        if (null != fname && fname.length() > 0) {
            File sel = new File(fname);
            if (sel.isDirectory()) {
                chooser.setCurrentDirectory(sel);
            } else {
                chooser.setSelectedFile(sel);
            }
        }
    }

    private void initComponents() {
        this.description = new JLabel();
        this.parentDirectoryLabel = new JLabel();
        this.configFile = new JTextField();
        this.openInstanceDirectorySelector = new JButton();
        this.spaceHack = new JLabel();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/javaee/wildfly/customizer/Bundle");
        this.description.setText(bundle.getString("TXT_instanceDirectoryDescription2"));
        this.description.setEnabled(false);
        this.description.setFocusable(false);
        this.parentDirectoryLabel.setLabelFor(this.configFile);
        Mnemonics.setLocalizedText((JLabel)this.parentDirectoryLabel, (String)NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_ParentFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.openInstanceDirectorySelector, (String)NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_openInstanceDirectorySelector"));
        this.openInstanceDirectorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WildflyTabVisualPanel.this.openInstanceDirectorySelectorActionPerformed(evt);
            }
        });
        this.spaceHack.setEnabled(false);
        this.spaceHack.setFocusable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spaceHack).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.parentDirectoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configFile, -1, 187, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openInstanceDirectorySelector).addGap(12, 12, 12)).addComponent(this.description, -2, 400, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spaceHack).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.description).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parentDirectoryLabel, -2, 23, -2).addComponent(this.configFile, -2, -1, -2).addComponent(this.openInstanceDirectorySelector)).addContainerGap(-1, Short.MAX_VALUE)));
        this.configFile.getAccessibleContext().setAccessibleDescription(bundle.getString("DSC_instanceDirectory"));
        this.openInstanceDirectorySelector.getAccessibleContext().setAccessibleDescription(bundle.getString("DSC_openInstanceDirectorySelector"));
    }

    private void openInstanceDirectorySelectorActionPerformed(ActionEvent evt) {
        String val = this.browseDomainLocation();
        this.dm.getInstanceProperties().setProperty("config_file", val);
        if (null != val && val.length() >= 1) {
            this.configFile.setText(val);
        }
    }
}

