/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.rename;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.php.findusages.PhpWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.php.findusages.WarningFileElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.Bundle;
import org.netbeans.modules.refactoring.php.rename.FileRenamer;
import org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringUI;
import org.netbeans.modules.refactoring.php.rename.RenameDiffElement;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PhpRenameRefactoringPlugin
extends PhpWhereUsedQueryPlugin {
    public PhpRenameRefactoringPlugin(RenameRefactoring refactoring) {
        super((AbstractRefactoring)refactoring);
    }

    @Override
    public Problem checkParameters() {
        String newName = this.getRefactoring().getNewName();
        if (newName != null) {
            File parentFolder;
            File possibleNewFile;
            String trimmedNewName = newName.trim();
            if (trimmedNewName.length() == 0) {
                return new Problem(true, Bundle.MSG_Error_ElementEmpty());
            }
            WhereUsedSupport usages = this.getUsages();
            String oldName = PhpRenameRefactoringUI.getElementName(usages.getName(), usages.getElementKind());
            if (trimmedNewName.equals(oldName.trim())) {
                return new Problem(true, Bundle.MSG_Error_SameName());
            }
            PhpRenameRefactoringUI.RenameDeclarationFile renameDeclarationFile = (PhpRenameRefactoringUI.RenameDeclarationFile)this.getRefactoring().getContext().lookup(PhpRenameRefactoringUI.RenameDeclarationFile.class);
            FileObject declarationFileObject = usages.getDeclarationFileObject();
            if (renameDeclarationFile.renameDeclarationFile() && (possibleNewFile = new File(parentFolder = FileUtil.toFile((FileObject)declarationFileObject.getParent()), trimmedNewName + "." + declarationFileObject.getExt())).isFile()) {
                return new Problem(true, Bundle.MSG_Error_FileExists(trimmedNewName));
            }
        }
        return null;
    }

    public RenameRefactoring getRefactoring() {
        return (RenameRefactoring)this.refactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    @Override
    protected void refactorResults(WhereUsedSupport.Results results, RefactoringElementsBag refactoringElements, FileObject declarationFileObject) {
        ModificationResult modificationResult = new ModificationResult();
        Collection<WhereUsedElement> resultElements = results.getResultElements();
        for (WhereUsedElement whereUsedElement : resultElements) {
            this.refactorElement(modificationResult, whereUsedElement);
        }
        PhpRenameRefactoringUI.RenameDeclarationFile renameDeclarationFile = (PhpRenameRefactoringUI.RenameDeclarationFile)this.refactoring.getContext().lookup(PhpRenameRefactoringUI.RenameDeclarationFile.class);
        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                FileRenamer fileRenamer = FileRenamer.NONE;
                if (fo.equals(declarationFileObject) && renameDeclarationFile != null) {
                    fileRenamer = new DelcarationFileRenamer(fo, renameDeclarationFile);
                }
                refactoringElements.add(this.refactoring, (RefactoringElementImplementation)RenameDiffElement.create(diff, fo, modificationResult, fileRenamer));
            }
        }
        Collection<WarningFileElement> collection = results.getWarningElements();
        for (WarningFileElement warningElement : collection) {
            refactoringElements.add(this.refactoring, (RefactoringElementImplementation)warningElement);
        }
    }

    private void refactorElement(ModificationResult modificationResult, WhereUsedElement whereUsedElement) {
        ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, whereUsedElement.getPosition().getBegin(), whereUsedElement.getPosition().getEnd(), whereUsedElement.getName(), this.getRefactoring().getNewName(), whereUsedElement.getDisplayText()));
        if (!diffs.isEmpty()) {
            modificationResult.addDifferences(whereUsedElement.getFile(), diffs);
        }
    }

    public static final class DelcarationFileRenamer
    implements FileRenamer {
        private final FileObject declarationFileObject;
        private final PhpRenameRefactoringUI.RenameDeclarationFile renameDeclarationFile;

        private DelcarationFileRenamer(FileObject declarationFileObject, PhpRenameRefactoringUI.RenameDeclarationFile renameDeclarationFile) {
            assert (declarationFileObject != null);
            assert (renameDeclarationFile != null);
            this.declarationFileObject = declarationFileObject;
            this.renameDeclarationFile = renameDeclarationFile;
        }

        @Override
        public void rename(String newName) {
            assert (newName != null);
            if (!newName.equals(this.declarationFileObject.getName()) && this.renameDeclarationFile.renameDeclarationFile()) {
                try {
                    FileLock lock = this.declarationFileObject.lock();
                    this.declarationFileObject.rename(lock, this.renameDeclarationFile.adjustName(newName), this.declarationFileObject.getExt());
                    lock.releaseLock();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

