/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;

class ClassLoaderManager
implements CommonConstants {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.server.ClassLoaderManager") != null;
    private static ProfilerServer profilerServer;
    private static WeakHashMap<ClassLoader, ClassLoaderManager> manMap;
    private static Vector<ClassLoaderManager> manVec;
    private static ReferenceQueue rq;
    private static boolean notifyToolAboutUnloadedClasses;
    private static Method findLoadedClassMethod;
    private static Method findBootstrapClassMethod;
    private static boolean notifyThreadIsRunning;
    private PhantomReference targetLdrPhantomRef;
    private WeakReference targetLdrWeakRef;
    private int indexIntoManVec;
    private int parentLoaderId;

    private ClassLoaderManager(ClassLoader targetLoader, int indexIntoManVec) {
        this.targetLdrWeakRef = new WeakReference<ClassLoader>(targetLoader);
        this.targetLdrPhantomRef = new PhantomReference<ClassLoader>(targetLoader, rq);
        this.indexIntoManVec = indexIntoManVec;
    }

    public String toString() {
        return "CLManager: indexIntoManVec = " + this.indexIntoManVec + ", parentLoaderId = " + this.parentLoaderId;
    }

    static int getDefiningLoaderForClass(String className, int initiatingLoaderId) {
        if (initiatingLoaderId >= manVec.size()) {
            return -1;
        }
        ClassLoaderManager man = manVec.get(initiatingLoaderId);
        if (man == null || man.targetLdrWeakRef.get() == null) {
            return -1;
        }
        Class clazz = man.getLoadedClassInThisLoaderOnly(className);
        if (clazz != null) {
            return ClassLoaderManager.registerLoader(clazz);
        }
        return -1;
    }

    static Class getLoadedClass(String name, int loaderIdx) {
        Class res;
        if (loaderIdx == -1) {
            loaderIdx = 0;
        }
        if ((res = manVec.get(loaderIdx).getLoadedClass(name)) != null) {
            return res;
        }
        System.err.println("*** Profiler engine warning: class " + name + " that should be instrumented is not loaded by target VM");
        ClassLoader errLoader = (ClassLoader)ClassLoaderManager.manVec.get((int)loaderIdx).targetLdrWeakRef.get();
        System.err.print("*** Requested classloader: " + errLoader);
        if (errLoader != null) {
            System.err.println(", its class = " + errLoader.getClass() + ", index = " + loaderIdx + ", hashcode = " + errLoader.hashCode());
        } else {
            System.err.println(", its index = " + loaderIdx);
        }
        return null;
    }

    static void setNotifyToolAboutUnloadedClasses(boolean v) {
        notifyToolAboutUnloadedClasses = v;
    }

    static int[] getParentLoaderIdTable() {
        int size = manVec.size();
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = ClassLoaderManager.manVec.get((int)i).parentLoaderId;
        }
        return ret;
    }

    static int[] getThisAndParentLoaderData(int thisLoaderId) {
        if (thisLoaderId == -1 || thisLoaderId == 0) {
            return new int[]{0, 0, 0};
        }
        int parentLoaderId = ClassLoaderManager.manVec.get((int)thisLoaderId).parentLoaderId;
        if (parentLoaderId == -1) {
            parentLoaderId = 0;
        }
        if (parentLoaderId <= thisLoaderId) {
            return new int[]{thisLoaderId, parentLoaderId, 0};
        }
        int ofs = 0;
        int curLoaderId = thisLoaderId;
        while (parentLoaderId > curLoaderId) {
            ++ofs;
            curLoaderId = parentLoaderId;
            parentLoaderId = ClassLoaderManager.manVec.get((int)curLoaderId).parentLoaderId;
        }
        if (parentLoaderId < 0) {
            parentLoaderId = 0;
        }
        return new int[]{thisLoaderId, parentLoaderId, ofs};
    }

    static void addLoader(ClassLoader loader) {
        ClassLoaderManager ldrMan;
        if (DEBUG) {
            System.out.println("Add loader for: " + loader);
        }
        if ((ldrMan = manMap.get(loader)) != null) {
            return;
        }
        int newId = manVec.size();
        ldrMan = new ClassLoaderManager(loader, newId);
        if (DEBUG) {
            System.out.println("ClassLoaderManager.DEBUG: Add loader for: " + loader + ", new Id: " + newId);
        }
        manMap.put(loader, ldrMan);
        manVec.add(ldrMan);
    }

    static void checkForUnloadedClasses() {
        if (rq == null) {
            return;
        }
        PhantomReference clRef = null;
        clRef = (PhantomReference)rq.poll();
        if (clRef != null) {
            if (notifyToolAboutUnloadedClasses) {
                if (!notifyThreadIsRunning) {
                    class NotifyThread
                    extends Thread {
                        private PhantomReference clRef;

                        NotifyThread(PhantomReference clRef) {
                            this.clRef = clRef;
                            ThreadInfo.addProfilerServerThread(this);
                        }

                        @Override
                        public void run() {
                            notifyThreadIsRunning = true;
                            do {
                                ProfilerInterface.dumpExistingResults(false);
                                ProfilerInterface.serialClientOperationsLock.beginTrans(true);
                                try {
                                    profilerServer.sendClassLoaderUnloadingCommand();
                                }
                                finally {
                                    ProfilerInterface.serialClientOperationsLock.endTrans();
                                }
                                this.clRef.clear();
                            } while ((this.clRef = (PhantomReference)rq.poll()) != null);
                            Classes.notifyAboutClassLoaderUnloading();
                            ThreadInfo.removeProfilerServerThread(this);
                            notifyThreadIsRunning = false;
                        }
                    }
                    new NotifyThread(clRef).start();
                }
            } else {
                do {
                    clRef.clear();
                } while ((clRef = (PhantomReference)rq.poll()) != null);
                Classes.notifyAboutClassLoaderUnloading();
            }
        }
    }

    static void initialize(ProfilerServer inProfilerServer) {
        try {
            Class<ClassLoader> classLoaderClass = ClassLoader.class;
            Class[] stringArg = new Class[]{String.class};
            findLoadedClassMethod = classLoaderClass.getDeclaredMethod("findLoadedClass", stringArg);
            findLoadedClassMethod.setAccessible(true);
            findBootstrapClassMethod = classLoaderClass.getDeclaredMethod("findBootstrapClass", stringArg);
            findBootstrapClassMethod.setAccessible(true);
        }
        catch (Exception ex) {
            System.err.println("*** Profiler engine warning: Cannot use ClassLoader.findLoadedClass() and/or ClassLoader.findBootstrapClass() in ClassLoaderManager");
            if (DEBUG) {
                ex.printStackTrace(System.err);
            }
            findLoadedClassMethod = null;
            findBootstrapClassMethod = null;
        }
        ClassLoaderManager clm = new ClassLoaderManager(ClassLoader.getSystemClassLoader(), 0);
        clm.getLoadedClass("java.lang.String");
        profilerServer = inProfilerServer;
        manMap = new WeakHashMap();
        manVec = new Vector();
        rq = new ReferenceQueue();
    }

    static int registerLoader(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            return -1;
        }
        int ret = ClassLoaderManager.registerLoader(loader);
        if (DEBUG) {
            System.out.println("ClassLoaderManager.DEBUG: Register loader for: " + clazz.getName() + ", ldr: " + loader + ", id: " + ret);
        }
        return ret;
    }

    private static synchronized int registerLoader(ClassLoader loader) {
        ClassLoaderManager ldrMan = manMap.get(loader);
        if (ldrMan != null) {
            if (ldrMan.targetLdrWeakRef.get() == loader) {
                return ldrMan.indexIntoManVec;
            }
            int size = manVec.size();
            for (int i = 0; i < size; ++i) {
                ldrMan = manVec.get(i);
                if (ldrMan.targetLdrWeakRef.get() != loader) continue;
                return ldrMan.indexIntoManVec;
            }
        }
        int ldrIdx = manVec.size();
        ldrMan = new ClassLoaderManager(loader, ldrIdx);
        manMap.put(loader, ldrMan);
        manVec.add(ldrMan);
        ClassLoader parentLoader = loader.getParent();
        ldrMan.parentLoaderId = parentLoader != null ? ClassLoaderManager.registerLoader(parentLoader) : -1;
        return ldrIdx;
    }

    private Class getLoadedClass(String className) {
        try {
            Object[] args = new Object[]{className};
            for (ClassLoader loader = (ClassLoader)this.targetLdrWeakRef.get(); loader != null; loader = loader.getParent()) {
                Class res = this.getLoadedClassInThisLoaderOnly(className);
                if (res == null) continue;
                return res;
            }
            if (findBootstrapClassMethod != null) {
                try {
                    return (Class)findBootstrapClassMethod.invoke((Object)ClassLoader.getSystemClassLoader(), args);
                }
                catch (Exception ex) {
                    System.err.println("Profiler Agent Error: internal error in ClassLoaderManager 1");
                    ex.printStackTrace(System.err);
                    return null;
                }
            }
            return ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("*** Profiler engine warning: CNFE for " + className + " in ClassLoaderManager ");
            if (DEBUG) {
                ex.printStackTrace(System.err);
            }
        }
        catch (Exception ex) {
            System.err.println("Profiler Agent Error: internal error in ClassLoaderManager 1");
            ex.printStackTrace(System.err);
        }
        return null;
    }

    private Class getLoadedClassInThisLoaderOnly(String className) {
        Class clazz = null;
        ClassLoader loader = (ClassLoader)this.targetLdrWeakRef.get();
        if (loader == null) {
            return null;
        }
        if (findLoadedClassMethod != null) {
            try {
                Object[] args = new Object[]{className};
                clazz = (Class)findLoadedClassMethod.invoke((Object)loader, args);
            }
            catch (Exception ex) {
                System.err.println("Profiler Agent Error: internal error in ClassLoaderManager 2");
                ex.printStackTrace(System.err);
            }
        }
        if (findLoadedClassMethod == null || clazz == null && this.indexIntoManVec > 0) {
            try {
                clazz = loader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("*** Profiler engine warning: CNFE in getLoadedClassInThisLoaderOnly " + ex.getLocalizedMessage() + " for " + className + " classloaderId " + this.indexIntoManVec + " classLoader: " + loader);
            }
        }
        return clazz;
    }
}

