/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class PropertyNode
extends Node {
    protected final Expression key;
    protected final Expression value;
    protected final FunctionNode getter;
    protected final FunctionNode setter;
    protected final List<Expression> decorators;
    protected final boolean isStatic;
    protected final boolean computed;

    public PropertyNode(long token, int finish, Expression key, Expression value, FunctionNode getter, FunctionNode setter, boolean isStatic, boolean computed, List<Expression> decorators) {
        super(token, finish);
        this.key = key;
        this.value = value;
        this.getter = getter;
        this.setter = setter;
        this.isStatic = isStatic;
        this.computed = computed;
        this.decorators = decorators;
    }

    protected PropertyNode(PropertyNode propertyNode, Expression key, Expression value, FunctionNode getter, FunctionNode setter, boolean isStatic, boolean computed, List<Expression> decorators) {
        super(propertyNode);
        this.key = key;
        this.value = value;
        this.getter = getter;
        this.setter = setter;
        this.isStatic = isStatic;
        this.computed = computed;
        this.decorators = decorators;
    }

    public String getKeyName() {
        return this.key instanceof PropertyKey ? ((PropertyKey)((Object)this.key)).getPropertyName() : null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterPropertyNode(this)) {
            return visitor.leavePropertyNode(this.setKey((Expression)this.key.accept(visitor)).setValue(this.value == null ? null : (Expression)this.value.accept(visitor)).setGetter(this.getter == null ? null : (FunctionNode)this.getter.accept(visitor)).setSetter(this.setter == null ? null : (FunctionNode)this.setter.accept(visitor)).setDecorators(Node.accept(visitor, this.decorators)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterPropertyNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        if (this.value instanceof FunctionNode && ((FunctionNode)this.value).getIdent() != null) {
            this.value.toString(sb);
        }
        if (this.value != null) {
            this.key.toString(sb, printType);
            sb.append(": ");
            this.value.toString(sb, printType);
        }
        if (this.getter != null) {
            sb.append(' ');
            this.getter.toString(sb, printType);
        }
        if (this.setter != null) {
            sb.append(' ');
            this.setter.toString(sb, printType);
        }
    }

    public FunctionNode getGetter() {
        return this.getter;
    }

    public PropertyNode setGetter(FunctionNode getter) {
        if (this.getter == getter) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, getter, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public Expression getKey() {
        return this.key;
    }

    private PropertyNode setKey(Expression key) {
        if (this.key == key) {
            return this;
        }
        return new PropertyNode(this, key, this.value, this.getter, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public FunctionNode getSetter() {
        return this.setter;
    }

    public PropertyNode setSetter(FunctionNode setter) {
        if (this.setter == setter) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, this.getter, setter, this.isStatic, this.computed, this.decorators);
    }

    public Expression getValue() {
        return this.value;
    }

    public PropertyNode setValue(Expression value) {
        if (this.value == value) {
            return this;
        }
        return new PropertyNode(this, this.key, value, this.getter, this.setter, this.isStatic, this.computed, this.decorators);
    }

    public List<Expression> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    private PropertyNode setDecorators(List<Expression> decorators) {
        if (this.decorators == decorators) {
            return this;
        }
        return new PropertyNode(this, this.key, this.value, this.getter, this.setter, this.isStatic, this.computed, decorators);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isComputed() {
        return this.computed;
    }
}

