/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wifi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.F.C;
import com.ubnt.model.api.wifi.ImmutableWifiConnectivityEventsGroupDto;
import com.ubnt.model.api.wifi.WifiConnectivityEventDto;
import com.ubnt.service.client.super.oooo;
import com.ubnt.service.wifi.connection.B;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableWifiConnectivityEventsGroupDto.class)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@C
public interface WifiConnectivityEventsGroupDto
extends Comparable<WifiConnectivityEventsGroupDto> {
    @JsonProperty(value="client")
    public oooo client();

    @JsonProperty(value="failure_stage")
    public B failureStage();

    @JsonProperty(value="ap_macs")
    public Set<String> apMacs();

    @JsonProperty(value="start_time")
    public long startTime();

    @JsonProperty(value="events")
    public List<WifiConnectivityEventDto> events();

    @JsonIgnore
    public List<Long> latencies();

    @JsonProperty(value="latency_avg")
    @Value.Derived
    default public Optional<Long> latencyAverage() {
        return this.latencies().stream().mapToLong(Long::valueOf).average().stream().mapToLong(Math::round).boxed().findFirst();
    }

    @Override
    default public int compareTo(WifiConnectivityEventsGroupDto wifiConnectivityEventsGroupDto) {
        return Comparator.comparingLong(WifiConnectivityEventsGroupDto::startTime).reversed().compare(this, wifiConnectivityEventsGroupDto);
    }

    public static ImmutableWifiConnectivityEventsGroupDto.Builder builder() {
        return ImmutableWifiConnectivityEventsGroupDto.builder();
    }
}

