/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.clients;

import com.ubnt.data.Site;
import com.ubnt.model.api.HistoricalActivityResponse;
import com.ubnt.model.api.HistoricalSatisfactionDto;
import com.ubnt.model.api.HistoricalScoreResponse;
import com.ubnt.model.api.TrafficInsightsOverviewDto;
import com.ubnt.model.api.TrafficInsightsResponse;
import com.ubnt.model.api.client.ClientApStatisticDto;
import com.ubnt.model.api.client.ClientApStatisticsResponseDto;
import com.ubnt.model.api.client.ClientTrafficControlDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.service.client.b;
import com.ubnt.service.client.g;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Client Statistics")
public class ClientStatisticsController {
    private final b \u00d200000;
    private final g o00000;
    private final Clock \u00d300000;

    public ClientStatisticsController(b b2, g g2, Clock clock) {
        this.\u00d200000 = b2;
        this.o00000 = g2;
        this.\u00d300000 = clock;
    }

    @AllowPrivilege(value={"hotspot"})
    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/24hr-satisfaction"})
    public HistoricalScoreResponse<HistoricalSatisfactionDto> getLast24HrSatisfactionScores(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        return HistoricalScoreResponse.of(this.\u00d200000.\u00f400000(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/24hr-activity"})
    public HistoricalActivityResponse getLast24HrActivity(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        return HistoricalActivityResponse.of(this.\u00d200000.\u00d500000(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/ap-stats"})
    public ClientApStatisticsResponseDto getClientApStatistics(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string, @RequestParam(value="start", required=false) @Parameter(schema=@Schema(defaultValue="Last 24 hours")) Long l2) {
        Instant instant = this.\u00d300000.instant();
        long l3 = Optional.ofNullable(l2).orElseGet(() -> instant.minus(Duration.ofHours(24L)).toEpochMilli());
        return ClientApStatisticsResponseDto.of(this.\u00d200000.float(site.getId(), string, l3, instant.toEpochMilli()).stream().map(e2 -> ClientApStatisticDto.builder().deviceMac(e2.\u00d400000()).deviceName(e2.\u00d200000()).sessionTimeSeconds(e2.\u00d300000()).build()).toList());
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/traffic-insights"})
    public TrafficInsightsResponse getTrafficInsights(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        TrafficInsightsOverviewDto trafficInsightsOverviewDto = this.\u00d200000.oo0000(site.getId(), string);
        return TrafficInsightsResponse.of(trafficInsightsOverviewDto);
    }

    @GetMapping(value={"/api/site/{siteName}/clients/traffic-control"})
    public ClientTrafficControlDto getTrafficControl(@PathVariable(value="siteName") Site site) {
        return ClientTrafficControlDto.of(this.o00000.super(site.getId()));
    }
}

