/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.sslinspection.logs.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.sslinspection.SslInspectionRisk;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEvent;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventMessageDto;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventProtocol;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventType;
import com.ubnt.service.sslinspection.logs.model.SslInspectionFirmwareEventDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="SslInspectionEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSslInspectionEvent
implements SslInspectionEvent {
    @Nullable
    private final Long flowId;
    private final ZonedDateTime time;
    private final SslInspectionEventType type;
    private final String gatewayMac;
    private final String clientIp;
    private final int clientPort;
    private final String serverIp;
    private final int serverPort;
    private final SslInspectionEventProtocol protocol;
    @Nullable
    private final SslInspectionRisk risk;
    private final SslInspectionEventMessageDto message;
    private final String siteId;

    private ImmutableSslInspectionEvent(@Nullable Long l2, ZonedDateTime zonedDateTime, SslInspectionEventType sslInspectionEventType, String string, String string2, int n2, String string3, int n3, SslInspectionEventProtocol sslInspectionEventProtocol, @Nullable SslInspectionRisk sslInspectionRisk, SslInspectionEventMessageDto sslInspectionEventMessageDto, String string4) {
        this.flowId = l2;
        this.time = zonedDateTime;
        this.type = sslInspectionEventType;
        this.gatewayMac = string;
        this.clientIp = string2;
        this.clientPort = n2;
        this.serverIp = string3;
        this.serverPort = n3;
        this.protocol = sslInspectionEventProtocol;
        this.risk = sslInspectionRisk;
        this.message = sslInspectionEventMessageDto;
        this.siteId = string4;
    }

    @Override
    @JsonProperty(value="flow_id")
    public Optional<Long> flowId() {
        return Optional.ofNullable(this.flowId);
    }

    @Override
    @JsonProperty(value="time")
    public ZonedDateTime time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="type")
    public SslInspectionEventType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="gateway_mac")
    public String gatewayMac() {
        return this.gatewayMac;
    }

    @Override
    @JsonProperty(value="client_ip")
    public String clientIp() {
        return this.clientIp;
    }

    @Override
    @JsonProperty(value="client_port")
    public int clientPort() {
        return this.clientPort;
    }

    @Override
    @JsonProperty(value="server_ip")
    public String serverIp() {
        return this.serverIp;
    }

    @Override
    @JsonProperty(value="server_port")
    public int serverPort() {
        return this.serverPort;
    }

    @Override
    @JsonProperty(value="protocol")
    public SslInspectionEventProtocol protocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="risk")
    public Optional<SslInspectionRisk> risk() {
        return Optional.ofNullable(this.risk);
    }

    @Override
    @JsonProperty(value="message")
    public SslInspectionEventMessageDto message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="siteId")
    public String siteId() {
        return this.siteId;
    }

    public final ImmutableSslInspectionEvent withFlowId(long l2) {
        Long l3 = l2;
        if (Objects.equals(this.flowId, l3)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(l3, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withFlowId(Optional<Long> optional) {
        Long l2 = optional.orElse(null);
        if (Objects.equals(this.flowId, l2)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(l2, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withTime(ZonedDateTime zonedDateTime) {
        if (this.time == zonedDateTime) {
            return this;
        }
        ZonedDateTime zonedDateTime2 = Objects.requireNonNull(zonedDateTime, "time");
        return new ImmutableSslInspectionEvent(this.flowId, zonedDateTime2, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withType(SslInspectionEventType sslInspectionEventType) {
        SslInspectionEventType sslInspectionEventType2 = Objects.requireNonNull(sslInspectionEventType, "type");
        if (this.type == sslInspectionEventType2) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, sslInspectionEventType2, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withGatewayMac(String string) {
        String string2 = Objects.requireNonNull(string, "gatewayMac");
        if (this.gatewayMac.equals(string2)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, string2, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withClientIp(String string) {
        String string2 = Objects.requireNonNull(string, "clientIp");
        if (this.clientIp.equals(string2)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, string2, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withClientPort(int n2) {
        if (this.clientPort == n2) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, n2, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withServerIp(String string) {
        String string2 = Objects.requireNonNull(string, "serverIp");
        if (this.serverIp.equals(string2)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, string2, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withServerPort(int n2) {
        if (this.serverPort == n2) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, n2, this.protocol, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withProtocol(SslInspectionEventProtocol sslInspectionEventProtocol) {
        SslInspectionEventProtocol sslInspectionEventProtocol2 = Objects.requireNonNull(sslInspectionEventProtocol, "protocol");
        if (this.protocol == sslInspectionEventProtocol2) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, sslInspectionEventProtocol2, this.risk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withRisk(SslInspectionRisk sslInspectionRisk) {
        SslInspectionRisk sslInspectionRisk2 = Objects.requireNonNull(sslInspectionRisk, "risk");
        if (this.risk == sslInspectionRisk2) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, sslInspectionRisk2, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withRisk(Optional<? extends SslInspectionRisk> optional) {
        SslInspectionRisk sslInspectionRisk = optional.orElse(null);
        if (this.risk == sslInspectionRisk) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, sslInspectionRisk, this.message, this.siteId);
    }

    public final ImmutableSslInspectionEvent withMessage(SslInspectionEventMessageDto sslInspectionEventMessageDto) {
        if (this.message == sslInspectionEventMessageDto) {
            return this;
        }
        SslInspectionEventMessageDto sslInspectionEventMessageDto2 = Objects.requireNonNull(sslInspectionEventMessageDto, "message");
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, sslInspectionEventMessageDto2, this.siteId);
    }

    public final ImmutableSslInspectionEvent withSiteId(String string) {
        String string2 = Objects.requireNonNull(string, "siteId");
        if (this.siteId.equals(string2)) {
            return this;
        }
        return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, string2);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableSslInspectionEvent && this.\u00d200000(0, (ImmutableSslInspectionEvent)object);
    }

    private boolean \u00d200000(int n2, ImmutableSslInspectionEvent immutableSslInspectionEvent) {
        return Objects.equals(this.flowId, immutableSslInspectionEvent.flowId) && this.time.equals(immutableSslInspectionEvent.time) && this.type.equals((Object)immutableSslInspectionEvent.type) && this.gatewayMac.equals(immutableSslInspectionEvent.gatewayMac) && this.clientIp.equals(immutableSslInspectionEvent.clientIp) && this.clientPort == immutableSslInspectionEvent.clientPort && this.serverIp.equals(immutableSslInspectionEvent.serverIp) && this.serverPort == immutableSslInspectionEvent.serverPort && this.protocol.equals((Object)immutableSslInspectionEvent.protocol) && Objects.equals((Object)this.risk, (Object)immutableSslInspectionEvent.risk) && this.message.equals(immutableSslInspectionEvent.message) && this.siteId.equals(immutableSslInspectionEvent.siteId);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.flowId);
        n2 += (n2 << 5) + this.time.hashCode();
        n2 += (n2 << 5) + this.type.hashCode();
        n2 += (n2 << 5) + this.gatewayMac.hashCode();
        n2 += (n2 << 5) + this.clientIp.hashCode();
        n2 += (n2 << 5) + this.clientPort;
        n2 += (n2 << 5) + this.serverIp.hashCode();
        n2 += (n2 << 5) + this.serverPort;
        n2 += (n2 << 5) + this.protocol.hashCode();
        n2 += (n2 << 5) + Objects.hashCode((Object)this.risk);
        n2 += (n2 << 5) + this.message.hashCode();
        n2 += (n2 << 5) + this.siteId.hashCode();
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SslInspectionEvent").omitNullValues().add("flowId", (Object)this.flowId).add("time", (Object)this.time).add("type", (Object)this.type).add("gatewayMac", (Object)this.gatewayMac).add("clientIp", (Object)this.clientIp).add("clientPort", this.clientPort).add("serverIp", (Object)this.serverIp).add("serverPort", this.serverPort).add("protocol", (Object)this.protocol).add("risk", (Object)this.risk).add("message", (Object)this.message).add("siteId", (Object)this.siteId).toString();
    }

    public static ImmutableSslInspectionEvent copyOf(SslInspectionEvent sslInspectionEvent) {
        if (sslInspectionEvent instanceof ImmutableSslInspectionEvent) {
            return (ImmutableSslInspectionEvent)sslInspectionEvent;
        }
        return ImmutableSslInspectionEvent.builder().from(sslInspectionEvent).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="SslInspectionEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_GATEWAY_MAC = 4L;
        private static final long INIT_BIT_CLIENT_IP = 8L;
        private static final long INIT_BIT_CLIENT_PORT = 16L;
        private static final long INIT_BIT_SERVER_IP = 32L;
        private static final long INIT_BIT_SERVER_PORT = 64L;
        private static final long INIT_BIT_PROTOCOL = 128L;
        private static final long INIT_BIT_MESSAGE = 256L;
        private static final long INIT_BIT_SITE_ID = 512L;
        private long initBits = 1023L;
        @Nullable
        private Long flowId;
        @Nullable
        private ZonedDateTime time;
        @Nullable
        private SslInspectionEventType type;
        @Nullable
        private String gatewayMac;
        @Nullable
        private String clientIp;
        private int clientPort;
        @Nullable
        private String serverIp;
        private int serverPort;
        @Nullable
        private SslInspectionEventProtocol protocol;
        @Nullable
        private SslInspectionRisk risk;
        @Nullable
        private SslInspectionEventMessageDto message;
        @Nullable
        private String siteId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SslInspectionEvent sslInspectionEvent) {
            Objects.requireNonNull(sslInspectionEvent, "instance");
            this.o00000((short)0, sslInspectionEvent);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SslInspectionFirmwareEventDto sslInspectionFirmwareEventDto) {
            Objects.requireNonNull(sslInspectionFirmwareEventDto, "instance");
            this.o00000((short)0, sslInspectionFirmwareEventDto);
            return this;
        }

        private void o00000(short s2, Object object) {
            Optional<Object> optional;
            SslInspectionFirmwareEventDto sslInspectionFirmwareEventDto;
            long l2 = 0L;
            if (object instanceof SslInspectionEvent) {
                sslInspectionFirmwareEventDto = (SslInspectionEvent)object;
                if ((l2 & 8L) == 0L) {
                    this.protocol(sslInspectionFirmwareEventDto.protocol());
                    l2 |= 8L;
                }
                if ((l2 & 0x10L) == 0L) {
                    this.gatewayMac(sslInspectionFirmwareEventDto.gatewayMac());
                    l2 |= 0x10L;
                }
                if ((l2 & 0x20L) == 0L) {
                    this.clientIp(sslInspectionFirmwareEventDto.clientIp());
                    l2 |= 0x20L;
                }
                if ((l2 & 0x40L) == 0L) {
                    this.clientPort(sslInspectionFirmwareEventDto.clientPort());
                    l2 |= 0x40L;
                }
                if ((l2 & 0x80L) == 0L) {
                    this.serverIp(sslInspectionFirmwareEventDto.serverIp());
                    l2 |= 0x80L;
                }
                this.siteId(sslInspectionFirmwareEventDto.siteId());
                if ((l2 & 0x100L) == 0L) {
                    optional = sslInspectionFirmwareEventDto.risk();
                    if (optional.isPresent()) {
                        this.risk(optional);
                    }
                    l2 |= 0x100L;
                }
                if ((l2 & 0x200L) == 0L) {
                    this.time(sslInspectionFirmwareEventDto.time());
                    l2 |= 0x200L;
                }
                if ((l2 & 1L) == 0L) {
                    this.type(sslInspectionFirmwareEventDto.type());
                    l2 |= 1L;
                }
                if ((l2 & 2L) == 0L) {
                    this.serverPort(sslInspectionFirmwareEventDto.serverPort());
                    l2 |= 2L;
                }
                if ((l2 & 4L) == 0L) {
                    this.message(sslInspectionFirmwareEventDto.message());
                    l2 |= 4L;
                }
                if ((l2 & 0x400L) == 0L) {
                    optional = sslInspectionFirmwareEventDto.flowId();
                    if (optional.isPresent()) {
                        this.flowId(optional);
                    }
                    l2 |= 0x400L;
                }
            }
            if (object instanceof SslInspectionFirmwareEventDto) {
                sslInspectionFirmwareEventDto = (SslInspectionFirmwareEventDto)object;
                if ((l2 & 8L) == 0L) {
                    this.protocol(sslInspectionFirmwareEventDto.protocol());
                    l2 |= 8L;
                }
                if ((l2 & 0x10L) == 0L) {
                    this.gatewayMac(sslInspectionFirmwareEventDto.gatewayMac());
                    l2 |= 0x10L;
                }
                if ((l2 & 0x20L) == 0L) {
                    this.clientIp(sslInspectionFirmwareEventDto.clientIp());
                    l2 |= 0x20L;
                }
                if ((l2 & 0x40L) == 0L) {
                    this.clientPort(sslInspectionFirmwareEventDto.clientPort());
                    l2 |= 0x40L;
                }
                if ((l2 & 0x80L) == 0L) {
                    this.serverIp(sslInspectionFirmwareEventDto.serverIp());
                    l2 |= 0x80L;
                }
                if ((l2 & 0x100L) == 0L) {
                    optional = sslInspectionFirmwareEventDto.risk();
                    if (optional.isPresent()) {
                        this.risk(optional);
                    }
                    l2 |= 0x100L;
                }
                if ((l2 & 0x200L) == 0L) {
                    this.time(sslInspectionFirmwareEventDto.time());
                    l2 |= 0x200L;
                }
                if ((l2 & 1L) == 0L) {
                    this.type(sslInspectionFirmwareEventDto.type());
                    l2 |= 1L;
                }
                if ((l2 & 2L) == 0L) {
                    this.serverPort(sslInspectionFirmwareEventDto.serverPort());
                    l2 |= 2L;
                }
                if ((l2 & 4L) == 0L) {
                    this.message(sslInspectionFirmwareEventDto.message());
                    l2 |= 4L;
                }
                if ((l2 & 0x400L) == 0L) {
                    optional = sslInspectionFirmwareEventDto.flowId();
                    if (optional.isPresent()) {
                        this.flowId(optional);
                    }
                    l2 |= 0x400L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder flowId(long l2) {
            this.flowId = l2;
            return this;
        }

        @JsonProperty(value="flow_id")
        @CanIgnoreReturnValue
        public final Builder flowId(Optional<Long> optional) {
            this.flowId = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="time")
        @CanIgnoreReturnValue
        public final Builder time(ZonedDateTime zonedDateTime) {
            this.time = Objects.requireNonNull(zonedDateTime, "time");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(SslInspectionEventType sslInspectionEventType) {
            this.type = Objects.requireNonNull(sslInspectionEventType, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="gateway_mac")
        @CanIgnoreReturnValue
        public final Builder gatewayMac(String string) {
            this.gatewayMac = Objects.requireNonNull(string, "gatewayMac");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="client_ip")
        @CanIgnoreReturnValue
        public final Builder clientIp(String string) {
            this.clientIp = Objects.requireNonNull(string, "clientIp");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="client_port")
        @CanIgnoreReturnValue
        public final Builder clientPort(int n2) {
            this.clientPort = n2;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="server_ip")
        @CanIgnoreReturnValue
        public final Builder serverIp(String string) {
            this.serverIp = Objects.requireNonNull(string, "serverIp");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="server_port")
        @CanIgnoreReturnValue
        public final Builder serverPort(int n2) {
            this.serverPort = n2;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="protocol")
        @CanIgnoreReturnValue
        public final Builder protocol(SslInspectionEventProtocol sslInspectionEventProtocol) {
            this.protocol = Objects.requireNonNull(sslInspectionEventProtocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder risk(SslInspectionRisk sslInspectionRisk) {
            this.risk = Objects.requireNonNull(sslInspectionRisk, "risk");
            return this;
        }

        @JsonProperty(value="risk")
        @CanIgnoreReturnValue
        public final Builder risk(Optional<? extends SslInspectionRisk> optional) {
            this.risk = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="message")
        @CanIgnoreReturnValue
        public final Builder message(SslInspectionEventMessageDto sslInspectionEventMessageDto) {
            this.message = Objects.requireNonNull(sslInspectionEventMessageDto, "message");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="siteId")
        @CanIgnoreReturnValue
        public final Builder siteId(String string) {
            this.siteId = Objects.requireNonNull(string, "siteId");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableSslInspectionEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.\u00d200000());
            }
            return new ImmutableSslInspectionEvent(this.flowId, this.time, this.type, this.gatewayMac, this.clientIp, this.clientPort, this.serverIp, this.serverPort, this.protocol, this.risk, this.message, this.siteId);
        }

        private String \u00d200000() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("time");
            }
            if ((this.initBits & 2L) != 0L) {
                arrayList.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                arrayList.add("gatewayMac");
            }
            if ((this.initBits & 8L) != 0L) {
                arrayList.add("clientIp");
            }
            if ((this.initBits & 0x10L) != 0L) {
                arrayList.add("clientPort");
            }
            if ((this.initBits & 0x20L) != 0L) {
                arrayList.add("serverIp");
            }
            if ((this.initBits & 0x40L) != 0L) {
                arrayList.add("serverPort");
            }
            if ((this.initBits & 0x80L) != 0L) {
                arrayList.add("protocol");
            }
            if ((this.initBits & 0x100L) != 0L) {
                arrayList.add("message");
            }
            if ((this.initBits & 0x200L) != 0L) {
                arrayList.add("siteId");
            }
            return "Cannot build SslInspectionEvent, some of required attributes are not set " + arrayList;
        }
    }
}

