/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.client.ClientSession;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;

class MongoResourceHolder
extends ResourceHolderSupport {
    @Nullable
    private ClientSession session;
    private MongoDatabaseFactory dbFactory;

    MongoResourceHolder(@Nullable ClientSession session, MongoDatabaseFactory dbFactory) {
        this.session = session;
        this.dbFactory = dbFactory;
    }

    @Nullable
    ClientSession getSession() {
        return this.session;
    }

    ClientSession getRequiredSession() {
        ClientSession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("No session available");
        }
        return session;
    }

    public MongoDatabaseFactory getDbFactory() {
        return this.dbFactory;
    }

    public void setSession(@Nullable ClientSession session) {
        this.session = session;
    }

    void setTimeoutIfNotDefaulted(int seconds) {
        if (seconds != -1) {
            this.setTimeoutInSeconds(seconds);
        }
    }

    boolean hasSession() {
        return this.session != null;
    }

    boolean hasActiveSession() {
        if (!this.hasSession()) {
            return false;
        }
        return this.hasServerSession() && !this.getRequiredSession().getServerSession().isClosed();
    }

    boolean hasActiveTransaction() {
        if (!this.hasActiveSession()) {
            return false;
        }
        return this.getRequiredSession().hasActiveTransaction();
    }

    boolean hasServerSession() {
        try {
            return this.getRequiredSession().getServerSession() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }
}

