/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;

class JvmJvmstatModel_5
extends JvmJvmstatModel {
    private static final String PERM_GEN_PREFIX = "sun.gc.generation.2.";

    JvmJvmstatModel_5(Application app, JvmstatModel stat) {
        super(app, stat);
        this.initMonitoredVales();
    }

    private void initMonitoredVales() {
        this.loadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.loadedClasses");
        this.sharedLoadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedLoadedClasses");
        this.sharedUnloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedUnloadedClasses");
        this.unloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.unloadedClasses");
        this.threadsDaemon = this.jvmstat.findMonitoredValueByName("java.threads.daemon");
        this.threadsLive = this.jvmstat.findMonitoredValueByName("java.threads.live");
        this.threadsLivePeak = this.jvmstat.findMonitoredValueByName("java.threads.livePeak");
        this.threadsStarted = this.jvmstat.findMonitoredValueByName("java.threads.started");
        this.applicationTime = this.jvmstat.findMonitoredValueByName("sun.rt.applicationTime");
        this.upTime = this.jvmstat.findMonitoredValueByName("sun.os.hrt.ticks");
        MonitoredValue osFrequencyMon = this.jvmstat.findMonitoredValueByName("sun.os.hrt.frequency");
        this.osFrequency = this.getLongValue(osFrequencyMon);
        this.genCapacity = this.jvmstat.findMonitoredValueByPattern("sun.gc.generation.[0-9]+.capacity");
        this.genUsed = this.jvmstat.findMonitoredValueByPattern("sun.gc.generation.[0-9]+.space.[0-9]+.used");
        this.genMaxCapacity = this.getGenerationSum(this.jvmstat.findMonitoredValueByPattern("sun.gc.generation.[0-9]+.maxCapacity"));
    }

    protected String getPermGenPrefix() {
        return PERM_GEN_PREFIX;
    }
}

