/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasupport;

import java.io.Serializable;
import java.util.Comparator;
import org.graalvm.visualvm.core.datasupport.ClassNameComparator;

public interface Positionable {
    public static final int POSITION_AT_THE_END = 0x7FFFFFFE;
    public static final int POSITION_LAST = Integer.MAX_VALUE;
    public static final Comparator<Positionable> COMPARATOR = new PositionableComparator();
    public static final Comparator<Positionable> STRONG_COMPARATOR = new StrongPositionableComparator();

    public int getPreferredPosition();

    public static final class StrongPositionableComparator
    implements Comparator<Positionable>,
    Serializable {
        @Override
        public int compare(Positionable p1, Positionable p2) {
            int position2;
            int position1 = p1.getPreferredPosition();
            if (position1 > (position2 = p2.getPreferredPosition())) {
                return 1;
            }
            if (position1 < position2) {
                return -1;
            }
            if (p1.equals(p2)) {
                return 0;
            }
            int result = ClassNameComparator.INSTANCE.compare(p1, p2);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(System.identityHashCode(p1), System.identityHashCode(p2));
            if (result != 0) {
                return result;
            }
            result = Integer.compare(p1.hashCode(), p2.hashCode());
            if (result != 0) {
                return result;
            }
            return -1;
        }
    }

    public static final class PositionableComparator
    implements Comparator<Positionable>,
    Serializable {
        @Override
        public int compare(Positionable p1, Positionable p2) {
            int position1 = p1.getPreferredPosition();
            int position2 = p2.getPreferredPosition();
            return Integer.compare(position1, position2);
        }
    }
}

