/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.PackageScope;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.tree.Tree;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jspecify.nullness.Nullable;

public final class FileManagerClassBinder {
    public static ClassPath adapt(StandardJavaFileManager fileManager, StandardLocation location) {
        final PackageLookup packageLookup = new PackageLookup(fileManager, location);
        final Env<ClassSymbol, BytecodeBoundClass> env = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public @Nullable BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)packageLookup.getPackage(this, sym.packageName()).get(sym);
            }
        };
        final SimpleEnv moduleEnv = new SimpleEnv(ImmutableMap.of());
        final FileManagerTopLevelIndex tli = new FileManagerTopLevelIndex(env, packageLookup);
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return moduleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return tli;
            }

            @Override
            public @Nullable Supplier<byte[]> resource(String path) {
                return packageLookup.resource(path);
            }
        };
    }

    private FileManagerClassBinder() {
    }

    private static class FileManagerTopLevelIndex
    implements TopLevelIndex {
        private final Env<ClassSymbol, BytecodeBoundClass> env;
        private final PackageLookup packageLookup;

        public FileManagerTopLevelIndex(Env<ClassSymbol, BytecodeBoundClass> env, PackageLookup packageLookup) {
            this.env = env;
            this.packageLookup = packageLookup;
        }

        @Override
        public Scope scope() {
            return new Scope(){

                @Override
                public @Nullable LookupResult lookup(LookupKey lookupKey) {
                    for (int i = lookupKey.simpleNames().size(); i > 0; --i) {
                        String p = Joiner.on((char)'/').join((Iterable)lookupKey.simpleNames().subList(0, i));
                        ClassSymbol sym = new ClassSymbol(p);
                        BytecodeBoundClass r = (BytecodeBoundClass)env.get(sym);
                        if (r == null) continue;
                        return new LookupResult(sym, new LookupKey((ImmutableList<Tree.Ident>)lookupKey.simpleNames().subList(i - 1, lookupKey.simpleNames().size())));
                    }
                    return null;
                }
            };
        }

        @Override
        public @Nullable PackageScope lookupPackage(Iterable<String> names) {
            final String packageName = Joiner.on((char)'/').join(names);
            final Map pkg = this.packageLookup.getPackage(this.env, packageName);
            if (pkg.isEmpty()) {
                return null;
            }
            return new PackageScope(){

                @Override
                public Iterable<ClassSymbol> classes() {
                    return pkg.keySet();
                }

                @Override
                public @Nullable LookupResult lookup(LookupKey lookupKey) {
                    ClassSymbol sym;
                    String className = lookupKey.first().value();
                    if (!packageName.isEmpty()) {
                        className = packageName + "/" + className;
                    }
                    if (!pkg.containsKey(sym = new ClassSymbol(className))) {
                        return null;
                    }
                    return new LookupResult(sym, lookupKey);
                }
            };
        }
    }

    private static class PackageLookup {
        private final Map<String, Map<ClassSymbol, BytecodeBoundClass>> packages = new HashMap<String, Map<ClassSymbol, BytecodeBoundClass>>();
        private final StandardJavaFileManager fileManager;
        private final StandardLocation location;

        private PackageLookup(StandardJavaFileManager fileManager, StandardLocation location) {
            this.fileManager = fileManager;
            this.location = location;
        }

        private ImmutableMap<ClassSymbol, BytecodeBoundClass> listPackage(Env<ClassSymbol, BytecodeBoundClass> env, String packageName) throws IOException {
            HashMap<ClassSymbol, BytecodeBoundClass> result = new HashMap<ClassSymbol, BytecodeBoundClass>();
            for (final JavaFileObject jfo : this.fileManager.list(this.location, packageName.replace('/', '.'), EnumSet.of(JavaFileObject.Kind.CLASS), false)) {
                String binaryName = this.fileManager.inferBinaryName(this.location, jfo);
                ClassSymbol sym = new ClassSymbol(binaryName.replace('.', '/'));
                result.putIfAbsent(sym, new BytecodeBoundClass(sym, new Supplier<byte[]>(){

                    public byte[] get() {
                        try {
                            return jfo.openInputStream().readAllBytes();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }, env, null));
            }
            return ImmutableMap.copyOf(result);
        }

        private Map<ClassSymbol, BytecodeBoundClass> getPackage(Env<ClassSymbol, BytecodeBoundClass> env, String key) {
            return this.packages.computeIfAbsent(key, k -> {
                try {
                    return this.listPackage(env, key);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        public @Nullable Supplier<byte[]> resource(String resource) {
            FileObject fileObject;
            String name;
            String dir;
            int idx = resource.lastIndexOf(47);
            if (idx != -1) {
                dir = resource.substring(0, idx + 1);
                name = resource.substring(idx + 1, resource.length());
            } else {
                dir = "";
                name = resource;
            }
            try {
                fileObject = this.fileManager.getFileForInput(this.location, dir, name);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (fileObject == null) {
                return null;
            }
            return new Supplier<byte[]>(){

                public byte[] get() {
                    try {
                        return fileObject.openInputStream().readAllBytes();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
    }
}

