/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.type;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.AutoValue_Type_ArrayTy;
import com.google.turbine.type.AutoValue_Type_ClassTy;
import com.google.turbine.type.AutoValue_Type_ClassTy_SimpleClassTy;
import com.google.turbine.type.AutoValue_Type_IntersectionTy;
import com.google.turbine.type.AutoValue_Type_MethodTy;
import com.google.turbine.type.AutoValue_Type_PrimTy;
import com.google.turbine.type.AutoValue_Type_TyVar;
import com.google.turbine.type.AutoValue_Type_WildLowerBoundedTy;
import com.google.turbine.type.AutoValue_Type_WildUnboundedTy;
import com.google.turbine.type.AutoValue_Type_WildUpperBoundedTy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public interface Type {
    public static final Type VOID = new Type(){

        @Override
        public TyKind tyKind() {
            return TyKind.VOID_TY;
        }

        public final String toString() {
            return "void";
        }
    };
    public static final Type NONE = new Type(){

        @Override
        public TyKind tyKind() {
            return TyKind.NONE_TY;
        }

        public final String toString() {
            return "none";
        }
    };

    public TyKind tyKind();

    public static final class ErrorTy
    implements Type {
        private final String name;

        private ErrorTy(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String name() {
            return this.name;
        }

        public static ErrorTy create(Iterable<Tree.Ident> names) {
            ArrayList<String> bits = new ArrayList<String>();
            for (Tree.Ident ident : names) {
                bits.add(ident.value());
            }
            return ErrorTy.create(Joiner.on((char)'.').join(bits));
        }

        public static ErrorTy create(String name) {
            return new ErrorTy(name);
        }

        @Override
        public TyKind tyKind() {
            return TyKind.ERROR_TY;
        }

        public final String toString() {
            return this.name();
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final boolean equals(@Nullable Object other) {
            return false;
        }
    }

    @AutoValue
    public static abstract class MethodTy
    implements Type {
        public abstract ImmutableSet<TyVarSymbol> tyParams();

        public abstract Type returnType();

        public abstract @Nullable Type receiverType();

        public abstract ImmutableList<Type> parameters();

        public abstract ImmutableList<Type> thrown();

        public static MethodTy create(ImmutableSet<TyVarSymbol> tyParams, Type returnType, Type receiverType, ImmutableList<Type> parameters, ImmutableList<Type> thrown) {
            return new AutoValue_Type_MethodTy(tyParams, returnType, receiverType, parameters, thrown);
        }

        @Override
        public TyKind tyKind() {
            return TyKind.METHOD_TY;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.tyParams().isEmpty()) {
                sb.append('<');
                Joiner.on((char)',').appendTo(sb, this.tyParams());
                sb.append('>');
            }
            sb.append('(');
            Joiner.on((char)',').appendTo(sb, this.parameters());
            sb.append(')');
            sb.append(this.returnType());
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class IntersectionTy
    implements Type {
        public abstract ImmutableList<Type> bounds();

        public static IntersectionTy create(ImmutableList<Type> bounds) {
            return new AutoValue_Type_IntersectionTy(bounds);
        }

        @Override
        public TyKind tyKind() {
            return TyKind.INTERSECTION_TY;
        }

        @Memoized
        public abstract int hashCode();

        public final String toString() {
            return Joiner.on((char)'&').join(this.bounds());
        }
    }

    @AutoValue
    public static abstract class WildUnboundedTy
    extends WildTy {
        public static WildUnboundedTy create(ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildUnboundedTy(annotations);
        }

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.NONE;
        }

        @Override
        public Type bound() {
            throw new IllegalStateException();
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            for (AnnoInfo anno : this.annotations()) {
                sb.append(anno);
                sb.append(' ');
            }
            sb.append('?');
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class WildLowerBoundedTy
    extends WildTy {
        public static WildLowerBoundedTy create(Type bound, ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildLowerBoundedTy(annotations, bound);
        }

        @Override
        public abstract Type bound();

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.LOWER;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            for (AnnoInfo anno : this.annotations()) {
                sb.append(anno);
                sb.append(' ');
            }
            sb.append("? super ");
            sb.append(this.bound());
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class WildUpperBoundedTy
    extends WildTy {
        public static WildUpperBoundedTy create(Type bound, ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildUpperBoundedTy(annotations, bound);
        }

        @Override
        public abstract Type bound();

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.UPPER;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            for (AnnoInfo anno : this.annotations()) {
                sb.append(anno);
                sb.append(' ');
            }
            sb.append("? extends ");
            sb.append(this.bound());
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    public static abstract class WildTy
    implements Type {
        public abstract BoundKind boundKind();

        public abstract Type bound();

        public abstract ImmutableList<AnnoInfo> annotations();

        @Override
        public TyKind tyKind() {
            return TyKind.WILD_TY;
        }

        public static enum BoundKind {
            NONE,
            UPPER,
            LOWER;

        }
    }

    @AutoValue
    public static abstract class PrimTy
    implements Type {
        public static PrimTy create(TurbineConstantTypeKind tykind, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_PrimTy(tykind, annos);
        }

        public abstract TurbineConstantTypeKind primkind();

        @Override
        public TyKind tyKind() {
            return TyKind.PRIM_TY;
        }

        public abstract ImmutableList<AnnoInfo> annos();

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            for (AnnoInfo anno : this.annos()) {
                sb.append(anno);
                sb.append(' ');
            }
            sb.append((Object)this.primkind());
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class TyVar
    implements Type {
        public static TyVar create(TyVarSymbol sym, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_TyVar(sym, annos);
        }

        public abstract TyVarSymbol sym();

        @Override
        public TyKind tyKind() {
            return TyKind.TY_VAR;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            for (AnnoInfo anno : this.annos()) {
                sb.append(anno);
                sb.append(' ');
            }
            sb.append(this.sym().name());
            return sb.toString();
        }

        public abstract ImmutableList<AnnoInfo> annos();

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class ArrayTy
    implements Type {
        public static ArrayTy create(Type elem, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_ArrayTy(elem, annos);
        }

        public abstract Type elementType();

        @Override
        public TyKind tyKind() {
            return TyKind.ARRAY_TY;
        }

        public abstract ImmutableList<AnnoInfo> annos();

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.elementType());
            if (!this.annos().isEmpty()) {
                sb.append(' ');
                for (AnnoInfo anno : this.annos()) {
                    sb.append(anno);
                    sb.append(' ');
                }
            }
            sb.append("[]");
            return sb.toString();
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class ClassTy
    implements Type {
        public static final ClassTy OBJECT = ClassTy.asNonParametricClassTy(ClassSymbol.OBJECT);
        public static final ClassTy STRING = ClassTy.asNonParametricClassTy(ClassSymbol.STRING);
        public static final ClassTy CLONEABLE = ClassTy.asNonParametricClassTy(ClassSymbol.CLONEABLE);
        public static final ClassTy SERIALIZABLE = ClassTy.asNonParametricClassTy(ClassSymbol.SERIALIZABLE);

        public static ClassTy asNonParametricClassTy(ClassSymbol i) {
            return ClassTy.create(Arrays.asList(SimpleClassTy.create(i, (ImmutableList<Type>)ImmutableList.of(), (ImmutableList<AnnoInfo>)ImmutableList.of())));
        }

        public abstract ImmutableList<SimpleClassTy> classes();

        public static ClassTy create(Iterable<SimpleClassTy> classes) {
            return new AutoValue_Type_ClassTy((ImmutableList<SimpleClassTy>)ImmutableList.copyOf(classes));
        }

        @Override
        public TyKind tyKind() {
            return TyKind.CLASS_TY;
        }

        public ClassSymbol sym() {
            return ((SimpleClassTy)Iterables.getLast(this.classes())).sym();
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (SimpleClassTy c : this.classes()) {
                String binaryName = c.sym().binaryName();
                if (!first) {
                    for (AnnoInfo anno : c.annos()) {
                        sb.append(anno);
                        sb.append(' ');
                    }
                    sb.append('.');
                    sb.append(binaryName, binaryName.lastIndexOf(36) + 1, binaryName.length());
                } else {
                    int idx = Math.max(binaryName.lastIndexOf(47), binaryName.lastIndexOf(36)) + 1;
                    String name = binaryName.replace('/', '.').replace('$', '.');
                    sb.append(name, 0, idx);
                    for (AnnoInfo anno : c.annos()) {
                        sb.append(anno);
                        sb.append(' ');
                    }
                    sb.append(name, idx, name.length());
                }
                if (!c.targs().isEmpty()) {
                    sb.append('<');
                    Joiner.on((char)',').appendTo(sb, c.targs());
                    sb.append('>');
                }
                first = false;
            }
            return sb.toString();
        }

        @Memoized
        public int hashCode() {
            return ((SimpleClassTy)Iterables.getLast(this.classes())).hashCode();
        }

        public final boolean equals(@Nullable Object obj) {
            int j;
            if (!(obj instanceof ClassTy)) {
                return false;
            }
            ClassTy that = (ClassTy)obj;
            int i = this.classes().size() - 1;
            for (j = that.classes().size() - 1; i >= 0 && j >= 0; --i, --j) {
                if (((SimpleClassTy)this.classes().get(i)).equals(that.classes().get(j))) continue;
                return false;
            }
            return !ClassTy.hasTargs(this.classes(), i) && !ClassTy.hasTargs(that.classes(), j);
        }

        private static boolean hasTargs(ImmutableList<SimpleClassTy> classes, int idx) {
            while (idx >= 0) {
                SimpleClassTy simple = (SimpleClassTy)classes.get(idx);
                if (!simple.targs().isEmpty() || !simple.annos().isEmpty()) {
                    return true;
                }
                --idx;
            }
            return false;
        }

        @AutoValue
        public static abstract class SimpleClassTy {
            public static SimpleClassTy create(ClassSymbol sym, ImmutableList<Type> targs, ImmutableList<AnnoInfo> annos) {
                return new AutoValue_Type_ClassTy_SimpleClassTy(sym, targs, annos);
            }

            public abstract ClassSymbol sym();

            public abstract ImmutableList<Type> targs();

            public abstract ImmutableList<AnnoInfo> annos();

            @Memoized
            public abstract int hashCode();
        }
    }

    public static enum TyKind {
        PRIM_TY,
        VOID_TY,
        CLASS_TY,
        ARRAY_TY,
        TY_VAR,
        WILD_TY,
        INTERSECTION_TY,
        METHOD_TY,
        ERROR_TY,
        NONE_TY;

    }
}

