/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;
import java.util.Objects;

public final class ChangeDelta<T>
extends AbstractDelta<T> {
    public ChangeDelta(Chunk<T> source, Chunk<T> target) {
        super(DeltaType.CHANGE, source, target);
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(target, "target must not be null");
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        int i;
        this.verifyChunk(target);
        int position = this.getSource().getPosition();
        int size = this.getSource().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getTarget().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int i;
        int position = this.getTarget().getPosition();
        int size = this.getTarget().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getSource().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getSource().getLines() + " to " + this.getTarget().getLines() + "]";
    }
}

