/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.Platform;
import junit.framework.Assert;

@GwtCompatible
public final class SerializableTester {
    private SerializableTester() {
    }

    public static <T> T reserialize(T object) {
        return Platform.reserialize(object);
    }

    public static <T> T reserializeAndAssert(T object) {
        T copy = SerializableTester.reserialize(object);
        new EqualsTester().addEqualityGroup(object, copy).testEquals();
        Assert.assertEquals(object.getClass(), copy.getClass());
        return copy;
    }
}

