/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;
import java.util.EnumSet;
import java.util.Set;

public enum Density implements ResourceEnum
{
    XXXHIGH("xxxhdpi", "XXX-High Density", 640, 18),
    DPI_560("560dpi", "560 DPI Density", 560, 1),
    XXHIGH("xxhdpi", "XX-High Density", 480, 16),
    DPI_420("420dpi", "420 DPI Density", 420, 23),
    DPI_400("400dpi", "400 DPI Density", 400, 1),
    DPI_360("360dpi", "360 DPI Density", 360, 23),
    XHIGH("xhdpi", "X-High Density", 320, 8),
    DPI_260("260dpi", "260 DPI Density", 260, 25),
    DPI_280("280dpi", "280 DPI Density", 280, 22),
    DPI_300("300dpi", "300 DPI Density", 300, 25),
    DPI_340("340dpi", "340 DPI Density", 340, 25),
    HIGH("hdpi", "High Density", 240, 4),
    TV("tvdpi", "TV Density", 213, 13),
    MEDIUM("mdpi", "Medium Density", 160, 4),
    LOW("ldpi", "Low Density", 120, 4),
    ANYDPI("anydpi", "Any Density", 0, 21),
    NODPI("nodpi", "No Density", 0, 4);

    public static final int DEFAULT_DENSITY = 160;
    private final String mValue;
    private final String mDisplayValue;
    private final int mDensity;
    private final int mSince;

    private Density(String value, String displayValue, int density, int since) {
        this.mValue = value;
        this.mDisplayValue = displayValue;
        this.mDensity = density;
        this.mSince = since;
    }

    public static Density getEnum(String value) {
        for (Density orient : Density.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    public static Density getEnum(int value) {
        for (Density d : Density.values()) {
            if (d.mDensity != value) continue;
            return d;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    public int getDpiValue() {
        return this.mDensity;
    }

    public int since() {
        return this.mSince;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(Density value) {
        return value == null ? -1 : value.ordinal();
    }

    public static Density getByIndex(int index) {
        Density[] values = Density.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    public static Set<Density> getRecommendedValuesForDevice() {
        EnumSet<Density> result = EnumSet.allOf(Density.class);
        for (Density value : Density.values()) {
            if (value.isRecommended() && value.isValidValueForDevice()) continue;
            result.remove(value);
        }
        return result;
    }

    public boolean isRecommended() {
        switch (this) {
            case TV: 
            case DPI_260: 
            case DPI_280: 
            case DPI_300: 
            case DPI_340: 
            case DPI_360: 
            case DPI_400: 
            case DPI_420: 
            case DPI_560: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NODPI && this != ANYDPI;
    }
}

