/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.shaded.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.shaded.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.shaded.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.shaded.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.shaded.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.shaded.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.SuperNode;
import org.checkerframework.shaded.dataflow.cfg.node.ThisNode;
import org.checkerframework.shaded.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.shaded.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.shaded.dataflow.expression.ArrayAccess;
import org.checkerframework.shaded.dataflow.expression.ArrayCreation;
import org.checkerframework.shaded.dataflow.expression.BinaryOperation;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.FieldAccess;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.dataflow.expression.MethodCall;
import org.checkerframework.shaded.dataflow.expression.ThisReference;
import org.checkerframework.shaded.dataflow.expression.UnaryOperation;
import org.checkerframework.shaded.dataflow.expression.Unknown;
import org.checkerframework.shaded.dataflow.expression.ValueLiteral;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.TreePathUtil;
import org.checkerframework.shaded.javacutil.TreeUtils;

public abstract class JavaExpression {
    protected final TypeMirror type;

    protected JavaExpression(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public abstract boolean containsOfClass(Class<? extends JavaExpression> var1);

    public boolean containsUnknown() {
        return this.containsOfClass(Unknown.class);
    }

    public abstract boolean isDeterministic(AnnotationProvider var1);

    public static boolean listIsDeterministic(List<? extends @Nullable JavaExpression> list, AnnotationProvider provider) {
        return list.stream().allMatch(je -> je == null || je.isDeterministic(provider));
    }

    public abstract boolean isUnassignableByOtherCode();

    public abstract boolean isUnmodifiableByOtherCode();

    @EqualsMethod
    public abstract boolean syntacticEquals(JavaExpression var1);

    static boolean syntacticEqualsList(List<? extends @Nullable JavaExpression> lst1, List<? extends @Nullable JavaExpression> lst2) {
        if (lst1.size() != lst2.size()) {
            return false;
        }
        for (int i = 0; i < lst1.size(); ++i) {
            JavaExpression dim1 = lst1.get(i);
            JavaExpression dim2 = lst2.get(i);
            if (dim1 == null && dim2 == null) continue;
            if (dim1 == null || dim2 == null) {
                return false;
            }
            if (dim1.syntacticEquals(dim2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean containsSyntacticEqualJavaExpression(JavaExpression var1);

    public static boolean listContainsSyntacticEqualJavaExpression(List<? extends @Nullable JavaExpression> list, JavaExpression other) {
        return list.stream().anyMatch(je -> je != null && je.containsSyntacticEqualJavaExpression(other));
    }

    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.equals(other) || store.canAlias(this, other);
    }

    public String toStringDebug() {
        return String.format("%s(%s): %s", this.getClass().getSimpleName(), this.type, this.toString());
    }

    public static FieldAccess fromNodeFieldAccess(FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        JavaExpression receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : JavaExpression.fromNode(receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess fromArrayAccess(ArrayAccessNode node) {
        JavaExpression array = JavaExpression.fromNode(node.getArray());
        JavaExpression index = JavaExpression.fromNode(node.getIndex());
        return new ArrayAccess(node.getType(), array, index);
    }

    public static JavaExpression fromNode(Node receiverNode) {
        JavaExpression result = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            result = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : (fan.getFieldName().equals("class") ? new ClassName(fan.getReceiver().getType()) : JavaExpression.fromNodeFieldAccess(fan));
        } else if (receiverNode instanceof ExplicitThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            result = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            result = JavaExpression.fromArrayAccess(a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return JavaExpression.fromNode(((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return JavaExpression.fromNode(((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return JavaExpression.fromNode(((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof UnaryOperationNode) {
                UnaryOperationNode uopn = (UnaryOperationNode)receiverNode;
                return new UnaryOperation(uopn, JavaExpression.fromNode(uopn.getOperand()));
            }
            if (receiverNode instanceof BinaryOperationNode) {
                BinaryOperationNode bopn = (BinaryOperationNode)receiverNode;
                return new BinaryOperation(bopn, JavaExpression.fromNode(bopn.getLeftOperand()), JavaExpression.fromNode(bopn.getRightOperand()));
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                result = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                result = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                ArrayList<@Nullable JavaExpression> dimensions = new ArrayList<JavaExpression>();
                for (Node node : an.getDimensions()) {
                    dimensions.add(JavaExpression.fromNode(node));
                }
                ArrayList<JavaExpression> initializers = new ArrayList<JavaExpression>();
                for (Node initializer : an.getInitializers()) {
                    initializers.add(JavaExpression.fromNode(initializer));
                }
                result = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                MethodInvocationTree t = mn.getTree();
                if (t == null) {
                    throw new BugInCF("Unexpected null tree for node: " + mn);
                }
                assert (TreeUtils.isUseOfElement(t)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement invokedMethod = TreeUtils.elementFromUse(t);
                ArrayList<JavaExpression> arrayList = new ArrayList<JavaExpression>();
                for (Node p : mn.getArguments()) {
                    arrayList.add(JavaExpression.fromNode(p));
                }
                JavaExpression methodReceiver = ElementUtils.isStatic(invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : JavaExpression.fromNode(mn.getTarget().getReceiver());
                result = new MethodCall(mn.getType(), invokedMethod, methodReceiver, arrayList);
            }
        }
        if (result == null) {
            result = new Unknown(receiverNode);
        }
        return result;
    }

    public static JavaExpression fromTree(ExpressionTree tree) {
        JavaExpression result;
        switch (tree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)tree;
                JavaExpression arrayAccessExpression = JavaExpression.fromTree(a.getExpression());
                JavaExpression index = JavaExpression.fromTree(a.getIndex());
                result = new ArrayAccess(TreeUtils.typeOf(a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)tree;
                result = new ValueLiteral(TreeUtils.typeOf(tree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)tree;
                ArrayList<JavaExpression> dimensions = new ArrayList<JavaExpression>();
                if (newArrayTree.getDimensions() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(JavaExpression.fromTree(expressionTree));
                    }
                }
                ArrayList<JavaExpression> initializers = new ArrayList<JavaExpression>();
                if (newArrayTree.getInitializers() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(JavaExpression.fromTree(expressionTree));
                    }
                }
                result = new ArrayCreation(TreeUtils.typeOf(tree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                assert (TreeUtils.isUseOfElement(methodInvocationTree)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement executableElement = TreeUtils.elementFromUse(methodInvocationTree);
                ArrayList<JavaExpression> parameters = new ArrayList<JavaExpression>();
                for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
                    parameters.add(JavaExpression.fromTree(expressionTree));
                }
                JavaExpression methodReceiver = ElementUtils.isStatic(executableElement) ? new ClassName(TreeUtils.typeOf(methodInvocationTree.getMethodSelect())) : JavaExpression.getReceiver(methodInvocationTree);
                TypeMirror typeMirror = TreeUtils.typeOf(methodInvocationTree);
                result = new MethodCall(typeMirror, executableElement, methodReceiver, parameters);
                break;
            }
            case MEMBER_SELECT: {
                result = JavaExpression.fromMemberSelect((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)tree;
                TypeMirror typeOfId = TreeUtils.typeOf(identifierTree);
                if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                    result = new ThisReference(typeOfId);
                    break;
                }
                assert (TreeUtils.isUseOfElement(identifierTree)) : "@AssumeAssertion(nullness): tree kind";
                Element ele = TreeUtils.elementFromUse(identifierTree);
                if (ElementUtils.isTypeElement(ele)) {
                    result = new ClassName(ele.asType());
                    break;
                }
                result = JavaExpression.fromVariableElement(typeOfId, ele);
                break;
            }
            case UNARY_PLUS: {
                return JavaExpression.fromTree(((UnaryTree)tree).getExpression());
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: {
                JavaExpression operand = JavaExpression.fromTree(((UnaryTree)tree).getExpression());
                return new UnaryOperation(TreeUtils.typeOf(tree), tree.getKind(), operand);
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                BinaryTree binaryTree = (BinaryTree)tree;
                JavaExpression left = JavaExpression.fromTree(binaryTree.getLeftOperand());
                JavaExpression right = JavaExpression.fromTree(binaryTree.getRightOperand());
                return new BinaryOperation(TreeUtils.typeOf(tree), tree.getKind(), left, right);
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            result = new Unknown(tree);
        }
        return result;
    }

    public static JavaExpression fromVariableTree(VariableTree tree) {
        return JavaExpression.fromVariableElement(TreeUtils.typeOf(tree), TreeUtils.elementFromDeclaration(tree));
    }

    private static JavaExpression fromVariableElement(TypeMirror typeOfEle, Element ele) {
        switch (ele.getKind()) {
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case PARAMETER: {
                return new LocalVariable(ele);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror enclosingTypeElement = ElementUtils.enclosingTypeElement(ele).asType();
                JavaExpression fieldAccessExpression = ElementUtils.isStatic(ele) ? new ClassName(enclosingTypeElement) : new ThisReference(enclosingTypeElement);
                return new FieldAccess(fieldAccessExpression, typeOfEle, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected kind of VariableTree: kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    private static JavaExpression fromMemberSelect(MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf(memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral(memberSelectTree)) {
            return new ClassName(expressionType);
        }
        assert (TreeUtils.isUseOfElement(memberSelectTree)) : "@AssumeAssertion(nullness): tree kind";
        Element ele = TreeUtils.elementFromUse(memberSelectTree);
        if (ElementUtils.isTypeElement(ele)) {
            TypeMirror selectType = TreeUtils.typeOf(memberSelectTree);
            return new ClassName(selectType);
        }
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return JavaExpression.fromTree(memberSelectTree.getExpression());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf(memberSelectTree);
                JavaExpression je = JavaExpression.fromTree(memberSelectTree.getExpression());
                return new FieldAccess(je, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static @Nullable List<JavaExpression> getParametersOfEnclosingMethod(TreePath path) {
        MethodTree methodTree = TreePathUtil.enclosingMethod(path);
        if (methodTree == null) {
            return null;
        }
        ArrayList<JavaExpression> internalArguments = new ArrayList<JavaExpression>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(JavaExpression.fromNode(new LocalVariableNode(variableTree)));
        }
        return internalArguments;
    }

    public static JavaExpression getReceiver(ExpressionTree accessTree) {
        assert (accessTree instanceof MethodInvocationTree || accessTree instanceof NewClassTree);
        ExpressionTree receiverTree = TreeUtils.getReceiverTree(accessTree);
        if (receiverTree != null) {
            return JavaExpression.fromTree(receiverTree);
        }
        Element ele = TreeUtils.elementFromUse(accessTree);
        if (ele == null) {
            throw new BugInCF("TreeUtils.elementFromUse(" + accessTree + ") => null");
        }
        return JavaExpression.getImplicitReceiver(ele);
    }

    public static JavaExpression getImplicitReceiver(Element ele) {
        TypeElement enclosingClass = ElementUtils.enclosingTypeElement(ele);
        if (enclosingClass == null) {
            throw new BugInCF("getImplicitReceiver's arg has no enclosing class: " + ele);
        }
        TypeMirror enclosingType = enclosingClass.asType();
        if (ElementUtils.isStatic(ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static JavaExpression getPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreePathUtil.isTreeInStaticScope(path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public abstract <R, P> R accept(JavaExpressionVisitor<R, P> var1, P var2);
}

