/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdElement;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;

class VdGroup
extends VdElement {
    private static Logger logger = Logger.getLogger(VdGroup.class.getSimpleName());
    private static final String GROUP_ROTATION = "android:rotation";
    private static final String GROUP_PIVOTX = "android:pivotX";
    private static final String GROUP_PIVOTY = "android:pivotY";
    private static final String GROUP_TRANSLATEX = "android:translateX";
    private static final String GROUP_TRANSLATEY = "android:translateY";
    private static final String GROUP_SCALEX = "android:scaleX";
    private static final String GROUP_SCALEY = "android:scaleY";
    private static final String GROUP_NAME = "android:name";
    private float mRotate = 0.0f;
    private float mPivotX = 0.0f;
    private float mPivotY = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslateX = 0.0f;
    private float mTranslateY = 0.0f;
    private AffineTransform mTempStackedMatrix = new AffineTransform();
    private AffineTransform mLocalMatrix = new AffineTransform();
    private ArrayList<VdElement> mChildren = new ArrayList();

    VdGroup() {
    }

    public void add(VdElement pathOrGroup) {
        this.mChildren.add(pathOrGroup);
    }

    public ArrayList<VdElement> getChildren() {
        return this.mChildren;
    }

    public int size() {
        return this.mChildren.size();
    }

    private void androidPostTransform(AffineTransform src, AffineTransform trans) {
        src.preConcatenate(trans);
    }

    private void updateLocalMatrix() {
        this.mLocalMatrix.setToIdentity();
        AffineTransform tempTrans = new AffineTransform();
        tempTrans.setToIdentity();
        tempTrans.translate(-this.mPivotX, -this.mPivotY);
        this.androidPostTransform(this.mLocalMatrix, tempTrans);
        tempTrans.setToIdentity();
        tempTrans.scale(this.mScaleX, this.mScaleY);
        this.androidPostTransform(this.mLocalMatrix, tempTrans);
        tempTrans.setToIdentity();
        tempTrans.rotate((double)this.mRotate * 3.1415926 / 180.0, 0.0, 0.0);
        this.androidPostTransform(this.mLocalMatrix, tempTrans);
        tempTrans.setToIdentity();
        tempTrans.translate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        this.androidPostTransform(this.mLocalMatrix, tempTrans);
    }

    @Override
    public void draw(Graphics2D g, AffineTransform currentMatrix, float scaleX, float scaleY) {
        this.mTempStackedMatrix.setTransform(currentMatrix);
        this.mTempStackedMatrix.concatenate(this.mLocalMatrix);
        for (int i = 0; i < this.mChildren.size(); ++i) {
            this.mChildren.get(i).draw(g, this.mTempStackedMatrix, scaleX, scaleY);
        }
    }

    private void setNameValue(String name, String value) {
        if (GROUP_ROTATION.equals(name)) {
            this.mRotate = Float.parseFloat(value);
        } else if (GROUP_PIVOTX.equals(name)) {
            this.mPivotX = Float.parseFloat(value);
        } else if (GROUP_PIVOTY.equals(name)) {
            this.mPivotY = Float.parseFloat(value);
        } else if (GROUP_TRANSLATEX.equals(name)) {
            this.mTranslateX = Float.parseFloat(value);
        } else if (GROUP_TRANSLATEY.equals(name)) {
            this.mTranslateY = Float.parseFloat(value);
        } else if (GROUP_SCALEX.equals(name)) {
            this.mScaleX = Float.parseFloat(value);
        } else if (GROUP_SCALEY.equals(name)) {
            this.mScaleY = Float.parseFloat(value);
        } else if (GROUP_NAME.equals(name)) {
            this.mName = value;
        } else {
            logger.log(Level.WARNING, ">>>>>> DID NOT UNDERSTAND ! \"" + name + "\" <<<<");
        }
    }

    @Override
    public void parseAttributes(NamedNodeMap attributes) {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.item(i).getNodeName();
            String value = attributes.item(i).getNodeValue();
            this.setNameValue(name, value);
        }
        this.updateLocalMatrix();
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public String toString() {
        StringBuilder pathInfo = new StringBuilder();
        pathInfo.append("Group:");
        pathInfo.append(" Name: " + this.mName);
        pathInfo.append(" mTranslateX: " + this.mTranslateX);
        pathInfo.append(" mTranslateY:" + this.mTranslateY);
        pathInfo.append(" mScaleX:" + this.mScaleX);
        pathInfo.append(" mScaleY:" + this.mScaleY);
        pathInfo.append(" mPivotX:" + this.mPivotX);
        pathInfo.append(" mPivotY:" + this.mPivotY);
        pathInfo.append(" mRotate:" + this.mRotate);
        return pathInfo.toString();
    }
}

