/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.BuildType;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;

public class DefaultBuildType
extends BaseConfigImpl
implements BuildType {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private boolean mDebuggable = false;
    private boolean mPseudoLocalesEnabled = false;
    private boolean mTestCoverageEnabled = false;
    private boolean mJniDebuggable = false;
    private boolean mRenderscriptDebuggable = false;
    private int mRenderscriptOptimLevel = 3;
    private String mVersionNameSuffix = null;
    private boolean mMinifyEnabled = false;
    private SigningConfig mSigningConfig = null;
    private boolean mEmbedMicroApp = true;
    private boolean mZipAlignEnabled = true;

    public DefaultBuildType(String name) {
        this.mName = name;
    }

    public DefaultBuildType initWith(DefaultBuildType that) {
        this._initWith(that);
        this.setDebuggable(that.isDebuggable());
        this.setTestCoverageEnabled(that.isTestCoverageEnabled());
        this.setJniDebuggable(that.isJniDebuggable());
        this.setRenderscriptDebuggable(that.isRenderscriptDebuggable());
        this.setRenderscriptOptimLevel(that.getRenderscriptOptimLevel());
        this.setVersionNameSuffix(that.getVersionNameSuffix());
        this.setMinifyEnabled(that.isMinifyEnabled());
        this.setZipAlignEnabled(that.isZipAlignEnabled());
        this.setSigningConfig(that.getSigningConfig());
        this.setEmbedMicroApp(that.isEmbedMicroApp());
        this.setPseudoLocalesEnabled(that.isPseudoLocalesEnabled());
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public BuildType setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
        return this;
    }

    public boolean isDebuggable() {
        return this.mDebuggable || this.mTestCoverageEnabled;
    }

    public void setTestCoverageEnabled(boolean testCoverageEnabled) {
        this.mTestCoverageEnabled = testCoverageEnabled;
    }

    public boolean isTestCoverageEnabled() {
        return this.mTestCoverageEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.mPseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    public boolean isPseudoLocalesEnabled() {
        return this.mPseudoLocalesEnabled;
    }

    public BuildType setJniDebuggable(boolean jniDebugBuild) {
        this.mJniDebuggable = jniDebugBuild;
        return this;
    }

    public boolean isJniDebuggable() {
        return this.mJniDebuggable;
    }

    public boolean isRenderscriptDebuggable() {
        return this.mRenderscriptDebuggable;
    }

    public BuildType setRenderscriptDebuggable(boolean renderscriptDebugBuild) {
        this.mRenderscriptDebuggable = renderscriptDebugBuild;
        return this;
    }

    public int getRenderscriptOptimLevel() {
        return this.mRenderscriptOptimLevel;
    }

    public void setRenderscriptOptimLevel(int renderscriptOptimLevel) {
        this.mRenderscriptOptimLevel = renderscriptOptimLevel;
    }

    public BuildType setVersionNameSuffix(String versionNameSuffix) {
        this.mVersionNameSuffix = versionNameSuffix;
        return this;
    }

    public String getVersionNameSuffix() {
        return this.mVersionNameSuffix;
    }

    public BuildType setMinifyEnabled(boolean enabled) {
        this.mMinifyEnabled = enabled;
        return this;
    }

    public boolean isMinifyEnabled() {
        return this.mMinifyEnabled;
    }

    public BuildType setZipAlignEnabled(boolean zipAlign) {
        this.mZipAlignEnabled = zipAlign;
        return this;
    }

    public boolean isZipAlignEnabled() {
        return this.mZipAlignEnabled;
    }

    public BuildType setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    public boolean isEmbedMicroApp() {
        return this.mEmbedMicroApp;
    }

    public void setEmbedMicroApp(boolean embedMicroApp) {
        this.mEmbedMicroApp = embedMicroApp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBuildType buildType = (DefaultBuildType)o;
        return Objects.equal((Object)this.mName, (Object)buildType.mName) && this.mDebuggable == buildType.mDebuggable && this.mTestCoverageEnabled == buildType.mTestCoverageEnabled && this.mJniDebuggable == buildType.mJniDebuggable && this.mPseudoLocalesEnabled == buildType.mPseudoLocalesEnabled && this.mRenderscriptDebuggable == buildType.mRenderscriptDebuggable && this.mRenderscriptOptimLevel == buildType.mRenderscriptOptimLevel && this.mMinifyEnabled == buildType.mMinifyEnabled && this.mZipAlignEnabled == buildType.mZipAlignEnabled && this.mEmbedMicroApp == buildType.mEmbedMicroApp && Objects.equal((Object)this.mVersionNameSuffix, (Object)buildType.mVersionNameSuffix) && Objects.equal((Object)this.mSigningConfig, (Object)buildType.mSigningConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mName, this.mDebuggable, this.mTestCoverageEnabled, this.mJniDebuggable, this.mPseudoLocalesEnabled, this.mRenderscriptDebuggable, this.mRenderscriptOptimLevel, this.mVersionNameSuffix, this.mMinifyEnabled, this.mZipAlignEnabled, this.mSigningConfig, this.mEmbedMicroApp});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("debuggable", this.mDebuggable).add("testCoverageEnabled", this.mTestCoverageEnabled).add("jniDebuggable", this.mJniDebuggable).add("pseudoLocalesEnabled", this.mPseudoLocalesEnabled).add("renderscriptDebuggable", this.mRenderscriptDebuggable).add("renderscriptOptimLevel", this.mRenderscriptOptimLevel).add("versionNameSuffix", (Object)this.mVersionNameSuffix).add("minifyEnabled", this.mMinifyEnabled).add("zipAlignEnabled", this.mZipAlignEnabled).add("signingConfig", (Object)this.mSigningConfig).add("embedMicroApp", this.mEmbedMicroApp).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).toString();
    }
}

