/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import java.util.List;

public class ResourceItemResolver
extends RenderResources {
    private final FolderConfiguration mConfiguration;
    private final LayoutLog mLogger;
    private final ResourceProvider mResourceProvider;
    private ResourceRepository mFrameworkResources;
    private ResourceResolver mResolver;
    private AbstractResourceRepository myAppResources;
    private List<ResourceValue> mLookupChain;

    public ResourceItemResolver(FolderConfiguration configuration, ResourceProvider resourceProvider, LayoutLog logger) {
        this.mConfiguration = configuration;
        this.mResourceProvider = resourceProvider;
        this.mLogger = logger;
        this.mResolver = resourceProvider.getResolver(false);
    }

    public ResourceItemResolver(FolderConfiguration configuration, ResourceRepository frameworkResources, AbstractResourceRepository appResources, LayoutLog logger) {
        this.mConfiguration = configuration;
        this.mResourceProvider = null;
        this.mLogger = logger;
        this.mFrameworkResources = frameworkResources;
        this.myAppResources = appResources;
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        if (this.mResolver != null) {
            return this.mResolver.resolveResValue(resValue);
        }
        if (this.mLookupChain != null) {
            this.mLookupChain.add(resValue);
        }
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null || resValue instanceof ArrayResourceValue) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.findResValue(value, resValue.isFramework());
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    public ResourceValue findResValue(String reference, boolean inFramework) {
        ResourceUrl resource;
        ResourceValue prev;
        if (this.mResolver != null) {
            return this.mResolver.findResValue(reference, inFramework);
        }
        if (reference == null) {
            return null;
        }
        if (this.mLookupChain != null && !this.mLookupChain.isEmpty() && reference.startsWith("@") && !reference.equals((prev = this.mLookupChain.get(this.mLookupChain.size() - 1)).getValue())) {
            ResourceValue next = new ResourceValue(prev.getResourceType(), prev.getName(), prev.isFramework());
            next.setValue(reference);
            this.mLookupChain.add(next);
        }
        if ((resource = ResourceUrl.parse(reference)) != null && resource.hasValidName()) {
            if (resource.theme) {
                ResourceResolver resolver = this.getFullResolver();
                if (resolver != null) {
                    return resolver.findResValue(reference, inFramework);
                }
                return null;
            }
            if (reference.startsWith("@")) {
                return this.findResValue(resource.type, resource.name, inFramework || resource.framework);
            }
        }
        return null;
    }

    private ResourceValue findResValue(ResourceType resType, String resName, boolean framework) {
        if (!framework) {
            if (this.myAppResources == null) {
                assert (this.mResourceProvider != null);
                this.myAppResources = this.mResourceProvider.getAppResources();
                if (this.myAppResources == null) {
                    return null;
                }
            }
            ResourceValue item = null;
            item = this.myAppResources.getConfiguredValue(resType, resName, this.mConfiguration);
            if (item != null) {
                if (this.mLookupChain != null) {
                    this.mLookupChain.add(item);
                }
                return item;
            }
        } else {
            if (this.mFrameworkResources == null) {
                assert (this.mResourceProvider != null);
                this.mFrameworkResources = this.mResourceProvider.getFrameworkResources();
                if (this.mFrameworkResources == null) {
                    return null;
                }
            }
            if (this.mFrameworkResources.hasResourceItem(resType, resName)) {
                ResourceItem item = this.mFrameworkResources.getResourceItem(resType, resName);
                ResourceValue value = item.getResourceValue(resType, this.mConfiguration, true);
                if (value != null && this.mLookupChain != null) {
                    this.mLookupChain.add(value);
                }
                return value;
            }
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource @" + (framework ? "android:" : "") + resType + "/" + resName, (Object)new ResourceValue(resType, resName, framework));
        }
        return null;
    }

    public StyleResourceValue getCurrentTheme() {
        ResourceResolver resolver = this.getFullResolver();
        if (resolver != null) {
            return resolver.getCurrentTheme();
        }
        return null;
    }

    public ResourceValue resolveValue(ResourceType type, String name, String value, boolean isFrameworkValue) {
        if (value == null) {
            return null;
        }
        ResourceValue resValue = this.findResValue(value, isFrameworkValue);
        if (resValue == null) {
            return new ResourceValue(type, name, value, isFrameworkValue);
        }
        return this.resolveResValue(resValue);
    }

    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        assert (false);
        return super.getTheme(name, frameworkTheme);
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        assert (false);
        return super.themeIsParentOf(parentTheme, childTheme);
    }

    public ResourceValue findItemInTheme(String itemName) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInTheme(itemName) : null;
    }

    public ResourceValue findItemInTheme(String attrName, boolean isFrameworkAttr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInTheme(attrName, isFrameworkAttr) : null;
    }

    public ResourceValue findItemInStyle(StyleResourceValue style, String attrName) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInStyle(style, attrName) : null;
    }

    public ResourceValue findItemInStyle(StyleResourceValue style, String attrName, boolean isFrameworkAttr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInStyle(style, attrName, isFrameworkAttr) : null;
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.getParent(style) : null;
    }

    private ResourceResolver getFullResolver() {
        if (this.mResolver == null) {
            if (this.mResourceProvider == null) {
                return null;
            }
            this.mResolver = this.mResourceProvider.getResolver(true);
            if (this.mResolver != null && this.mLookupChain != null) {
                this.mResolver = this.mResolver.createRecorder(this.mLookupChain);
            }
        }
        return this.mResolver;
    }

    public void setLookupChainList(List<ResourceValue> lookupChain) {
        this.mLookupChain = lookupChain;
    }

    public List<ResourceValue> getLookupChain() {
        return this.mLookupChain;
    }

    public static String getDisplayString(ResourceType type, String name, boolean isFramework, List<ResourceValue> lookupChain) {
        String url = ResourceUrl.create(type, name, isFramework, false).toString();
        return ResourceItemResolver.getDisplayString(url, lookupChain);
    }

    public static String getDisplayString(String url, List<ResourceValue> lookupChain) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        String prev = url;
        for (ResourceValue element : lookupChain) {
            int end;
            String text;
            String value;
            if (element == null || (value = element.getValue()) == null || (text = value).equals(prev)) continue;
            sb.append(" => ");
            if (!text.startsWith("?") && !text.startsWith("@") && (end = Math.max(text.lastIndexOf(47), text.lastIndexOf(92))) != -1) {
                text = text.substring(end + 1);
            }
            sb.append(text);
            prev = value;
        }
        return sb.toString();
    }

    public static interface ResourceProvider {
        public ResourceResolver getResolver(boolean var1);

        public ResourceRepository getFrameworkResources();

        public AbstractResourceRepository getAppResources();
    }
}

