/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="This catch block appears to be catching an explicitly declared InterruptedException as an Exception/Throwable and not handling the interruption separately.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class InterruptedExceptionSwallowed
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.TryTreeMatcher {
    private static final String METHOD_DESCRIPTION = "This method can throw InterruptedException but declares that it throws Exception/Throwable. This makes it difficult for callers to recognize the need to handle interruption properly.";

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (Matchers.MAIN_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type interrupted = state.getSymtab().interruptedExceptionType;
        if (tree.getThrows().stream().anyMatch(t -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)t), (Type)interrupted, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        ImmutableSet thrownExceptions = ASTHelpers.getThrownExceptions((Tree)tree.getBody(), (VisitorState)state);
        if (thrownExceptions.stream().noneMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)interrupted, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        if (thrownExceptions.stream().anyMatch(t -> !ASTHelpers.isSameType((Type)t, (Type)interrupted, (VisitorState)state) && ASTHelpers.isSubtype((Type)interrupted, (Type)t, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        Set exceptions = Stream.concat(thrownExceptions.stream().filter(t -> !ASTHelpers.isSubtype((Type)t, (Type)state.getSymtab().runtimeExceptionType, (VisitorState)state)), tree.getThrows().stream().filter(t -> !ASTHelpers.isSubtype((Type)interrupted, (Type)ASTHelpers.getType((Tree)t), (VisitorState)state)).map(ASTHelpers::getType)).collect(Collectors.toCollection(HashSet::new));
        for (Type type : ImmutableSet.copyOf((Collection)exceptions)) {
            exceptions.removeIf(t -> !ASTHelpers.isSameType((Type)t, (Type)type, (VisitorState)state) && ASTHelpers.isSubtype((Type)t, (Type)type, (VisitorState)state));
        }
        if (exceptions.size() > 5) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = InterruptedExceptionSwallowed.narrowExceptionTypes(tree, exceptions, state);
        return this.buildDescription(tree).setMessage(METHOD_DESCRIPTION).addFix((Fix)fix).build();
    }

    private static SuggestedFix narrowExceptionTypes(MethodTree tree, Set<Type> exceptions, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(ASTHelpers.getStartPosition((Tree)tree.getThrows().get(0)), state.getEndPosition((Tree)Iterables.getLast(tree.getThrows())), exceptions.stream().map(t -> SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)t)).sorted().collect(Collectors.joining(", ")));
        return fix.build();
    }

    public Description matchTry(TryTree tree, VisitorState state) {
        for (CatchTree catchTree : tree.getCatches()) {
            ImmutableSet<Type> thrownExceptions;
            Type type = ASTHelpers.getType((Tree)catchTree.getParameter());
            Type interrupted = state.getSymtab().interruptedExceptionType;
            ImmutableList<Type> caughtTypes = InterruptedExceptionSwallowed.extractTypes(type);
            if (caughtTypes.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)interrupted, (VisitorState)state))) {
                return Description.NO_MATCH;
            }
            if (!caughtTypes.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)interrupted, (Type)t, (VisitorState)state)) || !(thrownExceptions = InterruptedExceptionSwallowed.getThrownExceptions(tree, state)).stream().anyMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)interrupted, (VisitorState)state)) || InterruptedExceptionSwallowed.blockChecksForInterruptedException(catchTree.getBlock(), state) || this.exceptionIsRethrown(catchTree, catchTree.getParameter(), state) && this.methodDeclaresInterruptedException((MethodTree)state.findEnclosing(new Class[]{MethodTree.class}), state) || this.isSuppressed(catchTree.getParameter(), state)) continue;
            return this.describeMatch(catchTree, (Fix)InterruptedExceptionSwallowed.createFix(catchTree));
        }
        return Description.NO_MATCH;
    }

    private boolean exceptionIsRethrown(CatchTree catchTree, final VariableTree parameter, VisitorState state) {
        final AtomicBoolean rethrown = new AtomicBoolean();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitThrow(ThrowTree throwTree, Void unused) {
                Symbol.VarSymbol parameterSymbol = ASTHelpers.getSymbol((VariableTree)parameter);
                if (parameterSymbol.equals(ASTHelpers.getSymbol((Tree)throwTree.getExpression()))) {
                    rethrown.set(true);
                }
                return (Void)super.visitThrow(throwTree, null);
            }
        }.scan(new TreePath(state.getPath(), catchTree), (Void)null);
        return rethrown.get();
    }

    private boolean methodDeclaresInterruptedException(MethodTree enclosing, VisitorState state) {
        if (enclosing == null) {
            return false;
        }
        return enclosing.getThrows().stream().anyMatch(t -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)t), (Type)state.getSymtab().interruptedExceptionType, (VisitorState)state));
    }

    private static SuggestedFix createFix(CatchTree catchTree) {
        List<? extends StatementTree> block = catchTree.getBlock().getStatements();
        String fix = String.format("if (%s instanceof InterruptedException) {\nThread.currentThread().interrupt();\n}\n", catchTree.getParameter().getName());
        if (block.isEmpty()) {
            return SuggestedFix.replace((Tree)catchTree.getBlock(), (String)String.format("{%s}", fix));
        }
        return SuggestedFix.prefixWith((Tree)block.get(0), (String)fix);
    }

    private static boolean blockChecksForInterruptedException(BlockTree block, final VisitorState state) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean reduce(Boolean a, Boolean b) {
                return Boolean.TRUE.equals(a) || Boolean.TRUE.equals(b);
            }

            @Override
            public Boolean visitInstanceOf(InstanceOfTree instanceOfTree, Void unused) {
                return ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)instanceOfTree.getType()), (Type)state.getSymtab().interruptedExceptionType, (VisitorState)state);
            }
        }.scan(block, null));
    }

    private static ImmutableSet<Type> getThrownExceptions(TryTree tryTree, VisitorState state) {
        ASTHelpers.ScanThrownTypes scanner = new ASTHelpers.ScanThrownTypes(state);
        scanner.scanResources(tryTree);
        scanner.scan((Tree)tryTree.getBlock(), null);
        return ImmutableSet.copyOf((Collection)scanner.getThrownTypes());
    }

    private static ImmutableList<Type> extractTypes(@Nullable Type type) {
        if (type == null) {
            return ImmutableList.of();
        }
        if (type.isUnion()) {
            Type.UnionClassType unionType = (Type.UnionClassType)type;
            return ImmutableList.copyOf(unionType.getAlternativeTypes());
        }
        return ImmutableList.of((Object)type);
    }
}

