/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;

@BugPattern(summary="This test has members annotated with @Theory, @DataPoint, or @DataPoints but is using the default JUnit4 runner.", severity=BugPattern.SeverityLevel.ERROR)
public final class TheoryButNoTheories
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String THEORIES = "org.junit.experimental.theories.Theories";
    private static final Supplier<ImmutableSet<Name>> TYPES = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("org.junit.experimental.theories.Theory", "org.junit.experimental.theories.DataPoint", "org.junit.experimental.theories.DataPoints").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final MultiMatcher<Tree, AnnotationTree> USING_THEORIES_RUNNER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)JUnitMatchers.isJUnit4TestRunnerOfType((Iterable)ImmutableSet.of((Object)"org.junit.experimental.theories.Theories"))));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnitMatchers.hasJUnit4TestRunner.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (USING_THEORIES_RUNNER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getMembers().stream().allMatch(m -> ASTHelpers.annotationsAmong((Symbol)ASTHelpers.getSymbol((Tree)m), (Set)((Set)TYPES.get(state)), (VisitorState)state).isEmpty())) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"RunWith");
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)annotation, String.format("@RunWith(%s.class)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)THEORIES)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

