/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

class PenaltyThresholdHeuristic
implements Heuristic {
    private final double threshold;
    private static final double DEFAULT_THRESHOLD = 0.6;

    PenaltyThresholdHeuristic(double threshold) {
        this.threshold = threshold;
    }

    PenaltyThresholdHeuristic() {
        this(0.6);
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        int numberOfChanges = changes.changedPairs().size();
        return changes.totalOriginalCost() - changes.totalAssignmentCost() >= this.threshold * (double)numberOfChanges;
    }
}

