/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.errorprone.refaster.AutoValue_UTypeVar_TypeWithExpression;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inlineable;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UClassType;
import com.google.errorprone.refaster.UPrimitiveType;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.Unifier;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

public class UTypeVar
extends UType {
    private final String name;
    private UType lowerBound;
    private UType upperBound;

    public static UTypeVar create(String name, UType lowerBound, UType upperBound) {
        return new UTypeVar(name, lowerBound, upperBound);
    }

    public static UTypeVar create(String name, UType upperBound) {
        return UTypeVar.create(name, UPrimitiveType.NULL, upperBound);
    }

    public static UTypeVar create(String name) {
        return UTypeVar.create(name, UClassType.create("java.lang.Object", new UType[0]));
    }

    private UTypeVar(String name, UType lowerBound, UType upperBound) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.lowerBound = (UType)Preconditions.checkNotNull((Object)lowerBound);
        this.upperBound = (UType)Preconditions.checkNotNull((Object)upperBound);
    }

    @Override
    public Choice<Unifier> visitType(Type target, Unifier unifier) {
        return Choice.condition(!target.isPrimitive(), unifier);
    }

    public Key key() {
        return new Key((CharSequence)this.name);
    }

    public String getName() {
        return this.name;
    }

    public UType getLowerBound() {
        return this.lowerBound;
    }

    public UType getUpperBound() {
        return this.upperBound;
    }

    public void setLowerBound(UType lowerBound) {
        this.lowerBound = (UType)Preconditions.checkNotNull((Object)lowerBound);
    }

    public void setUpperBound(UType upperBound) {
        this.upperBound = (UType)Preconditions.checkNotNull((Object)upperBound);
    }

    @Override
    public Type inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.inlineTypeVar(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UTypeVar) {
            UTypeVar typeVar = (UTypeVar)obj;
            return this.name.equals(typeVar.name) && this.lowerBound.equals(typeVar.lowerBound) && this.upperBound.equals(typeVar.upperBound);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    public static final class Key
    extends Bindings.Key<TypeWithExpression> {
        public Key(CharSequence name) {
            super(name.toString());
        }
    }

    @AutoValue
    public static abstract class TypeWithExpression
    implements Inlineable<JCTree.JCExpression> {
        public static TypeWithExpression create(Type type, JCTree.JCExpression expression) {
            return new AutoValue_UTypeVar_TypeWithExpression(type, (JCTree.JCExpression)Preconditions.checkNotNull((Object)expression));
        }

        public static TypeWithExpression create(Type type) {
            return new AutoValue_UTypeVar_TypeWithExpression(type, null);
        }

        public abstract Type type();

        @Nullable
        abstract JCTree.JCExpression expression();

        @Override
        public JCTree.JCExpression inline(Inliner inliner) {
            return this.expression() == null ? inliner.inlineAsTree(this.type()) : this.expression();
        }

        public final String toString() {
            return this.type().toString();
        }
    }
}

