/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.util.Iterator;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.jacoco.ant.AntFilesLocator;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiSourceFileLocator;

class AntResourcesLocator
extends MultiSourceFileLocator {
    private final String encoding;
    private final AntFilesLocator filesLocator;
    private boolean empty;

    AntResourcesLocator(String encoding, int tabWidth) {
        super(tabWidth);
        this.encoding = encoding;
        this.filesLocator = new AntFilesLocator(encoding, tabWidth);
        this.empty = true;
        super.add((ISourceFileLocator)this.filesLocator);
    }

    void add(Resource resource) {
        this.empty = false;
        if (resource.isDirectory()) {
            FileResource dir = (FileResource)resource;
            super.add((ISourceFileLocator)new DirectorySourceFileLocator(dir.getFile(), this.encoding, this.getTabWidth()));
        } else {
            this.filesLocator.add(resource);
        }
    }

    void addAll(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            this.add((Resource)iterator.next());
        }
    }

    boolean isEmpty() {
        return this.empty;
    }
}

