/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.tools.JavaFileObject;

public class JavacErrorDescriptionListener
implements DescriptionListener {
    private final Log log;
    private final JavaFileObject sourceFile;
    private final Function<Fix, AppliedFix> fixToAppliedFix;
    private final Context context;
    private final boolean dontUseErrors;
    private static final String MESSAGE_BUNDLE_KEY = "error.prone";
    private static final Supplier<EnumSet<JCDiagnostic.DiagnosticFlag>> diagnosticFlags = Suppliers.memoize(() -> {
        try {
            return EnumSet.of(JCDiagnostic.DiagnosticFlag.valueOf("MULTIPLE"));
        }
        catch (IllegalArgumentException iae) {
            return EnumSet.noneOf(JCDiagnostic.DiagnosticFlag.class);
        }
    });

    private JavacErrorDescriptionListener(Log log, EndPosTable endPositions, JavaFileObject sourceFile, Context context, boolean dontUseErrors) {
        this.log = log;
        this.sourceFile = sourceFile;
        this.context = context;
        this.dontUseErrors = dontUseErrors;
        Preconditions.checkNotNull((Object)endPositions);
        HashMap cache = new HashMap();
        try {
            CharSequence sourceFileContent = sourceFile.getCharContent(true);
            AppliedFix.Applier applier = AppliedFix.fromSource(sourceFileContent, endPositions);
            this.fixToAppliedFix = fix -> cache.computeIfAbsent(fix, applier::apply);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDescribed(Description description) {
        ImmutableList appliedFixes = (ImmutableList)description.fixes.stream().filter(f -> !JavacErrorDescriptionListener.shouldSkipImportTreeFix(description.position, f)).map(this.fixToAppliedFix).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        String message = JavacErrorDescriptionListener.messageForFixes(description, (List<AppliedFix>)appliedFixes);
        JavaFileObject originalSource = this.log.useSource(this.sourceFile);
        try {
            JCDiagnostic.Factory factory = JCDiagnostic.Factory.instance(this.context);
            JCDiagnostic.DiagnosticType type = JCDiagnostic.DiagnosticType.ERROR;
            JCDiagnostic.DiagnosticPosition pos = description.position;
            switch (description.severity()) {
                case ERROR: {
                    if (this.dontUseErrors) {
                        type = JCDiagnostic.DiagnosticType.WARNING;
                        break;
                    }
                    type = JCDiagnostic.DiagnosticType.ERROR;
                    break;
                }
                case WARNING: {
                    type = JCDiagnostic.DiagnosticType.WARNING;
                    break;
                }
                case SUGGESTION: {
                    type = JCDiagnostic.DiagnosticType.NOTE;
                }
            }
            this.log.report(factory.create(type, null, (Set)diagnosticFlags.get(), this.log.currentSource(), pos, MESSAGE_BUNDLE_KEY, message));
        }
        finally {
            if (originalSource != null) {
                this.log.useSource(originalSource);
            }
        }
    }

    private static boolean shouldSkipImportTreeFix(JCDiagnostic.DiagnosticPosition position, Fix f) {
        if (position.getTree() != null && position.getTree().getKind() != Tree.Kind.IMPORT) {
            return false;
        }
        return !f.getImportsToAdd().isEmpty() || !f.getImportsToRemove().isEmpty();
    }

    private static String messageForFixes(Description description, List<AppliedFix> appliedFixes) {
        StringBuilder messageBuilder = new StringBuilder(description.getMessage());
        boolean first = true;
        for (AppliedFix appliedFix : appliedFixes) {
            if (first) {
                messageBuilder.append("\nDid you mean ");
            } else {
                messageBuilder.append(" or ");
            }
            if (appliedFix.isRemoveLine()) {
                messageBuilder.append("to remove this line");
            } else {
                messageBuilder.append("'").append(appliedFix.getNewCodeSnippet()).append("'");
            }
            first = false;
        }
        if (!first) {
            messageBuilder.append("?");
        }
        return messageBuilder.toString();
    }

    static DescriptionListener.Factory provider(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), context, false);
    }

    static DescriptionListener.Factory providerForRefactoring(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), context, true);
    }
}

