/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

public final class InjectMatchers {
    public static final Matcher<Tree> INSIDE_GUICE_MODULE = Matchers.enclosingClass(Matchers.anyOf(Matchers.isSubtypeOf("com.google.inject.Module"), Matchers.isSubtypeOf("com.google.gwt.inject.client.GinModule")));
    public static final String GUICE_PROVIDES_ANNOTATION = "com.google.inject.Provides";
    public static final String DAGGER_PROVIDES_ANNOTATION = "dagger.Provides";
    private static final Matcher<Tree> HAS_PROVIDES_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isType("com.google.inject.Provides"), Matchers.isType("dagger.Provides"), Matchers.isType("com.google.inject.throwingproviders.CheckedProvides"), Matchers.isType("com.google.inject.multibindings.ProvidesIntoMap"), Matchers.isType("com.google.inject.multibindings.ProvidesIntoSet"), Matchers.isType("com.google.inject.multibindings.ProvidesIntoOptional"), Matchers.isType("dagger.producers.Produces")));
    public static final String ASSISTED_ANNOTATION = "com.google.inject.assistedinject.Assisted";
    public static final String ASSISTED_INJECT_ANNOTATION = "com.google.inject.assistedinject.AssistedInject";
    public static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    public static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_JAVAX_INJECT = new AnnotationType("javax.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_GUICE_INJECT = new AnnotationType("com.google.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_AT_INJECT = Matchers.anyOf(IS_APPLICATION_OF_JAVAX_INJECT, IS_APPLICATION_OF_GUICE_INJECT);
    public static final Matcher<Tree> HAS_INJECT_ANNOTATION = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject"));
    public static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    public static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    public static final Matcher<AnnotationTree> IS_SCOPING_ANNOTATION = Matchers.anyOf(Matchers.symbolHasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.symbolHasAnnotation("javax.inject.Scope"));
    public static final String GUICE_BINDING_ANNOTATION = "com.google.inject.BindingAnnotation";
    public static final String JAVAX_QUALIFIER_ANNOTATION = "javax.inject.Qualifier";
    public static final Matcher<AnnotationTree> IS_BINDING_ANNOTATION = Matchers.anyOf(Matchers.symbolHasAnnotation("javax.inject.Qualifier"), Matchers.symbolHasAnnotation("com.google.inject.BindingAnnotation"));
    public static final String GUICE_MAP_KEY_ANNOTATION = "com.google.inject.multibindings.MapKey";
    public static final String DAGGER_MAP_KEY_ANNOTATION = "dagger.MapKey";
    public static final Matcher<ClassTree> IS_DAGGER_COMPONENT = Matchers.anyOf(Matchers.hasAnnotation("dagger.Component"), Matchers.hasAnnotation("dagger.Subcomponent"), Matchers.hasAnnotation("dagger.producers.ProductionComponent"), Matchers.hasAnnotation("dagger.producers.ProductionSubcomponent"), Matchers.hasAnnotation("dagger.hilt.DefineComponent"));
    public static final Matcher<ClassTree> IS_DAGGER_COMPONENT_OR_MODULE = Matchers.anyOf(IS_DAGGER_COMPONENT, Matchers.hasAnnotation("dagger.Module"));

    private InjectMatchers() {
    }

    public static <T extends Tree> Matcher<T> hasProvidesAnnotation() {
        return HAS_PROVIDES_ANNOTATION;
    }

    public static <T extends Tree> Matcher<T> hasInjectAnnotation() {
        return HAS_INJECT_ANNOTATION;
    }
}

