/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class MathDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"FloatMath", (String)"Using `FloatMath` instead of `Math`", (String)"In older versions of Android, using `android.util.FloatMath` was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, `FloatMath` is actually slower than using `java.lang.Math` due to the way the JIT optimizes `java.lang.Math`. Therefore, you should use `Math` instead of `FloatMath` if you are only targeting Froyo and above.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(MathDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation call) {
        JavaParser.ResolvedNode resolved;
        Expression operand = call.astOperand();
        if ((operand == null || !operand.toString().equals("Math")) && (resolved = context.resolve((Node)call)) instanceof JavaParser.ResolvedMethod && ((JavaParser.ResolvedMethod)resolved).getContainingClass().matches("android.util.FloatMath") && context.getProject().getMinSdk() >= 8) {
            String message = String.format("Use `java.lang.Math#%1$s` instead of `android.util.FloatMath#%1$s()` since it is faster as of API 8", call.astName().astValue());
            Location location = operand != null ? context.getRangeLocation((Node)operand, 0, (Node)call.astName(), 0) : context.getLocation((Node)call);
            context.report(ISSUE, (Node)call, location, message);
        }
    }
}

