/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider.pkcs;

import java.io.IOException;
import java.util.Objects;
import net.schmizz.sshj.userauth.keyprovider.pkcs.DSAPrivateKeyInfoKeyPairConverter;
import net.schmizz.sshj.userauth.keyprovider.pkcs.ECDSAPrivateKeyInfoKeyPairConverter;
import net.schmizz.sshj.userauth.keyprovider.pkcs.KeyPairConverter;
import net.schmizz.sshj.userauth.keyprovider.pkcs.RSAPrivateKeyInfoKeyPairConverter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.openssl.PEMKeyPair;

public class PrivateKeyInfoKeyPairConverter
implements KeyPairConverter<PrivateKeyInfo> {
    private DSAPrivateKeyInfoKeyPairConverter dsaPrivateKeyInfoKeyPairConverter = new DSAPrivateKeyInfoKeyPairConverter();
    private ECDSAPrivateKeyInfoKeyPairConverter ecdsaPrivateKeyInfoKeyPairConverter = new ECDSAPrivateKeyInfoKeyPairConverter();
    private RSAPrivateKeyInfoKeyPairConverter rsaPrivateKeyInfoKeyPairConverter = new RSAPrivateKeyInfoKeyPairConverter();

    @Override
    public PEMKeyPair getKeyPair(PrivateKeyInfo privateKeyInfo) throws IOException {
        Objects.requireNonNull(privateKeyInfo, "Private Key Info required");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithm)) {
            return this.rsaPrivateKeyInfoKeyPairConverter.getKeyPair(privateKeyInfo);
        }
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithm)) {
            return this.ecdsaPrivateKeyInfoKeyPairConverter.getKeyPair(privateKeyInfo);
        }
        if (X9ObjectIdentifiers.id_dsa.equals((ASN1Primitive)algorithm)) {
            return this.dsaPrivateKeyInfoKeyPairConverter.getKeyPair(privateKeyInfo);
        }
        throw new IllegalArgumentException(String.format("Unsupported Algorithm [%s]", algorithm));
    }
}

