/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.validation.CriteriaValidator;
import org.springframework.data.mongodb.core.validation.DocumentValidator;
import org.springframework.data.mongodb.core.validation.JsonSchemaValidator;
import org.springframework.util.Assert;

public interface Validator {
    public Document toDocument();

    public static Validator document(Document validationRules) {
        Assert.notNull((Object)validationRules, (String)"ValidationRules must not be null");
        return DocumentValidator.of(validationRules);
    }

    public static Validator schema(MongoJsonSchema schema) {
        Assert.notNull((Object)schema, (String)"Schema must not be null");
        return JsonSchemaValidator.of(schema);
    }

    public static Validator criteria(CriteriaDefinition criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null");
        return CriteriaValidator.of(criteria);
    }
}

