/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.parser;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.vinniks.parsla.exception.GrammarException;
import org.vinniks.parsla.parser.CompiledItem;
import org.vinniks.parsla.parser.CompiledOption;
import org.vinniks.parsla.parser.CompiledRuleItem;

class LeftRecursionDetector {
    private final Map<String, Collection<CompiledOption>> compiledRules;
    private final Set<CompiledOption> visitedOptions;

    static void detect(Map<String, Collection<CompiledOption>> compiledRules) {
        new LeftRecursionDetector(compiledRules).detect();
    }

    private LeftRecursionDetector(Map<String, Collection<CompiledOption>> compiledRules) {
        this.compiledRules = compiledRules;
        this.visitedOptions = new LinkedHashSet<CompiledOption>();
    }

    private void detect() {
        this.compiledRules.keySet().forEach(ruleName -> this.detect((String)ruleName, new RecursionTreeNode(null, (String)ruleName)));
    }

    private RecursionTreeNode detect(String ruleName, RecursionTreeNode path) {
        RecursionTreeNode shortestEmptyPath = null;
        for (CompiledOption option : this.compiledRules.get(ruleName)) {
            RecursionTreeNode emptyPath = this.detect(option, path);
            if (shortestEmptyPath != null && (emptyPath == null || shortestEmptyPath.getLevel() <= emptyPath.getLevel())) continue;
            shortestEmptyPath = emptyPath;
        }
        return shortestEmptyPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecursionTreeNode detect(CompiledOption option, RecursionTreeNode path) {
        if (this.visitedOptions.contains(option)) {
            throw new GrammarException(String.format("Left recursion detected at %s", this.buildRecursionPath(path)));
        }
        this.visitedOptions.add(option);
        try {
            for (CompiledItem item : option.getItems(false)) {
                RecursionTreeNode recursionTreeNode;
                if (item instanceof CompiledRuleItem) {
                    CompiledRuleItem ruleItem = (CompiledRuleItem)item;
                    recursionTreeNode = this.detect(ruleItem.getRuleName(), new RecursionTreeNode(path, ruleItem.getRuleName()));
                } else {
                    recursionTreeNode = null;
                }
                if ((path = recursionTreeNode) != null) continue;
                break;
            }
        }
        finally {
            this.visitedOptions.remove(option);
        }
        return path;
    }

    private String buildRecursionPath(RecursionTreeNode path) {
        StringBuilder builder = new StringBuilder();
        this.buildRecursionPath(path, builder, null);
        return builder.toString();
    }

    private void buildRecursionPath(RecursionTreeNode path, StringBuilder builder, String recursiveRuleName) {
        if (path.getParent() != null && recursiveRuleName == null || !recursiveRuleName.equals(path.getRuleName())) {
            this.buildRecursionPath(path.getParent(), builder, recursiveRuleName == null ? path.getRuleName() : recursiveRuleName);
        }
        if (!builder.isEmpty()) {
            builder.append(" > ");
        }
        builder.append(path.getRuleName());
    }

    private static class RecursionTreeNode {
        private final RecursionTreeNode parent;
        private final String ruleName;
        private final int level;

        public RecursionTreeNode(RecursionTreeNode parent, String ruleName) {
            this.parent = parent;
            this.ruleName = ruleName;
            this.level = parent == null ? 1 : parent.getLevel() + 1;
        }

        @Generated
        private RecursionTreeNode getParent() {
            return this.parent;
        }

        @Generated
        private String getRuleName() {
            return this.ruleName;
        }

        @Generated
        private int getLevel() {
            return this.level;
        }
    }
}

