package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListL7PoliciesRequest Request Object
type ListL7PoliciesRequest struct {

	// **参数解释**：上一页最后一条记录的ID。  **约束限制**： - 必须与limit一起使用。 - 不指定时表示查询第一页。 - 该字段不允许为空或无效的ID。  **取值范围**：不涉及  **默认取值**：不涉及
	Marker *string `json:"marker,omitempty"`

	// **参数解释**：每页返回的个数。  **约束限制**：不涉及  **取值范围**：0-2000  **默认取值**：2000
	Limit *int32 `json:"limit,omitempty"`

	// **参数解释**：是否反向查询。  **约束限制**： - 必须与limit一起使用。 - 当page_reverse=true时，若要查询上一页，marker取值为当前页返回值的previous_marker。  **取值范围**： - true：查询上一页。 - false：查询下一页。  **默认取值**：false
	PageReverse *bool `json:"page_reverse,omitempty"`

	// **参数解释**：资源所属的企业项目ID。 支持多值查询，查询条件格式：*enterprise_project_id=xxx&enterprise_project_id=xxx*。  **约束限制**： - 如果enterprise_project_id不传值，默认查询所有企业项目下的资源，鉴权按照细粒度权限鉴权，必须在用户组下分配elb:l7policies:list权限。 - 如果enterprise_project_id传值，鉴权按照企业项目权限鉴权，分为传入具体eps_id和all_granted_eps两种场景，前者查询指定eps_id的eps下的资源，后者查询的是所有有list权限的eps下的资源。  **取值范围**：不涉及  **默认取值**：不涉及  [不支持该字段，请勿使用。](tag:dt,hcso_dt)
	EnterpriseProjectId *[]string `json:"enterprise_project_id,omitempty"`

	// **参数解释**：转发策略ID。 支持多值查询，查询条件格式：*id=xxx&id=xxx*。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	Id *[]string `json:"id,omitempty"`

	// **参数解释**：转发策略名称。 支持多值查询，查询条件格式：**name=xxx&name=xxx**。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	Name *[]string `json:"name,omitempty"`

	// **参数解释**：转发策略额描述信息。 支持多值查询，查询条件格式：*description=xxx&description=xxx*。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	Description *[]string `json:"description,omitempty"`

	// **参数解释**：转发策略的管理状态。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	AdminStateUp *bool `json:"admin_state_up,omitempty"`

	// **参数解释**：转发策略所属的监听器ID。 支持多值查询，查询条件格式：*******listener_id=xxx&listener_id=xxx*******。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	ListenerId *[]string `json:"listener_id,omitempty"`

	// **参数解释**：转发策略的优先级。 支持多值查询，查询条件格式：****position=xxx&position=xxx****。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	Position *[]int32 `json:"position,omitempty"`

	// **参数解释**：转发策略的转发动作。 支持多值查询，查询条件格式：*****action=xxx&action=xxx*****。  **约束限制**：不涉及  **取值范围**： - REDIRECT_TO_POOL：转发到后端服务器组。 - REDIRECT_TO_LISTENER：重定向到监听器。 - REDIRECT_TO_URL：重定向到URL。 - FIXED_RESPONSE：返回固定响应体。  **默认取值**：不涉及
	Action *[]string `json:"action,omitempty"`

	// **参数解释**：转发到的url。 支持多值查询，查询条件格式：****redirect_url=xxx&redirect_url=xxx****。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及  不支持该字段，请勿使用。
	RedirectUrl *[]string `json:"redirect_url,omitempty"`

	// **参数解释**：转发到pool的ID。 支持多值查询，查询条件格式：***redirect_pool_id=xxx&redirect_pool_id=xxx***。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	RedirectPoolId *[]string `json:"redirect_pool_id,omitempty"`

	// **参数解释**：转发到的listener的ID。 支持多值查询，查询条件格式：**redirect_listener_id=xxx&redirect_listener_id=xxx**。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及
	RedirectListenerId *[]string `json:"redirect_listener_id,omitempty"`

	// **参数解释**：转发策略的配置状态。 支持多值查询，查询条件格式：*provisioning_status=xxx&provisioning_status=xxx*。  **约束限制**：不涉及  **取值范围**： - ACTIVE: 表示正常。 - ERROR: 表示当前策略与同一监听器下的其他策略存在相同的规则配置。  **默认取值**：不涉及
	ProvisioningStatus *[]string `json:"provisioning_status,omitempty"`

	// **参数解释**：是否显示转发策略下的rule详细信息。  **约束限制**：不涉及  **取值范围**： - true：显示policy下面的rule的详细信息。 - false：只显示policy下面的rule的id信息。  **默认取值**：不涉及
	DisplayAllRules *bool `json:"display_all_rules,omitempty"`

	// **参数解释**：转发策略的优先级。数值越小，优先级越高。 支持多值查询，查询条件格式：*priority=xxx&priority=xxx*。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：不涉及  [不支持该字段，请勿使用。](tag:hcso_dt)
	Priority *[]int32 `json:"priority,omitempty"`
}

func (o ListL7PoliciesRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListL7PoliciesRequest struct{}"
	}

	return strings.Join([]string{"ListL7PoliciesRequest", string(data)}, " ")
}
