/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	apisv1alpha2 "sigs.k8s.io/gateway-api/apis/applyconfiguration/apis/v1alpha2"
	v1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
)

// FakeBackendLBPolicies implements BackendLBPolicyInterface
type FakeBackendLBPolicies struct {
	Fake *FakeGatewayV1alpha2
	ns   string
}

var backendlbpoliciesResource = v1alpha2.SchemeGroupVersion.WithResource("backendlbpolicies")

var backendlbpoliciesKind = v1alpha2.SchemeGroupVersion.WithKind("BackendLBPolicy")

// Get takes name of the backendLBPolicy, and returns the corresponding backendLBPolicy object, and an error if there is any.
func (c *FakeBackendLBPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.BackendLBPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(backendlbpoliciesResource, c.ns, name), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// List takes label and field selectors, and returns the list of BackendLBPolicies that match those selectors.
func (c *FakeBackendLBPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.BackendLBPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(backendlbpoliciesResource, backendlbpoliciesKind, c.ns, opts), &v1alpha2.BackendLBPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha2.BackendLBPolicyList{ListMeta: obj.(*v1alpha2.BackendLBPolicyList).ListMeta}
	for _, item := range obj.(*v1alpha2.BackendLBPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested backendLBPolicies.
func (c *FakeBackendLBPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(backendlbpoliciesResource, c.ns, opts))

}

// Create takes the representation of a backendLBPolicy and creates it.  Returns the server's representation of the backendLBPolicy, and an error, if there is any.
func (c *FakeBackendLBPolicies) Create(ctx context.Context, backendLBPolicy *v1alpha2.BackendLBPolicy, opts v1.CreateOptions) (result *v1alpha2.BackendLBPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(backendlbpoliciesResource, c.ns, backendLBPolicy), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// Update takes the representation of a backendLBPolicy and updates it. Returns the server's representation of the backendLBPolicy, and an error, if there is any.
func (c *FakeBackendLBPolicies) Update(ctx context.Context, backendLBPolicy *v1alpha2.BackendLBPolicy, opts v1.UpdateOptions) (result *v1alpha2.BackendLBPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(backendlbpoliciesResource, c.ns, backendLBPolicy), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeBackendLBPolicies) UpdateStatus(ctx context.Context, backendLBPolicy *v1alpha2.BackendLBPolicy, opts v1.UpdateOptions) (*v1alpha2.BackendLBPolicy, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(backendlbpoliciesResource, "status", c.ns, backendLBPolicy), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// Delete takes name of the backendLBPolicy and deletes it. Returns an error if one occurs.
func (c *FakeBackendLBPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(backendlbpoliciesResource, c.ns, name, opts), &v1alpha2.BackendLBPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeBackendLBPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(backendlbpoliciesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha2.BackendLBPolicyList{})
	return err
}

// Patch applies the patch and returns the patched backendLBPolicy.
func (c *FakeBackendLBPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.BackendLBPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(backendlbpoliciesResource, c.ns, name, pt, data, subresources...), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied backendLBPolicy.
func (c *FakeBackendLBPolicies) Apply(ctx context.Context, backendLBPolicy *apisv1alpha2.BackendLBPolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.BackendLBPolicy, err error) {
	if backendLBPolicy == nil {
		return nil, fmt.Errorf("backendLBPolicy provided to Apply must not be nil")
	}
	data, err := json.Marshal(backendLBPolicy)
	if err != nil {
		return nil, err
	}
	name := backendLBPolicy.Name
	if name == nil {
		return nil, fmt.Errorf("backendLBPolicy.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(backendlbpoliciesResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeBackendLBPolicies) ApplyStatus(ctx context.Context, backendLBPolicy *apisv1alpha2.BackendLBPolicyApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.BackendLBPolicy, err error) {
	if backendLBPolicy == nil {
		return nil, fmt.Errorf("backendLBPolicy provided to Apply must not be nil")
	}
	data, err := json.Marshal(backendLBPolicy)
	if err != nil {
		return nil, err
	}
	name := backendLBPolicy.Name
	if name == nil {
		return nil, fmt.Errorf("backendLBPolicy.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(backendlbpoliciesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha2.BackendLBPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.BackendLBPolicy), err
}
