// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.12.4
// source: sev.proto

package sev

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Mirrors struct vmcb_seg in arch/x86/include/asm/svm.h.
type VmcbSeg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Selector uint32 `protobuf:"varint,1,opt,name=selector,proto3" json:"selector,omitempty"` // uint16_t
	Attrib   uint32 `protobuf:"varint,2,opt,name=attrib,proto3" json:"attrib,omitempty"`     // uint16_t
	Limit    uint32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	Base     uint64 `protobuf:"varint,4,opt,name=base,proto3" json:"base,omitempty"`
}

func (x *VmcbSeg) Reset() {
	*x = VmcbSeg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sev_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmcbSeg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmcbSeg) ProtoMessage() {}

func (x *VmcbSeg) ProtoReflect() protoreflect.Message {
	mi := &file_sev_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmcbSeg.ProtoReflect.Descriptor instead.
func (*VmcbSeg) Descriptor() ([]byte, []int) {
	return file_sev_proto_rawDescGZIP(), []int{0}
}

func (x *VmcbSeg) GetSelector() uint32 {
	if x != nil {
		return x.Selector
	}
	return 0
}

func (x *VmcbSeg) GetAttrib() uint32 {
	if x != nil {
		return x.Attrib
	}
	return 0
}

func (x *VmcbSeg) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *VmcbSeg) GetBase() uint64 {
	if x != nil {
		return x.Base
	}
	return 0
}

// VMCB Save Area (VMSA) used when SEV-ES is enabled. Mirrors struct
// vmcb_save_area in arch/x86/include/asm/svm.h.
type VmcbSaveArea struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Es           *VmcbSeg `protobuf:"bytes,1,opt,name=es,proto3" json:"es,omitempty"`
	Cs           *VmcbSeg `protobuf:"bytes,2,opt,name=cs,proto3" json:"cs,omitempty"`
	Ss           *VmcbSeg `protobuf:"bytes,3,opt,name=ss,proto3" json:"ss,omitempty"`
	Ds           *VmcbSeg `protobuf:"bytes,4,opt,name=ds,proto3" json:"ds,omitempty"`
	Fs           *VmcbSeg `protobuf:"bytes,5,opt,name=fs,proto3" json:"fs,omitempty"`
	Gs           *VmcbSeg `protobuf:"bytes,6,opt,name=gs,proto3" json:"gs,omitempty"`
	Gdtr         *VmcbSeg `protobuf:"bytes,7,opt,name=gdtr,proto3" json:"gdtr,omitempty"`
	Ldtr         *VmcbSeg `protobuf:"bytes,8,opt,name=ldtr,proto3" json:"ldtr,omitempty"`
	Idtr         *VmcbSeg `protobuf:"bytes,9,opt,name=idtr,proto3" json:"idtr,omitempty"`
	Tr           *VmcbSeg `protobuf:"bytes,10,opt,name=tr,proto3" json:"tr,omitempty"`
	Reserved_1   []byte   `protobuf:"bytes,11,opt,name=reserved_1,json=reserved1,proto3" json:"reserved_1,omitempty"` // 43 bytes
	Cpl          uint32   `protobuf:"varint,12,opt,name=cpl,proto3" json:"cpl,omitempty"`                             // uint8_t
	Reserved_2   []byte   `protobuf:"bytes,13,opt,name=reserved_2,json=reserved2,proto3" json:"reserved_2,omitempty"` // 4 bytes
	Efer         uint64   `protobuf:"varint,14,opt,name=efer,proto3" json:"efer,omitempty"`
	Reserved_3   []byte   `protobuf:"bytes,15,opt,name=reserved_3,json=reserved3,proto3" json:"reserved_3,omitempty"` // 104 bytes
	Xss          uint64   `protobuf:"varint,16,opt,name=xss,proto3" json:"xss,omitempty"`
	Cr4          uint64   `protobuf:"varint,17,opt,name=cr4,proto3" json:"cr4,omitempty"`
	Cr3          uint64   `protobuf:"varint,18,opt,name=cr3,proto3" json:"cr3,omitempty"`
	Cr0          uint64   `protobuf:"varint,19,opt,name=cr0,proto3" json:"cr0,omitempty"`
	Dr7          uint64   `protobuf:"varint,20,opt,name=dr7,proto3" json:"dr7,omitempty"`
	Dr6          uint64   `protobuf:"varint,21,opt,name=dr6,proto3" json:"dr6,omitempty"`
	Rflags       uint64   `protobuf:"varint,22,opt,name=rflags,proto3" json:"rflags,omitempty"`
	Rip          uint64   `protobuf:"varint,23,opt,name=rip,proto3" json:"rip,omitempty"`
	Reserved_4   []byte   `protobuf:"bytes,24,opt,name=reserved_4,json=reserved4,proto3" json:"reserved_4,omitempty"` // 88 bytes
	Rsp          uint64   `protobuf:"varint,25,opt,name=rsp,proto3" json:"rsp,omitempty"`
	Reserved_5   []byte   `protobuf:"bytes,26,opt,name=reserved_5,json=reserved5,proto3" json:"reserved_5,omitempty"` // 24 bytes
	Rax          uint64   `protobuf:"varint,27,opt,name=rax,proto3" json:"rax,omitempty"`
	Star         uint64   `protobuf:"varint,28,opt,name=star,proto3" json:"star,omitempty"`
	Lstar        uint64   `protobuf:"varint,29,opt,name=lstar,proto3" json:"lstar,omitempty"`
	Cstar        uint64   `protobuf:"varint,30,opt,name=cstar,proto3" json:"cstar,omitempty"`
	Sfmask       uint64   `protobuf:"varint,31,opt,name=sfmask,proto3" json:"sfmask,omitempty"`
	KernelGsBase uint64   `protobuf:"varint,32,opt,name=kernel_gs_base,json=kernelGsBase,proto3" json:"kernel_gs_base,omitempty"`
	SysenterCs   uint64   `protobuf:"varint,33,opt,name=sysenter_cs,json=sysenterCs,proto3" json:"sysenter_cs,omitempty"`
	SysenterEsp  uint64   `protobuf:"varint,34,opt,name=sysenter_esp,json=sysenterEsp,proto3" json:"sysenter_esp,omitempty"`
	SysenterEip  uint64   `protobuf:"varint,35,opt,name=sysenter_eip,json=sysenterEip,proto3" json:"sysenter_eip,omitempty"`
	Cr2          uint64   `protobuf:"varint,36,opt,name=cr2,proto3" json:"cr2,omitempty"`
	Reserved_6   []byte   `protobuf:"bytes,37,opt,name=reserved_6,json=reserved6,proto3" json:"reserved_6,omitempty"` // 32 bytes
	GPat         uint64   `protobuf:"varint,38,opt,name=g_pat,json=gPat,proto3" json:"g_pat,omitempty"`
	Dbgctl       uint64   `protobuf:"varint,39,opt,name=dbgctl,proto3" json:"dbgctl,omitempty"`
	BrFrom       uint64   `protobuf:"varint,40,opt,name=br_from,json=brFrom,proto3" json:"br_from,omitempty"`
	BrTo         uint64   `protobuf:"varint,41,opt,name=br_to,json=brTo,proto3" json:"br_to,omitempty"`
	LastExcpFrom uint64   `protobuf:"varint,42,opt,name=last_excp_from,json=lastExcpFrom,proto3" json:"last_excp_from,omitempty"`
	LastExcpTo   uint64   `protobuf:"varint,43,opt,name=last_excp_to,json=lastExcpTo,proto3" json:"last_excp_to,omitempty"`
	// SEV-ES fields.
	Reserved_7   []byte `protobuf:"bytes,44,opt,name=reserved_7,json=reserved7,proto3" json:"reserved_7,omitempty"` // 80 bytes
	Pkru         uint32 `protobuf:"varint,45,opt,name=pkru,proto3" json:"pkru,omitempty"`
	Reserved_7A  []byte `protobuf:"bytes,46,opt,name=reserved_7a,json=reserved7a,proto3" json:"reserved_7a,omitempty"` // 20 bytes
	Reserved_8   uint64 `protobuf:"varint,47,opt,name=reserved_8,json=reserved8,proto3" json:"reserved_8,omitempty"`
	Rcx          uint64 `protobuf:"varint,48,opt,name=rcx,proto3" json:"rcx,omitempty"`
	Rdx          uint64 `protobuf:"varint,49,opt,name=rdx,proto3" json:"rdx,omitempty"`
	Rbx          uint64 `protobuf:"varint,50,opt,name=rbx,proto3" json:"rbx,omitempty"`
	Reserved_9   uint64 `protobuf:"varint,51,opt,name=reserved_9,json=reserved9,proto3" json:"reserved_9,omitempty"`
	Rbp          uint64 `protobuf:"varint,52,opt,name=rbp,proto3" json:"rbp,omitempty"`
	Rsi          uint64 `protobuf:"varint,53,opt,name=rsi,proto3" json:"rsi,omitempty"`
	Rdi          uint64 `protobuf:"varint,54,opt,name=rdi,proto3" json:"rdi,omitempty"`
	R8           uint64 `protobuf:"varint,55,opt,name=r8,proto3" json:"r8,omitempty"`
	R9           uint64 `protobuf:"varint,56,opt,name=r9,proto3" json:"r9,omitempty"`
	R10          uint64 `protobuf:"varint,57,opt,name=r10,proto3" json:"r10,omitempty"`
	R11          uint64 `protobuf:"varint,58,opt,name=r11,proto3" json:"r11,omitempty"`
	R12          uint64 `protobuf:"varint,59,opt,name=r12,proto3" json:"r12,omitempty"`
	R13          uint64 `protobuf:"varint,60,opt,name=r13,proto3" json:"r13,omitempty"`
	R14          uint64 `protobuf:"varint,61,opt,name=r14,proto3" json:"r14,omitempty"`
	R15          uint64 `protobuf:"varint,62,opt,name=r15,proto3" json:"r15,omitempty"`
	Reserved_10  []byte `protobuf:"bytes,63,opt,name=reserved_10,json=reserved10,proto3" json:"reserved_10,omitempty"` // 16 bytes
	SwExitCode   uint64 `protobuf:"varint,64,opt,name=sw_exit_code,json=swExitCode,proto3" json:"sw_exit_code,omitempty"`
	SwExitInfo_1 uint64 `protobuf:"varint,65,opt,name=sw_exit_info_1,json=swExitInfo1,proto3" json:"sw_exit_info_1,omitempty"`
	SwExitInfo_2 uint64 `protobuf:"varint,66,opt,name=sw_exit_info_2,json=swExitInfo2,proto3" json:"sw_exit_info_2,omitempty"`
	SwScratch    uint64 `protobuf:"varint,67,opt,name=sw_scratch,json=swScratch,proto3" json:"sw_scratch,omitempty"`
	SevFeatures  uint64 `protobuf:"varint,68,opt,name=sev_features,json=sevFeatures,proto3" json:"sev_features,omitempty"`
	Reserved_11  []byte `protobuf:"bytes,69,opt,name=reserved_11,json=reserved11,proto3" json:"reserved_11,omitempty"` // 48 bytes
	Xcr0         uint64 `protobuf:"varint,70,opt,name=xcr0,proto3" json:"xcr0,omitempty"`
	ValidBitmap  []byte `protobuf:"bytes,71,opt,name=valid_bitmap,json=validBitmap,proto3" json:"valid_bitmap,omitempty"` // 16 bytes
	X87StateGpa  uint64 `protobuf:"varint,72,opt,name=x87_state_gpa,json=x87StateGpa,proto3" json:"x87_state_gpa,omitempty"`
	Reserved_12  []byte `protobuf:"bytes,73,opt,name=reserved_12,json=reserved12,proto3" json:"reserved_12,omitempty"` // 1016 bytes
}

func (x *VmcbSaveArea) Reset() {
	*x = VmcbSaveArea{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sev_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmcbSaveArea) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmcbSaveArea) ProtoMessage() {}

func (x *VmcbSaveArea) ProtoReflect() protoreflect.Message {
	mi := &file_sev_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmcbSaveArea.ProtoReflect.Descriptor instead.
func (*VmcbSaveArea) Descriptor() ([]byte, []int) {
	return file_sev_proto_rawDescGZIP(), []int{1}
}

func (x *VmcbSaveArea) GetEs() *VmcbSeg {
	if x != nil {
		return x.Es
	}
	return nil
}

func (x *VmcbSaveArea) GetCs() *VmcbSeg {
	if x != nil {
		return x.Cs
	}
	return nil
}

func (x *VmcbSaveArea) GetSs() *VmcbSeg {
	if x != nil {
		return x.Ss
	}
	return nil
}

func (x *VmcbSaveArea) GetDs() *VmcbSeg {
	if x != nil {
		return x.Ds
	}
	return nil
}

func (x *VmcbSaveArea) GetFs() *VmcbSeg {
	if x != nil {
		return x.Fs
	}
	return nil
}

func (x *VmcbSaveArea) GetGs() *VmcbSeg {
	if x != nil {
		return x.Gs
	}
	return nil
}

func (x *VmcbSaveArea) GetGdtr() *VmcbSeg {
	if x != nil {
		return x.Gdtr
	}
	return nil
}

func (x *VmcbSaveArea) GetLdtr() *VmcbSeg {
	if x != nil {
		return x.Ldtr
	}
	return nil
}

func (x *VmcbSaveArea) GetIdtr() *VmcbSeg {
	if x != nil {
		return x.Idtr
	}
	return nil
}

func (x *VmcbSaveArea) GetTr() *VmcbSeg {
	if x != nil {
		return x.Tr
	}
	return nil
}

func (x *VmcbSaveArea) GetReserved_1() []byte {
	if x != nil {
		return x.Reserved_1
	}
	return nil
}

func (x *VmcbSaveArea) GetCpl() uint32 {
	if x != nil {
		return x.Cpl
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_2() []byte {
	if x != nil {
		return x.Reserved_2
	}
	return nil
}

func (x *VmcbSaveArea) GetEfer() uint64 {
	if x != nil {
		return x.Efer
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_3() []byte {
	if x != nil {
		return x.Reserved_3
	}
	return nil
}

func (x *VmcbSaveArea) GetXss() uint64 {
	if x != nil {
		return x.Xss
	}
	return 0
}

func (x *VmcbSaveArea) GetCr4() uint64 {
	if x != nil {
		return x.Cr4
	}
	return 0
}

func (x *VmcbSaveArea) GetCr3() uint64 {
	if x != nil {
		return x.Cr3
	}
	return 0
}

func (x *VmcbSaveArea) GetCr0() uint64 {
	if x != nil {
		return x.Cr0
	}
	return 0
}

func (x *VmcbSaveArea) GetDr7() uint64 {
	if x != nil {
		return x.Dr7
	}
	return 0
}

func (x *VmcbSaveArea) GetDr6() uint64 {
	if x != nil {
		return x.Dr6
	}
	return 0
}

func (x *VmcbSaveArea) GetRflags() uint64 {
	if x != nil {
		return x.Rflags
	}
	return 0
}

func (x *VmcbSaveArea) GetRip() uint64 {
	if x != nil {
		return x.Rip
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_4() []byte {
	if x != nil {
		return x.Reserved_4
	}
	return nil
}

func (x *VmcbSaveArea) GetRsp() uint64 {
	if x != nil {
		return x.Rsp
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_5() []byte {
	if x != nil {
		return x.Reserved_5
	}
	return nil
}

func (x *VmcbSaveArea) GetRax() uint64 {
	if x != nil {
		return x.Rax
	}
	return 0
}

func (x *VmcbSaveArea) GetStar() uint64 {
	if x != nil {
		return x.Star
	}
	return 0
}

func (x *VmcbSaveArea) GetLstar() uint64 {
	if x != nil {
		return x.Lstar
	}
	return 0
}

func (x *VmcbSaveArea) GetCstar() uint64 {
	if x != nil {
		return x.Cstar
	}
	return 0
}

func (x *VmcbSaveArea) GetSfmask() uint64 {
	if x != nil {
		return x.Sfmask
	}
	return 0
}

func (x *VmcbSaveArea) GetKernelGsBase() uint64 {
	if x != nil {
		return x.KernelGsBase
	}
	return 0
}

func (x *VmcbSaveArea) GetSysenterCs() uint64 {
	if x != nil {
		return x.SysenterCs
	}
	return 0
}

func (x *VmcbSaveArea) GetSysenterEsp() uint64 {
	if x != nil {
		return x.SysenterEsp
	}
	return 0
}

func (x *VmcbSaveArea) GetSysenterEip() uint64 {
	if x != nil {
		return x.SysenterEip
	}
	return 0
}

func (x *VmcbSaveArea) GetCr2() uint64 {
	if x != nil {
		return x.Cr2
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_6() []byte {
	if x != nil {
		return x.Reserved_6
	}
	return nil
}

func (x *VmcbSaveArea) GetGPat() uint64 {
	if x != nil {
		return x.GPat
	}
	return 0
}

func (x *VmcbSaveArea) GetDbgctl() uint64 {
	if x != nil {
		return x.Dbgctl
	}
	return 0
}

func (x *VmcbSaveArea) GetBrFrom() uint64 {
	if x != nil {
		return x.BrFrom
	}
	return 0
}

func (x *VmcbSaveArea) GetBrTo() uint64 {
	if x != nil {
		return x.BrTo
	}
	return 0
}

func (x *VmcbSaveArea) GetLastExcpFrom() uint64 {
	if x != nil {
		return x.LastExcpFrom
	}
	return 0
}

func (x *VmcbSaveArea) GetLastExcpTo() uint64 {
	if x != nil {
		return x.LastExcpTo
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_7() []byte {
	if x != nil {
		return x.Reserved_7
	}
	return nil
}

func (x *VmcbSaveArea) GetPkru() uint32 {
	if x != nil {
		return x.Pkru
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_7A() []byte {
	if x != nil {
		return x.Reserved_7A
	}
	return nil
}

func (x *VmcbSaveArea) GetReserved_8() uint64 {
	if x != nil {
		return x.Reserved_8
	}
	return 0
}

func (x *VmcbSaveArea) GetRcx() uint64 {
	if x != nil {
		return x.Rcx
	}
	return 0
}

func (x *VmcbSaveArea) GetRdx() uint64 {
	if x != nil {
		return x.Rdx
	}
	return 0
}

func (x *VmcbSaveArea) GetRbx() uint64 {
	if x != nil {
		return x.Rbx
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_9() uint64 {
	if x != nil {
		return x.Reserved_9
	}
	return 0
}

func (x *VmcbSaveArea) GetRbp() uint64 {
	if x != nil {
		return x.Rbp
	}
	return 0
}

func (x *VmcbSaveArea) GetRsi() uint64 {
	if x != nil {
		return x.Rsi
	}
	return 0
}

func (x *VmcbSaveArea) GetRdi() uint64 {
	if x != nil {
		return x.Rdi
	}
	return 0
}

func (x *VmcbSaveArea) GetR8() uint64 {
	if x != nil {
		return x.R8
	}
	return 0
}

func (x *VmcbSaveArea) GetR9() uint64 {
	if x != nil {
		return x.R9
	}
	return 0
}

func (x *VmcbSaveArea) GetR10() uint64 {
	if x != nil {
		return x.R10
	}
	return 0
}

func (x *VmcbSaveArea) GetR11() uint64 {
	if x != nil {
		return x.R11
	}
	return 0
}

func (x *VmcbSaveArea) GetR12() uint64 {
	if x != nil {
		return x.R12
	}
	return 0
}

func (x *VmcbSaveArea) GetR13() uint64 {
	if x != nil {
		return x.R13
	}
	return 0
}

func (x *VmcbSaveArea) GetR14() uint64 {
	if x != nil {
		return x.R14
	}
	return 0
}

func (x *VmcbSaveArea) GetR15() uint64 {
	if x != nil {
		return x.R15
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_10() []byte {
	if x != nil {
		return x.Reserved_10
	}
	return nil
}

func (x *VmcbSaveArea) GetSwExitCode() uint64 {
	if x != nil {
		return x.SwExitCode
	}
	return 0
}

func (x *VmcbSaveArea) GetSwExitInfo_1() uint64 {
	if x != nil {
		return x.SwExitInfo_1
	}
	return 0
}

func (x *VmcbSaveArea) GetSwExitInfo_2() uint64 {
	if x != nil {
		return x.SwExitInfo_2
	}
	return 0
}

func (x *VmcbSaveArea) GetSwScratch() uint64 {
	if x != nil {
		return x.SwScratch
	}
	return 0
}

func (x *VmcbSaveArea) GetSevFeatures() uint64 {
	if x != nil {
		return x.SevFeatures
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_11() []byte {
	if x != nil {
		return x.Reserved_11
	}
	return nil
}

func (x *VmcbSaveArea) GetXcr0() uint64 {
	if x != nil {
		return x.Xcr0
	}
	return 0
}

func (x *VmcbSaveArea) GetValidBitmap() []byte {
	if x != nil {
		return x.ValidBitmap
	}
	return nil
}

func (x *VmcbSaveArea) GetX87StateGpa() uint64 {
	if x != nil {
		return x.X87StateGpa
	}
	return 0
}

func (x *VmcbSaveArea) GetReserved_12() []byte {
	if x != nil {
		return x.Reserved_12
	}
	return nil
}

var File_sev_proto protoreflect.FileDescriptor

var file_sev_proto_rawDesc = []byte{
	0x0a, 0x09, 0x73, 0x65, 0x76, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x73, 0x65, 0x76,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x67, 0x0a, 0x07, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a,
	0x06, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x62,
	0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x62, 0x61, 0x73, 0x65, 0x22,
	0xac, 0x0f, 0x0a, 0x0c, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x61, 0x76, 0x65, 0x41, 0x72, 0x65, 0x61,
	0x12, 0x22, 0x0a, 0x02, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73,
	0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67,
	0x52, 0x02, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x02, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63,
	0x62, 0x53, 0x65, 0x67, 0x52, 0x02, 0x63, 0x73, 0x12, 0x22, 0x0a, 0x02, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67, 0x52, 0x02, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x02,
	0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67, 0x52, 0x02, 0x64, 0x73,
	0x12, 0x22, 0x0a, 0x02, 0x66, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73,
	0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67,
	0x52, 0x02, 0x66, 0x73, 0x12, 0x22, 0x0a, 0x02, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63,
	0x62, 0x53, 0x65, 0x67, 0x52, 0x02, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x04, 0x67, 0x64, 0x74, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67, 0x52, 0x04, 0x67, 0x64, 0x74, 0x72,
	0x12, 0x26, 0x0a, 0x04, 0x6c, 0x64, 0x74, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53,
	0x65, 0x67, 0x52, 0x04, 0x6c, 0x64, 0x74, 0x72, 0x12, 0x26, 0x0a, 0x04, 0x69, 0x64, 0x74, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67, 0x52, 0x04, 0x69, 0x64, 0x74, 0x72,
	0x12, 0x22, 0x0a, 0x02, 0x74, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73,
	0x65, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x56, 0x6d, 0x63, 0x62, 0x53, 0x65, 0x67,
	0x52, 0x02, 0x74, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x5f, 0x31, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x64, 0x31, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x70, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x03, 0x63, 0x70, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x64, 0x5f, 0x32, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x32, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x66, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x04, 0x65, 0x66, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x5f, 0x33, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x33, 0x12, 0x10, 0x0a, 0x03, 0x78, 0x73, 0x73, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x78, 0x73, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x72, 0x34,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x63, 0x72, 0x34, 0x12, 0x10, 0x0a, 0x03, 0x63,
	0x72, 0x33, 0x18, 0x12, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x63, 0x72, 0x33, 0x12, 0x10, 0x0a,
	0x03, 0x63, 0x72, 0x30, 0x18, 0x13, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x63, 0x72, 0x30, 0x12,
	0x10, 0x0a, 0x03, 0x64, 0x72, 0x37, 0x18, 0x14, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x64, 0x72,
	0x37, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x72, 0x36, 0x18, 0x15, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03,
	0x64, 0x72, 0x36, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x72, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x72,
	0x69, 0x70, 0x18, 0x17, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x69, 0x70, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x34, 0x18, 0x18, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x34, 0x12, 0x10, 0x0a, 0x03,
	0x72, 0x73, 0x70, 0x18, 0x19, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x73, 0x70, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x35, 0x18, 0x1a, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x35, 0x12, 0x10, 0x0a,
	0x03, 0x72, 0x61, 0x78, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x61, 0x78, 0x12,
	0x12, 0x0a, 0x04, 0x73, 0x74, 0x61, 0x72, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73,
	0x74, 0x61, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x73, 0x74, 0x61, 0x72, 0x18, 0x1d, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x05, 0x6c, 0x73, 0x74, 0x61, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x73, 0x74,
	0x61, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x63, 0x73, 0x74, 0x61, 0x72, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x66, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x06, 0x73, 0x66, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x24, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x67, 0x73, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0c, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x47, 0x73, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x73, 0x18, 0x21, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0a, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x73, 0x70, 0x18, 0x22,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x45, 0x73,
	0x70, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x69,
	0x70, 0x18, 0x23, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x79, 0x73, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x45, 0x69, 0x70, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x72, 0x32, 0x18, 0x24, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x03, 0x63, 0x72, 0x32, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x64, 0x5f, 0x36, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x36, 0x12, 0x13, 0x0a, 0x05, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x18, 0x26,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x67, 0x50, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x62,
	0x67, 0x63, 0x74, 0x6c, 0x18, 0x27, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x64, 0x62, 0x67, 0x63,
	0x74, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x72, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x18, 0x28, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x62, 0x72, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x13, 0x0a, 0x05, 0x62,
	0x72, 0x5f, 0x74, 0x6f, 0x18, 0x29, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x62, 0x72, 0x54, 0x6f,
	0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x70, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x78,
	0x63, 0x70, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x20, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65,
	0x78, 0x63, 0x70, 0x5f, 0x74, 0x6f, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6c, 0x61,
	0x73, 0x74, 0x45, 0x78, 0x63, 0x70, 0x54, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x5f, 0x37, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x37, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6b, 0x72, 0x75, 0x18,
	0x2d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6b, 0x72, 0x75, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x37, 0x61, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x37, 0x61, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x38, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x38, 0x12, 0x10, 0x0a, 0x03, 0x72,
	0x63, 0x78, 0x18, 0x30, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x63, 0x78, 0x12, 0x10, 0x0a,
	0x03, 0x72, 0x64, 0x78, 0x18, 0x31, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x64, 0x78, 0x12,
	0x10, 0x0a, 0x03, 0x72, 0x62, 0x78, 0x18, 0x32, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x62,
	0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x39, 0x18,
	0x33, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x39,
	0x12, 0x10, 0x0a, 0x03, 0x72, 0x62, 0x70, 0x18, 0x34, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72,
	0x62, 0x70, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x73, 0x69, 0x18, 0x35, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x03, 0x72, 0x73, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x64, 0x69, 0x18, 0x36, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x03, 0x72, 0x64, 0x69, 0x12, 0x0e, 0x0a, 0x02, 0x72, 0x38, 0x18, 0x37, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x02, 0x72, 0x38, 0x12, 0x0e, 0x0a, 0x02, 0x72, 0x39, 0x18, 0x38, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x02, 0x72, 0x39, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x31, 0x30, 0x18, 0x39, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x31, 0x30, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x31, 0x31, 0x18,
	0x3a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x31, 0x31, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x31,
	0x32, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x31, 0x32, 0x12, 0x10, 0x0a, 0x03,
	0x72, 0x31, 0x33, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x31, 0x33, 0x12, 0x10,
	0x0a, 0x03, 0x72, 0x31, 0x34, 0x18, 0x3d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72, 0x31, 0x34,
	0x12, 0x10, 0x0a, 0x03, 0x72, 0x31, 0x35, 0x18, 0x3e, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x72,
	0x31, 0x35, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x31,
	0x30, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x64, 0x31, 0x30, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x77, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x40, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x77, 0x45, 0x78, 0x69,
	0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0e, 0x73, 0x77, 0x5f, 0x65, 0x78, 0x69, 0x74,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x31, 0x18, 0x41, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73,
	0x77, 0x45, 0x78, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x31, 0x12, 0x23, 0x0a, 0x0e, 0x73, 0x77,
	0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x32, 0x18, 0x42, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0b, 0x73, 0x77, 0x45, 0x78, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x32, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x77, 0x5f, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x18, 0x43, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x09, 0x73, 0x77, 0x53, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x65, 0x76, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x44,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x65, 0x76, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x31, 0x31,
	0x18, 0x45, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x31, 0x31, 0x12, 0x12, 0x0a, 0x04, 0x78, 0x63, 0x72, 0x30, 0x18, 0x46, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x04, 0x78, 0x63, 0x72, 0x30, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f,
	0x62, 0x69, 0x74, 0x6d, 0x61, 0x70, 0x18, 0x47, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x42, 0x69, 0x74, 0x6d, 0x61, 0x70, 0x12, 0x22, 0x0a, 0x0d, 0x78, 0x38, 0x37,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x67, 0x70, 0x61, 0x18, 0x48, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x78, 0x38, 0x37, 0x53, 0x74, 0x61, 0x74, 0x65, 0x47, 0x70, 0x61, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x31, 0x32, 0x18, 0x49, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x31, 0x32, 0x42, 0x2e,
	0x5a, 0x2c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x67, 0x63, 0x65, 0x2d, 0x74, 0x63, 0x62, 0x2d, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x73, 0x65, 0x76, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sev_proto_rawDescOnce sync.Once
	file_sev_proto_rawDescData = file_sev_proto_rawDesc
)

func file_sev_proto_rawDescGZIP() []byte {
	file_sev_proto_rawDescOnce.Do(func() {
		file_sev_proto_rawDescData = protoimpl.X.CompressGZIP(file_sev_proto_rawDescData)
	})
	return file_sev_proto_rawDescData
}

var file_sev_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_sev_proto_goTypes = []interface{}{
	(*VmcbSeg)(nil),      // 0: sev_proto.VmcbSeg
	(*VmcbSaveArea)(nil), // 1: sev_proto.VmcbSaveArea
}
var file_sev_proto_depIdxs = []int32{
	0,  // 0: sev_proto.VmcbSaveArea.es:type_name -> sev_proto.VmcbSeg
	0,  // 1: sev_proto.VmcbSaveArea.cs:type_name -> sev_proto.VmcbSeg
	0,  // 2: sev_proto.VmcbSaveArea.ss:type_name -> sev_proto.VmcbSeg
	0,  // 3: sev_proto.VmcbSaveArea.ds:type_name -> sev_proto.VmcbSeg
	0,  // 4: sev_proto.VmcbSaveArea.fs:type_name -> sev_proto.VmcbSeg
	0,  // 5: sev_proto.VmcbSaveArea.gs:type_name -> sev_proto.VmcbSeg
	0,  // 6: sev_proto.VmcbSaveArea.gdtr:type_name -> sev_proto.VmcbSeg
	0,  // 7: sev_proto.VmcbSaveArea.ldtr:type_name -> sev_proto.VmcbSeg
	0,  // 8: sev_proto.VmcbSaveArea.idtr:type_name -> sev_proto.VmcbSeg
	0,  // 9: sev_proto.VmcbSaveArea.tr:type_name -> sev_proto.VmcbSeg
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_sev_proto_init() }
func file_sev_proto_init() {
	if File_sev_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sev_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmcbSeg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sev_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmcbSaveArea); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sev_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sev_proto_goTypes,
		DependencyIndexes: file_sev_proto_depIdxs,
		MessageInfos:      file_sev_proto_msgTypes,
	}.Build()
	File_sev_proto = out.File
	file_sev_proto_rawDesc = nil
	file_sev_proto_goTypes = nil
	file_sev_proto_depIdxs = nil
}
