// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/beyondcorp/clientgateways/v1/client_gateways_service.proto

package clientgatewayspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ClientGatewaysService_ListClientGateways_FullMethodName  = "/google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysService/ListClientGateways"
	ClientGatewaysService_GetClientGateway_FullMethodName    = "/google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysService/GetClientGateway"
	ClientGatewaysService_CreateClientGateway_FullMethodName = "/google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysService/CreateClientGateway"
	ClientGatewaysService_DeleteClientGateway_FullMethodName = "/google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysService/DeleteClientGateway"
)

// ClientGatewaysServiceClient is the client API for ClientGatewaysService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ClientGatewaysServiceClient interface {
	// Lists ClientGateways in a given project and location.
	ListClientGateways(ctx context.Context, in *ListClientGatewaysRequest, opts ...grpc.CallOption) (*ListClientGatewaysResponse, error)
	// Gets details of a single ClientGateway.
	GetClientGateway(ctx context.Context, in *GetClientGatewayRequest, opts ...grpc.CallOption) (*ClientGateway, error)
	// Creates a new ClientGateway in a given project and location.
	CreateClientGateway(ctx context.Context, in *CreateClientGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ClientGateway.
	DeleteClientGateway(ctx context.Context, in *DeleteClientGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type clientGatewaysServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClientGatewaysServiceClient(cc grpc.ClientConnInterface) ClientGatewaysServiceClient {
	return &clientGatewaysServiceClient{cc}
}

func (c *clientGatewaysServiceClient) ListClientGateways(ctx context.Context, in *ListClientGatewaysRequest, opts ...grpc.CallOption) (*ListClientGatewaysResponse, error) {
	out := new(ListClientGatewaysResponse)
	err := c.cc.Invoke(ctx, ClientGatewaysService_ListClientGateways_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientGatewaysServiceClient) GetClientGateway(ctx context.Context, in *GetClientGatewayRequest, opts ...grpc.CallOption) (*ClientGateway, error) {
	out := new(ClientGateway)
	err := c.cc.Invoke(ctx, ClientGatewaysService_GetClientGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientGatewaysServiceClient) CreateClientGateway(ctx context.Context, in *CreateClientGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClientGatewaysService_CreateClientGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientGatewaysServiceClient) DeleteClientGateway(ctx context.Context, in *DeleteClientGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClientGatewaysService_DeleteClientGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClientGatewaysServiceServer is the server API for ClientGatewaysService service.
// All implementations should embed UnimplementedClientGatewaysServiceServer
// for forward compatibility
type ClientGatewaysServiceServer interface {
	// Lists ClientGateways in a given project and location.
	ListClientGateways(context.Context, *ListClientGatewaysRequest) (*ListClientGatewaysResponse, error)
	// Gets details of a single ClientGateway.
	GetClientGateway(context.Context, *GetClientGatewayRequest) (*ClientGateway, error)
	// Creates a new ClientGateway in a given project and location.
	CreateClientGateway(context.Context, *CreateClientGatewayRequest) (*longrunningpb.Operation, error)
	// Deletes a single ClientGateway.
	DeleteClientGateway(context.Context, *DeleteClientGatewayRequest) (*longrunningpb.Operation, error)
}

// UnimplementedClientGatewaysServiceServer should be embedded to have forward compatible implementations.
type UnimplementedClientGatewaysServiceServer struct {
}

func (UnimplementedClientGatewaysServiceServer) ListClientGateways(context.Context, *ListClientGatewaysRequest) (*ListClientGatewaysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClientGateways not implemented")
}
func (UnimplementedClientGatewaysServiceServer) GetClientGateway(context.Context, *GetClientGatewayRequest) (*ClientGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClientGateway not implemented")
}
func (UnimplementedClientGatewaysServiceServer) CreateClientGateway(context.Context, *CreateClientGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientGateway not implemented")
}
func (UnimplementedClientGatewaysServiceServer) DeleteClientGateway(context.Context, *DeleteClientGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClientGateway not implemented")
}

// UnsafeClientGatewaysServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClientGatewaysServiceServer will
// result in compilation errors.
type UnsafeClientGatewaysServiceServer interface {
	mustEmbedUnimplementedClientGatewaysServiceServer()
}

func RegisterClientGatewaysServiceServer(s grpc.ServiceRegistrar, srv ClientGatewaysServiceServer) {
	s.RegisterService(&ClientGatewaysService_ServiceDesc, srv)
}

func _ClientGatewaysService_ListClientGateways_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClientGatewaysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientGatewaysServiceServer).ListClientGateways(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientGatewaysService_ListClientGateways_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientGatewaysServiceServer).ListClientGateways(ctx, req.(*ListClientGatewaysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientGatewaysService_GetClientGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClientGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientGatewaysServiceServer).GetClientGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientGatewaysService_GetClientGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientGatewaysServiceServer).GetClientGateway(ctx, req.(*GetClientGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientGatewaysService_CreateClientGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientGatewaysServiceServer).CreateClientGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientGatewaysService_CreateClientGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientGatewaysServiceServer).CreateClientGateway(ctx, req.(*CreateClientGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientGatewaysService_DeleteClientGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientGatewaysServiceServer).DeleteClientGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClientGatewaysService_DeleteClientGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientGatewaysServiceServer).DeleteClientGateway(ctx, req.(*DeleteClientGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ClientGatewaysService_ServiceDesc is the grpc.ServiceDesc for ClientGatewaysService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClientGatewaysService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysService",
	HandlerType: (*ClientGatewaysServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClientGateways",
			Handler:    _ClientGatewaysService_ListClientGateways_Handler,
		},
		{
			MethodName: "GetClientGateway",
			Handler:    _ClientGatewaysService_GetClientGateway_Handler,
		},
		{
			MethodName: "CreateClientGateway",
			Handler:    _ClientGatewaysService_CreateClientGateway_Handler,
		},
		{
			MethodName: "DeleteClientGateway",
			Handler:    _ClientGatewaysService_DeleteClientGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/clientgateways/v1/client_gateways_service.proto",
}
