// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

package analyticshubpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AnalyticsHubService_ListDataExchanges_FullMethodName               = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListDataExchanges"
	AnalyticsHubService_ListOrgDataExchanges_FullMethodName            = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListOrgDataExchanges"
	AnalyticsHubService_GetDataExchange_FullMethodName                 = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetDataExchange"
	AnalyticsHubService_CreateDataExchange_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateDataExchange"
	AnalyticsHubService_UpdateDataExchange_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateDataExchange"
	AnalyticsHubService_DeleteDataExchange_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteDataExchange"
	AnalyticsHubService_ListListings_FullMethodName                    = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListListings"
	AnalyticsHubService_GetListing_FullMethodName                      = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetListing"
	AnalyticsHubService_CreateListing_FullMethodName                   = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateListing"
	AnalyticsHubService_UpdateListing_FullMethodName                   = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateListing"
	AnalyticsHubService_DeleteListing_FullMethodName                   = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteListing"
	AnalyticsHubService_SubscribeListing_FullMethodName                = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeListing"
	AnalyticsHubService_SubscribeDataExchange_FullMethodName           = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeDataExchange"
	AnalyticsHubService_RefreshSubscription_FullMethodName             = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RefreshSubscription"
	AnalyticsHubService_GetSubscription_FullMethodName                 = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetSubscription"
	AnalyticsHubService_ListSubscriptions_FullMethodName               = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSubscriptions"
	AnalyticsHubService_ListSharedResourceSubscriptions_FullMethodName = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSharedResourceSubscriptions"
	AnalyticsHubService_RevokeSubscription_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RevokeSubscription"
	AnalyticsHubService_DeleteSubscription_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteSubscription"
	AnalyticsHubService_GetIamPolicy_FullMethodName                    = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetIamPolicy"
	AnalyticsHubService_SetIamPolicy_FullMethodName                    = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SetIamPolicy"
	AnalyticsHubService_TestIamPermissions_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/TestIamPermissions"
	AnalyticsHubService_CreateQueryTemplate_FullMethodName             = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateQueryTemplate"
	AnalyticsHubService_GetQueryTemplate_FullMethodName                = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetQueryTemplate"
	AnalyticsHubService_ListQueryTemplates_FullMethodName              = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListQueryTemplates"
	AnalyticsHubService_UpdateQueryTemplate_FullMethodName             = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateQueryTemplate"
	AnalyticsHubService_DeleteQueryTemplate_FullMethodName             = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteQueryTemplate"
	AnalyticsHubService_SubmitQueryTemplate_FullMethodName             = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubmitQueryTemplate"
	AnalyticsHubService_ApproveQueryTemplate_FullMethodName            = "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ApproveQueryTemplate"
)

// AnalyticsHubServiceClient is the client API for AnalyticsHubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AnalyticsHubServiceClient interface {
	// Lists all data exchanges in a given project and location.
	ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error)
	// Lists all data exchanges from projects in a given organization and
	// location.
	ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error)
	// Gets the details of a data exchange.
	GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Creates a new data exchange.
	CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Updates an existing data exchange.
	UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Deletes an existing data exchange.
	DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all listings in a given project and location.
	ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error)
	// Gets the details of a listing.
	GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Creates a new listing.
	CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Updates an existing listing.
	UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Deletes a listing.
	DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Subscribes to a listing.
	//
	// Currently, with Analytics Hub, you can create listings that
	// reference only BigQuery datasets.
	// Upon subscription to a listing for a BigQuery dataset, Analytics Hub
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error)
	// Creates a Subscription to a Data Clean Room. This is a
	// long-running operation as it will create one or more linked datasets.
	// Throws a Bad Request error if the Data Exchange does not contain any
	// listings.
	SubscribeDataExchange(ctx context.Context, in *SubscribeDataExchangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Refreshes a Subscription to a Data Exchange. A Data Exchange can become
	// stale when a publisher adds or removes data. This is a long-running
	// operation as it may create many linked datasets.
	RefreshSubscription(ctx context.Context, in *RefreshSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of a Subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists all subscriptions in a given project and location.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Lists all subscriptions on a given Data Exchange or Listing.
	ListSharedResourceSubscriptions(ctx context.Context, in *ListSharedResourceSubscriptionsRequest, opts ...grpc.CallOption) (*ListSharedResourceSubscriptionsResponse, error)
	// Revokes a given subscription.
	RevokeSubscription(ctx context.Context, in *RevokeSubscriptionRequest, opts ...grpc.CallOption) (*RevokeSubscriptionResponse, error)
	// Deletes a subscription.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the IAM policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new QueryTemplate
	CreateQueryTemplate(ctx context.Context, in *CreateQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error)
	// Gets a QueryTemplate
	GetQueryTemplate(ctx context.Context, in *GetQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error)
	// Lists all QueryTemplates in a given project and location.
	ListQueryTemplates(ctx context.Context, in *ListQueryTemplatesRequest, opts ...grpc.CallOption) (*ListQueryTemplatesResponse, error)
	// Updates an existing QueryTemplate
	UpdateQueryTemplate(ctx context.Context, in *UpdateQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error)
	// Deletes a query template.
	DeleteQueryTemplate(ctx context.Context, in *DeleteQueryTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Submits a query template for approval.
	SubmitQueryTemplate(ctx context.Context, in *SubmitQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error)
	// Approves a query template.
	ApproveQueryTemplate(ctx context.Context, in *ApproveQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error)
}

type analyticsHubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsHubServiceClient(cc grpc.ClientConnInterface) AnalyticsHubServiceClient {
	return &analyticsHubServiceClient{cc}
}

func (c *analyticsHubServiceClient) ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error) {
	out := new(ListDataExchangesResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListDataExchanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error) {
	out := new(ListOrgDataExchangesResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListOrgDataExchanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, AnalyticsHubService_GetDataExchange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, AnalyticsHubService_CreateDataExchange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, AnalyticsHubService_UpdateDataExchange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsHubService_DeleteDataExchange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error) {
	out := new(ListListingsResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListListings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, AnalyticsHubService_GetListing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, AnalyticsHubService_CreateListing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, AnalyticsHubService_UpdateListing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsHubService_DeleteListing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error) {
	out := new(SubscribeListingResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_SubscribeListing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubscribeDataExchange(ctx context.Context, in *SubscribeDataExchangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AnalyticsHubService_SubscribeDataExchange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) RefreshSubscription(ctx context.Context, in *RefreshSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AnalyticsHubService_RefreshSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, AnalyticsHubService_GetSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListSubscriptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListSharedResourceSubscriptions(ctx context.Context, in *ListSharedResourceSubscriptionsRequest, opts ...grpc.CallOption) (*ListSharedResourceSubscriptionsResponse, error) {
	out := new(ListSharedResourceSubscriptionsResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListSharedResourceSubscriptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) RevokeSubscription(ctx context.Context, in *RevokeSubscriptionRequest, opts ...grpc.CallOption) (*RevokeSubscriptionResponse, error) {
	out := new(RevokeSubscriptionResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_RevokeSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AnalyticsHubService_DeleteSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, AnalyticsHubService_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, AnalyticsHubService_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateQueryTemplate(ctx context.Context, in *CreateQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error) {
	out := new(QueryTemplate)
	err := c.cc.Invoke(ctx, AnalyticsHubService_CreateQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetQueryTemplate(ctx context.Context, in *GetQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error) {
	out := new(QueryTemplate)
	err := c.cc.Invoke(ctx, AnalyticsHubService_GetQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListQueryTemplates(ctx context.Context, in *ListQueryTemplatesRequest, opts ...grpc.CallOption) (*ListQueryTemplatesResponse, error) {
	out := new(ListQueryTemplatesResponse)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ListQueryTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateQueryTemplate(ctx context.Context, in *UpdateQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error) {
	out := new(QueryTemplate)
	err := c.cc.Invoke(ctx, AnalyticsHubService_UpdateQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteQueryTemplate(ctx context.Context, in *DeleteQueryTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsHubService_DeleteQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubmitQueryTemplate(ctx context.Context, in *SubmitQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error) {
	out := new(QueryTemplate)
	err := c.cc.Invoke(ctx, AnalyticsHubService_SubmitQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ApproveQueryTemplate(ctx context.Context, in *ApproveQueryTemplateRequest, opts ...grpc.CallOption) (*QueryTemplate, error) {
	out := new(QueryTemplate)
	err := c.cc.Invoke(ctx, AnalyticsHubService_ApproveQueryTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsHubServiceServer is the server API for AnalyticsHubService service.
// All implementations should embed UnimplementedAnalyticsHubServiceServer
// for forward compatibility
type AnalyticsHubServiceServer interface {
	// Lists all data exchanges in a given project and location.
	ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error)
	// Lists all data exchanges from projects in a given organization and
	// location.
	ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error)
	// Gets the details of a data exchange.
	GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error)
	// Creates a new data exchange.
	CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error)
	// Updates an existing data exchange.
	UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error)
	// Deletes an existing data exchange.
	DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error)
	// Lists all listings in a given project and location.
	ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error)
	// Gets the details of a listing.
	GetListing(context.Context, *GetListingRequest) (*Listing, error)
	// Creates a new listing.
	CreateListing(context.Context, *CreateListingRequest) (*Listing, error)
	// Updates an existing listing.
	UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error)
	// Deletes a listing.
	DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error)
	// Subscribes to a listing.
	//
	// Currently, with Analytics Hub, you can create listings that
	// reference only BigQuery datasets.
	// Upon subscription to a listing for a BigQuery dataset, Analytics Hub
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error)
	// Creates a Subscription to a Data Clean Room. This is a
	// long-running operation as it will create one or more linked datasets.
	// Throws a Bad Request error if the Data Exchange does not contain any
	// listings.
	SubscribeDataExchange(context.Context, *SubscribeDataExchangeRequest) (*longrunningpb.Operation, error)
	// Refreshes a Subscription to a Data Exchange. A Data Exchange can become
	// stale when a publisher adds or removes data. This is a long-running
	// operation as it may create many linked datasets.
	RefreshSubscription(context.Context, *RefreshSubscriptionRequest) (*longrunningpb.Operation, error)
	// Gets the details of a Subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists all subscriptions in a given project and location.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Lists all subscriptions on a given Data Exchange or Listing.
	ListSharedResourceSubscriptions(context.Context, *ListSharedResourceSubscriptionsRequest) (*ListSharedResourceSubscriptionsResponse, error)
	// Revokes a given subscription.
	RevokeSubscription(context.Context, *RevokeSubscriptionRequest) (*RevokeSubscriptionResponse, error)
	// Deletes a subscription.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*longrunningpb.Operation, error)
	// Gets the IAM policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new QueryTemplate
	CreateQueryTemplate(context.Context, *CreateQueryTemplateRequest) (*QueryTemplate, error)
	// Gets a QueryTemplate
	GetQueryTemplate(context.Context, *GetQueryTemplateRequest) (*QueryTemplate, error)
	// Lists all QueryTemplates in a given project and location.
	ListQueryTemplates(context.Context, *ListQueryTemplatesRequest) (*ListQueryTemplatesResponse, error)
	// Updates an existing QueryTemplate
	UpdateQueryTemplate(context.Context, *UpdateQueryTemplateRequest) (*QueryTemplate, error)
	// Deletes a query template.
	DeleteQueryTemplate(context.Context, *DeleteQueryTemplateRequest) (*emptypb.Empty, error)
	// Submits a query template for approval.
	SubmitQueryTemplate(context.Context, *SubmitQueryTemplateRequest) (*QueryTemplate, error)
	// Approves a query template.
	ApproveQueryTemplate(context.Context, *ApproveQueryTemplateRequest) (*QueryTemplate, error)
}

// UnimplementedAnalyticsHubServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAnalyticsHubServiceServer struct {
}

func (UnimplementedAnalyticsHubServiceServer) ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataExchanges not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrgDataExchanges not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataExchange not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataExchange not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataExchange not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataExchange not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListListings not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) GetListing(context.Context, *GetListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListing not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) CreateListing(context.Context, *CreateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateListing not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateListing not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteListing not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeListing not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) SubscribeDataExchange(context.Context, *SubscribeDataExchangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeDataExchange not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) RefreshSubscription(context.Context, *RefreshSubscriptionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshSubscription not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscription not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ListSharedResourceSubscriptions(context.Context, *ListSharedResourceSubscriptionsRequest) (*ListSharedResourceSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSharedResourceSubscriptions not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) RevokeSubscription(context.Context, *RevokeSubscriptionRequest) (*RevokeSubscriptionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeSubscription not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) CreateQueryTemplate(context.Context, *CreateQueryTemplateRequest) (*QueryTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQueryTemplate not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) GetQueryTemplate(context.Context, *GetQueryTemplateRequest) (*QueryTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQueryTemplate not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ListQueryTemplates(context.Context, *ListQueryTemplatesRequest) (*ListQueryTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQueryTemplates not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) UpdateQueryTemplate(context.Context, *UpdateQueryTemplateRequest) (*QueryTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQueryTemplate not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) DeleteQueryTemplate(context.Context, *DeleteQueryTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQueryTemplate not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) SubmitQueryTemplate(context.Context, *SubmitQueryTemplateRequest) (*QueryTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitQueryTemplate not implemented")
}
func (UnimplementedAnalyticsHubServiceServer) ApproveQueryTemplate(context.Context, *ApproveQueryTemplateRequest) (*QueryTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveQueryTemplate not implemented")
}

// UnsafeAnalyticsHubServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AnalyticsHubServiceServer will
// result in compilation errors.
type UnsafeAnalyticsHubServiceServer interface {
	mustEmbedUnimplementedAnalyticsHubServiceServer()
}

func RegisterAnalyticsHubServiceServer(s grpc.ServiceRegistrar, srv AnalyticsHubServiceServer) {
	s.RegisterService(&AnalyticsHubService_ServiceDesc, srv)
}

func _AnalyticsHubService_ListDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListDataExchanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, req.(*ListDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListOrgDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrgDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListOrgDataExchanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, req.(*ListOrgDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_GetDataExchange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, req.(*GetDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_CreateDataExchange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, req.(*CreateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_UpdateDataExchange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, req.(*UpdateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_DeleteDataExchange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, req.(*DeleteDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListListings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListListingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListListings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, req.(*ListListingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_GetListing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, req.(*GetListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_CreateListing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, req.(*CreateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_UpdateListing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, req.(*UpdateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_DeleteListing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, req.(*DeleteListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubscribeListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_SubscribeListing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, req.(*SubscribeListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubscribeDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubscribeDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_SubscribeDataExchange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubscribeDataExchange(ctx, req.(*SubscribeDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_RefreshSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).RefreshSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_RefreshSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).RefreshSubscription(ctx, req.(*RefreshSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_GetSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListSubscriptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListSharedResourceSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSharedResourceSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListSharedResourceSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListSharedResourceSubscriptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListSharedResourceSubscriptions(ctx, req.(*ListSharedResourceSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_RevokeSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).RevokeSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_RevokeSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).RevokeSubscription(ctx, req.(*RevokeSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_DeleteSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_CreateQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateQueryTemplate(ctx, req.(*CreateQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_GetQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetQueryTemplate(ctx, req.(*GetQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListQueryTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQueryTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListQueryTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ListQueryTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListQueryTemplates(ctx, req.(*ListQueryTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_UpdateQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateQueryTemplate(ctx, req.(*UpdateQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_DeleteQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteQueryTemplate(ctx, req.(*DeleteQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubmitQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubmitQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_SubmitQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubmitQueryTemplate(ctx, req.(*SubmitQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ApproveQueryTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveQueryTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ApproveQueryTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsHubService_ApproveQueryTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ApproveQueryTemplate(ctx, req.(*ApproveQueryTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AnalyticsHubService_ServiceDesc is the grpc.ServiceDesc for AnalyticsHubService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AnalyticsHubService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
	HandlerType: (*AnalyticsHubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDataExchanges",
			Handler:    _AnalyticsHubService_ListDataExchanges_Handler,
		},
		{
			MethodName: "ListOrgDataExchanges",
			Handler:    _AnalyticsHubService_ListOrgDataExchanges_Handler,
		},
		{
			MethodName: "GetDataExchange",
			Handler:    _AnalyticsHubService_GetDataExchange_Handler,
		},
		{
			MethodName: "CreateDataExchange",
			Handler:    _AnalyticsHubService_CreateDataExchange_Handler,
		},
		{
			MethodName: "UpdateDataExchange",
			Handler:    _AnalyticsHubService_UpdateDataExchange_Handler,
		},
		{
			MethodName: "DeleteDataExchange",
			Handler:    _AnalyticsHubService_DeleteDataExchange_Handler,
		},
		{
			MethodName: "ListListings",
			Handler:    _AnalyticsHubService_ListListings_Handler,
		},
		{
			MethodName: "GetListing",
			Handler:    _AnalyticsHubService_GetListing_Handler,
		},
		{
			MethodName: "CreateListing",
			Handler:    _AnalyticsHubService_CreateListing_Handler,
		},
		{
			MethodName: "UpdateListing",
			Handler:    _AnalyticsHubService_UpdateListing_Handler,
		},
		{
			MethodName: "DeleteListing",
			Handler:    _AnalyticsHubService_DeleteListing_Handler,
		},
		{
			MethodName: "SubscribeListing",
			Handler:    _AnalyticsHubService_SubscribeListing_Handler,
		},
		{
			MethodName: "SubscribeDataExchange",
			Handler:    _AnalyticsHubService_SubscribeDataExchange_Handler,
		},
		{
			MethodName: "RefreshSubscription",
			Handler:    _AnalyticsHubService_RefreshSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _AnalyticsHubService_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _AnalyticsHubService_ListSubscriptions_Handler,
		},
		{
			MethodName: "ListSharedResourceSubscriptions",
			Handler:    _AnalyticsHubService_ListSharedResourceSubscriptions_Handler,
		},
		{
			MethodName: "RevokeSubscription",
			Handler:    _AnalyticsHubService_RevokeSubscription_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _AnalyticsHubService_DeleteSubscription_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _AnalyticsHubService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _AnalyticsHubService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _AnalyticsHubService_TestIamPermissions_Handler,
		},
		{
			MethodName: "CreateQueryTemplate",
			Handler:    _AnalyticsHubService_CreateQueryTemplate_Handler,
		},
		{
			MethodName: "GetQueryTemplate",
			Handler:    _AnalyticsHubService_GetQueryTemplate_Handler,
		},
		{
			MethodName: "ListQueryTemplates",
			Handler:    _AnalyticsHubService_ListQueryTemplates_Handler,
		},
		{
			MethodName: "UpdateQueryTemplate",
			Handler:    _AnalyticsHubService_UpdateQueryTemplate_Handler,
		},
		{
			MethodName: "DeleteQueryTemplate",
			Handler:    _AnalyticsHubService_DeleteQueryTemplate_Handler,
		},
		{
			MethodName: "SubmitQueryTemplate",
			Handler:    _AnalyticsHubService_SubmitQueryTemplate_Handler,
		},
		{
			MethodName: "ApproveQueryTemplate",
			Handler:    _AnalyticsHubService_ApproveQueryTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/analyticshub/v1/analyticshub.proto",
}
