// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Speech API
//
// The OCI Speech Service harnesses the power of spoken language by allowing developers to easily convert file-based data containing human speech into highly accurate text transcriptions.
//

package aispeech

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// EntityList List of entities of a given type, to be used to train a customization.
// Note: If multiple EntityLists are provided, a separate Customization resource will be created for each EntityList.
type EntityList struct {

	// Entity Type
	EntityType *string `mandatory:"true" json:"entityType"`

	// Alias of existing customization or to associate with new customization created from entityList.
	Alias *string `mandatory:"false" json:"alias"`

	// Entity type OCID
	Id *string `mandatory:"false" json:"id"`

	// List of entities such as names, words or phrases matching the given entityType to add recognition support for
	Entities []Entity `mandatory:"false" json:"entities"`
}

func (m EntityList) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m EntityList) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
