// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package networksecurity provides access to the Network Security API.
//
// For product documentation, see: https://cloud.google.com/networking
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/networksecurity/v1"
//	...
//	ctx := context.Background()
//	networksecurityService, err := networksecurity.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	networksecurityService, err := networksecurity.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	networksecurityService, err := networksecurity.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package networksecurity // import "google.golang.org/api/networksecurity/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "networksecurity:v1"
const apiName = "networksecurity"
const apiVersion = "v1"
const basePath = "https://networksecurity.googleapis.com/"
const basePathTemplate = "https://networksecurity.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://networksecurity.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.AddressGroups = NewOrganizationsLocationsAddressGroupsService(s)
	rs.FirewallEndpoints = NewOrganizationsLocationsFirewallEndpointsService(s)
	rs.Operations = NewOrganizationsLocationsOperationsService(s)
	rs.SecurityProfileGroups = NewOrganizationsLocationsSecurityProfileGroupsService(s)
	rs.SecurityProfiles = NewOrganizationsLocationsSecurityProfilesService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	AddressGroups *OrganizationsLocationsAddressGroupsService

	FirewallEndpoints *OrganizationsLocationsFirewallEndpointsService

	Operations *OrganizationsLocationsOperationsService

	SecurityProfileGroups *OrganizationsLocationsSecurityProfileGroupsService

	SecurityProfiles *OrganizationsLocationsSecurityProfilesService
}

func NewOrganizationsLocationsAddressGroupsService(s *Service) *OrganizationsLocationsAddressGroupsService {
	rs := &OrganizationsLocationsAddressGroupsService{s: s}
	return rs
}

type OrganizationsLocationsAddressGroupsService struct {
	s *Service
}

func NewOrganizationsLocationsFirewallEndpointsService(s *Service) *OrganizationsLocationsFirewallEndpointsService {
	rs := &OrganizationsLocationsFirewallEndpointsService{s: s}
	return rs
}

type OrganizationsLocationsFirewallEndpointsService struct {
	s *Service
}

func NewOrganizationsLocationsOperationsService(s *Service) *OrganizationsLocationsOperationsService {
	rs := &OrganizationsLocationsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsSecurityProfileGroupsService(s *Service) *OrganizationsLocationsSecurityProfileGroupsService {
	rs := &OrganizationsLocationsSecurityProfileGroupsService{s: s}
	return rs
}

type OrganizationsLocationsSecurityProfileGroupsService struct {
	s *Service
}

func NewOrganizationsLocationsSecurityProfilesService(s *Service) *OrganizationsLocationsSecurityProfilesService {
	rs := &OrganizationsLocationsSecurityProfilesService{s: s}
	return rs
}

type OrganizationsLocationsSecurityProfilesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AddressGroups = NewProjectsLocationsAddressGroupsService(s)
	rs.AuthorizationPolicies = NewProjectsLocationsAuthorizationPoliciesService(s)
	rs.AuthzPolicies = NewProjectsLocationsAuthzPoliciesService(s)
	rs.BackendAuthenticationConfigs = NewProjectsLocationsBackendAuthenticationConfigsService(s)
	rs.ClientTlsPolicies = NewProjectsLocationsClientTlsPoliciesService(s)
	rs.FirewallEndpointAssociations = NewProjectsLocationsFirewallEndpointAssociationsService(s)
	rs.GatewaySecurityPolicies = NewProjectsLocationsGatewaySecurityPoliciesService(s)
	rs.InterceptDeploymentGroups = NewProjectsLocationsInterceptDeploymentGroupsService(s)
	rs.InterceptDeployments = NewProjectsLocationsInterceptDeploymentsService(s)
	rs.InterceptEndpointGroupAssociations = NewProjectsLocationsInterceptEndpointGroupAssociationsService(s)
	rs.InterceptEndpointGroups = NewProjectsLocationsInterceptEndpointGroupsService(s)
	rs.MirroringDeploymentGroups = NewProjectsLocationsMirroringDeploymentGroupsService(s)
	rs.MirroringDeployments = NewProjectsLocationsMirroringDeploymentsService(s)
	rs.MirroringEndpointGroupAssociations = NewProjectsLocationsMirroringEndpointGroupAssociationsService(s)
	rs.MirroringEndpointGroups = NewProjectsLocationsMirroringEndpointGroupsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.ServerTlsPolicies = NewProjectsLocationsServerTlsPoliciesService(s)
	rs.TlsInspectionPolicies = NewProjectsLocationsTlsInspectionPoliciesService(s)
	rs.UrlLists = NewProjectsLocationsUrlListsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AddressGroups *ProjectsLocationsAddressGroupsService

	AuthorizationPolicies *ProjectsLocationsAuthorizationPoliciesService

	AuthzPolicies *ProjectsLocationsAuthzPoliciesService

	BackendAuthenticationConfigs *ProjectsLocationsBackendAuthenticationConfigsService

	ClientTlsPolicies *ProjectsLocationsClientTlsPoliciesService

	FirewallEndpointAssociations *ProjectsLocationsFirewallEndpointAssociationsService

	GatewaySecurityPolicies *ProjectsLocationsGatewaySecurityPoliciesService

	InterceptDeploymentGroups *ProjectsLocationsInterceptDeploymentGroupsService

	InterceptDeployments *ProjectsLocationsInterceptDeploymentsService

	InterceptEndpointGroupAssociations *ProjectsLocationsInterceptEndpointGroupAssociationsService

	InterceptEndpointGroups *ProjectsLocationsInterceptEndpointGroupsService

	MirroringDeploymentGroups *ProjectsLocationsMirroringDeploymentGroupsService

	MirroringDeployments *ProjectsLocationsMirroringDeploymentsService

	MirroringEndpointGroupAssociations *ProjectsLocationsMirroringEndpointGroupAssociationsService

	MirroringEndpointGroups *ProjectsLocationsMirroringEndpointGroupsService

	Operations *ProjectsLocationsOperationsService

	ServerTlsPolicies *ProjectsLocationsServerTlsPoliciesService

	TlsInspectionPolicies *ProjectsLocationsTlsInspectionPoliciesService

	UrlLists *ProjectsLocationsUrlListsService
}

func NewProjectsLocationsAddressGroupsService(s *Service) *ProjectsLocationsAddressGroupsService {
	rs := &ProjectsLocationsAddressGroupsService{s: s}
	return rs
}

type ProjectsLocationsAddressGroupsService struct {
	s *Service
}

func NewProjectsLocationsAuthorizationPoliciesService(s *Service) *ProjectsLocationsAuthorizationPoliciesService {
	rs := &ProjectsLocationsAuthorizationPoliciesService{s: s}
	return rs
}

type ProjectsLocationsAuthorizationPoliciesService struct {
	s *Service
}

func NewProjectsLocationsAuthzPoliciesService(s *Service) *ProjectsLocationsAuthzPoliciesService {
	rs := &ProjectsLocationsAuthzPoliciesService{s: s}
	return rs
}

type ProjectsLocationsAuthzPoliciesService struct {
	s *Service
}

func NewProjectsLocationsBackendAuthenticationConfigsService(s *Service) *ProjectsLocationsBackendAuthenticationConfigsService {
	rs := &ProjectsLocationsBackendAuthenticationConfigsService{s: s}
	return rs
}

type ProjectsLocationsBackendAuthenticationConfigsService struct {
	s *Service
}

func NewProjectsLocationsClientTlsPoliciesService(s *Service) *ProjectsLocationsClientTlsPoliciesService {
	rs := &ProjectsLocationsClientTlsPoliciesService{s: s}
	return rs
}

type ProjectsLocationsClientTlsPoliciesService struct {
	s *Service
}

func NewProjectsLocationsFirewallEndpointAssociationsService(s *Service) *ProjectsLocationsFirewallEndpointAssociationsService {
	rs := &ProjectsLocationsFirewallEndpointAssociationsService{s: s}
	return rs
}

type ProjectsLocationsFirewallEndpointAssociationsService struct {
	s *Service
}

func NewProjectsLocationsGatewaySecurityPoliciesService(s *Service) *ProjectsLocationsGatewaySecurityPoliciesService {
	rs := &ProjectsLocationsGatewaySecurityPoliciesService{s: s}
	rs.Rules = NewProjectsLocationsGatewaySecurityPoliciesRulesService(s)
	return rs
}

type ProjectsLocationsGatewaySecurityPoliciesService struct {
	s *Service

	Rules *ProjectsLocationsGatewaySecurityPoliciesRulesService
}

func NewProjectsLocationsGatewaySecurityPoliciesRulesService(s *Service) *ProjectsLocationsGatewaySecurityPoliciesRulesService {
	rs := &ProjectsLocationsGatewaySecurityPoliciesRulesService{s: s}
	return rs
}

type ProjectsLocationsGatewaySecurityPoliciesRulesService struct {
	s *Service
}

func NewProjectsLocationsInterceptDeploymentGroupsService(s *Service) *ProjectsLocationsInterceptDeploymentGroupsService {
	rs := &ProjectsLocationsInterceptDeploymentGroupsService{s: s}
	return rs
}

type ProjectsLocationsInterceptDeploymentGroupsService struct {
	s *Service
}

func NewProjectsLocationsInterceptDeploymentsService(s *Service) *ProjectsLocationsInterceptDeploymentsService {
	rs := &ProjectsLocationsInterceptDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsInterceptDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsInterceptEndpointGroupAssociationsService(s *Service) *ProjectsLocationsInterceptEndpointGroupAssociationsService {
	rs := &ProjectsLocationsInterceptEndpointGroupAssociationsService{s: s}
	return rs
}

type ProjectsLocationsInterceptEndpointGroupAssociationsService struct {
	s *Service
}

func NewProjectsLocationsInterceptEndpointGroupsService(s *Service) *ProjectsLocationsInterceptEndpointGroupsService {
	rs := &ProjectsLocationsInterceptEndpointGroupsService{s: s}
	return rs
}

type ProjectsLocationsInterceptEndpointGroupsService struct {
	s *Service
}

func NewProjectsLocationsMirroringDeploymentGroupsService(s *Service) *ProjectsLocationsMirroringDeploymentGroupsService {
	rs := &ProjectsLocationsMirroringDeploymentGroupsService{s: s}
	return rs
}

type ProjectsLocationsMirroringDeploymentGroupsService struct {
	s *Service
}

func NewProjectsLocationsMirroringDeploymentsService(s *Service) *ProjectsLocationsMirroringDeploymentsService {
	rs := &ProjectsLocationsMirroringDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsMirroringDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsMirroringEndpointGroupAssociationsService(s *Service) *ProjectsLocationsMirroringEndpointGroupAssociationsService {
	rs := &ProjectsLocationsMirroringEndpointGroupAssociationsService{s: s}
	return rs
}

type ProjectsLocationsMirroringEndpointGroupAssociationsService struct {
	s *Service
}

func NewProjectsLocationsMirroringEndpointGroupsService(s *Service) *ProjectsLocationsMirroringEndpointGroupsService {
	rs := &ProjectsLocationsMirroringEndpointGroupsService{s: s}
	return rs
}

type ProjectsLocationsMirroringEndpointGroupsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsServerTlsPoliciesService(s *Service) *ProjectsLocationsServerTlsPoliciesService {
	rs := &ProjectsLocationsServerTlsPoliciesService{s: s}
	return rs
}

type ProjectsLocationsServerTlsPoliciesService struct {
	s *Service
}

func NewProjectsLocationsTlsInspectionPoliciesService(s *Service) *ProjectsLocationsTlsInspectionPoliciesService {
	rs := &ProjectsLocationsTlsInspectionPoliciesService{s: s}
	return rs
}

type ProjectsLocationsTlsInspectionPoliciesService struct {
	s *Service
}

func NewProjectsLocationsUrlListsService(s *Service) *ProjectsLocationsUrlListsService {
	rs := &ProjectsLocationsUrlListsService{s: s}
	return rs
}

type ProjectsLocationsUrlListsService struct {
	s *Service
}

// AddAddressGroupItemsRequest: Request used by the AddAddressGroupItems
// method.
type AddAddressGroupItemsRequest struct {
	// Items: Required. List of items to add.
	Items []string `json:"items,omitempty"`
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddAddressGroupItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddAddressGroupItemsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddressGroup: AddressGroup is a resource that specifies how a collection of
// IP/DNS used in Firewall Policy.
type AddressGroup struct {
	// Capacity: Required. Capacity of the Address Group
	Capacity int64 `json:"capacity,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Items: Optional. List of items.
	Items []string `json:"items,omitempty"`
	// Labels: Optional. Set of label tags associated with the AddressGroup
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Name of the AddressGroup resource. It matches pattern
	// `projects/*/locations/{location}/addressGroups/`.
	Name string `json:"name,omitempty"`
	// Purpose: Optional. List of supported purposes of the Address Group.
	//
	// Possible values:
	//   "PURPOSE_UNSPECIFIED" - Default value. Should never happen.
	//   "DEFAULT" - Address Group is distributed to VMC, and is usable in Firewall
	// Policies and other systems that rely on VMC.
	//   "CLOUD_ARMOR" - Address Group is usable in Cloud Armor.
	Purpose []string `json:"purpose,omitempty"`
	// SelfLink: Output only. Server-defined fully-qualified URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// Type: Required. The type of the Address Group. Possible values are "IPv4" or
	// "IPV6".
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value.
	//   "IPV4" - IP v4 ranges.
	//   "IPV6" - IP v6 ranges.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Capacity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Capacity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddressGroup) MarshalJSON() ([]byte, error) {
	type NoMethod AddressGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AntivirusOverride: Defines what action to take for antivirus threats per
// protocol.
type AntivirusOverride struct {
	// Action: Required. Threat action override. For some threat types, only a
	// subset of actions applies.
	//
	// Possible values:
	//   "THREAT_ACTION_UNSPECIFIED" - Threat action not specified.
	//   "DEFAULT_ACTION" - The default action (as specified by the vendor) is
	// taken.
	//   "ALLOW" - The packet matching this rule will be allowed to transmit.
	//   "ALERT" - The packet matching this rule will be allowed to transmit, but a
	// threat_log entry will be sent to the consumer project.
	//   "DENY" - The packet matching this rule will be dropped, and a threat_log
	// entry will be sent to the consumer project.
	Action string `json:"action,omitempty"`
	// Protocol: Required. Protocol to match.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Protocol not specified.
	//   "SMTP" - SMTP protocol
	//   "SMB" - SMB protocol
	//   "POP3" - POP3 protocol
	//   "IMAP" - IMAP protocol
	//   "HTTP2" - HTTP2 protocol
	//   "HTTP" - HTTP protocol
	//   "FTP" - FTP protocol
	Protocol string `json:"protocol,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AntivirusOverride) MarshalJSON() ([]byte, error) {
	type NoMethod AntivirusOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthorizationPolicy: AuthorizationPolicy is a resource that specifies how a
// server should authorize incoming connections. This resource in itself does
// not change the configuration unless it's attached to a target https proxy or
// endpoint config selector resource.
type AuthorizationPolicy struct {
	// Action: Required. The action to take when a rule match is found. Possible
	// values are "ALLOW" or "DENY".
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - Default value.
	//   "ALLOW" - Grant access.
	//   "DENY" - Deny access. Deny rules should be avoided unless they are used to
	// provide a default "deny all" fallback.
	Action string `json:"action,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Set of label tags associated with the AuthorizationPolicy
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Name of the AuthorizationPolicy resource. It matches pattern
	// `projects/{project}/locations/{location}/authorizationPolicies/`.
	Name string `json:"name,omitempty"`
	// Rules: Optional. List of rules to match. Note that at least one of the rules
	// must match in order for the action specified in the 'action' field to be
	// taken. A rule is a match if there is a matching source and destination. If
	// left blank, the action specified in the `action` field will be applied on
	// every request.
	Rules []*Rule `json:"rules,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthorizationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicy: `AuthzPolicy` is a resource that allows to forward traffic to a
// callout backend designed to scan the traffic for security purposes.
type AuthzPolicy struct {
	// Action: Required. Can be one of `ALLOW`, `DENY`, `CUSTOM`. When the action
	// is `CUSTOM`, `customProvider` must be specified. When the action is `ALLOW`,
	// only requests matching the policy will be allowed. When the action is
	// `DENY`, only requests matching the policy will be denied. When a request
	// arrives, the policies are evaluated in the following order: 1. If there is a
	// `CUSTOM` policy that matches the request, the `CUSTOM` policy is evaluated
	// using the custom authorization providers and the request is denied if the
	// provider rejects the request. 2. If there are any `DENY` policies that match
	// the request, the request is denied. 3. If there are no `ALLOW` policies for
	// the resource or if any of the `ALLOW` policies match the request, the
	// request is allowed. 4. Else the request is denied by default if none of the
	// configured AuthzPolicies with `ALLOW` action match the request.
	//
	// Possible values:
	//   "AUTHZ_ACTION_UNSPECIFIED" - Unspecified action.
	//   "ALLOW" - Allow request to pass through to the backend.
	//   "DENY" - Deny the request and return a HTTP 404 to the client.
	//   "CUSTOM" - Delegate the authorization decision to an external
	// authorization engine.
	Action string `json:"action,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomProvider: Optional. Required if the action is `CUSTOM`. Allows
	// delegating authorization decisions to Cloud IAP or to Service Extensions.
	// One of `cloudIap` or `authzExtension` must be specified.
	CustomProvider *AuthzPolicyCustomProvider `json:"customProvider,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// HttpRules: Optional. A list of authorization HTTP rules to match against the
	// incoming request. A policy match occurs when at least one HTTP rule matches
	// the request or when no HTTP rules are specified in the policy. At least one
	// HTTP Rule is required for Allow or Deny Action. Limited to 5 rules.
	HttpRules []*AuthzPolicyAuthzRule `json:"httpRules,omitempty"`
	// Labels: Optional. Set of labels associated with the `AuthzPolicy` resource.
	// The format must comply with the following requirements
	// (/compute/docs/labeling-resources#requirements).
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Identifier. Name of the `AuthzPolicy` resource in the
	// following format:
	// `projects/{project}/locations/{location}/authzPolicies/{authz_policy}`.
	Name string `json:"name,omitempty"`
	// Target: Required. Specifies the set of resources to which this policy should
	// be applied to.
	Target *AuthzPolicyTarget `json:"target,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRule: Conditions to match against the incoming request.
type AuthzPolicyAuthzRule struct {
	// From: Optional. Describes properties of a source of a request.
	From *AuthzPolicyAuthzRuleFrom `json:"from,omitempty"`
	// To: Optional. Describes properties of a target of a request.
	To *AuthzPolicyAuthzRuleTo `json:"to,omitempty"`
	// When: Optional. CEL expression that describes the conditions to be satisfied
	// for the action. The result of the CEL expression is ANDed with the from and
	// to. Refer to the CEL language reference for a list of available attributes.
	When string `json:"when,omitempty"`
	// ForceSendFields is a list of field names (e.g. "From") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "From") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRule) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleFrom: Describes properties of one or more sources of a
// request.
type AuthzPolicyAuthzRuleFrom struct {
	// NotSources: Optional. Describes the negated properties of request sources.
	// Matches requests from sources that do not match the criteria specified in
	// this field. At least one of sources or notSources must be specified.
	NotSources []*AuthzPolicyAuthzRuleFromRequestSource `json:"notSources,omitempty"`
	// Sources: Optional. Describes the properties of a request's sources. At least
	// one of sources or notSources must be specified. Limited to 1 source. A match
	// occurs when ANY source (in sources or notSources) matches the request.
	// Within a single source, the match follows AND semantics across fields and OR
	// semantics within a single field, i.e. a match occurs when ANY principal
	// matches AND ANY ipBlocks match.
	Sources []*AuthzPolicyAuthzRuleFromRequestSource `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleFrom) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleFrom
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleFromRequestSource: Describes the properties of a single
// source.
type AuthzPolicyAuthzRuleFromRequestSource struct {
	// IpBlocks: Optional. A list of IP addresses or IP address ranges to match
	// against the source IP address of the request. Limited to 10 ip_blocks per
	// Authorization Policy
	IpBlocks []*AuthzPolicyAuthzRuleIpBlock `json:"ipBlocks,omitempty"`
	// Principals: Optional. A list of identities derived from the client's
	// certificate. This field will not match on a request unless frontend mutual
	// TLS is enabled for the forwarding rule or Gateway and the client certificate
	// has been successfully validated by mTLS. Each identity is a string whose
	// value is matched against a list of URI SANs, DNS Name SANs, or the common
	// name in the client's certificate. A match happens when any principal matches
	// with the rule. Limited to 50 principals per Authorization Policy for
	// regional internal Application Load Balancers, regional external Application
	// Load Balancers, cross-region internal Application Load Balancers, and Cloud
	// Service Mesh. This field is not supported for global external Application
	// Load Balancers.
	Principals []*AuthzPolicyAuthzRulePrincipal `json:"principals,omitempty"`
	// Resources: Optional. A list of resources to match against the resource of
	// the source VM of a request. Limited to 10 resources per Authorization
	// Policy.
	Resources []*AuthzPolicyAuthzRuleRequestResource `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpBlocks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpBlocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleFromRequestSource) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleFromRequestSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleHeaderMatch: Determines how a HTTP header should be
// matched.
type AuthzPolicyAuthzRuleHeaderMatch struct {
	// Name: Optional. Specifies the name of the header in the request.
	Name string `json:"name,omitempty"`
	// Value: Optional. Specifies how the header match will be performed.
	Value *AuthzPolicyAuthzRuleStringMatch `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleHeaderMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleIpBlock: Represents a range of IP Addresses.
type AuthzPolicyAuthzRuleIpBlock struct {
	// Length: Required. The length of the address range.
	Length int64 `json:"length,omitempty"`
	// Prefix: Required. The address prefix.
	Prefix string `json:"prefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Length") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Length") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleIpBlock) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleIpBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRulePrincipal: Describes the properties of a principal to be
// matched against.
type AuthzPolicyAuthzRulePrincipal struct {
	// Principal: Required. A non-empty string whose value is matched against the
	// principal value based on the principal_selector. Only exact match can be
	// applied for CLIENT_CERT_URI_SAN, CLIENT_CERT_DNS_NAME_SAN,
	// CLIENT_CERT_COMMON_NAME selectors.
	Principal *AuthzPolicyAuthzRuleStringMatch `json:"principal,omitempty"`
	// PrincipalSelector: Optional. An enum to decide what principal value the
	// principal rule will match against. If not specified, the PrincipalSelector
	// is CLIENT_CERT_URI_SAN.
	//
	// Possible values:
	//   "PRINCIPAL_SELECTOR_UNSPECIFIED" - Unspecified principal selector. It will
	// be treated as CLIENT_CERT_URI_SAN by default.
	//   "CLIENT_CERT_URI_SAN" - The principal rule is matched against a list of
	// URI SANs in the validated client's certificate. A match happens when there
	// is any exact URI SAN value match. This is the default principal selector.
	//   "CLIENT_CERT_DNS_NAME_SAN" - The principal rule is matched against a list
	// of DNS Name SANs in the validated client's certificate. A match happens when
	// there is any exact DNS Name SAN value match. This is only applicable for
	// Application Load Balancers except for classic Global External Application
	// load balancer. CLIENT_CERT_DNS_NAME_SAN is not supported for
	// INTERNAL_SELF_MANAGED load balancing scheme.
	//   "CLIENT_CERT_COMMON_NAME" - The principal rule is matched against the
	// common name in the client's certificate. Authorization against multiple
	// common names in the client certificate is not supported. Requests with
	// multiple common names in the client certificate will be rejected if
	// CLIENT_CERT_COMMON_NAME is set as the principal selector. A match happens
	// when there is an exact common name value match. This is only applicable for
	// Application Load Balancers except for global external Application Load
	// Balancer and classic Application Load Balancer. CLIENT_CERT_COMMON_NAME is
	// not supported for INTERNAL_SELF_MANAGED load balancing scheme.
	PrincipalSelector string `json:"principalSelector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Principal") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Principal") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRulePrincipal) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRulePrincipal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleRequestResource: Describes the properties of a client VM
// resource accessing the internal application load balancers.
type AuthzPolicyAuthzRuleRequestResource struct {
	// IamServiceAccount: Optional. An IAM service account to match against the
	// source service account of the VM sending the request.
	IamServiceAccount *AuthzPolicyAuthzRuleStringMatch `json:"iamServiceAccount,omitempty"`
	// TagValueIdSet: Optional. A list of resource tag value permanent IDs to match
	// against the resource manager tags value associated with the source VM of a
	// request.
	TagValueIdSet *AuthzPolicyAuthzRuleRequestResourceTagValueIdSet `json:"tagValueIdSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IamServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IamServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleRequestResource) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleRequestResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleRequestResourceTagValueIdSet: Describes a set of
// resource tag value permanent IDs to match against the resource manager tags
// value associated with the source VM of a request.
type AuthzPolicyAuthzRuleRequestResourceTagValueIdSet struct {
	// Ids: Required. A list of resource tag value permanent IDs to match against
	// the resource manager tags value associated with the source VM of a request.
	// The match follows AND semantics which means all the ids must match. Limited
	// to 5 ids in the Tag value id set.
	Ids googleapi.Int64s `json:"ids,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ids") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ids") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleRequestResourceTagValueIdSet) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleRequestResourceTagValueIdSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleStringMatch: Determines how a string value should be
// matched.
type AuthzPolicyAuthzRuleStringMatch struct {
	// Contains: The input string must have the substring specified here. Note:
	// empty contains match is not allowed, please use regex instead. Examples: *
	// ``abc`` matches the value ``xyz.abc.def``
	Contains string `json:"contains,omitempty"`
	// Exact: The input string must match exactly the string specified here.
	// Examples: * ``abc`` only matches the value ``abc``.
	Exact string `json:"exact,omitempty"`
	// IgnoreCase: If true, indicates the exact/prefix/suffix/contains matching
	// should be case insensitive. For example, the matcher ``data`` will match
	// both input string ``Data`` and ``data`` if set to true.
	IgnoreCase bool `json:"ignoreCase,omitempty"`
	// Prefix: The input string must have the prefix specified here. Note: empty
	// prefix is not allowed, please use regex instead. Examples: * ``abc`` matches
	// the value ``abc.xyz``
	Prefix string `json:"prefix,omitempty"`
	// Suffix: The input string must have the suffix specified here. Note: empty
	// prefix is not allowed, please use regex instead. Examples: * ``abc`` matches
	// the value ``xyz.abc``
	Suffix string `json:"suffix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contains") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleStringMatch) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleStringMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleTo: Describes properties of one or more targets of a
// request.
type AuthzPolicyAuthzRuleTo struct {
	// NotOperations: Optional. Describes the negated properties of the targets of
	// a request. Matches requests for operations that do not match the criteria
	// specified in this field. At least one of operations or notOperations must be
	// specified.
	NotOperations []*AuthzPolicyAuthzRuleToRequestOperation `json:"notOperations,omitempty"`
	// Operations: Optional. Describes properties of one or more targets of a
	// request. At least one of operations or notOperations must be specified.
	// Limited to 1 operation. A match occurs when ANY operation (in operations or
	// notOperations) matches. Within an operation, the match follows AND semantics
	// across fields and OR semantics within a field, i.e. a match occurs when ANY
	// path matches AND ANY header matches and ANY method matches.
	Operations []*AuthzPolicyAuthzRuleToRequestOperation `json:"operations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotOperations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotOperations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleTo) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleTo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleToRequestOperation: Describes properties of one or more
// targets of a request.
type AuthzPolicyAuthzRuleToRequestOperation struct {
	// HeaderSet: Optional. A list of headers to match against in http header.
	HeaderSet *AuthzPolicyAuthzRuleToRequestOperationHeaderSet `json:"headerSet,omitempty"`
	// Hosts: Optional. A list of HTTP Hosts to match against. The match can be one
	// of exact, prefix, suffix, or contains (substring match). Matches are always
	// case sensitive unless the ignoreCase is set. Limited to 10 hosts per
	// Authorization Policy.
	Hosts []*AuthzPolicyAuthzRuleStringMatch `json:"hosts,omitempty"`
	// Methods: Optional. A list of HTTP methods to match against. Each entry must
	// be a valid HTTP method name (GET, PUT, POST, HEAD, PATCH, DELETE, OPTIONS).
	// It only allows exact match and is always case sensitive. Limited to 10
	// methods per Authorization Policy.
	Methods []string `json:"methods,omitempty"`
	// Paths: Optional. A list of paths to match against. The match can be one of
	// exact, prefix, suffix, or contains (substring match). Matches are always
	// case sensitive unless the ignoreCase is set. Limited to 10 paths per
	// Authorization Policy. Note that this path match includes the query
	// parameters. For gRPC services, this should be a fully-qualified name of the
	// form /package.service/method.
	Paths []*AuthzPolicyAuthzRuleStringMatch `json:"paths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HeaderSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HeaderSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleToRequestOperation) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleToRequestOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyAuthzRuleToRequestOperationHeaderSet: Describes a set of HTTP
// headers to match against.
type AuthzPolicyAuthzRuleToRequestOperationHeaderSet struct {
	// Headers: Required. A list of headers to match against in http header. The
	// match can be one of exact, prefix, suffix, or contains (substring match).
	// The match follows AND semantics which means all the headers must match.
	// Matches are always case sensitive unless the ignoreCase is set. Limited to
	// 10 headers per Authorization Policy.
	Headers []*AuthzPolicyAuthzRuleHeaderMatch `json:"headers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Headers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Headers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyAuthzRuleToRequestOperationHeaderSet) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyAuthzRuleToRequestOperationHeaderSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyCustomProvider: Allows delegating authorization decisions to
// Cloud IAP or to Service Extensions.
type AuthzPolicyCustomProvider struct {
	// AuthzExtension: Optional. Delegate authorization decision to user authored
	// Service Extension. Only one of cloudIap or authzExtension can be specified.
	AuthzExtension *AuthzPolicyCustomProviderAuthzExtension `json:"authzExtension,omitempty"`
	// CloudIap: Optional. Delegates authorization decisions to Cloud IAP.
	// Applicable only for managed load balancers. Enabling Cloud IAP at the
	// AuthzPolicy level is not compatible with Cloud IAP settings in the
	// BackendService. Enabling IAP in both places will result in request failure.
	// Ensure that IAP is enabled in either the AuthzPolicy or the BackendService
	// but not in both places.
	CloudIap *AuthzPolicyCustomProviderCloudIap `json:"cloudIap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthzExtension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthzExtension") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyCustomProvider) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyCustomProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyCustomProviderAuthzExtension: Optional. Delegate authorization
// decision to user authored extension. Only one of cloudIap or authzExtension
// can be specified.
type AuthzPolicyCustomProviderAuthzExtension struct {
	// Resources: Required. A list of references to authorization extensions that
	// will be invoked for requests matching this policy. Limited to 1 custom
	// provider.
	Resources []string `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyCustomProviderAuthzExtension) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyCustomProviderAuthzExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthzPolicyCustomProviderCloudIap: Optional. Delegates authorization
// decisions to Cloud IAP. Applicable only for managed load balancers. Enabling
// Cloud IAP at the AuthzPolicy level is not compatible with Cloud IAP settings
// in the BackendService. Enabling IAP in both places will result in request
// failure. Ensure that IAP is enabled in either the AuthzPolicy or the
// BackendService but not in both places.
type AuthzPolicyCustomProviderCloudIap struct {
}

// AuthzPolicyTarget: Specifies the set of targets to which this policy should
// be applied to.
type AuthzPolicyTarget struct {
	// LoadBalancingScheme: Required. All gateways and forwarding rules referenced
	// by this policy and extensions must share the same load balancing scheme.
	// Supported values: `INTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`, and
	// `EXTERNAL_MANAGED`. For more information, refer to Backend services overview
	// (https://cloud.google.com/load-balancing/docs/backend-service).
	//
	// Possible values:
	//   "LOAD_BALANCING_SCHEME_UNSPECIFIED" - Default value. Do not use.
	//   "INTERNAL_MANAGED" - Signifies that this is used for Regional internal or
	// Cross-region internal Application Load Balancing.
	//   "EXTERNAL_MANAGED" - Signifies that this is used for Global external or
	// Regional external Application Load Balancing.
	//   "INTERNAL_SELF_MANAGED" - Signifies that this is used for Cloud Service
	// Mesh. Meant for use by CSM GKE controller only.
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`
	// Resources: Required. A list of references to the Forwarding Rules on which
	// this policy will be applied. For policies created for Cloudrun, this field
	// will reference the Cloud Run services.
	Resources []string `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LoadBalancingScheme") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LoadBalancingScheme") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzPolicyTarget) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzPolicyTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackendAuthenticationConfig: BackendAuthenticationConfig message groups the
// TrustConfig together with other settings that control how the load balancer
// authenticates, and expresses its identity to, the backend: * `trustConfig`
// is the attached TrustConfig. * `wellKnownRoots` indicates whether the load
// balance should trust backend server certificates that are issued by public
// certificate authorities, in addition to certificates trusted by the
// TrustConfig. * `clientCertificate` is a client certificate that the load
// balancer uses to express its identity to the backend, if the connection to
// the backend uses mTLS. You can attach the BackendAuthenticationConfig to the
// load balancer's BackendService directly determining how that BackendService
// negotiates TLS.
type BackendAuthenticationConfig struct {
	// ClientCertificate: Optional. A reference to a
	// certificatemanager.googleapis.com.Certificate resource. This is a relative
	// resource path following the form
	// "projects/{project}/locations/{location}/certificates/{certificate}". Used
	// by a BackendService to negotiate mTLS when the backend connection uses TLS
	// and the backend requests a client certificate. Must have a CLIENT_AUTH
	// scope.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Etag: Output only. Etag of the resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Set of label tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Name of the BackendAuthenticationConfig resource. It matches
	// the pattern
	// `projects/*/locations/{location}/backendAuthenticationConfigs/{backend_authen
	// tication_config}`
	Name string `json:"name,omitempty"`
	// TrustConfig: Optional. A reference to a TrustConfig resource from the
	// certificatemanager.googleapis.com namespace. This is a relative resource
	// path following the form
	// "projects/{project}/locations/{location}/trustConfigs/{trust_config}". A
	// BackendService uses the chain of trust represented by this TrustConfig, if
	// specified, to validate the server certificates presented by the backend.
	// Required unless wellKnownRoots is set to PUBLIC_ROOTS.
	TrustConfig string `json:"trustConfig,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WellKnownRoots: Well known roots to use for server certificate validation.
	//
	// Possible values:
	//   "WELL_KNOWN_ROOTS_UNSPECIFIED" - Equivalent to NONE.
	//   "NONE" - The BackendService will only validate server certificates against
	// roots specified in TrustConfig.
	//   "PUBLIC_ROOTS" - The BackendService uses a set of well-known public roots,
	// in addition to any roots specified in the trustConfig field, when validating
	// the server certificates presented by the backend. Validation with these
	// roots is only considered when the TlsSettings.sni field in the
	// BackendService is set. The well-known roots are a set of root CAs managed by
	// Google. CAs in this set can be added or removed without notice.
	WellKnownRoots string `json:"wellKnownRoots,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientCertificate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackendAuthenticationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackendAuthenticationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CertificateProviderInstance: Specification of a TLS certificate provider
// instance. Workloads may have one or more CertificateProvider instances
// (plugins) and one of them is enabled and configured by specifying this
// message. Workloads use the values from this message to locate and load the
// CertificateProvider instance configuration.
type CertificateProviderInstance struct {
	// PluginInstance: Required. Plugin instance name, used to locate and load
	// CertificateProvider instance configuration. Set to
	// "google_cloud_private_spiffe" to use Certificate Authority Service
	// certificate provider instance.
	PluginInstance string `json:"pluginInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PluginInstance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PluginInstance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CertificateProviderInstance) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateProviderInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClientTlsPolicy: ClientTlsPolicy is a resource that specifies how a client
// should authenticate connections to backends of a service. This resource
// itself does not affect configuration unless it is attached to a backend
// service resource.
type ClientTlsPolicy struct {
	// ClientCertificate: Optional. Defines a mechanism to provision client
	// identity (public and private keys) for peer to peer authentication. The
	// presence of this dictates mTLS.
	ClientCertificate *GoogleCloudNetworksecurityV1CertificateProvider `json:"clientCertificate,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Set of label tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Name of the ClientTlsPolicy resource. It matches the pattern
	// `projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy
	// }`
	Name string `json:"name,omitempty"`
	// ServerValidationCa: Optional. Defines the mechanism to obtain the
	// Certificate Authority certificate to validate the server certificate. If
	// empty, client does not validate the server certificate.
	ServerValidationCa []*ValidationCA `json:"serverValidationCa,omitempty"`
	// Sni: Optional. Server Name Indication string to present to the server during
	// TLS handshake. E.g: "secure.example.com".
	Sni string `json:"sni,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientCertificate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClientTlsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ClientTlsPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloneAddressGroupItemsRequest: Request used by the CloneAddressGroupItems
// method.
type CloneAddressGroupItemsRequest struct {
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// SourceAddressGroup: Required. Source address group to clone items from.
	SourceAddressGroup string `json:"sourceAddressGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloneAddressGroupItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CloneAddressGroupItemsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomInterceptProfile: CustomInterceptProfile defines in-band integration
// behavior (intercept). It is used by firewall rules with an
// APPLY_SECURITY_PROFILE_GROUP action.
type CustomInterceptProfile struct {
	// InterceptEndpointGroup: Required. The target InterceptEndpointGroup. When a
	// firewall rule with this security profile attached matches a packet, the
	// packet will be intercepted to the location-local target in this group.
	InterceptEndpointGroup string `json:"interceptEndpointGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InterceptEndpointGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InterceptEndpointGroup") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomInterceptProfile) MarshalJSON() ([]byte, error) {
	type NoMethod CustomInterceptProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomMirroringProfile: CustomMirroringProfile defines out-of-band
// integration behavior (mirroring). It is used by mirroring rules with a
// MIRROR action.
type CustomMirroringProfile struct {
	// MirroringEndpointGroup: Required. The target MirroringEndpointGroup. When a
	// mirroring rule with this security profile attached matches a packet, a
	// replica will be mirrored to the location-local target in this group.
	MirroringEndpointGroup string `json:"mirroringEndpointGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MirroringEndpointGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MirroringEndpointGroup") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomMirroringProfile) MarshalJSON() ([]byte, error) {
	type NoMethod CustomMirroringProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Destination: Specification of traffic destination attributes.
type Destination struct {
	// Hosts: Required. List of host names to match. Matched against the
	// ":authority" header in http requests. At least one host should match. Each
	// host can be an exact match, or a prefix match (example "mydomain.*") or a
	// suffix match (example "*.myorg.com") or a presence (any) match "*".
	Hosts []string `json:"hosts,omitempty"`
	// HttpHeaderMatch: Optional. Match against key:value pair in http header.
	// Provides a flexible match based on HTTP headers, for potentially advanced
	// use cases. At least one header should match. Avoid using header matches to
	// make authorization decisions unless there is a strong guarantee that
	// requests arrive through a trusted client or proxy.
	HttpHeaderMatch *HttpHeaderMatch `json:"httpHeaderMatch,omitempty"`
	// Methods: Optional. A list of HTTP methods to match. At least one method
	// should match. Should not be set for gRPC services.
	Methods []string `json:"methods,omitempty"`
	// Ports: Required. List of destination ports to match. At least one port
	// should match.
	Ports []int64 `json:"ports,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hosts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hosts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Destination) MarshalJSON() ([]byte, error) {
	type NoMethod Destination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirewallEndpoint: Message describing Endpoint object.
type FirewallEndpoint struct {
	// AssociatedNetworks: Output only. List of networks that are associated with
	// this endpoint in the local zone. This is a projection of the
	// FirewallEndpointAssociations pointing at this endpoint. A network will only
	// appear in this list after traffic routing is fully configured. Format:
	// projects/{project}/global/networks/{name}.
	AssociatedNetworks []string `json:"associatedNetworks,omitempty"`
	// Associations: Output only. List of FirewallEndpointAssociations that are
	// associated to this endpoint. An association will only appear in this list
	// after traffic routing is fully configured.
	Associations []*FirewallEndpointAssociationReference `json:"associations,omitempty"`
	// BillingProjectId: Required. Project to bill on endpoint uptime usage.
	BillingProjectId string `json:"billingProjectId,omitempty"`
	// CreateTime: Output only. Create time stamp.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the firewall endpoint. Max length 2048
	// characters.
	Description string `json:"description,omitempty"`
	// EndpointSettings: Optional. Settings for the endpoint.
	EndpointSettings *FirewallEndpointEndpointSettings `json:"endpointSettings,omitempty"`
	// Labels: Optional. Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. Name of resource.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. Whether reconciling is in progress, recommended
	// per https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// SatisfiesPzi: Output only. [Output Only] Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. Current state of the endpoint.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "CREATING" - Being created.
	//   "ACTIVE" - Processing configuration updates.
	//   "DELETING" - Being deleted.
	//   "INACTIVE" - Down or in an error state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Update time stamp
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssociatedNetworks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedNetworks") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirewallEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirewallEndpointAssociation: Message describing Association object
type FirewallEndpointAssociation struct {
	// CreateTime: Output only. Create time stamp
	CreateTime string `json:"createTime,omitempty"`
	// Disabled: Optional. Whether the association is disabled. True indicates that
	// traffic won't be intercepted
	Disabled bool `json:"disabled,omitempty"`
	// FirewallEndpoint: Required. The URL of the FirewallEndpoint that is being
	// associated.
	FirewallEndpoint string `json:"firewallEndpoint,omitempty"`
	// Labels: Optional. Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. name of resource
	Name string `json:"name,omitempty"`
	// Network: Required. The URL of the network that is being associated.
	Network string `json:"network,omitempty"`
	// Reconciling: Output only. Whether reconciling is in progress, recommended
	// per https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. Current state of the association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "CREATING" - Being created.
	//   "ACTIVE" - Active and ready for traffic.
	//   "DELETING" - Being deleted.
	//   "INACTIVE" - Down or in an error state.
	//   "ORPHAN" - The project that housed the association has been deleted.
	State string `json:"state,omitempty"`
	// TlsInspectionPolicy: Optional. The URL of the TlsInspectionPolicy that is
	// being associated.
	TlsInspectionPolicy string `json:"tlsInspectionPolicy,omitempty"`
	// UpdateTime: Output only. Update time stamp
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirewallEndpointAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallEndpointAssociation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirewallEndpointAssociationReference: This is a subset of the
// FirewallEndpointAssociation message, containing fields to be used by the
// consumer.
type FirewallEndpointAssociationReference struct {
	// Name: Output only. The resource name of the FirewallEndpointAssociation.
	// Format:
	// projects/{project}/locations/{location}/firewallEndpointAssociations/{id}
	Name string `json:"name,omitempty"`
	// Network: Output only. The VPC network associated. Format:
	// projects/{project}/global/networks/{name}.
	Network string `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirewallEndpointAssociationReference) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallEndpointAssociationReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirewallEndpointEndpointSettings: Settings for the endpoint.
type FirewallEndpointEndpointSettings struct {
}

// GatewaySecurityPolicy: The GatewaySecurityPolicy resource contains a
// collection of GatewaySecurityPolicyRules and associated metadata.
type GatewaySecurityPolicy struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Name: Required. Name of the resource. Name is of the form
	// projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_secu
	// rity_policy} gateway_security_policy should match the pattern:(^a-z
	// ([a-z0-9-]{0,61}[a-z0-9])?$).
	Name string `json:"name,omitempty"`
	// TlsInspectionPolicy: Optional. Name of a TLS Inspection Policy resource that
	// defines how TLS inspection will be performed for any rule(s) which enables
	// it.
	TlsInspectionPolicy string `json:"tlsInspectionPolicy,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GatewaySecurityPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GatewaySecurityPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GatewaySecurityPolicyRule: The GatewaySecurityPolicyRule resource is in a
// nested collection within a GatewaySecurityPolicy and represents a traffic
// matching condition and associated action to perform.
type GatewaySecurityPolicyRule struct {
	// ApplicationMatcher: Optional. CEL expression for matching on L7/application
	// level criteria.
	ApplicationMatcher string `json:"applicationMatcher,omitempty"`
	// BasicProfile: Required. Profile which tells what the primitive action should
	// be.
	//
	// Possible values:
	//   "BASIC_PROFILE_UNSPECIFIED" - If there is not a mentioned action for the
	// target.
	//   "ALLOW" - Allow the matched traffic.
	//   "DENY" - Deny the matched traffic.
	BasicProfile string `json:"basicProfile,omitempty"`
	// CreateTime: Output only. Time when the rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Enabled: Required. Whether the rule is enforced.
	Enabled bool `json:"enabled,omitempty"`
	// Name: Required. Immutable. Name of the resource. ame is the full resource
	// name so
	// projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_secu
	// rity_policy}/rules/{rule} rule should match the pattern: (^a-z
	// ([a-z0-9-]{0,61}[a-z0-9])?$).
	Name string `json:"name,omitempty"`
	// Priority: Required. Priority of the rule. Lower number corresponds to higher
	// precedence.
	Priority int64 `json:"priority,omitempty"`
	// SessionMatcher: Required. CEL expression for matching on session criteria.
	SessionMatcher string `json:"sessionMatcher,omitempty"`
	// TlsInspectionEnabled: Optional. Flag to enable TLS inspection of traffic
	// matching on , can only be true if the parent GatewaySecurityPolicy
	// references a TLSInspectionConfig.
	TlsInspectionEnabled bool `json:"tlsInspectionEnabled,omitempty"`
	// UpdateTime: Output only. Time when the rule was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplicationMatcher") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationMatcher") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GatewaySecurityPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GatewaySecurityPolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudNetworksecurityV1CertificateProvider: Specification of
// certificate provider. Defines the mechanism to obtain the certificate and
// private key for peer to peer authentication.
type GoogleCloudNetworksecurityV1CertificateProvider struct {
	// CertificateProviderInstance: The certificate provider instance specification
	// that will be passed to the data plane, which will be used to load necessary
	// credential information.
	CertificateProviderInstance *CertificateProviderInstance `json:"certificateProviderInstance,omitempty"`
	// GrpcEndpoint: gRPC specific configuration to access the gRPC server to
	// obtain the cert and private key.
	GrpcEndpoint *GoogleCloudNetworksecurityV1GrpcEndpoint `json:"grpcEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CertificateProviderInstance") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateProviderInstance") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudNetworksecurityV1CertificateProvider) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudNetworksecurityV1CertificateProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudNetworksecurityV1GrpcEndpoint: Specification of the GRPC
// Endpoint.
type GoogleCloudNetworksecurityV1GrpcEndpoint struct {
	// TargetUri: Required. The target URI of the gRPC endpoint. Only UDS path is
	// supported, and should start with "unix:".
	TargetUri string `json:"targetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudNetworksecurityV1GrpcEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudNetworksecurityV1GrpcEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type GoogleIamV1SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsRequest: Request message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsResponse: Response message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpHeaderMatch: Specification of HTTP header match attributes.
type HttpHeaderMatch struct {
	// HeaderName: Required. The name of the HTTP header to match. For matching
	// against the HTTP request's authority, use a headerMatch with the header name
	// ":authority". For matching a request's method, use the headerName ":method".
	HeaderName string `json:"headerName,omitempty"`
	// RegexMatch: Required. The value of the header must match the regular
	// expression specified in regexMatch. For regular expression grammar, please
	// see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port
	// specified in the HTTP request, use a headerMatch with headerName set to Host
	// and a regular expression that satisfies the RFC2616 Host header's port
	// specifier.
	RegexMatch string `json:"regexMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HeaderName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptDeployment: A deployment represents a zonal intercept backend ready
// to accept GENEVE-encapsulated traffic, e.g. a zonal instance group fronted
// by an internal passthrough load balancer. Deployments are always part of a
// global deployment group which represents a global intercept service.
type InterceptDeployment struct {
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the deployment. Used as
	// additional context for the deployment.
	Description string `json:"description,omitempty"`
	// ForwardingRule: Required. Immutable. The regional forwarding rule that
	// fronts the interceptors, for example:
	// `projects/123456789/regions/us-central1/forwardingRules/my-rule`. See
	// https://google.aip.dev/124.
	ForwardingRule string `json:"forwardingRule,omitempty"`
	// InterceptDeploymentGroup: Required. Immutable. The deployment group that
	// this deployment is a part of, for example:
	// `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	InterceptDeploymentGroup string `json:"interceptDeploymentGroup,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. The resource name of this deployment, for
	// example:
	// `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
	// See https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// part of the normal operation (e.g. linking a new association to the parent
	// group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the deployment. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment is ready and in sync with the parent group.
	//   "CREATING" - The deployment is being created.
	//   "DELETING" - The deployment is being deleted.
	//   "OUT_OF_SYNC" - The deployment is out of sync with the parent group. In
	// most cases, this is a result of a transient issue within the system (e.g. a
	// delayed data-path config) and the system is expected to recover
	// automatically. See the parent deployment group's state for more details.
	//   "DELETE_FAILED" - An attempt to delete the deployment has failed. This is
	// a terminal state and the deployment is not expected to recover. The only
	// permitted operation is to retry deleting the deployment.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptDeploymentGroup: A deployment group aggregates many zonal intercept
// backends (deployments) into a single global intercept service. Consumers can
// connect this service using an endpoint group.
type InterceptDeploymentGroup struct {
	// ConnectedEndpointGroups: Output only. The list of endpoint groups that are
	// connected to this resource.
	ConnectedEndpointGroups []*InterceptDeploymentGroupConnectedEndpointGroup `json:"connectedEndpointGroups,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the deployment group.
	// Used as additional context for the deployment group.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Locations: Output only. The list of locations where the deployment group is
	// present.
	Locations []*InterceptLocation `json:"locations,omitempty"`
	// Name: Immutable. Identifier. The resource name of this deployment group, for
	// example:
	// `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`. See
	// https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// NestedDeployments: Output only. The list of Intercept Deployments that
	// belong to this group.
	NestedDeployments []*InterceptDeploymentGroupDeployment `json:"nestedDeployments,omitempty"`
	// Network: Required. Immutable. The network that will be used for all child
	// deployments, for example: `projects/{project}/global/networks/{network}`.
	// See https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// is part of the normal operation (e.g. adding a new deployment to the group)
	// See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the deployment group. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment group is ready.
	//   "CREATING" - The deployment group is being created.
	//   "DELETING" - The deployment group is being deleted.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConnectedEndpointGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectedEndpointGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptDeploymentGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptDeploymentGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptDeploymentGroupConnectedEndpointGroup: An endpoint group connected
// to this deployment group.
type InterceptDeploymentGroupConnectedEndpointGroup struct {
	// Name: Output only. The connected endpoint group's resource name, for
	// example:
	// `projects/123456789/locations/global/interceptEndpointGroups/my-eg`. See
	// https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptDeploymentGroupConnectedEndpointGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptDeploymentGroupConnectedEndpointGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptDeploymentGroupDeployment: A deployment belonging to this
// deployment group.
type InterceptDeploymentGroupDeployment struct {
	// Name: Output only. The name of the Intercept Deployment, in the format:
	// `projects/{project}/locations/{location}/interceptDeployments/{intercept_depl
	// oyment}`.
	Name string `json:"name,omitempty"`
	// State: Output only. Most recent known state of the deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment is ready and in sync with the parent group.
	//   "CREATING" - The deployment is being created.
	//   "DELETING" - The deployment is being deleted.
	//   "OUT_OF_SYNC" - The deployment is out of sync with the parent group. In
	// most cases, this is a result of a transient issue within the system (e.g. a
	// delayed data-path config) and the system is expected to recover
	// automatically. See the parent deployment group's state for more details.
	//   "DELETE_FAILED" - An attempt to delete the deployment has failed. This is
	// a terminal state and the deployment is not expected to recover. The only
	// permitted operation is to retry deleting the deployment.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptDeploymentGroupDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptDeploymentGroupDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptEndpointGroup: An endpoint group is a consumer frontend for a
// deployment group (backend). In order to configure intercept for a network,
// consumers must create: - An association between their network and the
// endpoint group. - A security profile that points to the endpoint group. - A
// firewall rule that references the security profile (group).
type InterceptEndpointGroup struct {
	// Associations: Output only. List of associations to this endpoint group.
	Associations []*InterceptEndpointGroupAssociationDetails `json:"associations,omitempty"`
	// ConnectedDeploymentGroup: Output only. Details about the connected
	// deployment group to this endpoint group.
	ConnectedDeploymentGroup *InterceptEndpointGroupConnectedDeploymentGroup `json:"connectedDeploymentGroup,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the endpoint group. Used
	// as additional context for the endpoint group.
	Description string `json:"description,omitempty"`
	// InterceptDeploymentGroup: Required. Immutable. The deployment group that
	// this endpoint group is connected to, for example:
	// `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	InterceptDeploymentGroup string `json:"interceptDeploymentGroup,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. The resource name of this endpoint group, for
	// example:
	// `projects/123456789/locations/global/interceptEndpointGroups/my-eg`. See
	// https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// is part of the normal operation (e.g. adding a new association to the
	// group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the endpoint group. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The endpoint group is ready and in sync with the target
	// deployment group.
	//   "CLOSED" - The deployment group backing this endpoint group has been
	// force-deleted. This endpoint group cannot be used and interception is
	// effectively disabled.
	//   "CREATING" - The endpoint group is being created.
	//   "DELETING" - The endpoint group is being deleted.
	//   "OUT_OF_SYNC" - The endpoint group is out of sync with the backing
	// deployment group. In most cases, this is a result of a transient issue
	// within the system (e.g. an inaccessible location) and the system is expected
	// to recover automatically. See the associations field for details per network
	// and location.
	//   "DELETE_FAILED" - An attempt to delete the endpoint group has failed. This
	// is a terminal state and the endpoint group is not expected to recover. The
	// only permitted operation is to retry deleting the endpoint group.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Associations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptEndpointGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptEndpointGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptEndpointGroupAssociation: An endpoint group association represents
// a link between a network and an endpoint group in the organization. Creating
// an association creates the networking infrastructure linking the network to
// the endpoint group, but does not enable intercept by itself. To enable
// intercept, the user must also create a network firewall policy containing
// intercept rules and associate it with the network.
type InterceptEndpointGroupAssociation struct {
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// InterceptEndpointGroup: Required. Immutable. The endpoint group that this
	// association is connected to, for example:
	// `projects/123456789/locations/global/interceptEndpointGroups/my-eg`. See
	// https://google.aip.dev/124.
	InterceptEndpointGroup string `json:"interceptEndpointGroup,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Locations: Output only. The list of locations where the association is
	// configured. This information is retrieved from the linked endpoint group.
	Locations []*InterceptLocation `json:"locations,omitempty"`
	// LocationsDetails: Output only. The list of locations where the association
	// is present. This information is retrieved from the linked endpoint group,
	// and not configured as part of the association itself.
	LocationsDetails []*InterceptEndpointGroupAssociationLocationDetails `json:"locationsDetails,omitempty"`
	// Name: Immutable. Identifier. The resource name of this endpoint group
	// association, for example:
	// `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg
	// -association`. See https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Network: Required. Immutable. The VPC network that is associated. for
	// example: `projects/123456789/global/networks/my-network`. See
	// https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// part of the normal operation (e.g. adding a new location to the target
	// deployment group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. Current state of the endpoint group association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "CREATING" - The association is being created.
	//   "DELETING" - The association is being deleted.
	//   "CLOSED" - The association is disabled due to a breaking change in another
	// resource.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically. Check the `locations_details` field for more details.
	//   "DELETE_FAILED" - An attempt to delete the association has failed. This is
	// a terminal state and the association is not expected to be usable as some of
	// its resources have been deleted. The only permitted operation is to retry
	// deleting the association.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptEndpointGroupAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptEndpointGroupAssociation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptEndpointGroupAssociationDetails: The endpoint group's view of a
// connected association.
type InterceptEndpointGroupAssociationDetails struct {
	// Name: Output only. The connected association's resource name, for example:
	// `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-eg
	// a`. See https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// Network: Output only. The associated network, for example:
	// projects/123456789/global/networks/my-network. See
	// https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// State: Output only. Most recent known state of the association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "CREATING" - The association is being created.
	//   "DELETING" - The association is being deleted.
	//   "CLOSED" - The association is disabled due to a breaking change in another
	// resource.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically. Check the `locations_details` field for more details.
	//   "DELETE_FAILED" - An attempt to delete the association has failed. This is
	// a terminal state and the association is not expected to be usable as some of
	// its resources have been deleted. The only permitted operation is to retry
	// deleting the association.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptEndpointGroupAssociationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptEndpointGroupAssociationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptEndpointGroupAssociationLocationDetails: Contains details about the
// state of an association in a specific cloud location.
type InterceptEndpointGroupAssociationLocationDetails struct {
	// Location: Output only. The cloud location, e.g. "us-central1-a" or
	// "asia-south1".
	Location string `json:"location,omitempty"`
	// State: Output only. The current state of the association in this location.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptEndpointGroupAssociationLocationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptEndpointGroupAssociationLocationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptEndpointGroupConnectedDeploymentGroup: The endpoint group's view of
// a connected deployment group.
type InterceptEndpointGroupConnectedDeploymentGroup struct {
	// Locations: Output only. The list of locations where the deployment group is
	// present.
	Locations []*InterceptLocation `json:"locations,omitempty"`
	// Name: Output only. The connected deployment group's resource name, for
	// example:
	// `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptEndpointGroupConnectedDeploymentGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptEndpointGroupConnectedDeploymentGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InterceptLocation: Details about intercept in a specific cloud location.
type InterceptLocation struct {
	// Location: Output only. The cloud location, e.g. "us-central1-a" or
	// "asia-south1".
	Location string `json:"location,omitempty"`
	// State: Output only. The current state of the association in this location.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The resource is ready and in sync in the location.
	//   "OUT_OF_SYNC" - The resource is out of sync in the location. In most
	// cases, this is a result of a transient issue within the system (e.g. an
	// inaccessible location) and the system is expected to recover automatically.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InterceptLocation) MarshalJSON() ([]byte, error) {
	type NoMethod InterceptLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAddressGroupReferencesResponse: Response of the
// ListAddressGroupReferences method.
type ListAddressGroupReferencesResponse struct {
	// AddressGroupReferences: A list of references that matches the specified
	// filter in the request.
	AddressGroupReferences []*ListAddressGroupReferencesResponseAddressGroupReference `json:"addressGroupReferences,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AddressGroupReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressGroupReferences") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAddressGroupReferencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAddressGroupReferencesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAddressGroupReferencesResponseAddressGroupReference: The Reference of
// AddressGroup.
type ListAddressGroupReferencesResponseAddressGroupReference struct {
	// FirewallPolicy: FirewallPolicy that is using the Address Group.
	FirewallPolicy string `json:"firewallPolicy,omitempty"`
	// RulePriority: Rule priority of the FirewallPolicy that is using the Address
	// Group.
	RulePriority int64 `json:"rulePriority,omitempty"`
	// SecurityPolicy: Cloud Armor SecurityPolicy that is using the Address Group.
	SecurityPolicy string `json:"securityPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirewallPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirewallPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAddressGroupReferencesResponseAddressGroupReference) MarshalJSON() ([]byte, error) {
	type NoMethod ListAddressGroupReferencesResponseAddressGroupReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAddressGroupsResponse: Response returned by the ListAddressGroups
// method.
type ListAddressGroupsResponse struct {
	// AddressGroups: List of AddressGroups resources.
	AddressGroups []*AddressGroup `json:"addressGroups,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AddressGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressGroups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAddressGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAddressGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAuthorizationPoliciesResponse: Response returned by the
// ListAuthorizationPolicies method.
type ListAuthorizationPoliciesResponse struct {
	// AuthorizationPolicies: List of AuthorizationPolicies resources.
	AuthorizationPolicies []*AuthorizationPolicy `json:"authorizationPolicies,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizationPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizationPolicies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAuthorizationPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAuthorizationPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAuthzPoliciesResponse: Message for response to listing `AuthzPolicy`
// resources.
type ListAuthzPoliciesResponse struct {
	// AuthzPolicies: The list of `AuthzPolicy` resources.
	AuthzPolicies []*AuthzPolicy `json:"authzPolicies,omitempty"`
	// NextPageToken: A token identifying a page of results that the server
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthzPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthzPolicies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAuthzPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAuthzPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackendAuthenticationConfigsResponse: Response returned by the
// ListBackendAuthenticationConfigs method.
type ListBackendAuthenticationConfigsResponse struct {
	// BackendAuthenticationConfigs: List of BackendAuthenticationConfig resources.
	BackendAuthenticationConfigs []*BackendAuthenticationConfig `json:"backendAuthenticationConfigs,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "BackendAuthenticationConfigs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackendAuthenticationConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackendAuthenticationConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackendAuthenticationConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListClientTlsPoliciesResponse: Response returned by the
// ListClientTlsPolicies method.
type ListClientTlsPoliciesResponse struct {
	// ClientTlsPolicies: List of ClientTlsPolicy resources.
	ClientTlsPolicies []*ClientTlsPolicy `json:"clientTlsPolicies,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientTlsPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientTlsPolicies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListClientTlsPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClientTlsPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFirewallEndpointAssociationsResponse: Message for response to listing
// Associations
type ListFirewallEndpointAssociationsResponse struct {
	// FirewallEndpointAssociations: The list of Association
	FirewallEndpointAssociations []*FirewallEndpointAssociation `json:"firewallEndpointAssociations,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "FirewallEndpointAssociations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirewallEndpointAssociations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFirewallEndpointAssociationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFirewallEndpointAssociationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFirewallEndpointsResponse: Message for response to listing Endpoints
type ListFirewallEndpointsResponse struct {
	// FirewallEndpoints: The list of Endpoint
	FirewallEndpoints []*FirewallEndpoint `json:"firewallEndpoints,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FirewallEndpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirewallEndpoints") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFirewallEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFirewallEndpointsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGatewaySecurityPoliciesResponse: Response returned by the
// ListGatewaySecurityPolicies method.
type ListGatewaySecurityPoliciesResponse struct {
	// GatewaySecurityPolicies: List of GatewaySecurityPolicies resources.
	GatewaySecurityPolicies []*GatewaySecurityPolicy `json:"gatewaySecurityPolicies,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then 'next_page_token' is included. To get the next set of
	// results, call this method again using the value of 'next_page_token' as
	// 'page_token'.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GatewaySecurityPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GatewaySecurityPolicies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGatewaySecurityPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGatewaySecurityPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGatewaySecurityPolicyRulesResponse: Response returned by the
// ListGatewaySecurityPolicyRules method.
type ListGatewaySecurityPolicyRulesResponse struct {
	// GatewaySecurityPolicyRules: List of GatewaySecurityPolicyRule resources.
	GatewaySecurityPolicyRules []*GatewaySecurityPolicyRule `json:"gatewaySecurityPolicyRules,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then 'next_page_token' is included. To get the next set of
	// results, call this method again using the value of 'next_page_token' as
	// 'page_token'.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GatewaySecurityPolicyRules")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GatewaySecurityPolicyRules") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGatewaySecurityPolicyRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGatewaySecurityPolicyRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInterceptDeploymentGroupsResponse: Response message for
// ListInterceptDeploymentGroups.
type ListInterceptDeploymentGroupsResponse struct {
	// InterceptDeploymentGroups: The deployment groups from the specified parent.
	InterceptDeploymentGroups []*InterceptDeploymentGroup `json:"interceptDeploymentGroups,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InterceptDeploymentGroups")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InterceptDeploymentGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInterceptDeploymentGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInterceptDeploymentGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInterceptDeploymentsResponse: Response message for
// ListInterceptDeployments.
type ListInterceptDeploymentsResponse struct {
	// InterceptDeployments: The deployments from the specified parent.
	InterceptDeployments []*InterceptDeployment `json:"interceptDeployments,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InterceptDeployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InterceptDeployments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInterceptDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInterceptDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInterceptEndpointGroupAssociationsResponse: Response message for
// ListInterceptEndpointGroupAssociations.
type ListInterceptEndpointGroupAssociationsResponse struct {
	// InterceptEndpointGroupAssociations: The associations from the specified
	// parent.
	InterceptEndpointGroupAssociations []*InterceptEndpointGroupAssociation `json:"interceptEndpointGroupAssociations,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "InterceptEndpointGroupAssociations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "InterceptEndpointGroupAssociations") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s ListInterceptEndpointGroupAssociationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInterceptEndpointGroupAssociationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInterceptEndpointGroupsResponse: Response message for
// ListInterceptEndpointGroups.
type ListInterceptEndpointGroupsResponse struct {
	// InterceptEndpointGroups: The endpoint groups from the specified parent.
	InterceptEndpointGroups []*InterceptEndpointGroup `json:"interceptEndpointGroups,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InterceptEndpointGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InterceptEndpointGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInterceptEndpointGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInterceptEndpointGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMirroringDeploymentGroupsResponse: Response message for
// ListMirroringDeploymentGroups.
type ListMirroringDeploymentGroupsResponse struct {
	// MirroringDeploymentGroups: The deployment groups from the specified parent.
	MirroringDeploymentGroups []*MirroringDeploymentGroup `json:"mirroringDeploymentGroups,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MirroringDeploymentGroups")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MirroringDeploymentGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMirroringDeploymentGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMirroringDeploymentGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMirroringDeploymentsResponse: Response message for
// ListMirroringDeployments.
type ListMirroringDeploymentsResponse struct {
	// MirroringDeployments: The deployments from the specified parent.
	MirroringDeployments []*MirroringDeployment `json:"mirroringDeployments,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MirroringDeployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MirroringDeployments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMirroringDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMirroringDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMirroringEndpointGroupAssociationsResponse: Response message for
// ListMirroringEndpointGroupAssociations.
type ListMirroringEndpointGroupAssociationsResponse struct {
	// MirroringEndpointGroupAssociations: The associations from the specified
	// parent.
	MirroringEndpointGroupAssociations []*MirroringEndpointGroupAssociation `json:"mirroringEndpointGroupAssociations,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "MirroringEndpointGroupAssociations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "MirroringEndpointGroupAssociations") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s ListMirroringEndpointGroupAssociationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMirroringEndpointGroupAssociationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMirroringEndpointGroupsResponse: Response message for
// ListMirroringEndpointGroups.
type ListMirroringEndpointGroupsResponse struct {
	// MirroringEndpointGroups: The endpoint groups from the specified parent.
	MirroringEndpointGroups []*MirroringEndpointGroup `json:"mirroringEndpointGroups,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages. See
	// https://google.aip.dev/158 for more details.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MirroringEndpointGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MirroringEndpointGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMirroringEndpointGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMirroringEndpointGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSecurityProfileGroupsResponse: Response returned by the
// ListSecurityProfileGroups method.
type ListSecurityProfileGroupsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SecurityProfileGroups: List of SecurityProfileGroups resources.
	SecurityProfileGroups []*SecurityProfileGroup `json:"securityProfileGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSecurityProfileGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSecurityProfileGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSecurityProfilesResponse: Response returned by the ListSecurityProfiles
// method.
type ListSecurityProfilesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SecurityProfiles: List of SecurityProfile resources.
	SecurityProfiles []*SecurityProfile `json:"securityProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSecurityProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSecurityProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListServerTlsPoliciesResponse: Response returned by the
// ListServerTlsPolicies method.
type ListServerTlsPoliciesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServerTlsPolicies: List of ServerTlsPolicy resources.
	ServerTlsPolicies []*ServerTlsPolicy `json:"serverTlsPolicies,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// `return_partial_success` and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListServerTlsPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListServerTlsPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTlsInspectionPoliciesResponse: Response returned by the
// ListTlsInspectionPolicies method.
type ListTlsInspectionPoliciesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then 'next_page_token' is included. To get the next set of
	// results, call this method again using the value of 'next_page_token' as
	// 'page_token'.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TlsInspectionPolicies: List of TlsInspectionPolicies resources.
	TlsInspectionPolicies []*TlsInspectionPolicy `json:"tlsInspectionPolicies,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTlsInspectionPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTlsInspectionPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUrlListsResponse: Response returned by the ListUrlLists method.
type ListUrlListsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`
	// UrlLists: List of UrlList resources.
	UrlLists []*UrlList `json:"urlLists,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUrlListsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUrlListsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MTLSPolicy: Specification of the MTLSPolicy.
type MTLSPolicy struct {
	// ClientValidationCa: Required if the policy is to be used with Traffic
	// Director. For Application Load Balancers it must be empty. Defines the
	// mechanism to obtain the Certificate Authority certificate to validate the
	// client certificate.
	ClientValidationCa []*ValidationCA `json:"clientValidationCa,omitempty"`
	// ClientValidationMode: When the client presents an invalid certificate or no
	// certificate to the load balancer, the `client_validation_mode` specifies how
	// the client connection is handled. Required if the policy is to be used with
	// the Application Load Balancers. For Traffic Director it must be empty.
	//
	// Possible values:
	//   "CLIENT_VALIDATION_MODE_UNSPECIFIED" - Not allowed.
	//   "ALLOW_INVALID_OR_MISSING_CLIENT_CERT" - Allow connection even if
	// certificate chain validation of the client certificate failed or no client
	// certificate was presented. The proof of possession of the private key is
	// always checked if client certificate was presented. This mode requires the
	// backend to implement processing of data extracted from a client certificate
	// to authenticate the peer, or to reject connections if the client certificate
	// fingerprint is missing.
	//   "REJECT_INVALID" - Require a client certificate and allow connection to
	// the backend only if validation of the client certificate passed. If set,
	// requires a reference to non-empty TrustConfig specified in
	// `client_validation_trust_config`.
	ClientValidationMode string `json:"clientValidationMode,omitempty"`
	// ClientValidationTrustConfig: Reference to the TrustConfig from
	// certificatemanager.googleapis.com namespace. If specified, the chain
	// validation will be performed against certificates configured in the given
	// TrustConfig. Allowed only if the policy is to be used with Application Load
	// Balancers.
	ClientValidationTrustConfig string `json:"clientValidationTrustConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientValidationCa") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientValidationCa") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MTLSPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod MTLSPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringDeployment: A deployment represents a zonal mirroring backend ready
// to accept GENEVE-encapsulated replica traffic, e.g. a zonal instance group
// fronted by an internal passthrough load balancer. Deployments are always
// part of a global deployment group which represents a global mirroring
// service.
type MirroringDeployment struct {
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the deployment. Used as
	// additional context for the deployment.
	Description string `json:"description,omitempty"`
	// ForwardingRule: Required. Immutable. The regional forwarding rule that
	// fronts the mirroring collectors, for example:
	// `projects/123456789/regions/us-central1/forwardingRules/my-rule`. See
	// https://google.aip.dev/124.
	ForwardingRule string `json:"forwardingRule,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// MirroringDeploymentGroup: Required. Immutable. The deployment group that
	// this deployment is a part of, for example:
	// `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	MirroringDeploymentGroup string `json:"mirroringDeploymentGroup,omitempty"`
	// Name: Immutable. Identifier. The resource name of this deployment, for
	// example:
	// `projects/123456789/locations/us-central1-a/mirroringDeployments/my-dep`.
	// See https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// part of the normal operation (e.g. linking a new association to the parent
	// group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the deployment. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment is ready and in sync with the parent group.
	//   "CREATING" - The deployment is being created.
	//   "DELETING" - The deployment is being deleted.
	//   "OUT_OF_SYNC" - The deployment is out of sync with the parent group. In
	// most cases, this is a result of a transient issue within the system (e.g. a
	// delayed data-path config) and the system is expected to recover
	// automatically. See the parent deployment group's state for more details.
	//   "DELETE_FAILED" - An attempt to delete the deployment has failed. This is
	// a terminal state and the deployment is not expected to recover. The only
	// permitted operation is to retry deleting the deployment.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringDeploymentGroup: A deployment group aggregates many zonal mirroring
// backends (deployments) into a single global mirroring service. Consumers can
// connect this service using an endpoint group.
type MirroringDeploymentGroup struct {
	// ConnectedEndpointGroups: Output only. The list of endpoint groups that are
	// connected to this resource.
	ConnectedEndpointGroups []*MirroringDeploymentGroupConnectedEndpointGroup `json:"connectedEndpointGroups,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the deployment group.
	// Used as additional context for the deployment group.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Locations: Output only. The list of locations where the deployment group is
	// present.
	Locations []*MirroringLocation `json:"locations,omitempty"`
	// Name: Immutable. Identifier. The resource name of this deployment group, for
	// example:
	// `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`. See
	// https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// NestedDeployments: Output only. The list of Mirroring Deployments that
	// belong to this group.
	NestedDeployments []*MirroringDeploymentGroupDeployment `json:"nestedDeployments,omitempty"`
	// Network: Required. Immutable. The network that will be used for all child
	// deployments, for example: `projects/{project}/global/networks/{network}`.
	// See https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// is part of the normal operation (e.g. adding a new deployment to the group)
	// See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the deployment group. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment group is ready.
	//   "CREATING" - The deployment group is being created.
	//   "DELETING" - The deployment group is being deleted.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConnectedEndpointGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectedEndpointGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringDeploymentGroup) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringDeploymentGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringDeploymentGroupConnectedEndpointGroup: An endpoint group connected
// to this deployment group.
type MirroringDeploymentGroupConnectedEndpointGroup struct {
	// Name: Output only. The connected endpoint group's resource name, for
	// example:
	// `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`. See
	// https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringDeploymentGroupConnectedEndpointGroup) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringDeploymentGroupConnectedEndpointGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringDeploymentGroupDeployment: A deployment belonging to this
// deployment group.
type MirroringDeploymentGroupDeployment struct {
	// Name: Output only. The name of the Mirroring Deployment, in the format:
	// `projects/{project}/locations/{location}/mirroringDeployments/{mirroring_depl
	// oyment}`.
	Name string `json:"name,omitempty"`
	// State: Output only. Most recent known state of the deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The deployment is ready and in sync with the parent group.
	//   "CREATING" - The deployment is being created.
	//   "DELETING" - The deployment is being deleted.
	//   "OUT_OF_SYNC" - The deployment is out of sync with the parent group. In
	// most cases, this is a result of a transient issue within the system (e.g. a
	// delayed data-path config) and the system is expected to recover
	// automatically. See the parent deployment group's state for more details.
	//   "DELETE_FAILED" - An attempt to delete the deployment has failed. This is
	// a terminal state and the deployment is not expected to recover. The only
	// permitted operation is to retry deleting the deployment.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringDeploymentGroupDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringDeploymentGroupDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringEndpointGroup: An endpoint group is a consumer frontend for a
// deployment group (backend). In order to configure mirroring for a network,
// consumers must create: - An association between their network and the
// endpoint group. - A security profile that points to the endpoint group. - A
// mirroring rule that references the security profile (group).
type MirroringEndpointGroup struct {
	// Associations: Output only. List of associations to this endpoint group.
	Associations []*MirroringEndpointGroupAssociationDetails `json:"associations,omitempty"`
	// ConnectedDeploymentGroups: Output only. List of details about the connected
	// deployment groups to this endpoint group.
	ConnectedDeploymentGroups []*MirroringEndpointGroupConnectedDeploymentGroup `json:"connectedDeploymentGroups,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the endpoint group. Used
	// as additional context for the endpoint group.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// MirroringDeploymentGroup: Immutable. The deployment group that this DIRECT
	// endpoint group is connected to, for example:
	// `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	MirroringDeploymentGroup string `json:"mirroringDeploymentGroup,omitempty"`
	// Name: Immutable. Identifier. The resource name of this endpoint group, for
	// example:
	// `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`. See
	// https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// is part of the normal operation (e.g. adding a new association to the
	// group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. The current state of the endpoint group. See
	// https://google.aip.dev/216.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The endpoint group is ready and in sync with the target
	// deployment group.
	//   "CLOSED" - The deployment group backing this endpoint group has been
	// force-deleted. This endpoint group cannot be used and mirroring is
	// effectively disabled.
	//   "CREATING" - The endpoint group is being created.
	//   "DELETING" - The endpoint group is being deleted.
	//   "OUT_OF_SYNC" - The endpoint group is out of sync with the backing
	// deployment group. In most cases, this is a result of a transient issue
	// within the system (e.g. an inaccessible location) and the system is expected
	// to recover automatically. See the associations field for details per network
	// and location.
	//   "DELETE_FAILED" - An attempt to delete the endpoint group has failed. This
	// is a terminal state and the endpoint group is not expected to recover. The
	// only permitted operation is to retry deleting the endpoint group.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Associations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringEndpointGroup) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringEndpointGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringEndpointGroupAssociation: An endpoint group association represents
// a link between a network and an endpoint group in the organization. Creating
// an association creates the networking infrastructure linking the network to
// the endpoint group, but does not enable mirroring by itself. To enable
// mirroring, the user must also create a network firewall policy containing
// mirroring rules and associate it with the network.
type MirroringEndpointGroupAssociation struct {
	// CreateTime: Output only. The timestamp when the resource was created. See
	// https://google.aip.dev/148#timestamps.
	CreateTime string `json:"createTime,omitempty"`
	// Labels: Optional. Labels are key/value pairs that help to organize and
	// filter resources.
	Labels map[string]string `json:"labels,omitempty"`
	// Locations: Output only. The list of locations where the association is
	// configured. This information is retrieved from the linked endpoint group.
	Locations []*MirroringLocation `json:"locations,omitempty"`
	// LocationsDetails: Output only. The list of locations where the association
	// is present. This information is retrieved from the linked endpoint group,
	// and not configured as part of the association itself.
	LocationsDetails []*MirroringEndpointGroupAssociationLocationDetails `json:"locationsDetails,omitempty"`
	// MirroringEndpointGroup: Immutable. The endpoint group that this association
	// is connected to, for example:
	// `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`. See
	// https://google.aip.dev/124.
	MirroringEndpointGroup string `json:"mirroringEndpointGroup,omitempty"`
	// Name: Immutable. Identifier. The resource name of this endpoint group
	// association, for example:
	// `projects/123456789/locations/global/mirroringEndpointGroupAssociations/my-eg
	// -association`. See https://google.aip.dev/122 for more details.
	Name string `json:"name,omitempty"`
	// Network: Immutable. The VPC network that is associated. for example:
	// `projects/123456789/global/networks/my-network`. See
	// https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// Reconciling: Output only. The current state of the resource does not match
	// the user's intended state, and the system is working to reconcile them. This
	// part of the normal operation (e.g. adding a new location to the target
	// deployment group). See https://google.aip.dev/128.
	Reconciling bool `json:"reconciling,omitempty"`
	// State: Output only. Current state of the endpoint group association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "CREATING" - The association is being created.
	//   "DELETING" - The association is being deleted.
	//   "CLOSED" - The association is disabled due to a breaking change in another
	// resource.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically. Check the `locations_details` field for more details.
	//   "DELETE_FAILED" - An attempt to delete the association has failed. This is
	// a terminal state and the association is not expected to be usable as some of
	// its resources have been deleted. The only permitted operation is to retry
	// deleting the association.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was most recently
	// updated. See https://google.aip.dev/148#timestamps.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringEndpointGroupAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringEndpointGroupAssociation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringEndpointGroupAssociationDetails: The endpoint group's view of a
// connected association.
type MirroringEndpointGroupAssociationDetails struct {
	// Name: Output only. The connected association's resource name, for example:
	// `projects/123456789/locations/global/mirroringEndpointGroupAssociations/my-eg
	// a`. See https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// Network: Output only. The associated network, for example:
	// projects/123456789/global/networks/my-network. See
	// https://google.aip.dev/124.
	Network string `json:"network,omitempty"`
	// State: Output only. Most recent known state of the association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "CREATING" - The association is being created.
	//   "DELETING" - The association is being deleted.
	//   "CLOSED" - The association is disabled due to a breaking change in another
	// resource.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically. Check the `locations_details` field for more details.
	//   "DELETE_FAILED" - An attempt to delete the association has failed. This is
	// a terminal state and the association is not expected to be usable as some of
	// its resources have been deleted. The only permitted operation is to retry
	// deleting the association.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringEndpointGroupAssociationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringEndpointGroupAssociationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringEndpointGroupAssociationLocationDetails: Contains details about the
// state of an association in a specific cloud location.
type MirroringEndpointGroupAssociationLocationDetails struct {
	// Location: Output only. The cloud location, e.g. "us-central1-a" or
	// "asia-south1".
	Location string `json:"location,omitempty"`
	// State: Output only. The current state of the association in this location.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "ACTIVE" - The association is ready and in sync with the linked endpoint
	// group.
	//   "OUT_OF_SYNC" - The association is out of sync with the linked endpoint
	// group. In most cases, this is a result of a transient issue within the
	// system (e.g. an inaccessible location) and the system is expected to recover
	// automatically.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringEndpointGroupAssociationLocationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringEndpointGroupAssociationLocationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringEndpointGroupConnectedDeploymentGroup: The endpoint group's view of
// a connected deployment group.
type MirroringEndpointGroupConnectedDeploymentGroup struct {
	// Locations: Output only. The list of locations where the deployment group is
	// present.
	Locations []*MirroringLocation `json:"locations,omitempty"`
	// Name: Output only. The connected deployment group's resource name, for
	// example:
	// `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`. See
	// https://google.aip.dev/124.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringEndpointGroupConnectedDeploymentGroup) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringEndpointGroupConnectedDeploymentGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MirroringLocation: Details about mirroring in a specific cloud location.
type MirroringLocation struct {
	// Location: Output only. The cloud location, e.g. "us-central1-a" or
	// "asia-south1".
	Location string `json:"location,omitempty"`
	// State: Output only. The current state of the association in this location.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set (this is not a valid state).
	//   "ACTIVE" - The resource is ready and in sync in the location.
	//   "OUT_OF_SYNC" - The resource is out of sync in the location. In most
	// cases, this is a result of a transient issue within the system (e.g. an
	// inaccessible location) and the system is expected to recover automatically.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MirroringLocation) MarshalJSON() ([]byte, error) {
	type NoMethod MirroringLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have Operation.error value with a google.rpc.Status.code of
	// 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveAddressGroupItemsRequest: Request used by the RemoveAddressGroupItems
// method.
type RemoveAddressGroupItemsRequest struct {
	// Items: Required. List of items to remove.
	Items []string `json:"items,omitempty"`
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveAddressGroupItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveAddressGroupItemsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Rule: Specification of rules.
type Rule struct {
	// Destinations: Optional. List of attributes for the traffic destination. All
	// of the destinations must match. A destination is a match if a request
	// matches all the specified hosts, ports, methods and headers. If not set, the
	// action specified in the 'action' field will be applied without any rule
	// checks for the destination.
	Destinations []*Destination `json:"destinations,omitempty"`
	// Sources: Optional. List of attributes for the traffic source. All of the
	// sources must match. A source is a match if both principals and ip_blocks
	// match. If not set, the action specified in the 'action' field will be
	// applied without any rule checks for the source.
	Sources []*Source `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destinations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destinations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Rule) MarshalJSON() ([]byte, error) {
	type NoMethod Rule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityProfile: SecurityProfile is a resource that defines the behavior for
// one of many ProfileTypes.
type SecurityProfile struct {
	// CreateTime: Output only. Resource creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// CustomInterceptProfile: The custom TPPI configuration for the
	// SecurityProfile.
	CustomInterceptProfile *CustomInterceptProfile `json:"customInterceptProfile,omitempty"`
	// CustomMirroringProfile: The custom Packet Mirroring v2 configuration for the
	// SecurityProfile.
	CustomMirroringProfile *CustomMirroringProfile `json:"customMirroringProfile,omitempty"`
	// Description: Optional. An optional description of the profile. Max length
	// 512 characters.
	Description string `json:"description,omitempty"`
	// Etag: Output only. This checksum is computed by the server based on the
	// value of other fields, and may be sent on update and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. Name of the SecurityProfile resource. It
	// matches pattern
	// `projects|organizations/*/locations/{location}/securityProfiles/{security_pro
	// file}`.
	Name string `json:"name,omitempty"`
	// ThreatPreventionProfile: The threat prevention configuration for the
	// SecurityProfile.
	ThreatPreventionProfile *ThreatPreventionProfile `json:"threatPreventionProfile,omitempty"`
	// Type: Immutable. The single ProfileType that the SecurityProfile resource
	// configures.
	//
	// Possible values:
	//   "PROFILE_TYPE_UNSPECIFIED" - Profile type not specified.
	//   "THREAT_PREVENTION" - Profile type for threat prevention.
	//   "CUSTOM_MIRRORING" - Profile type for packet mirroring v2
	//   "CUSTOM_INTERCEPT" - Profile type for TPPI.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Last resource update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityProfile) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityProfileGroup: SecurityProfileGroup is a resource that defines the
// behavior for various ProfileTypes.
type SecurityProfileGroup struct {
	// CreateTime: Output only. Resource creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// CustomInterceptProfile: Optional. Reference to a SecurityProfile with the
	// CustomIntercept configuration.
	CustomInterceptProfile string `json:"customInterceptProfile,omitempty"`
	// CustomMirroringProfile: Optional. Reference to a SecurityProfile with the
	// CustomMirroring configuration.
	CustomMirroringProfile string `json:"customMirroringProfile,omitempty"`
	// DataPathId: Output only. Identifier used by the data-path. Unique within
	// {container, location}.
	DataPathId uint64 `json:"dataPathId,omitempty,string"`
	// Description: Optional. An optional description of the profile group. Max
	// length 2048 characters.
	Description string `json:"description,omitempty"`
	// Etag: Output only. This checksum is computed by the server based on the
	// value of other fields, and may be sent on update and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Immutable. Identifier. Name of the SecurityProfileGroup resource. It
	// matches pattern
	// `projects|organizations/*/locations/{location}/securityProfileGroups/{securit
	// y_profile_group}`.
	Name string `json:"name,omitempty"`
	// ThreatPreventionProfile: Optional. Reference to a SecurityProfile with the
	// ThreatPrevention configuration.
	ThreatPreventionProfile string `json:"threatPreventionProfile,omitempty"`
	// UpdateTime: Output only. Last resource update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityProfileGroup) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityProfileGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServerTlsPolicy: ServerTlsPolicy is a resource that specifies how a server
// should authenticate incoming requests. This resource itself does not affect
// configuration unless it is attached to a target HTTPS proxy or endpoint
// config selector resource. ServerTlsPolicy in the form accepted by
// Application Load Balancers can be attached only to TargetHttpsProxy with an
// `EXTERNAL`, `EXTERNAL_MANAGED` or `INTERNAL_MANAGED` load balancing scheme.
// Traffic Director compatible ServerTlsPolicies can be attached to
// EndpointPolicy and TargetHttpsProxy with Traffic Director
// `INTERNAL_SELF_MANAGED` load balancing scheme.
type ServerTlsPolicy struct {
	// AllowOpen: This field applies only for Traffic Director policies. It is must
	// be set to false for Application Load Balancer policies. Determines if server
	// allows plaintext connections. If set to true, server allows plain text
	// connections. By default, it is set to false. This setting is not exclusive
	// of other encryption modes. For example, if `allow_open` and `mtls_policy`
	// are set, server allows both plain text and mTLS connections. See
	// documentation of other encryption modes to confirm compatibility. Consider
	// using it if you wish to upgrade in place your deployment to TLS while having
	// mixed TLS and non-TLS traffic reaching port :80.
	AllowOpen bool `json:"allowOpen,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Labels: Set of label tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// MtlsPolicy: This field is required if the policy is used with Application
	// Load Balancers. This field can be empty for Traffic Director. Defines a
	// mechanism to provision peer validation certificates for peer to peer
	// authentication (Mutual TLS - mTLS). If not specified, client certificate
	// will not be requested. The connection is treated as TLS and not mTLS. If
	// `allow_open` and `mtls_policy` are set, server allows both plain text and
	// mTLS connections.
	MtlsPolicy *MTLSPolicy `json:"mtlsPolicy,omitempty"`
	// Name: Required. Name of the ServerTlsPolicy resource. It matches the pattern
	// `projects/*/locations/{location}/serverTlsPolicies/{server_tls_policy}`
	Name string `json:"name,omitempty"`
	// ServerCertificate: Optional if policy is to be used with Traffic Director.
	// For Application Load Balancers must be empty. Defines a mechanism to
	// provision server identity (public and private keys). Cannot be combined with
	// `allow_open` as a permissive mode that allows both plain text and TLS is not
	// supported.
	ServerCertificate *GoogleCloudNetworksecurityV1CertificateProvider `json:"serverCertificate,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowOpen") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowOpen") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServerTlsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ServerTlsPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeverityOverride: Defines what action to take for a specific severity match.
type SeverityOverride struct {
	// Action: Required. Threat action override.
	//
	// Possible values:
	//   "THREAT_ACTION_UNSPECIFIED" - Threat action not specified.
	//   "DEFAULT_ACTION" - The default action (as specified by the vendor) is
	// taken.
	//   "ALLOW" - The packet matching this rule will be allowed to transmit.
	//   "ALERT" - The packet matching this rule will be allowed to transmit, but a
	// threat_log entry will be sent to the consumer project.
	//   "DENY" - The packet matching this rule will be dropped, and a threat_log
	// entry will be sent to the consumer project.
	Action string `json:"action,omitempty"`
	// Severity: Required. Severity level to match.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Severity level not specified.
	//   "INFORMATIONAL" - Suspicious events that do not pose an immediate threat,
	// but that are reported to call attention to deeper problems that could
	// possibly exist.
	//   "LOW" - Warning-level threats that have very little impact on an
	// organization's infrastructure. They usually require local or physical system
	// access and may often result in victim privacy issues and information
	// leakage.
	//   "MEDIUM" - Minor threats in which impact is minimized, that do not
	// compromise the target or exploits that require an attacker to reside on the
	// same local network as the victim, affect only non-standard configurations or
	// obscure applications, or provide very limited access.
	//   "HIGH" - Threats that have the ability to become critical but have
	// mitigating factors; for example, they may be difficult to exploit, do not
	// result in elevated privileges, or do not have a large victim pool.
	//   "CRITICAL" - Serious threats, such as those that affect default
	// installations of widely deployed software, result in root compromise of
	// servers, and the exploit code is widely available to attackers. The attacker
	// usually does not need any special authentication credentials or knowledge
	// about the individual victims and the target does not need to be manipulated
	// into performing any special functions.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SeverityOverride) MarshalJSON() ([]byte, error) {
	type NoMethod SeverityOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Source: Specification of traffic source attributes.
type Source struct {
	// IpBlocks: Optional. List of CIDR ranges to match based on source IP address.
	// At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
	// (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone
	// should be avoided. The IP addresses of any load balancers or proxies should
	// be considered untrusted.
	IpBlocks []string `json:"ipBlocks,omitempty"`
	// Principals: Optional. List of peer identities to match for authorization. At
	// least one principal should match. Each peer can be an exact match, or a
	// prefix match (example, "namespace/*") or a suffix match (example,
	// "*/service-account") or a presence match "*". Authorization based on the
	// principal name without certificate validation (configured by ServerTlsPolicy
	// resource) is considered insecure.
	Principals []string `json:"principals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpBlocks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpBlocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Source) MarshalJSON() ([]byte, error) {
	type NoMethod Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ThreatOverride: Defines what action to take for a specific threat_id match.
type ThreatOverride struct {
	// Action: Required. Threat action override. For some threat types, only a
	// subset of actions applies.
	//
	// Possible values:
	//   "THREAT_ACTION_UNSPECIFIED" - Threat action not specified.
	//   "DEFAULT_ACTION" - The default action (as specified by the vendor) is
	// taken.
	//   "ALLOW" - The packet matching this rule will be allowed to transmit.
	//   "ALERT" - The packet matching this rule will be allowed to transmit, but a
	// threat_log entry will be sent to the consumer project.
	//   "DENY" - The packet matching this rule will be dropped, and a threat_log
	// entry will be sent to the consumer project.
	Action string `json:"action,omitempty"`
	// ThreatId: Required. Vendor-specific ID of a threat to override.
	ThreatId string `json:"threatId,omitempty"`
	// Type: Output only. Type of the threat (read only).
	//
	// Possible values:
	//   "THREAT_TYPE_UNSPECIFIED" - Type of threat not specified.
	//   "UNKNOWN" - Type of threat is not derivable from threat ID. An override
	// will be created for all types. Firewall will ignore overridden signature
	// ID's that don't exist in the specific type.
	//   "VULNERABILITY" - Threats related to system flaws that an attacker might
	// otherwise attempt to exploit.
	//   "ANTIVIRUS" - Threats related to viruses and malware found in executables
	// and file types.
	//   "SPYWARE" - Threats related to command-and-control (C2) activity, where
	// spyware on an infected client is collecting data without the user's consent
	// and/or communicating with a remote attacker.
	//   "DNS" - Threats related to DNS.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ThreatOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ThreatOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ThreatPreventionProfile: ThreatPreventionProfile defines an action for
// specific threat signatures or severity levels.
type ThreatPreventionProfile struct {
	// AntivirusOverrides: Optional. Configuration for overriding antivirus actions
	// per protocol.
	AntivirusOverrides []*AntivirusOverride `json:"antivirusOverrides,omitempty"`
	// SeverityOverrides: Optional. Configuration for overriding threats actions by
	// severity match.
	SeverityOverrides []*SeverityOverride `json:"severityOverrides,omitempty"`
	// ThreatOverrides: Optional. Configuration for overriding threats actions by
	// threat_id match. If a threat is matched both by configuration provided in
	// severity_overrides and threat_overrides, the threat_overrides action is
	// applied.
	ThreatOverrides []*ThreatOverride `json:"threatOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AntivirusOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AntivirusOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ThreatPreventionProfile) MarshalJSON() ([]byte, error) {
	type NoMethod ThreatPreventionProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsInspectionPolicy: The TlsInspectionPolicy resource contains references to
// CA pools in Certificate Authority Service and associated metadata.
type TlsInspectionPolicy struct {
	// CaPool: Required. A CA pool resource used to issue interception
	// certificates. The CA pool string has a relative resource path following the
	// form "projects/{project}/locations/{location}/caPools/{ca_pool}".
	CaPool string `json:"caPool,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomTlsFeatures: Optional. List of custom TLS cipher suites selected. This
	// field is valid only if the selected tls_feature_profile is CUSTOM. The
	// compute.SslPoliciesService.ListAvailableFeatures method returns the set of
	// features that can be specified in this list. Note that Secure Web Proxy does
	// not yet honor this field.
	CustomTlsFeatures []string `json:"customTlsFeatures,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// ExcludePublicCaSet: Optional. If FALSE (the default), use our default set of
	// public CAs in addition to any CAs specified in trust_config. These public
	// CAs are currently based on the Mozilla Root Program and are subject to
	// change over time. If TRUE, do not accept our default set of public CAs. Only
	// CAs specified in trust_config will be accepted. This defaults to FALSE (use
	// public CAs in addition to trust_config) for backwards compatibility, but
	// trusting public root CAs is *not recommended* unless the traffic in question
	// is outbound to public web servers. When possible, prefer setting this to
	// "false" and explicitly specifying trusted CAs and certificates in a
	// TrustConfig. Note that Secure Web Proxy does not yet honor this field.
	ExcludePublicCaSet bool `json:"excludePublicCaSet,omitempty"`
	// MinTlsVersion: Optional. Minimum TLS version that the firewall should use
	// when negotiating connections with both clients and servers. If this is not
	// set, then the default value is to allow the broadest set of clients and
	// servers (TLS 1.0 or higher). Setting this to more restrictive values may
	// improve security, but may also prevent the firewall from connecting to some
	// clients or servers. Note that Secure Web Proxy does not yet honor this
	// field.
	//
	// Possible values:
	//   "TLS_VERSION_UNSPECIFIED" - Indicates no TLS version was specified.
	//   "TLS_1_0" - TLS 1.0
	//   "TLS_1_1" - TLS 1.1
	//   "TLS_1_2" - TLS 1.2
	//   "TLS_1_3" - TLS 1.3
	MinTlsVersion string `json:"minTlsVersion,omitempty"`
	// Name: Required. Name of the resource. Name is of the form
	// projects/{project}/locations/{location}/tlsInspectionPolicies/{tls_inspection
	// _policy} tls_inspection_policy should match the pattern:(^a-z
	// ([a-z0-9-]{0,61}[a-z0-9])?$).
	Name string `json:"name,omitempty"`
	// TlsFeatureProfile: Optional. The selected Profile. If this is not set, then
	// the default value is to allow the broadest set of clients and servers
	// ("PROFILE_COMPATIBLE"). Setting this to more restrictive values may improve
	// security, but may also prevent the TLS inspection proxy from connecting to
	// some clients or servers. Note that Secure Web Proxy does not yet honor this
	// field.
	//
	// Possible values:
	//   "PROFILE_UNSPECIFIED" - Indicates no profile was specified.
	//   "PROFILE_COMPATIBLE" - Compatible profile. Allows the broadest set of
	// clients, even those which support only out-of-date SSL features to negotiate
	// with the TLS inspection proxy.
	//   "PROFILE_MODERN" - Modern profile. Supports a wide set of SSL features,
	// allowing modern clients to negotiate SSL with the TLS inspection proxy.
	//   "PROFILE_RESTRICTED" - Restricted profile. Supports a reduced set of SSL
	// features, intended to meet stricter compliance requirements.
	//   "PROFILE_CUSTOM" - Custom profile. Allow only the set of allowed SSL
	// features specified in the custom_features field of SslPolicy.
	TlsFeatureProfile string `json:"tlsFeatureProfile,omitempty"`
	// TrustConfig: Optional. A TrustConfig resource used when making a connection
	// to the TLS server. This is a relative resource path following the form
	// "projects/{project}/locations/{location}/trustConfigs/{trust_config}". This
	// is necessary to intercept TLS connections to servers with certificates
	// signed by a private CA or self-signed certificates. Note that Secure Web
	// Proxy does not yet honor this field.
	TrustConfig string `json:"trustConfig,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CaPool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaPool") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsInspectionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod TlsInspectionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UrlList: UrlList proto helps users to set reusable, independently manageable
// lists of hosts, host patterns, URLs, URL patterns.
type UrlList struct {
	// CreateTime: Output only. Time when the security policy was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free-text description of the resource.
	Description string `json:"description,omitempty"`
	// Name: Required. Name of the resource provided by the user. Name is of the
	// form projects/{project}/locations/{location}/urlLists/{url_list} url_list
	// should match the pattern:(^a-z ([a-z0-9-]{0,61}[a-z0-9])?$).
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Time when the security policy was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Values: Required. FQDNs and URLs.
	Values []string `json:"values,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UrlList) MarshalJSON() ([]byte, error) {
	type NoMethod UrlList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationCA: Specification of ValidationCA. Defines the mechanism to obtain
// the Certificate Authority certificate to validate the peer certificate.
type ValidationCA struct {
	// CertificateProviderInstance: The certificate provider instance specification
	// that will be passed to the data plane, which will be used to load necessary
	// credential information.
	CertificateProviderInstance *CertificateProviderInstance `json:"certificateProviderInstance,omitempty"`
	// GrpcEndpoint: gRPC specific configuration to access the gRPC server to
	// obtain the CA certificate.
	GrpcEndpoint *GoogleCloudNetworksecurityV1GrpcEndpoint `json:"grpcEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CertificateProviderInstance") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateProviderInstance") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationCA) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationCA
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrganizationsLocationsAddressGroupsAddItemsCall struct {
	s                           *Service
	addressGroup                string
	addaddressgroupitemsrequest *AddAddressGroupItemsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// AddItems: Adds items to an address group.
//
//   - addressGroup: A name of the AddressGroup to add items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) AddItems(addressGroup string, addaddressgroupitemsrequest *AddAddressGroupItemsRequest) *OrganizationsLocationsAddressGroupsAddItemsCall {
	c := &OrganizationsLocationsAddressGroupsAddItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.addaddressgroupitemsrequest = addaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsAddItemsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsAddItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsAddItemsCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsAddItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsAddItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsAddItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:addItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.addItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.addItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsAddItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.addItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsCloneItemsCall struct {
	s                             *Service
	addressGroup                  string
	cloneaddressgroupitemsrequest *CloneAddressGroupItemsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// CloneItems: Clones items from one address group to another.
//
//   - addressGroup: A name of the AddressGroup to clone items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) CloneItems(addressGroup string, cloneaddressgroupitemsrequest *CloneAddressGroupItemsRequest) *OrganizationsLocationsAddressGroupsCloneItemsCall {
	c := &OrganizationsLocationsAddressGroupsCloneItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.cloneaddressgroupitemsrequest = cloneaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsCloneItemsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsCloneItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsCloneItemsCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsCloneItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsCloneItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsCloneItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cloneaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:cloneItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.cloneItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.cloneItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsCloneItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.cloneItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsCreateCall struct {
	s            *Service
	parent       string
	addressgroup *AddressGroup
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new address group in a given project and location.
//
//   - parent: The parent resource of the AddressGroup. Must be in the format
//     `projects/*/locations/{location}`.
func (r *OrganizationsLocationsAddressGroupsService) Create(parent string, addressgroup *AddressGroup) *OrganizationsLocationsAddressGroupsCreateCall {
	c := &OrganizationsLocationsAddressGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.addressgroup = addressgroup
	return c
}

// AddressGroupId sets the optional parameter "addressGroupId": Required. Short
// name of the AddressGroup resource to be created. This value should be 1-63
// characters long, containing only letters, numbers, hyphens, and underscores,
// and should not start with a number. E.g. "authz_policy".
func (c *OrganizationsLocationsAddressGroupsCreateCall) AddressGroupId(addressGroupId string) *OrganizationsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("addressGroupId", addressGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsAddressGroupsCreateCall) RequestId(requestId string) *OrganizationsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsCreateCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addressgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/addressGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an address group.
//
//   - name: A name of the AddressGroup to delete. Must be in the format
//     `projects/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) Delete(name string) *OrganizationsLocationsAddressGroupsDeleteCall {
	c := &OrganizationsLocationsAddressGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsAddressGroupsDeleteCall) RequestId(requestId string) *OrganizationsLocationsAddressGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single address group.
//
//   - name: A name of the AddressGroup to get. Must be in the format
//     `projects/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) Get(name string) *OrganizationsLocationsAddressGroupsGetCall {
	c := &OrganizationsLocationsAddressGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsAddressGroupsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsAddressGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsGetCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddressGroup.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsGetCall) Do(opts ...googleapi.CallOption) (*AddressGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddressGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists address groups in a given project and location.
//
//   - parent: The project and location from which the AddressGroups should be
//     listed, specified in the format `projects/*/locations/{location}`.
func (r *OrganizationsLocationsAddressGroupsService) List(parent string) *OrganizationsLocationsAddressGroupsListCall {
	c := &OrganizationsLocationsAddressGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// AddressGroups to return per call.
func (c *OrganizationsLocationsAddressGroupsListCall) PageSize(pageSize int64) *OrganizationsLocationsAddressGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAddressGroupsResponse` Indicates that this is a continuation of a
// prior `ListAddressGroups` call, and that the system should return the next
// page of data.
func (c *OrganizationsLocationsAddressGroupsListCall) PageToken(pageToken string) *OrganizationsLocationsAddressGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
func (c *OrganizationsLocationsAddressGroupsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *OrganizationsLocationsAddressGroupsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsAddressGroupsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsAddressGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsListCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/addressGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddressGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsListCall) Do(opts ...googleapi.CallOption) (*ListAddressGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddressGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsAddressGroupsListCall) Pages(ctx context.Context, f func(*ListAddressGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsAddressGroupsListReferencesCall struct {
	s            *Service
	addressGroup string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListReferences: Lists references of an address group.
//
//   - addressGroup: A name of the AddressGroup to clone items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) ListReferences(addressGroup string) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c := &OrganizationsLocationsAddressGroupsListReferencesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// references to return. If unspecified, server will pick an appropriate
// default. Server may return fewer items than requested. A caller should only
// rely on response's next_page_token to determine if there are more
// AddressGroupUsers left to be queried.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) PageSize(pageSize int64) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) PageToken(pageToken string) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) IfNoneMatch(entityTag string) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsListReferencesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsListReferencesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:listReferences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.listReferences", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.listReferences" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddressGroupReferencesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) Do(opts ...googleapi.CallOption) (*ListAddressGroupReferencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddressGroupReferencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.listReferences", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsAddressGroupsListReferencesCall) Pages(ctx context.Context, f func(*ListAddressGroupReferencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsAddressGroupsPatchCall struct {
	s            *Service
	name         string
	addressgroup *AddressGroup
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates parameters of an address group.
//
//   - name: Name of the AddressGroup resource. It matches pattern
//     `projects/*/locations/{location}/addressGroups/`.
func (r *OrganizationsLocationsAddressGroupsService) Patch(name string, addressgroup *AddressGroup) *OrganizationsLocationsAddressGroupsPatchCall {
	c := &OrganizationsLocationsAddressGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.addressgroup = addressgroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsAddressGroupsPatchCall) RequestId(requestId string) *OrganizationsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the AddressGroup resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *OrganizationsLocationsAddressGroupsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsPatchCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addressgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsAddressGroupsRemoveItemsCall struct {
	s                              *Service
	addressGroup                   string
	removeaddressgroupitemsrequest *RemoveAddressGroupItemsRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// RemoveItems: Removes items from an address group.
//
//   - addressGroup: A name of the AddressGroup to remove items from. Must be in
//     the format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *OrganizationsLocationsAddressGroupsService) RemoveItems(addressGroup string, removeaddressgroupitemsrequest *RemoveAddressGroupItemsRequest) *OrganizationsLocationsAddressGroupsRemoveItemsCall {
	c := &OrganizationsLocationsAddressGroupsRemoveItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.removeaddressgroupitemsrequest = removeaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAddressGroupsRemoveItemsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAddressGroupsRemoveItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAddressGroupsRemoveItemsCall) Context(ctx context.Context) *OrganizationsLocationsAddressGroupsRemoveItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAddressGroupsRemoveItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAddressGroupsRemoveItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:removeItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.removeItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.addressGroups.removeItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsAddressGroupsRemoveItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.addressGroups.removeItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFirewallEndpointsCreateCall struct {
	s                *Service
	parent           string
	firewallendpoint *FirewallEndpoint
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new FirewallEndpoint in a given project and location.
//
// - parent: Value for parent.
func (r *OrganizationsLocationsFirewallEndpointsService) Create(parent string, firewallendpoint *FirewallEndpoint) *OrganizationsLocationsFirewallEndpointsCreateCall {
	c := &OrganizationsLocationsFirewallEndpointsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.firewallendpoint = firewallendpoint
	return c
}

// FirewallEndpointId sets the optional parameter "firewallEndpointId":
// Required. Id of the requesting object. If auto-generating Id server-side,
// remove this field and firewall_endpoint_id from the method_signature of
// Create RPC.
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) FirewallEndpointId(firewallEndpointId string) *OrganizationsLocationsFirewallEndpointsCreateCall {
	c.urlParams_.Set("firewallEndpointId", firewallEndpointId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) RequestId(requestId string) *OrganizationsLocationsFirewallEndpointsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFirewallEndpointsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) Context(ctx context.Context) *OrganizationsLocationsFirewallEndpointsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFirewallEndpointsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallendpoint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/firewallEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.firewallEndpoints.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsFirewallEndpointsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFirewallEndpointsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Endpoint.
//
// - name: Name of the resource.
func (r *OrganizationsLocationsFirewallEndpointsService) Delete(name string) *OrganizationsLocationsFirewallEndpointsDeleteCall {
	c := &OrganizationsLocationsFirewallEndpointsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) RequestId(requestId string) *OrganizationsLocationsFirewallEndpointsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFirewallEndpointsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsFirewallEndpointsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.firewallEndpoints.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsFirewallEndpointsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFirewallEndpointsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Endpoint.
//
// - name: Name of the resource.
func (r *OrganizationsLocationsFirewallEndpointsService) Get(name string) *OrganizationsLocationsFirewallEndpointsGetCall {
	c := &OrganizationsLocationsFirewallEndpointsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFirewallEndpointsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFirewallEndpointsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsFirewallEndpointsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsFirewallEndpointsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFirewallEndpointsGetCall) Context(ctx context.Context) *OrganizationsLocationsFirewallEndpointsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFirewallEndpointsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFirewallEndpointsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.firewallEndpoints.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallEndpoint.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsFirewallEndpointsGetCall) Do(opts ...googleapi.CallOption) (*FirewallEndpoint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallEndpoint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFirewallEndpointsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists FirewallEndpoints in a given project and location.
//
// - parent: Parent value for ListEndpointsRequest.
func (r *OrganizationsLocationsFirewallEndpointsService) List(parent string) *OrganizationsLocationsFirewallEndpointsListCall {
	c := &OrganizationsLocationsFirewallEndpointsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *OrganizationsLocationsFirewallEndpointsListCall) Filter(filter string) *OrganizationsLocationsFirewallEndpointsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *OrganizationsLocationsFirewallEndpointsListCall) OrderBy(orderBy string) *OrganizationsLocationsFirewallEndpointsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *OrganizationsLocationsFirewallEndpointsListCall) PageSize(pageSize int64) *OrganizationsLocationsFirewallEndpointsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *OrganizationsLocationsFirewallEndpointsListCall) PageToken(pageToken string) *OrganizationsLocationsFirewallEndpointsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFirewallEndpointsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFirewallEndpointsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsFirewallEndpointsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsFirewallEndpointsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFirewallEndpointsListCall) Context(ctx context.Context) *OrganizationsLocationsFirewallEndpointsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFirewallEndpointsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFirewallEndpointsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/firewallEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.firewallEndpoints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFirewallEndpointsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsFirewallEndpointsListCall) Do(opts ...googleapi.CallOption) (*ListFirewallEndpointsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFirewallEndpointsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsFirewallEndpointsListCall) Pages(ctx context.Context, f func(*ListFirewallEndpointsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsFirewallEndpointsPatchCall struct {
	s                *Service
	name             string
	firewallendpoint *FirewallEndpoint
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Update a single Endpoint.
//
// - name: Immutable. Identifier. Name of resource.
func (r *OrganizationsLocationsFirewallEndpointsService) Patch(name string, firewallendpoint *FirewallEndpoint) *OrganizationsLocationsFirewallEndpointsPatchCall {
	c := &OrganizationsLocationsFirewallEndpointsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.firewallendpoint = firewallendpoint
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) RequestId(requestId string) *OrganizationsLocationsFirewallEndpointsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Endpoint resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsFirewallEndpointsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFirewallEndpointsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) Context(ctx context.Context) *OrganizationsLocationsFirewallEndpointsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFirewallEndpointsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallendpoint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.firewallEndpoints.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsFirewallEndpointsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.firewallEndpoints.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *OrganizationsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *OrganizationsLocationsOperationsCancelCall {
	c := &OrganizationsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsCancelCall) Context(ctx context.Context) *OrganizationsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *OrganizationsLocationsOperationsService) Delete(name string) *OrganizationsLocationsOperationsDeleteCall {
	c := &OrganizationsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsOperationsService) Get(name string) *OrganizationsLocationsOperationsGetCall {
	c := &OrganizationsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *OrganizationsLocationsOperationsService) List(name string) *OrganizationsLocationsOperationsListCall {
	c := &OrganizationsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *OrganizationsLocationsOperationsListCall) Filter(filter string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *OrganizationsLocationsOperationsListCall) PageSize(pageSize int64) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *OrganizationsLocationsOperationsListCall) PageToken(pageToken string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOperationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOperationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOperationsListCall) Context(ctx context.Context) *OrganizationsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsSecurityProfileGroupsCreateCall struct {
	s                    *Service
	parent               string
	securityprofilegroup *SecurityProfileGroup
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Creates a new SecurityProfileGroup in a given organization and
// location.
//
//   - parent: The parent resource of the SecurityProfileGroup. Must be in the
//     format `projects|organizations/*/locations/{location}`.
func (r *OrganizationsLocationsSecurityProfileGroupsService) Create(parent string, securityprofilegroup *SecurityProfileGroup) *OrganizationsLocationsSecurityProfileGroupsCreateCall {
	c := &OrganizationsLocationsSecurityProfileGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.securityprofilegroup = securityprofilegroup
	return c
}

// SecurityProfileGroupId sets the optional parameter "securityProfileGroupId":
// Required. Short name of the SecurityProfileGroup resource to be created.
// This value should be 1-63 characters long, containing only letters, numbers,
// hyphens, and underscores, and should not start with a number. E.g.
// "security_profile_group1".
func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) SecurityProfileGroupId(securityProfileGroupId string) *OrganizationsLocationsSecurityProfileGroupsCreateCall {
	c.urlParams_.Set("securityProfileGroupId", securityProfileGroupId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfileGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfileGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.securityprofilegroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/securityProfileGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfileGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfileGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfileGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single SecurityProfileGroup.
//
//   - name: A name of the SecurityProfileGroup to delete. Must be in the format
//     `projects|organizations/*/locations/{location}/securityProfileGroups/{secur
//     ity_profile_group}`.
func (r *OrganizationsLocationsSecurityProfileGroupsService) Delete(name string) *OrganizationsLocationsSecurityProfileGroupsDeleteCall {
	c := &OrganizationsLocationsSecurityProfileGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If client provided etag is out of
// date, delete will return FAILED_PRECONDITION error.
func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) Etag(etag string) *OrganizationsLocationsSecurityProfileGroupsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfileGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfileGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfileGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfileGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfileGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single SecurityProfileGroup.
//
//   - name: A name of the SecurityProfileGroup to get. Must be in the format
//     `projects|organizations/*/locations/{location}/securityProfileGroups/{secur
//     ity_profile_group}`.
func (r *OrganizationsLocationsSecurityProfileGroupsService) Get(name string) *OrganizationsLocationsSecurityProfileGroupsGetCall {
	c := &OrganizationsLocationsSecurityProfileGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfileGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsSecurityProfileGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfileGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfileGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SecurityProfileGroup.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsSecurityProfileGroupsGetCall) Do(opts ...googleapi.CallOption) (*SecurityProfileGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecurityProfileGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfileGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists SecurityProfileGroups in a given organization and location.
//
//   - parent: The project or organization and location from which the
//     SecurityProfileGroups should be listed, specified in the format
//     `projects|organizations/*/locations/{location}`.
func (r *OrganizationsLocationsSecurityProfileGroupsService) List(parent string) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c := &OrganizationsLocationsSecurityProfileGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// SecurityProfileGroups to return per call.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) PageSize(pageSize int64) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListSecurityProfileGroupsResponse` Indicates that this is a
// continuation of a prior `ListSecurityProfileGroups` call, and that the
// system should return the next page of data.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) PageToken(pageToken string) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfileGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfileGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/securityProfileGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfileGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSecurityProfileGroupsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) Do(opts ...googleapi.CallOption) (*ListSecurityProfileGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSecurityProfileGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsSecurityProfileGroupsListCall) Pages(ctx context.Context, f func(*ListSecurityProfileGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsSecurityProfileGroupsPatchCall struct {
	s                    *Service
	name                 string
	securityprofilegroup *SecurityProfileGroup
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates the parameters of a single SecurityProfileGroup.
//
//   - name: Immutable. Identifier. Name of the SecurityProfileGroup resource. It
//     matches pattern
//     `projects|organizations/*/locations/{location}/securityProfileGroups/{secur
//     ity_profile_group}`.
func (r *OrganizationsLocationsSecurityProfileGroupsService) Patch(name string, securityprofilegroup *SecurityProfileGroup) *OrganizationsLocationsSecurityProfileGroupsPatchCall {
	c := &OrganizationsLocationsSecurityProfileGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securityprofilegroup = securityprofilegroup
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the SecurityProfileGroup
// resource by the update. The fields specified in the update_mask are relative
// to the resource, not the full request. A field will be overwritten if it is
// in the mask.
func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsSecurityProfileGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfileGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfileGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.securityprofilegroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfileGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfileGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfileGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfilesCreateCall struct {
	s               *Service
	parent          string
	securityprofile *SecurityProfile
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new SecurityProfile in a given organization and location.
//
//   - parent: The parent resource of the SecurityProfile. Must be in the format
//     `projects|organizations/*/locations/{location}`.
func (r *OrganizationsLocationsSecurityProfilesService) Create(parent string, securityprofile *SecurityProfile) *OrganizationsLocationsSecurityProfilesCreateCall {
	c := &OrganizationsLocationsSecurityProfilesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.securityprofile = securityprofile
	return c
}

// SecurityProfileId sets the optional parameter "securityProfileId": Required.
// Short name of the SecurityProfile resource to be created. This value should
// be 1-63 characters long, containing only letters, numbers, hyphens, and
// underscores, and should not start with a number. E.g. "security_profile1".
func (c *OrganizationsLocationsSecurityProfilesCreateCall) SecurityProfileId(securityProfileId string) *OrganizationsLocationsSecurityProfilesCreateCall {
	c.urlParams_.Set("securityProfileId", securityProfileId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfilesCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfilesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfilesCreateCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfilesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfilesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfilesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.securityprofile)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/securityProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfiles.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfilesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single SecurityProfile.
//
//   - name: A name of the SecurityProfile to delete. Must be in the format
//     `projects|organizations/*/locations/{location}/securityProfiles/{security_p
//     rofile_id}`.
func (r *OrganizationsLocationsSecurityProfilesService) Delete(name string) *OrganizationsLocationsSecurityProfilesDeleteCall {
	c := &OrganizationsLocationsSecurityProfilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If client provided etag is out of
// date, delete will return FAILED_PRECONDITION error.
func (c *OrganizationsLocationsSecurityProfilesDeleteCall) Etag(etag string) *OrganizationsLocationsSecurityProfilesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfilesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfilesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfilesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single SecurityProfile.
//
//   - name: A name of the SecurityProfile to get. Must be in the format
//     `projects|organizations/*/locations/{location}/securityProfiles/{security_p
//     rofile_id}`.
func (r *OrganizationsLocationsSecurityProfilesService) Get(name string) *OrganizationsLocationsSecurityProfilesGetCall {
	c := &OrganizationsLocationsSecurityProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfilesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsSecurityProfilesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsSecurityProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfilesGetCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SecurityProfile.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsSecurityProfilesGetCall) Do(opts ...googleapi.CallOption) (*SecurityProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SecurityProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsSecurityProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists SecurityProfiles in a given organization and location.
//
//   - parent: The project or organization and location from which the
//     SecurityProfiles should be listed, specified in the format
//     `projects|organizations/*/locations/{location}`.
func (r *OrganizationsLocationsSecurityProfilesService) List(parent string) *OrganizationsLocationsSecurityProfilesListCall {
	c := &OrganizationsLocationsSecurityProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// SecurityProfiles to return per call.
func (c *OrganizationsLocationsSecurityProfilesListCall) PageSize(pageSize int64) *OrganizationsLocationsSecurityProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListSecurityProfilesResponse` Indicates that this is a continuation of
// a prior `ListSecurityProfiles` call, and that the system should return the
// next page of data.
func (c *OrganizationsLocationsSecurityProfilesListCall) PageToken(pageToken string) *OrganizationsLocationsSecurityProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfilesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsSecurityProfilesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsSecurityProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfilesListCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/securityProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSecurityProfilesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfilesListCall) Do(opts ...googleapi.CallOption) (*ListSecurityProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSecurityProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsSecurityProfilesListCall) Pages(ctx context.Context, f func(*ListSecurityProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsSecurityProfilesPatchCall struct {
	s               *Service
	name            string
	securityprofile *SecurityProfile
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of a single SecurityProfile.
//
//   - name: Immutable. Identifier. Name of the SecurityProfile resource. It
//     matches pattern
//     `projects|organizations/*/locations/{location}/securityProfiles/{security_p
//     rofile}`.
func (r *OrganizationsLocationsSecurityProfilesService) Patch(name string, securityprofile *SecurityProfile) *OrganizationsLocationsSecurityProfilesPatchCall {
	c := &OrganizationsLocationsSecurityProfilesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securityprofile = securityprofile
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the SecurityProfile resource
// by the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask.
func (c *OrganizationsLocationsSecurityProfilesPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsSecurityProfilesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsSecurityProfilesPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsSecurityProfilesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsSecurityProfilesPatchCall) Context(ctx context.Context) *OrganizationsLocationsSecurityProfilesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsSecurityProfilesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsSecurityProfilesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.securityprofile)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.organizations.locations.securityProfiles.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsSecurityProfilesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.organizations.locations.securityProfiles.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Unless
// explicitly documented otherwise, don't use this unsupported field which is
// primarily intended for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAddressGroupsAddItemsCall struct {
	s                           *Service
	addressGroup                string
	addaddressgroupitemsrequest *AddAddressGroupItemsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// AddItems: Adds items to an address group.
//
//   - addressGroup: A name of the AddressGroup to add items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) AddItems(addressGroup string, addaddressgroupitemsrequest *AddAddressGroupItemsRequest) *ProjectsLocationsAddressGroupsAddItemsCall {
	c := &ProjectsLocationsAddressGroupsAddItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.addaddressgroupitemsrequest = addaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsAddItemsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsAddItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsAddItemsCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsAddItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsAddItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsAddItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:addItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.addItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.addItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsAddItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.addItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsCloneItemsCall struct {
	s                             *Service
	addressGroup                  string
	cloneaddressgroupitemsrequest *CloneAddressGroupItemsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// CloneItems: Clones items from one address group to another.
//
//   - addressGroup: A name of the AddressGroup to clone items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) CloneItems(addressGroup string, cloneaddressgroupitemsrequest *CloneAddressGroupItemsRequest) *ProjectsLocationsAddressGroupsCloneItemsCall {
	c := &ProjectsLocationsAddressGroupsCloneItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.cloneaddressgroupitemsrequest = cloneaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsCloneItemsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsCloneItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsCloneItemsCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsCloneItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsCloneItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsCloneItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cloneaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:cloneItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.cloneItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.cloneItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsCloneItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.cloneItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsCreateCall struct {
	s            *Service
	parent       string
	addressgroup *AddressGroup
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new address group in a given project and location.
//
//   - parent: The parent resource of the AddressGroup. Must be in the format
//     `projects/*/locations/{location}`.
func (r *ProjectsLocationsAddressGroupsService) Create(parent string, addressgroup *AddressGroup) *ProjectsLocationsAddressGroupsCreateCall {
	c := &ProjectsLocationsAddressGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.addressgroup = addressgroup
	return c
}

// AddressGroupId sets the optional parameter "addressGroupId": Required. Short
// name of the AddressGroup resource to be created. This value should be 1-63
// characters long, containing only letters, numbers, hyphens, and underscores,
// and should not start with a number. E.g. "authz_policy".
func (c *ProjectsLocationsAddressGroupsCreateCall) AddressGroupId(addressGroupId string) *ProjectsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("addressGroupId", addressGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAddressGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addressgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/addressGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single address group.
//
//   - name: A name of the AddressGroup to delete. Must be in the format
//     `projects/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) Delete(name string) *ProjectsLocationsAddressGroupsDeleteCall {
	c := &ProjectsLocationsAddressGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAddressGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsAddressGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single address group.
//
//   - name: A name of the AddressGroup to get. Must be in the format
//     `projects/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) Get(name string) *ProjectsLocationsAddressGroupsGetCall {
	c := &ProjectsLocationsAddressGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAddressGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAddressGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddressGroup.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsGetCall) Do(opts ...googleapi.CallOption) (*AddressGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddressGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAddressGroupsService) GetIamPolicy(resource string) *ProjectsLocationsAddressGroupsGetIamPolicyCall {
	c := &ProjectsLocationsAddressGroupsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsAddressGroupsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsAddressGroupsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAddressGroupsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists address groups in a given project and location.
//
//   - parent: The project and location from which the AddressGroups should be
//     listed, specified in the format `projects/*/locations/{location}`.
func (r *ProjectsLocationsAddressGroupsService) List(parent string) *ProjectsLocationsAddressGroupsListCall {
	c := &ProjectsLocationsAddressGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// AddressGroups to return per call.
func (c *ProjectsLocationsAddressGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsAddressGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAddressGroupsResponse` Indicates that this is a continuation of a
// prior `ListAddressGroups` call, and that the system should return the next
// page of data.
func (c *ProjectsLocationsAddressGroupsListCall) PageToken(pageToken string) *ProjectsLocationsAddressGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
func (c *ProjectsLocationsAddressGroupsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsAddressGroupsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAddressGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAddressGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsListCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/addressGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddressGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsListCall) Do(opts ...googleapi.CallOption) (*ListAddressGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddressGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAddressGroupsListCall) Pages(ctx context.Context, f func(*ListAddressGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAddressGroupsListReferencesCall struct {
	s            *Service
	addressGroup string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListReferences: Lists references of an address group.
//
//   - addressGroup: A name of the AddressGroup to clone items to. Must be in the
//     format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) ListReferences(addressGroup string) *ProjectsLocationsAddressGroupsListReferencesCall {
	c := &ProjectsLocationsAddressGroupsListReferencesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// references to return. If unspecified, server will pick an appropriate
// default. Server may return fewer items than requested. A caller should only
// rely on response's next_page_token to determine if there are more
// AddressGroupUsers left to be queried.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) PageSize(pageSize int64) *ProjectsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) PageToken(pageToken string) *ProjectsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsListReferencesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) IfNoneMatch(entityTag string) *ProjectsLocationsAddressGroupsListReferencesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsListReferencesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsListReferencesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:listReferences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.listReferences", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.listReferences" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddressGroupReferencesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) Do(opts ...googleapi.CallOption) (*ListAddressGroupReferencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddressGroupReferencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.listReferences", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAddressGroupsListReferencesCall) Pages(ctx context.Context, f func(*ListAddressGroupReferencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAddressGroupsPatchCall struct {
	s            *Service
	name         string
	addressgroup *AddressGroup
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the parameters of a single address group.
//
//   - name: Name of the AddressGroup resource. It matches pattern
//     `projects/*/locations/{location}/addressGroups/`.
func (r *ProjectsLocationsAddressGroupsService) Patch(name string, addressgroup *AddressGroup) *ProjectsLocationsAddressGroupsPatchCall {
	c := &ProjectsLocationsAddressGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.addressgroup = addressgroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAddressGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the AddressGroup resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsAddressGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addressgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsRemoveItemsCall struct {
	s                              *Service
	addressGroup                   string
	removeaddressgroupitemsrequest *RemoveAddressGroupItemsRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// RemoveItems: Removes items from an address group.
//
//   - addressGroup: A name of the AddressGroup to remove items from. Must be in
//     the format `projects|organization/*/locations/{location}/addressGroups/*`.
func (r *ProjectsLocationsAddressGroupsService) RemoveItems(addressGroup string, removeaddressgroupitemsrequest *RemoveAddressGroupItemsRequest) *ProjectsLocationsAddressGroupsRemoveItemsCall {
	c := &ProjectsLocationsAddressGroupsRemoveItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.addressGroup = addressGroup
	c.removeaddressgroupitemsrequest = removeaddressgroupitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsRemoveItemsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsRemoveItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsRemoveItemsCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsRemoveItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsRemoveItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsRemoveItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeaddressgroupitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+addressGroup}:removeItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"addressGroup": c.addressGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.removeItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.removeItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsRemoveItemsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.removeItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAddressGroupsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsAddressGroupsSetIamPolicyCall {
	c := &ProjectsLocationsAddressGroupsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAddressGroupsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAddressGroupsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsAddressGroupsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsAddressGroupsTestIamPermissionsCall {
	c := &ProjectsLocationsAddressGroupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAddressGroupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAddressGroupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAddressGroupsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAddressGroupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAddressGroupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAddressGroupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.addressGroups.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAddressGroupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.addressGroups.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesCreateCall struct {
	s                   *Service
	parent              string
	authorizationpolicy *AuthorizationPolicy
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a new AuthorizationPolicy in a given project and location.
//
//   - parent: The parent resource of the AuthorizationPolicy. Must be in the
//     format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthorizationPoliciesService) Create(parent string, authorizationpolicy *AuthorizationPolicy) *ProjectsLocationsAuthorizationPoliciesCreateCall {
	c := &ProjectsLocationsAuthorizationPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.authorizationpolicy = authorizationpolicy
	return c
}

// AuthorizationPolicyId sets the optional parameter "authorizationPolicyId":
// Required. Short name of the AuthorizationPolicy resource to be created. This
// value should be 1-63 characters long, containing only letters, numbers,
// hyphens, and underscores, and should not start with a number. E.g.
// "authz_policy".
func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) AuthorizationPolicyId(authorizationPolicyId string) *ProjectsLocationsAuthorizationPoliciesCreateCall {
	c.urlParams_.Set("authorizationPolicyId", authorizationPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authorizationpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizationPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizationPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single AuthorizationPolicy.
//
//   - name: A name of the AuthorizationPolicy to delete. Must be in the format
//     `projects/{project}/locations/{location}/authorizationPolicies/*`.
func (r *ProjectsLocationsAuthorizationPoliciesService) Delete(name string) *ProjectsLocationsAuthorizationPoliciesDeleteCall {
	c := &ProjectsLocationsAuthorizationPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizationPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single AuthorizationPolicy.
//
//   - name: A name of the AuthorizationPolicy to get. Must be in the format
//     `projects/{project}/locations/{location}/authorizationPolicies/*`.
func (r *ProjectsLocationsAuthorizationPoliciesService) Get(name string) *ProjectsLocationsAuthorizationPoliciesGetCall {
	c := &ProjectsLocationsAuthorizationPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizationPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizationPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuthorizationPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizationPoliciesGetCall) Do(opts ...googleapi.CallOption) (*AuthorizationPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuthorizationPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthorizationPoliciesService) GetIamPolicy(resource string) *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall {
	c := &ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizationPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists AuthorizationPolicies in a given project and location.
//
//   - parent: The project and location from which the AuthorizationPolicies
//     should be listed, specified in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthorizationPoliciesService) List(parent string) *ProjectsLocationsAuthorizationPoliciesListCall {
	c := &ProjectsLocationsAuthorizationPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// AuthorizationPolicies to return per call.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizationPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAuthorizationPoliciesResponse` Indicates that this is a
// continuation of a prior `ListAuthorizationPolicies` call, and that the
// system should return the next page of data.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizationPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizationPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizationPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthorizationPoliciesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListAuthorizationPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthorizationPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizationPoliciesListCall) Pages(ctx context.Context, f func(*ListAuthorizationPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizationPoliciesPatchCall struct {
	s                   *Service
	name                string
	authorizationpolicy *AuthorizationPolicy
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates the parameters of a single AuthorizationPolicy.
//
//   - name: Name of the AuthorizationPolicy resource. It matches pattern
//     `projects/{project}/locations/{location}/authorizationPolicies/`.
func (r *ProjectsLocationsAuthorizationPoliciesService) Patch(name string, authorizationpolicy *AuthorizationPolicy) *ProjectsLocationsAuthorizationPoliciesPatchCall {
	c := &ProjectsLocationsAuthorizationPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.authorizationpolicy = authorizationpolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the AuthorizationPolicy resource by
// the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthorizationPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authorizationpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizationPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthorizationPoliciesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall {
	c := &ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizationPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsAuthorizationPoliciesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall {
	c := &ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authorizationPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizationPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authorizationPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesCreateCall struct {
	s           *Service
	parent      string
	authzpolicy *AuthzPolicy
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new AuthzPolicy in a given project and location.
//
//   - parent: The parent resource of the `AuthzPolicy` resource. Must be in the
//     format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthzPoliciesService) Create(parent string, authzpolicy *AuthzPolicy) *ProjectsLocationsAuthzPoliciesCreateCall {
	c := &ProjectsLocationsAuthzPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.authzpolicy = authzpolicy
	return c
}

// AuthzPolicyId sets the optional parameter "authzPolicyId": Required.
// User-provided ID of the `AuthzPolicy` resource to be created.
func (c *ProjectsLocationsAuthzPoliciesCreateCall) AuthzPolicyId(authzPolicyId string) *ProjectsLocationsAuthzPoliciesCreateCall {
	c.urlParams_.Set("authzPolicyId", authzPolicyId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for at least 60 minutes since the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzPoliciesCreateCall) RequestId(requestId string) *ProjectsLocationsAuthzPoliciesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authzpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authzPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single AuthzPolicy.
//
//   - name: The name of the `AuthzPolicy` resource to delete. Must be in the
//     format
//     `projects/{project}/locations/{location}/authzPolicies/{authz_policy}`.
func (r *ProjectsLocationsAuthzPoliciesService) Delete(name string) *ProjectsLocationsAuthzPoliciesDeleteCall {
	c := &ProjectsLocationsAuthzPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for at least 60 minutes after the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzPoliciesDeleteCall) RequestId(requestId string) *ProjectsLocationsAuthzPoliciesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single AuthzPolicy.
//
//   - name: A name of the `AuthzPolicy` resource to get. Must be in the format
//     `projects/{project}/locations/{location}/authzPolicies/{authz_policy}`.
func (r *ProjectsLocationsAuthzPoliciesService) Get(name string) *ProjectsLocationsAuthzPoliciesGetCall {
	c := &ProjectsLocationsAuthzPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthzPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthzPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuthzPolicy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesGetCall) Do(opts ...googleapi.CallOption) (*AuthzPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuthzPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthzPoliciesService) GetIamPolicy(resource string) *ProjectsLocationsAuthzPoliciesGetIamPolicyCall {
	c := &ProjectsLocationsAuthzPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsAuthzPoliciesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthzPoliciesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthzPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists AuthzPolicies in a given project and location.
//
//   - parent: The project and location from which the `AuthzPolicy` resources
//     are listed, specified in the following format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthzPoliciesService) List(parent string) *ProjectsLocationsAuthzPoliciesListCall {
	c := &ProjectsLocationsAuthzPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsAuthzPoliciesListCall) Filter(filter string) *ProjectsLocationsAuthzPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results.
func (c *ProjectsLocationsAuthzPoliciesListCall) OrderBy(orderBy string) *ProjectsLocationsAuthzPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server might return fewer items than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsAuthzPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsAuthzPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server returns.
func (c *ProjectsLocationsAuthzPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsAuthzPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthzPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthzPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authzPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthzPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListAuthzPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthzPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthzPoliciesListCall) Pages(ctx context.Context, f func(*ListAuthzPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthzPoliciesPatchCall struct {
	s           *Service
	name        string
	authzpolicy *AuthzPolicy
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the parameters of a single AuthzPolicy.
//
//   - name: Identifier. Name of the `AuthzPolicy` resource in the following
//     format:
//     `projects/{project}/locations/{location}/authzPolicies/{authz_policy}`.
func (r *ProjectsLocationsAuthzPoliciesService) Patch(name string, authzpolicy *AuthzPolicy) *ProjectsLocationsAuthzPoliciesPatchCall {
	c := &ProjectsLocationsAuthzPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.authzpolicy = authzpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for at least 60 minutes since the
// first request. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with the
// same request ID, the server can check if original operation with the same
// request ID was received, and if so, ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzPoliciesPatchCall) RequestId(requestId string) *ProjectsLocationsAuthzPoliciesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Used to
// specify the fields to be overwritten in the `AuthzPolicy` resource by the
// update. The fields specified in the `update_mask` are relative to the
// resource, not the full request. A field is overwritten if it is in the mask.
// If the user does not specify a mask, then all fields are overwritten.
func (c *ProjectsLocationsAuthzPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthzPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authzpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthzPoliciesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsAuthzPoliciesSetIamPolicyCall {
	c := &ProjectsLocationsAuthzPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthzPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzPoliciesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsAuthzPoliciesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall {
	c := &ProjectsLocationsAuthzPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.authzPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.authzPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendAuthenticationConfigsCreateCall struct {
	s                           *Service
	parent                      string
	backendauthenticationconfig *BackendAuthenticationConfig
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Create: Creates a new BackendAuthenticationConfig in a given project and
// location.
//
//   - parent: The parent resource of the BackendAuthenticationConfig. Must be in
//     the format `projects/*/locations/{location}`.
func (r *ProjectsLocationsBackendAuthenticationConfigsService) Create(parent string, backendauthenticationconfig *BackendAuthenticationConfig) *ProjectsLocationsBackendAuthenticationConfigsCreateCall {
	c := &ProjectsLocationsBackendAuthenticationConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backendauthenticationconfig = backendauthenticationconfig
	return c
}

// BackendAuthenticationConfigId sets the optional parameter
// "backendAuthenticationConfigId": Required. Short name of the
// BackendAuthenticationConfig resource to be created. This value should be
// 1-63 characters long, containing only letters, numbers, hyphens, and
// underscores, and should not start with a number. E.g. "backend-auth-config".
func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) BackendAuthenticationConfigId(backendAuthenticationConfigId string) *ProjectsLocationsBackendAuthenticationConfigsCreateCall {
	c.urlParams_.Set("backendAuthenticationConfigId", backendAuthenticationConfigId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendAuthenticationConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackendAuthenticationConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backendauthenticationconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backendAuthenticationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.backendAuthenticationConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendAuthenticationConfigsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendAuthenticationConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single BackendAuthenticationConfig to
// BackendAuthenticationConfig.
//
//   - name: A name of the BackendAuthenticationConfig to delete. Must be in the
//     format `projects/*/locations/{location}/backendAuthenticationConfigs/*`.
func (r *ProjectsLocationsBackendAuthenticationConfigsService) Delete(name string) *ProjectsLocationsBackendAuthenticationConfigsDeleteCall {
	c := &ProjectsLocationsBackendAuthenticationConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": Etag of the resource. If this is
// provided, it must match the server's etag.
func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) Etag(etag string) *ProjectsLocationsBackendAuthenticationConfigsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendAuthenticationConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackendAuthenticationConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.backendAuthenticationConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendAuthenticationConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendAuthenticationConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single BackendAuthenticationConfig to
// BackendAuthenticationConfig.
//
//   - name: A name of the BackendAuthenticationConfig to get. Must be in the
//     format `projects/*/locations/{location}/backendAuthenticationConfigs/*`.
func (r *ProjectsLocationsBackendAuthenticationConfigsService) Get(name string) *ProjectsLocationsBackendAuthenticationConfigsGetCall {
	c := &ProjectsLocationsBackendAuthenticationConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendAuthenticationConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendAuthenticationConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) Context(ctx context.Context) *ProjectsLocationsBackendAuthenticationConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.backendAuthenticationConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackendAuthenticationConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendAuthenticationConfigsGetCall) Do(opts ...googleapi.CallOption) (*BackendAuthenticationConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackendAuthenticationConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackendAuthenticationConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists BackendAuthenticationConfigs in a given project and location.
//
//   - parent: The project and location from which the
//     BackendAuthenticationConfigs should be listed, specified in the format
//     `projects/*/locations/{location}`.
func (r *ProjectsLocationsBackendAuthenticationConfigsService) List(parent string) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c := &ProjectsLocationsBackendAuthenticationConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// BackendAuthenticationConfigs to return per call.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) PageSize(pageSize int64) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListBackendAuthenticationConfigsResponse` Indicates that this is a
// continuation of a prior `ListBackendAuthenticationConfigs` call, and that
// the system should return the next page of data.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) PageToken(pageToken string) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) Context(ctx context.Context) *ProjectsLocationsBackendAuthenticationConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backendAuthenticationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.backendAuthenticationConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackendAuthenticationConfigsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) Do(opts ...googleapi.CallOption) (*ListBackendAuthenticationConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackendAuthenticationConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackendAuthenticationConfigsListCall) Pages(ctx context.Context, f func(*ListBackendAuthenticationConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackendAuthenticationConfigsPatchCall struct {
	s                           *Service
	name                        string
	backendauthenticationconfig *BackendAuthenticationConfig
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Patch: Updates the parameters of a single BackendAuthenticationConfig to
// BackendAuthenticationConfig.
//
//   - name: Name of the BackendAuthenticationConfig resource. It matches the
//     pattern
//     `projects/*/locations/{location}/backendAuthenticationConfigs/{backend_auth
//     entication_config}`.
func (r *ProjectsLocationsBackendAuthenticationConfigsService) Patch(name string, backendauthenticationconfig *BackendAuthenticationConfig) *ProjectsLocationsBackendAuthenticationConfigsPatchCall {
	c := &ProjectsLocationsBackendAuthenticationConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backendauthenticationconfig = backendauthenticationconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the BackendAuthenticationConfig
// resource by the update. The fields specified in the update_mask are relative
// to the resource, not the full request. A field will be overwritten if it is
// in the mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackendAuthenticationConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackendAuthenticationConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackendAuthenticationConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backendauthenticationconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.backendAuthenticationConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackendAuthenticationConfigsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.backendAuthenticationConfigs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesCreateCall struct {
	s               *Service
	parent          string
	clienttlspolicy *ClientTlsPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new ClientTlsPolicy in a given project and location.
//
//   - parent: The parent resource of the ClientTlsPolicy. Must be in the format
//     `projects/*/locations/{location}`.
func (r *ProjectsLocationsClientTlsPoliciesService) Create(parent string, clienttlspolicy *ClientTlsPolicy) *ProjectsLocationsClientTlsPoliciesCreateCall {
	c := &ProjectsLocationsClientTlsPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.clienttlspolicy = clienttlspolicy
	return c
}

// ClientTlsPolicyId sets the optional parameter "clientTlsPolicyId": Required.
// Short name of the ClientTlsPolicy resource to be created. This value should
// be 1-63 characters long, containing only letters, numbers, hyphens, and
// underscores, and should not start with a number. E.g. "client_mtls_policy".
func (c *ProjectsLocationsClientTlsPoliciesCreateCall) ClientTlsPolicyId(clientTlsPolicyId string) *ProjectsLocationsClientTlsPoliciesCreateCall {
	c.urlParams_.Set("clientTlsPolicyId", clientTlsPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.clienttlspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clientTlsPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClientTlsPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ClientTlsPolicy.
//
//   - name: A name of the ClientTlsPolicy to delete. Must be in the format
//     `projects/*/locations/{location}/clientTlsPolicies/*`.
func (r *ProjectsLocationsClientTlsPoliciesService) Delete(name string) *ProjectsLocationsClientTlsPoliciesDeleteCall {
	c := &ProjectsLocationsClientTlsPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClientTlsPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ClientTlsPolicy.
//
//   - name: A name of the ClientTlsPolicy to get. Must be in the format
//     `projects/*/locations/{location}/clientTlsPolicies/*`.
func (r *ProjectsLocationsClientTlsPoliciesService) Get(name string) *ProjectsLocationsClientTlsPoliciesGetCall {
	c := &ProjectsLocationsClientTlsPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClientTlsPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsClientTlsPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientTlsPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClientTlsPoliciesGetCall) Do(opts ...googleapi.CallOption) (*ClientTlsPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientTlsPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsClientTlsPoliciesService) GetIamPolicy(resource string) *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall {
	c := &ProjectsLocationsClientTlsPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClientTlsPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ClientTlsPolicies in a given project and location.
//
//   - parent: The project and location from which the ClientTlsPolicies should
//     be listed, specified in the format `projects/*/locations/{location}`.
func (r *ProjectsLocationsClientTlsPoliciesService) List(parent string) *ProjectsLocationsClientTlsPoliciesListCall {
	c := &ProjectsLocationsClientTlsPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// ClientTlsPolicies to return per call.
func (c *ProjectsLocationsClientTlsPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsClientTlsPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListClientTlsPoliciesResponse` Indicates that this is a continuation
// of a prior `ListClientTlsPolicies` call, and that the system should return
// the next page of data.
func (c *ProjectsLocationsClientTlsPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsClientTlsPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClientTlsPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsClientTlsPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clientTlsPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClientTlsPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsClientTlsPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListClientTlsPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClientTlsPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsClientTlsPoliciesListCall) Pages(ctx context.Context, f func(*ListClientTlsPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsClientTlsPoliciesPatchCall struct {
	s               *Service
	name            string
	clienttlspolicy *ClientTlsPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of a single ClientTlsPolicy.
//
//   - name: Name of the ClientTlsPolicy resource. It matches the pattern
//     `projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_poli
//     cy}`.
func (r *ProjectsLocationsClientTlsPoliciesService) Patch(name string, clienttlspolicy *ClientTlsPolicy) *ProjectsLocationsClientTlsPoliciesPatchCall {
	c := &ProjectsLocationsClientTlsPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.clienttlspolicy = clienttlspolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the ClientTlsPolicy resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsClientTlsPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsClientTlsPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.clienttlspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClientTlsPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsClientTlsPoliciesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall {
	c := &ProjectsLocationsClientTlsPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClientTlsPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsClientTlsPoliciesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall {
	c := &ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.clientTlsPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsClientTlsPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.clientTlsPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFirewallEndpointAssociationsCreateCall struct {
	s                           *Service
	parent                      string
	firewallendpointassociation *FirewallEndpointAssociation
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Create: Creates a new FirewallEndpointAssociation in a given project and
// location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsFirewallEndpointAssociationsService) Create(parent string, firewallendpointassociation *FirewallEndpointAssociation) *ProjectsLocationsFirewallEndpointAssociationsCreateCall {
	c := &ProjectsLocationsFirewallEndpointAssociationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.firewallendpointassociation = firewallendpointassociation
	return c
}

// FirewallEndpointAssociationId sets the optional parameter
// "firewallEndpointAssociationId": Id of the requesting object. If
// auto-generating Id server-side, remove this field and
// firewall_endpoint_association_id from the method_signature of Create RPC.
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) FirewallEndpointAssociationId(firewallEndpointAssociationId string) *ProjectsLocationsFirewallEndpointAssociationsCreateCall {
	c.urlParams_.Set("firewallEndpointAssociationId", firewallEndpointAssociationId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) RequestId(requestId string) *ProjectsLocationsFirewallEndpointAssociationsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsFirewallEndpointAssociationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) Context(ctx context.Context) *ProjectsLocationsFirewallEndpointAssociationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallendpointassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/firewallEndpointAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.firewallEndpointAssociations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFirewallEndpointAssociationsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFirewallEndpointAssociationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single FirewallEndpointAssociation.
//
// - name: Name of the resource.
func (r *ProjectsLocationsFirewallEndpointAssociationsService) Delete(name string) *ProjectsLocationsFirewallEndpointAssociationsDeleteCall {
	c := &ProjectsLocationsFirewallEndpointAssociationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) RequestId(requestId string) *ProjectsLocationsFirewallEndpointAssociationsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsFirewallEndpointAssociationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsFirewallEndpointAssociationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.firewallEndpointAssociations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFirewallEndpointAssociationsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFirewallEndpointAssociationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single FirewallEndpointAssociation.
//
// - name: Name of the resource.
func (r *ProjectsLocationsFirewallEndpointAssociationsService) Get(name string) *ProjectsLocationsFirewallEndpointAssociationsGetCall {
	c := &ProjectsLocationsFirewallEndpointAssociationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsFirewallEndpointAssociationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsFirewallEndpointAssociationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) Context(ctx context.Context) *ProjectsLocationsFirewallEndpointAssociationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.firewallEndpointAssociations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallEndpointAssociation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsFirewallEndpointAssociationsGetCall) Do(opts ...googleapi.CallOption) (*FirewallEndpointAssociation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallEndpointAssociation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsFirewallEndpointAssociationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Associations in a given project and location.
//
// - parent: Parent value for ListAssociationsRequest.
func (r *ProjectsLocationsFirewallEndpointAssociationsService) List(parent string) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c := &ProjectsLocationsFirewallEndpointAssociationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Filter(filter string) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) OrderBy(orderBy string) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) PageSize(pageSize int64) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) PageToken(pageToken string) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Context(ctx context.Context) *ProjectsLocationsFirewallEndpointAssociationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/firewallEndpointAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.firewallEndpointAssociations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFirewallEndpointAssociationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Do(opts ...googleapi.CallOption) (*ListFirewallEndpointAssociationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFirewallEndpointAssociationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsFirewallEndpointAssociationsListCall) Pages(ctx context.Context, f func(*ListFirewallEndpointAssociationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsFirewallEndpointAssociationsPatchCall struct {
	s                           *Service
	name                        string
	firewallendpointassociation *FirewallEndpointAssociation
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Patch: Update a single FirewallEndpointAssociation.
//
// - name: Immutable. Identifier. name of resource.
func (r *ProjectsLocationsFirewallEndpointAssociationsService) Patch(name string, firewallendpointassociation *FirewallEndpointAssociation) *ProjectsLocationsFirewallEndpointAssociationsPatchCall {
	c := &ProjectsLocationsFirewallEndpointAssociationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.firewallendpointassociation = firewallendpointassociation
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) RequestId(requestId string) *ProjectsLocationsFirewallEndpointAssociationsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Association resource by
// the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsFirewallEndpointAssociationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsFirewallEndpointAssociationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) Context(ctx context.Context) *ProjectsLocationsFirewallEndpointAssociationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallendpointassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.firewallEndpointAssociations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsFirewallEndpointAssociationsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.firewallEndpointAssociations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesCreateCall struct {
	s                     *Service
	parent                string
	gatewaysecuritypolicy *GatewaySecurityPolicy
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Create: Creates a new GatewaySecurityPolicy in a given project and location.
//
//   - parent: The parent resource of the GatewaySecurityPolicy. Must be in the
//     format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsGatewaySecurityPoliciesService) Create(parent string, gatewaysecuritypolicy *GatewaySecurityPolicy) *ProjectsLocationsGatewaySecurityPoliciesCreateCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.gatewaysecuritypolicy = gatewaysecuritypolicy
	return c
}

// GatewaySecurityPolicyId sets the optional parameter
// "gatewaySecurityPolicyId": Required. Short name of the GatewaySecurityPolicy
// resource to be created. This value should be 1-63 characters long,
// containing only letters, numbers, hyphens, and underscores, and should not
// start with a number. E.g. "gateway_security_policy1".
func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) GatewaySecurityPolicyId(gatewaySecurityPolicyId string) *ProjectsLocationsGatewaySecurityPoliciesCreateCall {
	c.urlParams_.Set("gatewaySecurityPolicyId", gatewaySecurityPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gatewaysecuritypolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/gatewaySecurityPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single GatewaySecurityPolicy.
//
//   - name: A name of the GatewaySecurityPolicy to delete. Must be in the format
//     `projects/{project}/locations/{location}/gatewaySecurityPolicies/*`.
func (r *ProjectsLocationsGatewaySecurityPoliciesService) Delete(name string) *ProjectsLocationsGatewaySecurityPoliciesDeleteCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single GatewaySecurityPolicy.
//
//   - name: A name of the GatewaySecurityPolicy to get. Must be in the format
//     `projects/{project}/locations/{location}/gatewaySecurityPolicies/*`.
func (r *ProjectsLocationsGatewaySecurityPoliciesService) Get(name string) *ProjectsLocationsGatewaySecurityPoliciesGetCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaySecurityPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GatewaySecurityPolicy.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesGetCall) Do(opts ...googleapi.CallOption) (*GatewaySecurityPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GatewaySecurityPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GatewaySecurityPolicies in a given project and location.
//
//   - parent: The project and location from which the GatewaySecurityPolicies
//     should be listed, specified in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsGatewaySecurityPoliciesService) List(parent string) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// GatewaySecurityPolicies to return per call.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last 'ListGatewaySecurityPoliciesResponse' Indicates that this is a
// continuation of a prior 'ListGatewaySecurityPolicies' call, and that the
// system should return the next page of data.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/gatewaySecurityPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGatewaySecurityPoliciesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListGatewaySecurityPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGatewaySecurityPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGatewaySecurityPoliciesListCall) Pages(ctx context.Context, f func(*ListGatewaySecurityPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGatewaySecurityPoliciesPatchCall struct {
	s                     *Service
	name                  string
	gatewaysecuritypolicy *GatewaySecurityPolicy
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Patch: Updates the parameters of a single GatewaySecurityPolicy.
//
//   - name: Name of the resource. Name is of the form
//     projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_se
//     curity_policy} gateway_security_policy should match the pattern:(^a-z
//     ([a-z0-9-]{0,61}[a-z0-9])?$).
func (r *ProjectsLocationsGatewaySecurityPoliciesService) Patch(name string, gatewaysecuritypolicy *GatewaySecurityPolicy) *ProjectsLocationsGatewaySecurityPoliciesPatchCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.gatewaysecuritypolicy = gatewaysecuritypolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the GatewaySecurityPolicy resource
// by the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGatewaySecurityPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gatewaysecuritypolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall struct {
	s                         *Service
	parent                    string
	gatewaysecuritypolicyrule *GatewaySecurityPolicyRule
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Create: Creates a new GatewaySecurityPolicy in a given project and location.
//
//   - parent: The parent where this rule will be created. Format :
//     projects/{project}/location/{location}/gatewaySecurityPolicies/*.
func (r *ProjectsLocationsGatewaySecurityPoliciesRulesService) Create(parent string, gatewaysecuritypolicyrule *GatewaySecurityPolicyRule) *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.gatewaysecuritypolicyrule = gatewaysecuritypolicyrule
	return c
}

// GatewaySecurityPolicyRuleId sets the optional parameter
// "gatewaySecurityPolicyRuleId": The ID to use for the rule, which will become
// the final component of the rule's resource name. This value should be 4-63
// characters, and valid characters are /a-z-/.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) GatewaySecurityPolicyRuleId(gatewaySecurityPolicyRuleId string) *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall {
	c.urlParams_.Set("gatewaySecurityPolicyRuleId", gatewaySecurityPolicyRuleId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gatewaysecuritypolicyrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/rules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.rules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single GatewaySecurityPolicyRule.
//
//   - name: A name of the GatewaySecurityPolicyRule to delete. Must be in the
//     format
//     `projects/{project}/locations/{location}/gatewaySecurityPolicies/{gatewaySe
//     curityPolicy}/rules/*`.
func (r *ProjectsLocationsGatewaySecurityPoliciesRulesService) Delete(name string) *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.rules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single GatewaySecurityPolicyRule.
//
//   - name: The name of the GatewaySecurityPolicyRule to retrieve. Format:
//     projects/{project}/location/{location}/gatewaySecurityPolicies/*/rules/*.
func (r *ProjectsLocationsGatewaySecurityPoliciesRulesService) Get(name string) *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.rules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GatewaySecurityPolicyRule.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesGetCall) Do(opts ...googleapi.CallOption) (*GatewaySecurityPolicyRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GatewaySecurityPolicyRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaySecurityPoliciesRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GatewaySecurityPolicyRules in a given project and location.
//
//   - parent: The project, location and GatewaySecurityPolicy from which the
//     GatewaySecurityPolicyRules should be listed, specified in the format
//     `projects/{project}/locations/{location}/gatewaySecurityPolicies/{gatewaySe
//     curityPolicy}`.
func (r *ProjectsLocationsGatewaySecurityPoliciesRulesService) List(parent string) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// GatewaySecurityPolicyRules to return per call.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) PageSize(pageSize int64) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last 'ListGatewaySecurityPolicyRulesResponse' Indicates that this is a
// continuation of a prior 'ListGatewaySecurityPolicyRules' call, and that the
// system should return the next page of data.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) PageToken(pageToken string) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/rules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.rules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGatewaySecurityPolicyRulesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) Do(opts ...googleapi.CallOption) (*ListGatewaySecurityPolicyRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGatewaySecurityPolicyRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesListCall) Pages(ctx context.Context, f func(*ListGatewaySecurityPolicyRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall struct {
	s                         *Service
	name                      string
	gatewaysecuritypolicyrule *GatewaySecurityPolicyRule
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Patch: Updates the parameters of a single GatewaySecurityPolicyRule.
//
//   - name: Immutable. Name of the resource. ame is the full resource name so
//     projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_se
//     curity_policy}/rules/{rule} rule should match the pattern: (^a-z
//     ([a-z0-9-]{0,61}[a-z0-9])?$).
func (r *ProjectsLocationsGatewaySecurityPoliciesRulesService) Patch(name string, gatewaysecuritypolicyrule *GatewaySecurityPolicyRule) *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall {
	c := &ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.gatewaysecuritypolicyrule = gatewaysecuritypolicyrule
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the GatewaySecurityPolicy resource
// by the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gatewaysecuritypolicyrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.gatewaySecurityPolicies.rules.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaySecurityPoliciesRulesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.gatewaySecurityPolicies.rules.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentGroupsCreateCall struct {
	s                        *Service
	parent                   string
	interceptdeploymentgroup *InterceptDeploymentGroup
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Create: Creates a deployment group in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this deployment group will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsInterceptDeploymentGroupsService) Create(parent string, interceptdeploymentgroup *InterceptDeploymentGroup) *ProjectsLocationsInterceptDeploymentGroupsCreateCall {
	c := &ProjectsLocationsInterceptDeploymentGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.interceptdeploymentgroup = interceptdeploymentgroup
	return c
}

// InterceptDeploymentGroupId sets the optional parameter
// "interceptDeploymentGroupId": Required. The ID to use for the new deployment
// group, which will become the final component of the deployment group's
// resource name.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) InterceptDeploymentGroupId(interceptDeploymentGroupId string) *ProjectsLocationsInterceptDeploymentGroupsCreateCall {
	c.urlParams_.Set("interceptDeploymentGroupId", interceptDeploymentGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptdeploymentgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptDeploymentGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeploymentGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a deployment group. See https://google.aip.dev/135.
//
// - name: The deployment group to delete.
func (r *ProjectsLocationsInterceptDeploymentGroupsService) Delete(name string) *ProjectsLocationsInterceptDeploymentGroupsDeleteCall {
	c := &ProjectsLocationsInterceptDeploymentGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeploymentGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific deployment group. See https://google.aip.dev/131.
//
//   - name: The name of the deployment group to retrieve. Format:
//     projects/{project}/locations/{location}/interceptDeploymentGroups/{intercep
//     t_deployment_group}.
func (r *ProjectsLocationsInterceptDeploymentGroupsService) Get(name string) *ProjectsLocationsInterceptDeploymentGroupsGetCall {
	c := &ProjectsLocationsInterceptDeploymentGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptDeploymentGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeploymentGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InterceptDeploymentGroup.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentGroupsGetCall) Do(opts ...googleapi.CallOption) (*InterceptDeploymentGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InterceptDeploymentGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists deployment groups in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of deployment groups.
//     Example: `projects/123456789/locations/global`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsInterceptDeploymentGroupsService) List(parent string) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c := &ProjectsLocationsInterceptDeploymentGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Filter(filter string) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInterceptDeploymentGroups` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListInterceptDeploymentGroups` must match the call that provided the
// page token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) PageToken(pageToken string) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptDeploymentGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeploymentGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInterceptDeploymentGroupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Do(opts ...googleapi.CallOption) (*ListInterceptDeploymentGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInterceptDeploymentGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInterceptDeploymentGroupsListCall) Pages(ctx context.Context, f func(*ListInterceptDeploymentGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInterceptDeploymentGroupsPatchCall struct {
	s                        *Service
	name                     string
	interceptdeploymentgroup *InterceptDeploymentGroup
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Patch: Updates a deployment group. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this deployment group,
//     for example:
//     `projects/123456789/locations/global/interceptDeploymentGroups/my-dg`. See
//     https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsInterceptDeploymentGroupsService) Patch(name string, interceptdeploymentgroup *InterceptDeploymentGroup) *ProjectsLocationsInterceptDeploymentGroupsPatchCall {
	c := &ProjectsLocationsInterceptDeploymentGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.interceptdeploymentgroup = interceptdeploymentgroup
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the deployment group (e.g.
// `description`; *not* `intercept_deployment_group.description`). See
// https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsInterceptDeploymentGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptdeploymentgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeploymentGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeploymentGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentsCreateCall struct {
	s                   *Service
	parent              string
	interceptdeployment *InterceptDeployment
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a deployment in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this deployment will be created. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsInterceptDeploymentsService) Create(parent string, interceptdeployment *InterceptDeployment) *ProjectsLocationsInterceptDeploymentsCreateCall {
	c := &ProjectsLocationsInterceptDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.interceptdeployment = interceptdeployment
	return c
}

// InterceptDeploymentId sets the optional parameter "interceptDeploymentId":
// Required. The ID to use for the new deployment, which will become the final
// component of the deployment's resource name.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) InterceptDeploymentId(interceptDeploymentId string) *ProjectsLocationsInterceptDeploymentsCreateCall {
	c.urlParams_.Set("interceptDeploymentId", interceptDeploymentId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a deployment. See https://google.aip.dev/135.
//
// - name: Name of the resource.
func (r *ProjectsLocationsInterceptDeploymentsService) Delete(name string) *ProjectsLocationsInterceptDeploymentsDeleteCall {
	c := &ProjectsLocationsInterceptDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific deployment. See https://google.aip.dev/131.
//
//   - name: The name of the deployment to retrieve. Format:
//     projects/{project}/locations/{location}/interceptDeployments/{intercept_dep
//     loyment}.
func (r *ProjectsLocationsInterceptDeploymentsService) Get(name string) *ProjectsLocationsInterceptDeploymentsGetCall {
	c := &ProjectsLocationsInterceptDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentsGetCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InterceptDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsInterceptDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*InterceptDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InterceptDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists deployments in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of deployments. Example:
//     `projects/123456789/locations/us-central1-a`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsInterceptDeploymentsService) List(parent string) *ProjectsLocationsInterceptDeploymentsListCall {
	c := &ProjectsLocationsInterceptDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Filter(filter string) *ProjectsLocationsInterceptDeploymentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsInterceptDeploymentsListCall) OrderBy(orderBy string) *ProjectsLocationsInterceptDeploymentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptDeploymentsListCall) PageSize(pageSize int64) *ProjectsLocationsInterceptDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInterceptDeployments` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListInterceptDeployments` must match the call that provided the page token.
// See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptDeploymentsListCall) PageToken(pageToken string) *ProjectsLocationsInterceptDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInterceptDeploymentsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Do(opts ...googleapi.CallOption) (*ListInterceptDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInterceptDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInterceptDeploymentsListCall) Pages(ctx context.Context, f func(*ListInterceptDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInterceptDeploymentsPatchCall struct {
	s                   *Service
	name                string
	interceptdeployment *InterceptDeployment
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates a deployment. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this deployment, for
//     example:
//     `projects/123456789/locations/us-central1-a/interceptDeployments/my-dep`.
//     See https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsInterceptDeploymentsService) Patch(name string, interceptdeployment *InterceptDeployment) *ProjectsLocationsInterceptDeploymentsPatchCall {
	c := &ProjectsLocationsInterceptDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.interceptdeployment = interceptdeployment
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) RequestId(requestId string) *ProjectsLocationsInterceptDeploymentsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the deployment (e.g. `description`;
// *not* `intercept_deployment.description`). See https://google.aip.dev/161
// for more details.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsInterceptDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) Context(ctx context.Context) *ProjectsLocationsInterceptDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptDeployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptDeployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall struct {
	s                                 *Service
	parent                            string
	interceptendpointgroupassociation *InterceptEndpointGroupAssociation
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Creates an association in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this association will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsInterceptEndpointGroupAssociationsService) Create(parent string, interceptendpointgroupassociation *InterceptEndpointGroupAssociation) *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall {
	c := &ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.interceptendpointgroupassociation = interceptendpointgroupassociation
	return c
}

// InterceptEndpointGroupAssociationId sets the optional parameter
// "interceptEndpointGroupAssociationId": The ID to use for the new
// association, which will become the final component of the endpoint group's
// resource name. If not provided, the server will generate a unique ID.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) InterceptEndpointGroupAssociationId(interceptEndpointGroupAssociationId string) *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("interceptEndpointGroupAssociationId", interceptEndpointGroupAssociationId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptendpointgroupassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptEndpointGroupAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroupAssociations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an association. See https://google.aip.dev/135.
//
// - name: The association to delete.
func (r *ProjectsLocationsInterceptEndpointGroupAssociationsService) Delete(name string) *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall {
	c := &ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroupAssociations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupAssociationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific association. See https://google.aip.dev/131.
//
//   - name: The name of the association to retrieve. Format:
//     projects/{project}/locations/{location}/interceptEndpointGroupAssociations/
//     {intercept_endpoint_group_association}.
func (r *ProjectsLocationsInterceptEndpointGroupAssociationsService) Get(name string) *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall {
	c := &ProjectsLocationsInterceptEndpointGroupAssociationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroupAssociations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InterceptEndpointGroupAssociation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsGetCall) Do(opts ...googleapi.CallOption) (*InterceptEndpointGroupAssociation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InterceptEndpointGroupAssociation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupAssociationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists associations in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of associations. Example:
//     `projects/123456789/locations/global`. See https://google.aip.dev/132 for
//     more details.
func (r *ProjectsLocationsInterceptEndpointGroupAssociationsService) List(parent string) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c := &ProjectsLocationsInterceptEndpointGroupAssociationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Filter(filter string) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) OrderBy(orderBy string) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) PageSize(pageSize int64) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInterceptEndpointGroups` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListInterceptEndpointGroups` must match the call that provided the page
// token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) PageToken(pageToken string) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupAssociationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptEndpointGroupAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroupAssociations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInterceptEndpointGroupAssociationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Do(opts ...googleapi.CallOption) (*ListInterceptEndpointGroupAssociationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInterceptEndpointGroupAssociationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsListCall) Pages(ctx context.Context, f func(*ListInterceptEndpointGroupAssociationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall struct {
	s                                 *Service
	name                              string
	interceptendpointgroupassociation *InterceptEndpointGroupAssociation
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch: Updates an association. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this endpoint group
//     association, for example:
//     `projects/123456789/locations/global/interceptEndpointGroupAssociations/my-
//     eg-association`. See https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsInterceptEndpointGroupAssociationsService) Patch(name string, interceptendpointgroupassociation *InterceptEndpointGroupAssociation) *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall {
	c := &ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.interceptendpointgroupassociation = interceptendpointgroupassociation
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the association (e.g.
// `description`; *not* `intercept_endpoint_group_association.description`).
// See https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptendpointgroupassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroupAssociations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupAssociationsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroupAssociations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupsCreateCall struct {
	s                      *Service
	parent                 string
	interceptendpointgroup *InterceptEndpointGroup
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Create: Creates an endpoint group in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this endpoint group will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsInterceptEndpointGroupsService) Create(parent string, interceptendpointgroup *InterceptEndpointGroup) *ProjectsLocationsInterceptEndpointGroupsCreateCall {
	c := &ProjectsLocationsInterceptEndpointGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.interceptendpointgroup = interceptendpointgroup
	return c
}

// InterceptEndpointGroupId sets the optional parameter
// "interceptEndpointGroupId": Required. The ID to use for the endpoint group,
// which will become the final component of the endpoint group's resource name.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) InterceptEndpointGroupId(interceptEndpointGroupId string) *ProjectsLocationsInterceptEndpointGroupsCreateCall {
	c.urlParams_.Set("interceptEndpointGroupId", interceptEndpointGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptendpointgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an endpoint group. See https://google.aip.dev/135.
//
// - name: The endpoint group to delete.
func (r *ProjectsLocationsInterceptEndpointGroupsService) Delete(name string) *ProjectsLocationsInterceptEndpointGroupsDeleteCall {
	c := &ProjectsLocationsInterceptEndpointGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific endpoint group. See https://google.aip.dev/131.
//
//   - name: The name of the endpoint group to retrieve. Format:
//     projects/{project}/locations/{location}/interceptEndpointGroups/{intercept_
//     endpoint_group}.
func (r *ProjectsLocationsInterceptEndpointGroupsService) Get(name string) *ProjectsLocationsInterceptEndpointGroupsGetCall {
	c := &ProjectsLocationsInterceptEndpointGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptEndpointGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InterceptEndpointGroup.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsInterceptEndpointGroupsGetCall) Do(opts ...googleapi.CallOption) (*InterceptEndpointGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InterceptEndpointGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInterceptEndpointGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists endpoint groups in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of endpoint groups.
//     Example: `projects/123456789/locations/global`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsInterceptEndpointGroupsService) List(parent string) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c := &ProjectsLocationsInterceptEndpointGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Filter(filter string) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListInterceptEndpointGroups` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListInterceptEndpointGroups` must match the call that provided the page
// token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) PageToken(pageToken string) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/interceptEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInterceptEndpointGroupsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Do(opts ...googleapi.CallOption) (*ListInterceptEndpointGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInterceptEndpointGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInterceptEndpointGroupsListCall) Pages(ctx context.Context, f func(*ListInterceptEndpointGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInterceptEndpointGroupsPatchCall struct {
	s                      *Service
	name                   string
	interceptendpointgroup *InterceptEndpointGroup
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Patch: Updates an endpoint group. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this endpoint group, for
//     example:
//     `projects/123456789/locations/global/interceptEndpointGroups/my-eg`. See
//     https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsInterceptEndpointGroupsService) Patch(name string, interceptendpointgroup *InterceptEndpointGroup) *ProjectsLocationsInterceptEndpointGroupsPatchCall {
	c := &ProjectsLocationsInterceptEndpointGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.interceptendpointgroup = interceptendpointgroup
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsInterceptEndpointGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the endpoint group (e.g.
// `description`; *not* `intercept_endpoint_group.description`). See
// https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsInterceptEndpointGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsInterceptEndpointGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsInterceptEndpointGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.interceptendpointgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.interceptEndpointGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInterceptEndpointGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.interceptEndpointGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentGroupsCreateCall struct {
	s                        *Service
	parent                   string
	mirroringdeploymentgroup *MirroringDeploymentGroup
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Create: Creates a deployment group in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this deployment group will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsMirroringDeploymentGroupsService) Create(parent string, mirroringdeploymentgroup *MirroringDeploymentGroup) *ProjectsLocationsMirroringDeploymentGroupsCreateCall {
	c := &ProjectsLocationsMirroringDeploymentGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mirroringdeploymentgroup = mirroringdeploymentgroup
	return c
}

// MirroringDeploymentGroupId sets the optional parameter
// "mirroringDeploymentGroupId": Required. The ID to use for the new deployment
// group, which will become the final component of the deployment group's
// resource name.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) MirroringDeploymentGroupId(mirroringDeploymentGroupId string) *ProjectsLocationsMirroringDeploymentGroupsCreateCall {
	c.urlParams_.Set("mirroringDeploymentGroupId", mirroringDeploymentGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringdeploymentgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringDeploymentGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeploymentGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a deployment group. See https://google.aip.dev/135.
//
// - name: The deployment group to delete.
func (r *ProjectsLocationsMirroringDeploymentGroupsService) Delete(name string) *ProjectsLocationsMirroringDeploymentGroupsDeleteCall {
	c := &ProjectsLocationsMirroringDeploymentGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeploymentGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific deployment group. See https://google.aip.dev/131.
//
//   - name: The name of the deployment group to retrieve. Format:
//     projects/{project}/locations/{location}/mirroringDeploymentGroups/{mirrorin
//     g_deployment_group}.
func (r *ProjectsLocationsMirroringDeploymentGroupsService) Get(name string) *ProjectsLocationsMirroringDeploymentGroupsGetCall {
	c := &ProjectsLocationsMirroringDeploymentGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringDeploymentGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeploymentGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MirroringDeploymentGroup.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentGroupsGetCall) Do(opts ...googleapi.CallOption) (*MirroringDeploymentGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MirroringDeploymentGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists deployment groups in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of deployment groups.
//     Example: `projects/123456789/locations/global`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsMirroringDeploymentGroupsService) List(parent string) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c := &ProjectsLocationsMirroringDeploymentGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Filter(filter string) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListMirroringDeploymentGroups` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListMirroringDeploymentGroups` must match the call that provided the
// page token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) PageToken(pageToken string) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringDeploymentGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeploymentGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMirroringDeploymentGroupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Do(opts ...googleapi.CallOption) (*ListMirroringDeploymentGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMirroringDeploymentGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMirroringDeploymentGroupsListCall) Pages(ctx context.Context, f func(*ListMirroringDeploymentGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMirroringDeploymentGroupsPatchCall struct {
	s                        *Service
	name                     string
	mirroringdeploymentgroup *MirroringDeploymentGroup
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Patch: Updates a deployment group. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this deployment group,
//     for example:
//     `projects/123456789/locations/global/mirroringDeploymentGroups/my-dg`. See
//     https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsMirroringDeploymentGroupsService) Patch(name string, mirroringdeploymentgroup *MirroringDeploymentGroup) *ProjectsLocationsMirroringDeploymentGroupsPatchCall {
	c := &ProjectsLocationsMirroringDeploymentGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.mirroringdeploymentgroup = mirroringdeploymentgroup
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the deployment group (e.g.
// `description`; *not* `mirroring_deployment_group.description`). See
// https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMirroringDeploymentGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringdeploymentgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeploymentGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeploymentGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentsCreateCall struct {
	s                   *Service
	parent              string
	mirroringdeployment *MirroringDeployment
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a deployment in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this deployment will be created. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsMirroringDeploymentsService) Create(parent string, mirroringdeployment *MirroringDeployment) *ProjectsLocationsMirroringDeploymentsCreateCall {
	c := &ProjectsLocationsMirroringDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mirroringdeployment = mirroringdeployment
	return c
}

// MirroringDeploymentId sets the optional parameter "mirroringDeploymentId":
// Required. The ID to use for the new deployment, which will become the final
// component of the deployment's resource name.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) MirroringDeploymentId(mirroringDeploymentId string) *ProjectsLocationsMirroringDeploymentsCreateCall {
	c.urlParams_.Set("mirroringDeploymentId", mirroringDeploymentId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a deployment. See https://google.aip.dev/135.
//
// - name: Name of the resource.
func (r *ProjectsLocationsMirroringDeploymentsService) Delete(name string) *ProjectsLocationsMirroringDeploymentsDeleteCall {
	c := &ProjectsLocationsMirroringDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific deployment. See https://google.aip.dev/131.
//
//   - name: The name of the deployment to retrieve. Format:
//     projects/{project}/locations/{location}/mirroringDeployments/{mirroring_dep
//     loyment}.
func (r *ProjectsLocationsMirroringDeploymentsService) Get(name string) *ProjectsLocationsMirroringDeploymentsGetCall {
	c := &ProjectsLocationsMirroringDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentsGetCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MirroringDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsMirroringDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*MirroringDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MirroringDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists deployments in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of deployments. Example:
//     `projects/123456789/locations/us-central1-a`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsMirroringDeploymentsService) List(parent string) *ProjectsLocationsMirroringDeploymentsListCall {
	c := &ProjectsLocationsMirroringDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Filter(filter string) *ProjectsLocationsMirroringDeploymentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsMirroringDeploymentsListCall) OrderBy(orderBy string) *ProjectsLocationsMirroringDeploymentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringDeploymentsListCall) PageSize(pageSize int64) *ProjectsLocationsMirroringDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListMirroringDeployments` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListMirroringDeployments` must match the call that provided the page token.
// See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringDeploymentsListCall) PageToken(pageToken string) *ProjectsLocationsMirroringDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMirroringDeploymentsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Do(opts ...googleapi.CallOption) (*ListMirroringDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMirroringDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMirroringDeploymentsListCall) Pages(ctx context.Context, f func(*ListMirroringDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMirroringDeploymentsPatchCall struct {
	s                   *Service
	name                string
	mirroringdeployment *MirroringDeployment
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates a deployment. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this deployment, for
//     example:
//     `projects/123456789/locations/us-central1-a/mirroringDeployments/my-dep`.
//     See https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsMirroringDeploymentsService) Patch(name string, mirroringdeployment *MirroringDeployment) *ProjectsLocationsMirroringDeploymentsPatchCall {
	c := &ProjectsLocationsMirroringDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.mirroringdeployment = mirroringdeployment
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) RequestId(requestId string) *ProjectsLocationsMirroringDeploymentsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the deployment (e.g. `description`;
// *not* `mirroring_deployment.description`). See https://google.aip.dev/161
// for more details.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMirroringDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) Context(ctx context.Context) *ProjectsLocationsMirroringDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringDeployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringDeployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall struct {
	s                                 *Service
	parent                            string
	mirroringendpointgroupassociation *MirroringEndpointGroupAssociation
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Creates an association in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this association will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsMirroringEndpointGroupAssociationsService) Create(parent string, mirroringendpointgroupassociation *MirroringEndpointGroupAssociation) *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall {
	c := &ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mirroringendpointgroupassociation = mirroringendpointgroupassociation
	return c
}

// MirroringEndpointGroupAssociationId sets the optional parameter
// "mirroringEndpointGroupAssociationId": The ID to use for the new
// association, which will become the final component of the endpoint group's
// resource name. If not provided, the server will generate a unique ID.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) MirroringEndpointGroupAssociationId(mirroringEndpointGroupAssociationId string) *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("mirroringEndpointGroupAssociationId", mirroringEndpointGroupAssociationId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringendpointgroupassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringEndpointGroupAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroupAssociations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an association. See https://google.aip.dev/135.
//
// - name: The association to delete.
func (r *ProjectsLocationsMirroringEndpointGroupAssociationsService) Delete(name string) *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall {
	c := &ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroupAssociations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupAssociationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific association. See https://google.aip.dev/131.
//
//   - name: The name of the association to retrieve. Format:
//     projects/{project}/locations/{location}/mirroringEndpointGroupAssociations/
//     {mirroring_endpoint_group_association}.
func (r *ProjectsLocationsMirroringEndpointGroupAssociationsService) Get(name string) *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall {
	c := &ProjectsLocationsMirroringEndpointGroupAssociationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroupAssociations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MirroringEndpointGroupAssociation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsGetCall) Do(opts ...googleapi.CallOption) (*MirroringEndpointGroupAssociation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MirroringEndpointGroupAssociation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupAssociationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists associations in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of associations. Example:
//     `projects/123456789/locations/global`. See https://google.aip.dev/132 for
//     more details.
func (r *ProjectsLocationsMirroringEndpointGroupAssociationsService) List(parent string) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c := &ProjectsLocationsMirroringEndpointGroupAssociationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Filter(filter string) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) OrderBy(orderBy string) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) PageSize(pageSize int64) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListMirroringEndpointGroups` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListMirroringEndpointGroups` must match the call that provided the page
// token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) PageToken(pageToken string) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupAssociationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringEndpointGroupAssociations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroupAssociations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMirroringEndpointGroupAssociationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Do(opts ...googleapi.CallOption) (*ListMirroringEndpointGroupAssociationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMirroringEndpointGroupAssociationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsListCall) Pages(ctx context.Context, f func(*ListMirroringEndpointGroupAssociationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall struct {
	s                                 *Service
	name                              string
	mirroringendpointgroupassociation *MirroringEndpointGroupAssociation
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch: Updates an association. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this endpoint group
//     association, for example:
//     `projects/123456789/locations/global/mirroringEndpointGroupAssociations/my-
//     eg-association`. See https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsMirroringEndpointGroupAssociationsService) Patch(name string, mirroringendpointgroupassociation *MirroringEndpointGroupAssociation) *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall {
	c := &ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.mirroringendpointgroupassociation = mirroringendpointgroupassociation
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the association (e.g.
// `description`; *not* `mirroring_endpoint_group_association.description`).
// See https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringendpointgroupassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroupAssociations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupAssociationsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroupAssociations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupsCreateCall struct {
	s                      *Service
	parent                 string
	mirroringendpointgroup *MirroringEndpointGroup
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Create: Creates an endpoint group in a given project and location. See
// https://google.aip.dev/133.
//
//   - parent: The parent resource where this endpoint group will be created.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsMirroringEndpointGroupsService) Create(parent string, mirroringendpointgroup *MirroringEndpointGroup) *ProjectsLocationsMirroringEndpointGroupsCreateCall {
	c := &ProjectsLocationsMirroringEndpointGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mirroringendpointgroup = mirroringendpointgroup
	return c
}

// MirroringEndpointGroupId sets the optional parameter
// "mirroringEndpointGroupId": Required. The ID to use for the endpoint group,
// which will become the final component of the endpoint group's resource name.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) MirroringEndpointGroupId(mirroringEndpointGroupId string) *ProjectsLocationsMirroringEndpointGroupsCreateCall {
	c.urlParams_.Set("mirroringEndpointGroupId", mirroringEndpointGroupId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringendpointgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an endpoint group. See https://google.aip.dev/135.
//
// - name: The endpoint group to delete.
func (r *ProjectsLocationsMirroringEndpointGroupsService) Delete(name string) *ProjectsLocationsMirroringEndpointGroupsDeleteCall {
	c := &ProjectsLocationsMirroringEndpointGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific endpoint group. See https://google.aip.dev/131.
//
//   - name: The name of the endpoint group to retrieve. Format:
//     projects/{project}/locations/{location}/mirroringEndpointGroups/{mirroring_
//     endpoint_group}.
func (r *ProjectsLocationsMirroringEndpointGroupsService) Get(name string) *ProjectsLocationsMirroringEndpointGroupsGetCall {
	c := &ProjectsLocationsMirroringEndpointGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringEndpointGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MirroringEndpointGroup.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsMirroringEndpointGroupsGetCall) Do(opts ...googleapi.CallOption) (*MirroringEndpointGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MirroringEndpointGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMirroringEndpointGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists endpoint groups in a given project and location. See
// https://google.aip.dev/132.
//
//   - parent: The parent, which owns this collection of endpoint groups.
//     Example: `projects/123456789/locations/global`. See
//     https://google.aip.dev/132 for more details.
func (r *ProjectsLocationsMirroringEndpointGroupsService) List(parent string) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c := &ProjectsLocationsMirroringEndpointGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression. See
// https://google.aip.dev/160#filtering for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Filter(filter string) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort expression. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListMirroringEndpointGroups` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListMirroringEndpointGroups` must match the call that provided the page
// token. See https://google.aip.dev/158 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) PageToken(pageToken string) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/mirroringEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMirroringEndpointGroupsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Do(opts ...googleapi.CallOption) (*ListMirroringEndpointGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMirroringEndpointGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMirroringEndpointGroupsListCall) Pages(ctx context.Context, f func(*ListMirroringEndpointGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMirroringEndpointGroupsPatchCall struct {
	s                      *Service
	name                   string
	mirroringendpointgroup *MirroringEndpointGroup
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Patch: Updates an endpoint group. See https://google.aip.dev/134.
//
//   - name: Immutable. Identifier. The resource name of this endpoint group, for
//     example:
//     `projects/123456789/locations/global/mirroringEndpointGroups/my-eg`. See
//     https://google.aip.dev/122 for more details.
func (r *ProjectsLocationsMirroringEndpointGroupsService) Patch(name string, mirroringendpointgroup *MirroringEndpointGroup) *ProjectsLocationsMirroringEndpointGroupsPatchCall {
	c := &ProjectsLocationsMirroringEndpointGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.mirroringendpointgroup = mirroringendpointgroup
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Must be a UUID4. This request is only idempotent if a
// `request_id` is provided. See https://google.aip.dev/155 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsMirroringEndpointGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Fields are specified relative to the endpoint group (e.g.
// `description`; *not* `mirroring_endpoint_group.description`). See
// https://google.aip.dev/161 for more details.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMirroringEndpointGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMirroringEndpointGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsMirroringEndpointGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mirroringendpointgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.mirroringEndpointGroups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMirroringEndpointGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.mirroringEndpointGroups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServerTlsPoliciesCreateCall struct {
	s               *Service
	parent          string
	servertlspolicy *ServerTlsPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new ServerTlsPolicy in a given project and location.
//
//   - parent: The parent resource of the ServerTlsPolicy. Must be in the format
//     `projects/*/locations/{location}`.
func (r *ProjectsLocationsServerTlsPoliciesService) Create(parent string, servertlspolicy *ServerTlsPolicy) *ProjectsLocationsServerTlsPoliciesCreateCall {
	c := &ProjectsLocationsServerTlsPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.servertlspolicy = servertlspolicy
	return c
}

// ServerTlsPolicyId sets the optional parameter "serverTlsPolicyId": Required.
// Short name of the ServerTlsPolicy resource to be created. This value should
// be 1-63 characters long, containing only letters, numbers, hyphens, and
// underscores, and should not start with a number. E.g. "server_mtls_policy".
func (c *ProjectsLocationsServerTlsPoliciesCreateCall) ServerTlsPolicyId(serverTlsPolicyId string) *ProjectsLocationsServerTlsPoliciesCreateCall {
	c.urlParams_.Set("serverTlsPolicyId", serverTlsPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servertlspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/serverTlsPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServerTlsPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ServerTlsPolicy.
//
//   - name: A name of the ServerTlsPolicy to delete. Must be in the format
//     `projects/*/locations/{location}/serverTlsPolicies/*`.
func (r *ProjectsLocationsServerTlsPoliciesService) Delete(name string) *ProjectsLocationsServerTlsPoliciesDeleteCall {
	c := &ProjectsLocationsServerTlsPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServerTlsPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ServerTlsPolicy.
//
//   - name: A name of the ServerTlsPolicy to get. Must be in the format
//     `projects/*/locations/{location}/serverTlsPolicies/*`.
func (r *ProjectsLocationsServerTlsPoliciesService) Get(name string) *ProjectsLocationsServerTlsPoliciesGetCall {
	c := &ProjectsLocationsServerTlsPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServerTlsPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServerTlsPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ServerTlsPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServerTlsPoliciesGetCall) Do(opts ...googleapi.CallOption) (*ServerTlsPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ServerTlsPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServerTlsPoliciesService) GetIamPolicy(resource string) *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall {
	c := &ProjectsLocationsServerTlsPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServerTlsPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ServerTlsPolicies in a given project and location.
//
//   - parent: The project and location from which the ServerTlsPolicies should
//     be listed, specified in the format `projects/*/locations/{location}`.
func (r *ProjectsLocationsServerTlsPoliciesService) List(parent string) *ProjectsLocationsServerTlsPoliciesListCall {
	c := &ProjectsLocationsServerTlsPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// ServerTlsPolicies to return per call.
func (c *ProjectsLocationsServerTlsPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsServerTlsPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListServerTlsPoliciesResponse` Indicates that this is a continuation
// of a prior `ListServerTlsPolicies` call, and that the system should return
// the next page of data.
func (c *ProjectsLocationsServerTlsPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsServerTlsPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Setting this field to `true` will opt the request into returning the
// resources that are reachable, and into including the names of those that
// were unreachable in the [ListServerTlsPoliciesResponse.unreachable] field.
// This can only be `true` when reading across collections e.g. when `parent`
// is set to "projects/example/locations/-".
func (c *ProjectsLocationsServerTlsPoliciesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsServerTlsPoliciesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServerTlsPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServerTlsPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/serverTlsPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListServerTlsPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServerTlsPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListServerTlsPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListServerTlsPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServerTlsPoliciesListCall) Pages(ctx context.Context, f func(*ListServerTlsPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServerTlsPoliciesPatchCall struct {
	s               *Service
	name            string
	servertlspolicy *ServerTlsPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of a single ServerTlsPolicy.
//
//   - name: Name of the ServerTlsPolicy resource. It matches the pattern
//     `projects/*/locations/{location}/serverTlsPolicies/{server_tls_policy}`.
func (r *ProjectsLocationsServerTlsPoliciesService) Patch(name string, servertlspolicy *ServerTlsPolicy) *ProjectsLocationsServerTlsPoliciesPatchCall {
	c := &ProjectsLocationsServerTlsPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.servertlspolicy = servertlspolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the ServerTlsPolicy resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsServerTlsPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsServerTlsPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servertlspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServerTlsPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServerTlsPoliciesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall {
	c := &ProjectsLocationsServerTlsPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServerTlsPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsServerTlsPoliciesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall {
	c := &ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.serverTlsPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServerTlsPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.serverTlsPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsInspectionPoliciesCreateCall struct {
	s                   *Service
	parent              string
	tlsinspectionpolicy *TlsInspectionPolicy
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a new TlsInspectionPolicy in a given project and location.
//
//   - parent: The parent resource of the TlsInspectionPolicy. Must be in the
//     format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsTlsInspectionPoliciesService) Create(parent string, tlsinspectionpolicy *TlsInspectionPolicy) *ProjectsLocationsTlsInspectionPoliciesCreateCall {
	c := &ProjectsLocationsTlsInspectionPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.tlsinspectionpolicy = tlsinspectionpolicy
	return c
}

// TlsInspectionPolicyId sets the optional parameter "tlsInspectionPolicyId":
// Required. Short name of the TlsInspectionPolicy resource to be created. This
// value should be 1-63 characters long, containing only letters, numbers,
// hyphens, and underscores, and should not start with a number. E.g.
// "tls_inspection_policy1".
func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) TlsInspectionPolicyId(tlsInspectionPolicyId string) *ProjectsLocationsTlsInspectionPoliciesCreateCall {
	c.urlParams_.Set("tlsInspectionPolicyId", tlsInspectionPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsInspectionPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsTlsInspectionPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tlsinspectionpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/tlsInspectionPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.tlsInspectionPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsInspectionPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsInspectionPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single TlsInspectionPolicy.
//
//   - name: A name of the TlsInspectionPolicy to delete. Must be in the format
//     `projects/{project}/locations/{location}/tlsInspectionPolicies/{tls_inspect
//     ion_policy}`.
func (r *ProjectsLocationsTlsInspectionPoliciesService) Delete(name string) *ProjectsLocationsTlsInspectionPoliciesDeleteCall {
	c := &ProjectsLocationsTlsInspectionPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any rules for
// this TlsInspectionPolicy will also be deleted. (Otherwise, the request will
// only work if the TlsInspectionPolicy has no rules.)
func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) Force(force bool) *ProjectsLocationsTlsInspectionPoliciesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsInspectionPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsTlsInspectionPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.tlsInspectionPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsInspectionPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsInspectionPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single TlsInspectionPolicy.
//
//   - name: A name of the TlsInspectionPolicy to get. Must be in the format
//     `projects/{project}/locations/{location}/tlsInspectionPolicies/{tls_inspect
//     ion_policy}`.
func (r *ProjectsLocationsTlsInspectionPoliciesService) Get(name string) *ProjectsLocationsTlsInspectionPoliciesGetCall {
	c := &ProjectsLocationsTlsInspectionPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsInspectionPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsTlsInspectionPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsTlsInspectionPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.tlsInspectionPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TlsInspectionPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsTlsInspectionPoliciesGetCall) Do(opts ...googleapi.CallOption) (*TlsInspectionPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TlsInspectionPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsInspectionPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists TlsInspectionPolicies in a given project and location.
//
//   - parent: The project and location from which the TlsInspectionPolicies
//     should be listed, specified in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsTlsInspectionPoliciesService) List(parent string) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c := &ProjectsLocationsTlsInspectionPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// TlsInspectionPolicies to return per call.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last 'ListTlsInspectionPoliciesResponse' Indicates that this is a
// continuation of a prior 'ListTlsInspectionPolicies' call, and that the
// system should return the next page of data.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsTlsInspectionPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsInspectionPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/tlsInspectionPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.tlsInspectionPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTlsInspectionPoliciesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListTlsInspectionPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTlsInspectionPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsTlsInspectionPoliciesListCall) Pages(ctx context.Context, f func(*ListTlsInspectionPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsTlsInspectionPoliciesPatchCall struct {
	s                   *Service
	name                string
	tlsinspectionpolicy *TlsInspectionPolicy
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates the parameters of a single TlsInspectionPolicy.
//
//   - name: Name of the resource. Name is of the form
//     projects/{project}/locations/{location}/tlsInspectionPolicies/{tls_inspecti
//     on_policy} tls_inspection_policy should match the pattern:(^a-z
//     ([a-z0-9-]{0,61}[a-z0-9])?$).
func (r *ProjectsLocationsTlsInspectionPoliciesService) Patch(name string, tlsinspectionpolicy *TlsInspectionPolicy) *ProjectsLocationsTlsInspectionPoliciesPatchCall {
	c := &ProjectsLocationsTlsInspectionPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.tlsinspectionpolicy = tlsinspectionpolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the TlsInspectionPolicy resource by
// the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsTlsInspectionPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsInspectionPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsTlsInspectionPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tlsinspectionpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.tlsInspectionPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsInspectionPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.tlsInspectionPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUrlListsCreateCall struct {
	s          *Service
	parent     string
	urllist    *UrlList
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new UrlList in a given project and location.
//
//   - parent: The parent resource of the UrlList. Must be in the format
//     `projects/*/locations/{location}`.
func (r *ProjectsLocationsUrlListsService) Create(parent string, urllist *UrlList) *ProjectsLocationsUrlListsCreateCall {
	c := &ProjectsLocationsUrlListsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.urllist = urllist
	return c
}

// UrlListId sets the optional parameter "urlListId": Required. Short name of
// the UrlList resource to be created. This value should be 1-63 characters
// long, containing only letters, numbers, hyphens, and underscores, and should
// not start with a number. E.g. "url_list".
func (c *ProjectsLocationsUrlListsCreateCall) UrlListId(urlListId string) *ProjectsLocationsUrlListsCreateCall {
	c.urlParams_.Set("urlListId", urlListId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUrlListsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsUrlListsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUrlListsCreateCall) Context(ctx context.Context) *ProjectsLocationsUrlListsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUrlListsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUrlListsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.urllist)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/urlLists")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.urlLists.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUrlListsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUrlListsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single UrlList.
//
//   - name: A name of the UrlList to delete. Must be in the format
//     `projects/*/locations/{location}/urlLists/*`.
func (r *ProjectsLocationsUrlListsService) Delete(name string) *ProjectsLocationsUrlListsDeleteCall {
	c := &ProjectsLocationsUrlListsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUrlListsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsUrlListsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUrlListsDeleteCall) Context(ctx context.Context) *ProjectsLocationsUrlListsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUrlListsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUrlListsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.urlLists.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUrlListsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUrlListsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single UrlList.
//
//   - name: A name of the UrlList to get. Must be in the format
//     `projects/*/locations/{location}/urlLists/*`.
func (r *ProjectsLocationsUrlListsService) Get(name string) *ProjectsLocationsUrlListsGetCall {
	c := &ProjectsLocationsUrlListsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUrlListsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsUrlListsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUrlListsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsUrlListsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUrlListsGetCall) Context(ctx context.Context) *ProjectsLocationsUrlListsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUrlListsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUrlListsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.urlLists.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UrlList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUrlListsGetCall) Do(opts ...googleapi.CallOption) (*UrlList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UrlList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUrlListsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists UrlLists in a given project and location.
//
//   - parent: The project and location from which the UrlLists should be listed,
//     specified in the format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsUrlListsService) List(parent string) *ProjectsLocationsUrlListsListCall {
	c := &ProjectsLocationsUrlListsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of UrlLists
// to return per call.
func (c *ProjectsLocationsUrlListsListCall) PageSize(pageSize int64) *ProjectsLocationsUrlListsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListUrlListsResponse` Indicates that this is a continuation of a prior
// `ListUrlLists` call, and that the system should return the next page of
// data.
func (c *ProjectsLocationsUrlListsListCall) PageToken(pageToken string) *ProjectsLocationsUrlListsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUrlListsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsUrlListsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUrlListsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsUrlListsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUrlListsListCall) Context(ctx context.Context) *ProjectsLocationsUrlListsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUrlListsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUrlListsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/urlLists")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.urlLists.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUrlListsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsUrlListsListCall) Do(opts ...googleapi.CallOption) (*ListUrlListsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUrlListsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsUrlListsListCall) Pages(ctx context.Context, f func(*ListUrlListsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUrlListsPatchCall struct {
	s          *Service
	name       string
	urllist    *UrlList
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single UrlList.
//
//   - name: Name of the resource provided by the user. Name is of the form
//     projects/{project}/locations/{location}/urlLists/{url_list} url_list
//     should match the pattern:(^a-z ([a-z0-9-]{0,61}[a-z0-9])?$).
func (r *ProjectsLocationsUrlListsService) Patch(name string, urllist *UrlList) *ProjectsLocationsUrlListsPatchCall {
	c := &ProjectsLocationsUrlListsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.urllist = urllist
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the UrlList resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsUrlListsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsUrlListsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUrlListsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsUrlListsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUrlListsPatchCall) Context(ctx context.Context) *ProjectsLocationsUrlListsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUrlListsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUrlListsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.urllist)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networksecurity.projects.locations.urlLists.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUrlListsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networksecurity.projects.locations.urlLists.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
