/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class StandardManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(StandardManager.class);
    protected static final String name = "StandardManager";
    protected String pathname = null;

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in load() ", exception);
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(sm.getString("standardManager.loading", this.pathname));
        }
        ClassLoader classLoader = null;
        try (FileInputStream fis = new FileInputStream(file.getAbsolutePath());
             BufferedInputStream bis = new BufferedInputStream(fis);){
            Context c = this.getContext();
            Loader loader = c.getLoader();
            Log logger = c.getLogger();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Map map = this.sessions;
            synchronized (map) {
                block32: {
                    try {
                        try (CustomObjectInputStream ois = new CustomObjectInputStream(bis, classLoader, logger, this.getSessionAttributeValueClassNamePattern(), this.getWarnOnSessionAttributeFilterFailure());){
                            Integer count = (Integer)ois.readObject();
                            int n = count;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Loading " + n + " persisted sessions");
                            }
                            for (int i = 0; i < n; ++i) {
                                StandardSession session = this.getNewSession();
                                session.readObjectData(ois);
                                session.setManager(this);
                                this.sessions.put(session.getIdInternal(), session);
                                session.activate();
                                if (session.isValidInternal()) continue;
                                session.setValid(true);
                                session.expire();
                            }
                        }
                        if (!file.exists() || file.delete()) break block32;
                    }
                    catch (Throwable throwable) {
                        if (file.exists() && !file.delete()) {
                            this.log.warn(sm.getString("standardManager.deletePersistedFileFail", file));
                        }
                        throw throwable;
                    }
                    this.log.warn(sm.getString("standardManager.deletePersistedFileFail", file));
                }
            }
        }
        catch (FileNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("standardManager.noFile", file.getAbsolutePath()));
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in unLoad()", exception);
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace(sm.getString("standardManager.unloading.debug"));
        }
        if (this.sessions.isEmpty()) {
            this.log.debug(sm.getString("standardManager.unloading.nosessions"));
            return;
        }
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(sm.getString("standardManager.unloading", this.pathname));
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Map map = this.sessions;
            synchronized (map) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Unloading " + this.sessions.size() + " sessions");
                }
                oos.writeObject(this.sessions.size());
                for (Session s : this.sessions.values()) {
                    StandardSession session = (StandardSession)s;
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.expiringSessions", Integer.toString(list.size())));
        }
        for (StandardSession session : list) {
            try {
                session.expire(false);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
            finally {
                session.recycle();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Unloading complete");
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.load();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log.error(sm.getString("standardManager.managerLoad"), t);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        Session[] sessions;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log.error(sm.getString("standardManager.managerUnload"), t);
        }
        for (Session session : sessions = this.findSessions()) {
            try {
                if (!session.isValid()) continue;
                session.expire();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
            finally {
                session.recycle();
            }
        }
        super.stopInternal();
    }

    protected File file() {
        Context context;
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.isEmpty()) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && (tempdir = (File)(servletContext = (context = this.getContext()).getServletContext()).getAttribute("jakarta.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoad() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doLoad();
            return null;
        }
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoUnload() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doUnload();
            return null;
        }
    }
}

