/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotDeviceErrorCode;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import java.util.logging.Logger;

public class AwsIotDeviceReportMessage
extends AWSIotMessage {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceReportMessage.class.getName());
    private final AbstractAwsIotDevice device;
    private final long reportVersion;

    public AwsIotDeviceReportMessage(String topic, AWSIotQos qos, long reportVersion, String jsonState, AbstractAwsIotDevice device) {
        super(topic, qos, jsonState);
        this.device = device;
        this.reportVersion = reportVersion;
    }

    @Override
    public void onSuccess() {
        this.device.getLocalVersion().compareAndSet(this.reportVersion, this.reportVersion + 1L);
    }

    @Override
    public void onFailure() {
        if (AWSIotDeviceErrorCode.CONFLICT.equals((Object)this.errorCode)) {
            LOGGER.warning("Device version conflict, restart version synchronization");
            this.device.startVersionSync();
        } else {
            LOGGER.warning("Failed to publish device report: " + this.errorMessage);
        }
    }
}

