/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficflow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.F.return;
import com.ubnt.model.A;
import com.ubnt.model.api.PaginatedRequestWithTimestamp;
import com.ubnt.model.api.trafficflow.ImmutableTrafficFlowParametersDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilter;
import com.ubnt.model.api.trafficflow.TrafficFlowHostDto;
import com.ubnt.model.api.trafficflow.TrafficFlowPolicyParametersDto;
import com.ubnt.model.api.trafficflow.TrafficFlowPolicyType;
import com.ubnt.model.o0oO;
import com.ubnt.net.v2.validation.constraints.IpFormat;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.trafficflow.O0OO;
import com.ubnt.service.trafficflow.X;
import com.ubnt.service.trafficflow.oOo0;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ImmutableTrafficFlowParametersDto.Builder.class)
@Value.Immutable
@return
public interface TrafficFlowParametersDto
extends PaginatedRequestWithTimestamp {
    @JsonProperty(value="risk")
    public Optional<Set<X>> getRisk();

    @JsonProperty(value="action")
    public Optional<Set<oOo0>> getAction();

    @JsonProperty(value="direction")
    public Optional<Set<O0OO>> getDirection();

    @JsonProperty(value="protocol")
    public Optional<Set<o0oO>> getProtocol();

    @JsonProperty(value="service")
    public Optional<Set<A>> getService();

    @JsonProperty(value="policy_type")
    public Optional<Set<TrafficFlowPolicyType>> getPolicyType();

    @JsonProperty(value="policy")
    public Optional<Set<@Valid TrafficFlowPolicyParametersDto>> getPolicy();

    @JsonProperty(value="source_host")
    public Optional<Set<@Valid TrafficFlowHostDto>> getSourceHost();

    @JsonProperty(value="source_mac")
    public Optional<Set<@MacAddress String>> getSourceMac();

    @JsonProperty(value="source_ip")
    public Optional<Set<@IpFormat(acceptRanges=false, acceptSubnets=false) String>> getSourceIp();

    @JsonProperty(value="source_port")
    public Optional<Set<Integer>> getSourcePort();

    @JsonProperty(value="source_network_id")
    public Optional<Set<String>> getSourceNetworkId();

    @JsonProperty(value="source_domain")
    public Optional<Set<String>> getSourceDomain();

    @JsonProperty(value="source_zone_id")
    public Optional<Set<String>> getSourceZoneId();

    @JsonProperty(value="source_region")
    public Optional<Set<String>> getSourceRegion();

    @JsonProperty(value="destination_host")
    public Optional<Set<@Valid TrafficFlowHostDto>> getDestinationHost();

    @JsonProperty(value="destination_mac")
    public Optional<Set<@MacAddress String>> getDestinationMac();

    @JsonProperty(value="destination_ip")
    public Optional<Set<@IpFormat(acceptRanges=false, acceptSubnets=false) String>> getDestinationIp();

    @JsonProperty(value="destination_port")
    public Optional<Set<Integer>> getDestinationPort();

    @JsonProperty(value="destination_network_id")
    public Optional<Set<String>> getDestinationNetworkId();

    @JsonProperty(value="destination_domain")
    public Optional<Set<String>> getDestinationDomain();

    @JsonProperty(value="destination_zone_id")
    public Optional<Set<String>> getDestinationZoneId();

    @JsonProperty(value="destination_region")
    public Optional<Set<String>> getDestinationRegion();

    @JsonProperty(value="in_network_id")
    public Optional<Set<String>> getInNetworkId();

    @JsonProperty(value="out_network_id")
    public Optional<Set<String>> getOutNetworkId();

    @JsonProperty(value="next_ai_query")
    public Optional<Set<String>> getNextAiQuery();

    @JsonProperty(value="search_text")
    public Optional<String> getSearchText();

    @JsonProperty(value="except_for")
    public Optional<Set<TrafficFlowFilter>> getExceptFor();

    @Override
    @Min(value=1L)
    @Max(value=5000L)
    @Value.Default
    default public @Min(value=1L) @Max(value=5000L) int getPageSize() {
        return PaginatedRequestWithTimestamp.super.getPageSize();
    }

    public static ImmutableTrafficFlowParametersDto.Builder builder() {
        return ImmutableTrafficFlowParametersDto.builder();
    }
}

