/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final transient Supplier<T> _supplier;
    private T _value;
    private volatile transient boolean _evaluated;

    private Lazy(T value, boolean evaluated, Supplier<T> supplier) {
        this._value = value;
        this._evaluated = evaluated;
        this._supplier = supplier;
    }

    private Lazy(Supplier<T> supplier) {
        this(null, false, Objects.requireNonNull(supplier));
    }

    @Override
    public T get() {
        return this._evaluated ? this._value : this.evaluate();
    }

    public boolean isEvaluated() {
        return this._supplier == null || this._evaluated || this._evaluated();
    }

    private synchronized boolean _evaluated() {
        return this._evaluated;
    }

    private synchronized T evaluate() {
        if (!this._evaluated) {
            this._value = this._supplier.get();
            this._evaluated = true;
        }
        return this._value;
    }

    public int hashCode() {
        return Objects.hashCode(this.get());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Lazy && Objects.equals(((Lazy)obj).get(), this.get());
    }

    public String toString() {
        return String.format("Lazy[%s]", this.isEvaluated() ? this.get() : "?");
    }

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <T> Lazy<T> ofValue(T value) {
        return new Lazy<T>(value, true, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        T value = this.get();
        out.defaultWriteObject();
        out.writeObject(value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._value = in.readObject();
        this._evaluated = true;
    }
}

