/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collector;

public final class MinMax<C>
implements Consumer<C> {
    private final Comparator<? super C> _comparator;
    private C _min;
    private C _max;
    private long _count = 0L;

    private MinMax(Comparator<? super C> comparator) {
        this._comparator = Objects.requireNonNull(comparator);
    }

    @Override
    public void accept(C object) {
        this._min = MinMax.min(this._comparator, this._min, object);
        this._max = MinMax.max(this._comparator, this._max, object);
        ++this._count;
    }

    public MinMax<C> combine(MinMax<C> other) {
        this._min = MinMax.min(this._comparator, this._min, other._min);
        this._max = MinMax.max(this._comparator, this._max, other._max);
        this._count += other._count;
        return this;
    }

    public C getMin() {
        return this._min;
    }

    public C getMax() {
        return this._max;
    }

    public long getCount() {
        return this._count;
    }

    public boolean sameState(MinMax<C> other) {
        return this == other || Objects.equals(this._min, other._min) && Objects.equals(this._max, other._max);
    }

    public String toString() {
        return String.format("MinMax[count=%d, min=%s, max=%s]", this._count, this._min, this._max);
    }

    public static <T> T min(Comparator<? super T> comp, T a, T b) {
        return a != null ? (b != null ? (comp.compare(a, b) <= 0 ? a : b) : a) : b;
    }

    public static <T> T max(Comparator<? super T> comp, T a, T b) {
        return a != null ? (b != null ? (comp.compare(a, b) >= 0 ? a : b) : a) : b;
    }

    public static <T> Collector<T, ?, MinMax<T>> toMinMax(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return Collector.of(() -> MinMax.of(comparator), MinMax::accept, MinMax::combine, new Collector.Characteristics[0]);
    }

    public static <C extends Comparable<? super C>> Collector<C, ?, MinMax<C>> toMinMax() {
        return MinMax.toMinMax(Comparator.naturalOrder());
    }

    public static <T> MinMax<T> of(Comparator<? super T> comparator) {
        return new MinMax<T>(comparator);
    }

    public static <C extends Comparable<? super C>> MinMax<C> of() {
        return MinMax.of(Comparator.naturalOrder());
    }
}

