// Code generated by sdkgen-v2. DO NOT EDIT.
package awscompatibilitysdk

import (
	"context"

	awscompatibility "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1/awscompatibility"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	proto "google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// AccessKeyClient provides methods for managing AccessKey resources of Yandex.Cloud AWSCompatibility.
type AccessKeyClient interface {
	List(context.Context, *awscompatibility.ListAccessKeysRequest, ...grpc.CallOption) (*awscompatibility.ListAccessKeysResponse, error)
	Get(context.Context, *awscompatibility.GetAccessKeyRequest, ...grpc.CallOption) (*awscompatibility.AccessKey, error)
	Create(context.Context, *awscompatibility.CreateAccessKeyRequest, ...grpc.CallOption) (*awscompatibility.CreateAccessKeyResponse, error)
	Update(context.Context, *awscompatibility.UpdateAccessKeyRequest, ...grpc.CallOption) (*AccessKeyUpdateOperation, error)
	Delete(context.Context, *awscompatibility.DeleteAccessKeyRequest, ...grpc.CallOption) (*AccessKeyDeleteOperation, error)
	ListOperations(context.Context, *awscompatibility.ListAccessKeyOperationsRequest, ...grpc.CallOption) (*awscompatibility.ListAccessKeyOperationsResponse, error)
}

var _ AccessKeyClient = accessKeyClient{}

type accessKeyClient struct {
	connector transport.Connector
}

// NewAccessKeyClient returns AccessKeyClient implementation.
func NewAccessKeyClient(connector transport.Connector) AccessKeyClient {
	return accessKeyClient{connector}
}

// List is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
func (c accessKeyClient) List(ctx context.Context, in *awscompatibility.ListAccessKeysRequest, opts ...grpc.CallOption) (*awscompatibility.ListAccessKeysResponse, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyList, opts...)
	if err != nil {
		return nil, err
	}
	return awscompatibility.NewAccessKeyServiceClient(connection).List(ctx, in, opts...)
}

// Get is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
func (c accessKeyClient) Get(ctx context.Context, in *awscompatibility.GetAccessKeyRequest, opts ...grpc.CallOption) (*awscompatibility.AccessKey, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyGet, opts...)
	if err != nil {
		return nil, err
	}
	return awscompatibility.NewAccessKeyServiceClient(connection).Get(ctx, in, opts...)
}

// Create is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
func (c accessKeyClient) Create(ctx context.Context, in *awscompatibility.CreateAccessKeyRequest, opts ...grpc.CallOption) (*awscompatibility.CreateAccessKeyResponse, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyCreate, opts...)
	if err != nil {
		return nil, err
	}
	return awscompatibility.NewAccessKeyServiceClient(connection).Create(ctx, in, opts...)
}

// AccessKeyUpdateOperation is used to monitor the state of Update operations.
type AccessKeyUpdateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *AccessKeyUpdateOperation) Metadata() *awscompatibility.UpdateAccessKeyMetadata {
	return o.Operation.Metadata().(*awscompatibility.UpdateAccessKeyMetadata)
}

// Response retrieves the operation response.
func (o *AccessKeyUpdateOperation) Response() *awscompatibility.AccessKey {
	return o.Operation.Response().(*awscompatibility.AccessKey)
}

// Wait polls the operation until it's done.
func (o *AccessKeyUpdateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*awscompatibility.AccessKey, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*awscompatibility.AccessKey)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *AccessKeyUpdateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*awscompatibility.AccessKey, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*awscompatibility.AccessKey)
	return response, err
}

// Update is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
// It returns an object which should be used to monitor the operation state.
func (c accessKeyClient) Update(ctx context.Context, in *awscompatibility.UpdateAccessKeyRequest, opts ...grpc.CallOption) (*AccessKeyUpdateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyUpdate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := awscompatibility.NewAccessKeyServiceClient(connection).Update(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*awscompatibility.UpdateAccessKeyMetadata).GetAccessKeyId()
		},
		MetadataType: (*awscompatibility.UpdateAccessKeyMetadata)(nil),
		ResponseType: (*awscompatibility.AccessKey)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &AccessKeyUpdateOperation{*op}, nil
}

// AccessKeyDeleteOperation is used to monitor the state of Delete operations.
type AccessKeyDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *AccessKeyDeleteOperation) Metadata() *awscompatibility.DeleteAccessKeyMetadata {
	return o.Operation.Metadata().(*awscompatibility.DeleteAccessKeyMetadata)
}

// Response retrieves the operation response.
func (o *AccessKeyDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *AccessKeyDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *AccessKeyDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
// It returns an object which should be used to monitor the operation state.
func (c accessKeyClient) Delete(ctx context.Context, in *awscompatibility.DeleteAccessKeyRequest, opts ...grpc.CallOption) (*AccessKeyDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := awscompatibility.NewAccessKeyServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*awscompatibility.DeleteAccessKeyMetadata).GetAccessKeyId()
		},
		MetadataType: (*awscompatibility.DeleteAccessKeyMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &AccessKeyDeleteOperation{*op}, nil
}

// ListOperations is an operation of Yandex.Cloud AWSCompatibility AccessKey service.
func (c accessKeyClient) ListOperations(ctx context.Context, in *awscompatibility.ListAccessKeyOperationsRequest, opts ...grpc.CallOption) (*awscompatibility.ListAccessKeyOperationsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyListOperations, opts...)
	if err != nil {
		return nil, err
	}
	return awscompatibility.NewAccessKeyServiceClient(connection).ListOperations(ctx, in, opts...)
}

// pollOperation returns the current state of the polled operation.
func (c accessKeyClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, AccessKeyOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	AccessKeyList            = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.List")
	AccessKeyGet             = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.Get")
	AccessKeyCreate          = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.Create")
	AccessKeyUpdate          = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.Update")
	AccessKeyDelete          = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.Delete")
	AccessKeyListOperations  = protoreflect.FullName("yandex.cloud.iam.v1.awscompatibility.AccessKeyService.ListOperations")
	AccessKeyOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
