---
date: 2025-07-08
slug: goreleaser-v2.11
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.11

This version consists mostly of improvements to the [Homebrew Cask][casks]
feature introduced in the last release, and in other features.

<!-- more -->

- **pro**: added `republish` to [Cloudsmiths][cloudsmith];
- **pro**: `publishers` get a `output` option, which sets the output of the
  command as a template variable with that name (e.g. `output: foo` allows you
  to use `{{ .Outputs.foo }}`);
- **pro**: it will now allow to create nightly releases when there's no tags in
  the repository yet;
- **cask**: moved `custom_block` to the beginning of the Cask, renamed `manpage`
  to `manpages` to better match the Cask API, and added docs on how to make
  Casks for private repositories;
- **git**: you can now setup commit signing when publishing to a git repository;
- **ui**: the `--help` now looks a bit better, and we also improved the program
  output in a few places;
- **cleanups**: made a few improvements on how context cancellation works (i.e.
  on timeouts or `SIGINT`), removed the usage of some libraries, and many other
  smaller changes;

![New output of 'goreleaser --help'](https://carlosbecker.com/posts/goreleaser-v2.11/help.png)

## Other news

- GoReleaser now has ~14.8k stars and 435 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can install or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries from GitHub:

[:fontawesome-solid-download: Install][install]{ .md-button .md-button--primary }
[:fontawesome-brands-github: v2.11.0 (OSS)][oss-rel]{ .md-button }
[:fontawesome-brands-github: v2.11.0 (Pro)][pro-rel]{ .md-button }

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also sponsor the project, or get a GoReleaser Pro license.

[:material-professional-hexagon: Get the Pro license][pro]{ .md-button .md-button--primary }
[:simple-githubsponsors: Sponsor the project][sponsor]{ .md-button }

[sponsor]: https://goreleaser.com/sponsors
[pro]: https://goreleaser.com/pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.11.0
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.11.0
[discord]: https://goreleaser.com/discord
[cloudsmith]: https://goreleaser.com/customization/cloudsmith
[casks]: https://goreleaser.com/customization/homebrew_casks/
