/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import java.beans.PropertyChangeListener;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public abstract class JPDADebugger {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_THREAD_STARTED = "threadStarted";
    public static final String PROP_THREAD_DIED = "threadDied";
    public static final String PROP_THREAD_GROUP_ADDED = "threadGroupAdded";
    public static final String PROP_CLASSES_FIXED = "classesFixed";
    public static final String PROP_BREAKPOINTS_ACTIVE = "breakpointsActive";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int STATE_STARTING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_STOPPED = 3;
    public static final int STATE_DISCONNECTED = 4;
    public static final String ENGINE_ID = "netbeans-JPDASession/Java";
    public static final String SESSION_ID = "netbeans-JPDASession";

    public static void launch(String mainClassName, String[] args, String classPath, boolean suspend) {
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-LaunchingDICookie", (Object[])new Object[]{LaunchingDICookie.create(mainClassName, args, classPath, suspend)}));
        if (es.length == 0) {
            throw new RuntimeException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
        }
    }

    public static JPDADebugger listen(ListeningConnector connector, Map<String, ? extends Connector.Argument> args, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = ListeningDICookie.create(connector, args);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, JPDADebugger.class);
            if (d == null) continue;
            d.waitRunning();
            return d;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public static void startListening(ListeningConnector connector, Map<String, ? extends Connector.Argument> args, Object[] services) throws DebuggerStartException {
        JPDADebugger.startListeningAndGetEngines(connector, args, services);
    }

    public static DebuggerEngine[] startListeningAndGetEngines(ListeningConnector connector, Map<String, ? extends Connector.Argument> args, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = ListeningDICookie.create(connector, args);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])s));
        if (es.length == 0) {
            throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
        }
        return es;
    }

    public static JPDADebugger attach(String hostName, int portNumber, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = AttachingDICookie.create(hostName, portNumber);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, JPDADebugger.class);
            if (d == null) continue;
            d.waitRunning();
            return d;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public static JPDADebugger attach(String name, Object[] services) throws DebuggerStartException {
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 1, services.length);
        s[0] = AttachingDICookie.create(name);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])s));
        int k = es.length;
        for (int i = 0; i < k; ++i) {
            JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, JPDADebugger.class);
            if (d == null) continue;
            d.waitRunning();
            return d;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public abstract int getState();

    public abstract int getSuspend();

    public abstract void setSuspend(int var1);

    public abstract JPDAThread getCurrentThread();

    public abstract CallStackFrame getCurrentCallStackFrame();

    public abstract Variable evaluate(String var1) throws InvalidExpressionException;

    public abstract void waitRunning() throws DebuggerStartException;

    public abstract boolean canFixClasses();

    public abstract boolean canPopFrames();

    public boolean canBeModified() {
        return true;
    }

    public abstract void fixClasses(Map<String, byte[]> var1);

    public abstract SmartSteppingFilter getSmartSteppingFilter();

    protected void fireBreakpointEvent(JPDABreakpoint breakpoint, JPDABreakpointEvent event) {
        breakpoint.fireJPDABreakpointChange(event);
    }

    public boolean getBreakpointsActive() {
        return true;
    }

    public void setBreakpointsActive(boolean active) {
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public JPDAStep createJPDAStep(int size, int depth) {
        throw new UnsupportedOperationException("This method must be overridden.");
    }

    public boolean canGetInstanceInfo() {
        return false;
    }

    public List<JPDAClassType> getAllClasses() {
        return Collections.emptyList();
    }

    public List<JPDAClassType> getClassesByName(String name) {
        return Collections.emptyList();
    }

    public Variable createMirrorVar(Object obj) throws InvalidObjectException {
        return this.createMirrorVar(obj, false);
    }

    public Variable createMirrorVar(Object obj, boolean isPrimitive) throws InvalidObjectException {
        throw new InvalidObjectException("Object " + obj + " not supported");
    }

    public long[] getInstanceCounts(List<JPDAClassType> classTypes) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ThreadsCollector getThreadsCollector() {
        return null;
    }

    public Session getSession() {
        throw new AbstractMethodError();
    }

    static class ContextAware
    extends JPDADebugger
    implements ContextAwareService<JPDADebugger> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        public JPDADebugger forContext(ContextProvider context) {
            return (JPDADebugger)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)context);
        }

        @Override
        public int getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getSuspend() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setSuspend(int s) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public JPDAThread getCurrentThread() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CallStackFrame getCurrentCallStackFrame() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Variable evaluate(String expression) throws InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void waitRunning() throws DebuggerStartException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean canFixClasses() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean canPopFrames() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void fixClasses(Map<String, byte[]> classes) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SmartSteppingFilter getSmartSteppingFilter() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

