/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.LogViewMgr;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewServerLogAction
extends NodeAction {
    private static final String SHOW_SERVER_LOG_ICONBASE = "org/netbeans/modules/payara/common/resources/serverlog.gif";

    protected void performAction(Node[] nodes) {
        Lookup lookup = nodes[0].getLookup();
        CommonServerSupport commonSupport = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
        if (commonSupport != null) {
            LogViewMgr.displayOutput(commonSupport.getInstance(), lookup);
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length < 1 || nodes[0] == null) {
            return false;
        }
        PayaraModule commonSupport = (PayaraModule)nodes[0].getLookup().lookup(PayaraModule.class);
        if (commonSupport == null || !(commonSupport.getInstance() instanceof PayaraInstance)) {
            return false;
        }
        PayaraInstance server = (PayaraInstance)commonSupport.getInstance();
        String uri = server.getUrl();
        return uri != null && uri.length() > 0 && ((!server.isRemote() || server.isWSL()) && ServerUtils.getServerLogFile((PayaraServer)server).canRead() || commonSupport.isRestfulLogAccessSupported() && server.isRemote() && this.isRunning(commonSupport));
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ViewServerLogAction.class, (String)"CTL_ViewServerLogAction");
    }

    protected String iconResource() {
        return SHOW_SERVER_LOG_ICONBASE;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean isRunning(PayaraModule commonSupport) {
        PayaraModule.ServerState ss = commonSupport.getServerState();
        return ss == PayaraModule.ServerState.RUNNING || ss == PayaraModule.ServerState.RUNNING_JVM_DEBUG || ss == PayaraModule.ServerState.RUNNING_JVM_PROFILER;
    }
}

